/*** analhead.h: header file for analog 1.2 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** Change any of these according to your desires ***/

#ifndef ANALHEAD
#define ANALHEAD

#define DIRSUFFIX "index.html"
/* the default filename tried if a directory is requested. The program
   combines statistics from /dir/ and /dir/DIRSUFFIX. If you don't wish
   this combining to occur, define DIRSUFFIX to be "". The usual value
   is "index.html". In future versions there will be support for more
   than one value, for servers that support that. */

#define URLHASHSIZE (659)
/* the size of the hash table for URLs; must be odd, should be prime. */
/* too small will make the program slower; too big might use a bit */
/* more memory and be slightly less efficient. Maybe half the number */
/* of URLs expected, but it shouldn't be at all critical. There is a list
/* of primes in the file primes.tab */

#define DIRHASHSIZE (97)
/* ditto for directories */

#define HOSTHASHSIZE (5087)
/* ditto for all hostnames that have accessed us */

#define SUBDOMHASHSIZE (503)
/* and again for all subdomains we want to analyse */

#define MAXLINELENGTH (2048)
/* the maximum length of any line in the logfile (long lines can
   result from searches), domains file or rc file. Longer lines
   will be thrown away. */

#define MAXSTRINGLENGTH (128)
/* how long is the longest string we want for a filename, our
   organisation name, an internet address or geographical location?
   (Longer strings will be truncated). */

#define MINPAGEWIDTH (25)
#define MAXPAGEWIDTH (240)
/* the min and max allowed values of the pagewidth variable */

#define FORMPROG "/cgi-bin/analform.cgi"
/* If you make an analog form interface, what will be the URL of the
   program that processes it? (It should be wherever cgi-bin programs
   go on your server; normally in a cgi-bin directory). */

/*** The following options can be overriden in the configuration file, but
     not on the commandline ***/

#define WEEKBEGINSON (SUNDAY)
/* The 1st day of the week. I think it's SUNDAY, but you can choose any day. */

#define SEPCHAR ' '
/* The character to separate the thousands in a long number. I prefer ' ',
   but some people prefer '.' or ','. Use '9' if you really want to inflate
   your statistics! :) */

#define REPORTORDER "mWdDhoSir"
/* A string like "mWdDhoSir" giving the order in which the reports will be
   output. You should make sure to include each of the above letters exactly
   once or you will not get some report even if you specifically request it
   later, or you may get some report twice. */

#define APPROXHOSTSIZE (100000)
/* The number of bytes to allocate for approximate hostname counting; */
/* more will make it more accurate. About 3 bytes per host should give */
/* you a very good estimate, though even 1 byte per host will be fair. */
/* If statistics for last 7 days are asked for, twice this amount of space
   will be used. */

#define BACKGROUND "none"
/* URL of background image to appear on the output page. Preferably use "none"
   for none. If you must use one (i) it should be small, otherwise people
   with slow lines won't be able to load your page (ii) it should not stop
   people with low res. monochrome screens being able to read your page. */

#define BASEURL "none"
/* A string which is prepended to all URLs linked to in the request report.
   This is useful if you want to display the statistics on a different
   server from the one that generated the logfile. Use "none" for none. */

#define DOMCOLS "Rb"
/* Which columns we want to appear in the domain report, and in which order.
   The string can contain any of the following four letters:
   R   Number of requests from each domain
   r   Percentage of the requests from each domain
   B   Total number of bytes transferred to each domain
   b   The percentage of traffic to each domain                            */

/* And the same for the host report, directory report and request report */
#define HOSTCOLS "Rb"
#define DIRCOLS "Rb"
#define REQCOLS "Rb"

/*** ALL the options from here on can be overridden on the command line,
     or in the configuration file (except CONFIGFILE!) ***/ 

#define LOGFILE "/usr/local/etc/httpd/logs/access_log"
/* The name of the default logfile; use "stdin" for stdin */
/* Overridden by argument without + or -, or by just '-' for stdin. */

#define OUTFILE "stdout"
/* the default file for output. Use "stdout" for stdout. */

#define DOMAINSFILE "/usr/local/etc/httpd/analog/domains.tab"
/* the name of the file where the domain definitions live; see README.html
   for the format of this file */
/* Overridden by -f */

#define HEADERFILE "none"
/* an extra file (with HTML markup if desired) placed between the page title
   and the start of the statistics. Use "none" for none. */
/* Overridden by +H/-H */

#define FOOTERFILE "none"
/* And one placed at the bottom of the page */
/* Overridden by +F/-F */

#define ASCII (OFF)
/* Whether the output should be in ASCII or HTML by default */
/* Overridden by +a/-a */

#define LOGOURL "http://www.statslab.cam.ac.uk/~sret1/analog/analog/analogo.gif"
/* the URL of the file where the analog logo lives. You can put another
   logo in here (your organisation's logo, for example). You can point at
   http://www.statslab.cam.ac.uk/~sret1/analog/analog/analogo.gif
   but you will probably prefer to keep your own copy locally; one should
   have come with the program. */
/* Overridden by +p */

#define LOGO (ON)
/* whether to include a logo. Overridden by +p/-p */

#define CONFIGFILE "none"
/* the name of the configuration file; see README.html for a description
   of this file. Use "none" for no configuration file. */
/* Overridden by +g/-g */

#define HOSTNAME "the Statistical Laboratory"
/* the name of your organisation or WWW host. This is used for printing
   at the top of the output */
/* Overridden by -n */

#define HOSTURL "http://www.statslab.cam.ac.uk/"
/* the URL of your host's home page, for linking to at the top of the
   output; use "-" for no linking. */
/* Overridden by -u */

#define DEBUG (0)
/* Level of debugging output: 0 = none, 1 = print all corrupt lines to stderr,
   2 = also print hosts with unknown domains. */

#define MIN_URL_REQS (10)
/* the min. no. of requests a URL should have before appearing on the
   request report. Setting this to about 10 clears out a lot of junk.
   Setting it to a negative number gives a "top n" report. */
/* Overridden in +r/+R */

#define MIN_URL_BYTES (1)
/* if we are sorting by bytes, use this instead; it is measured in 1/100ths
of percentage of total bytes transferred. (Or "top n" if negative again). */
/* Overridden in +r/+R */

/* now the same for directory, domain and hostname reports. */
#define MIN_DIR_REQS (10)
#define MIN_DIR_BYTES (1)
/* Overridden in +i */
#define MIN_DOM_REQS (1) 
#define MIN_DOM_BYTES (0)
/* Overridden in +o */
#define MIN_HOST_REQS (100)
/* Set this quite high if you want it to finish in reasonable time */
#define MIN_HOST_BYTES (1)
/* Overridden in +S */
/* And the same for subdomains you have specified. Actually, these
   can't be changed on the commandline. Also they can't be negative. */
#define MIN_SUBDOM_REQS (100)
#define MIN_SUBDOM_BYTES (20)

/* how should the request report, domain report and directory report be
   sorted? Legal values ar BYREQUESTS, BYBYTES and ALPHABETICAL */
#define REQSORTBY (BYREQUESTS)
/* Overridden in +r/+R */
#define DOMSORTBY (BYBYTES)
/* Overridden in +o */
#define DIRSORTBY (BYBYTES)
/* Overridden in +i */
#define HOSTSORTBY (ALPHABETICAL)
/* Overridden in +S */

#define MARKCHAR '+'
/* a character for the graphical displays */
/* Overridden by -c */

#define PAGEWIDTH (65)
/* the width of the output. Standard text screens have 80 columns, but for
   WWW browsers something like 65 is probably better. */
/* Overridden by -w */

/* whether we want each of the reports by default */
#define GENERAL (ON)
/* General summary and "Go To" links; overridden by +x/-x */
#define MONTHLY (ON)
/* Overridden by +m/-m */
#define DAILY (ON)
/* Overridden by +d/-d */
#define FULLDAILY (OFF)
/* One line for each day. Think about the poor people loading your page from
   the other side of the world before turning this on by default */
/* Overridden by +D/-D */
#define WEEKLY (OFF)
/* One line for each week. The same comment applies, only less so */
/* Overridden by +W/-W */
#define HOURLY (ON)
/* Overridden by +h/-h */
#define DOMAIN (ON)
/* Overridden by +o/-o */
#define DIRECTORY (ON)
/* Overridden by +i/-i */
#define REQUEST (ON)
/* Overridden by +r/+R/-r/-R */
#define FULLHOSTS (OFF)
/* Full hostname report. Typically very long output and slow to produce
   on a full logfile, unless MIN_HOST_REQS or _BYTES is high as applicable */
/* Overridden by +S */

#define DIRLEVEL (1)
/* the level of directory report; see README */
/* Overridden by -l */

#define REQTYPE (ALL)
/* do we want to show ALL requests in the request report or just PAGES? */
/* Overridden by +r or +R */

#define PAGELINKS (ON)
/* whether pages are linked to in the request report by default. */
/* Can be OFF, ON (link to pages) or ALL (link to everything). */
/* Overridden by +k/-k */

#define COUNTHOSTS (ON)
/* whether we want to count the number of distinct hosts */
/* Can be ON, OFF or APPROX (for approximate count; in fact lower bound) */
/* FULLHOSTS ON turns COUNTHOSTS ON */
/* Turning this to OFF or APPROX will save a lot of memory */
/* Overridden by +s/-s */

#define LASTSEVEN (ON)
/* whether we want statistics for the last seven days */
/* Overridden by +7/-7 */

#define NUMLOOKUP (OFF)
/* whether we want to look up numerical addresses at run time to try
   and resolve them. This can get very slow. */
/* Overridden by +1/-1 */

/* the default values for the value of each MARKCHAR on the graphs.
   0 means choose a sensible value at the time based on number of requests
   and the value of PAGEWIDTH. */
#define MONTHLYUNIT (0)
/* Overridden in +m */
#define HOURLYUNIT (0)
/* Overridden in +h */
#define DAILYUNIT (0)
/* Overridden in +d */
#define WEEKLYUNIT (0)
/* Overridden in +W */
#define FULLDAILYUNIT (0)
/* Overridden in +D */

#endif
