/* analform.c 1.1beta -- parse the output of the analog form interface */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* You must change the next line to indicate where the analog program lives */

#define COMMAND "/users2/sret1/misc/analog/analog"
#define MAXARGLENGTH (2048)   /* should be plenty */
#define ERR (-1)

typedef int flag;

void unhttp(char *url)     /* converts back all http special characters */
{
  char *tempp;
  char tempstr[MAXARGLENGTH];
  int i;

  /* firstly, change +'s into spaces */

  for (i = strlen(url) - 1; i >= 0; i--) {
    if (url[i] == '+')
      url[i] = ' ';
  }

  /* secondly change %7E to ~, etc. */

  tempp = url;
  while ((tempp = strchr(tempp, '%')) != NULL) {
    sscanf(tempp + 1, "%2x", &i);
    if (i > 0x20 && i < 0x7F) {
      *tempp = i;
      strcpy(tempstr, tempp + 3);
      strcpy(tempp + 1, tempstr);
      /* strcpy(tempp + 1, tempp + 3) may not be safe on all machines
	 (overlapping arguments) */
    }
    tempp++;
  }

}


int main()
{
  extern void exit();

  /* the input */
  char *argstring;
  char *nextarg;
  char *nextval;

  /* the variables that can be read in */
  flag xq = 0, mq = 0, Wq = 0, dq = 0, Dq = 0, hq = 0, oq = 0, Sq = 0,
  iq = 0, rq = 0;
  int os, Ss, is, rs;
  double on = -1, Sn = -1, in = -1, rn = -1;
  int dirlevel;
  char reqtype, reqlinks;
  char *from = NULL, *to = NULL;
  char *fonly = NULL, *donly= NULL, *fign = NULL, *dign = NULL;
  char *org = NULL, *home = NULL;
  char *TZ = NULL;
  char TZenv[16];

  FILE *thepipe;
  
  if ((argstring = getenv("QUERY_STRING")) == NULL)
    exit(ERR);

  unhttp(argstring);

  nextarg = strtok(argstring, "&");

  while (nextarg != NULL) {
    nextval = strchr(nextarg, '=') + 1;
    if (nextval[0] != '\0') {
      switch(nextarg[0]) {
      case 'd':
	switch(nextarg[1]) {
	case 'i':
	  dign = nextval;
	  break;
	case 'q':
	  dq = 1;
	  break;
	case 'y':
	  donly = nextval;
	}
	break;
      case 'D':
	Dq = 1;
	break;
      case 'f':
	switch(nextarg[1]) {
	case 'i':
	  fign = nextval;
	  break;
	case 'r':
	  from = nextval;
	  break;
	case 'y':
	  fonly = nextval;
	  break;
	}
	break;
      case 'h':
	switch(nextarg[1]) {
	case 'o':
	  home = nextval;
	  break;
	case 'q':
	  hq = 1;
	  break;
	}
	break;
      case 'i':
	switch(nextarg[1]) {
	case 'd':
	  dirlevel = atoi(nextval);
	  break;
	case 'n':
	  in = atof(nextval);
	  break;
	case 'q':
	  iq = 1;
	  break;
	case 's':
	  is = atoi(nextval);
	  break;
	}
	break;
      case 'm':
	mq = 1;
	break;
      case 'o':
	switch(nextarg[1]) {
	case 'n':
	  on = atof(nextval);
	  break;
	case 'q':
	  oq = 1;
	  break;
	case 'r':
	  org = nextval;
	  break;
	case 's':
	  os = atoi(nextval);
	  break;
	}
	break;
      case 'r':
	switch(nextarg[1]) {
	case 'l':
	  reqlinks = nextval[0];
	  break;
	case 'n':
	  rn = atof(nextval);
	  break;
	case 'q':
	  rq = 1;
	  break;
	case 's':
	  rs = atoi(nextval);
	  break;
	case 't':
	  reqtype = nextval[0];
	  break;
	}
	break;
      case 'S':
	switch(nextarg[1]) {
	case 'n':
	  Sn = atof(nextval);
	  break;
	case 'q':
	  Sq = 1;
	  break;
	case 's':
	  Ss = atoi(nextval);
	  break;
	}
	break;
      case 't':
	to = nextval;
	break;
      case 'T':
	TZ = nextval;
	break;
      case 'W':
	Wq = 1;
	break;
      case 'x':
	xq = 1;
	break;
      }

    }

    nextarg = strtok((char *)NULL, "&");

  }

  /* OK, so we've read everything in, now send it to the program */
  
  if (TZ != NULL) {
    strcpy(TZenv, "TZ=");
    strcat(TZenv, TZ);
    putenv(TZenv);
  }

  printf("Content-type: text/html\n\n");
  fflush(stdout);

  thepipe = popen(COMMAND " +G-", "w");

  fprintf(thepipe, "GENERAL %s\n", xq?"ON":"OFF");
  fprintf(thepipe, "MONTHLY %s\n", mq?"ON":"OFF");
  fprintf(thepipe, "WEEKLY %s\n", Wq?"ON":"OFF");
  fprintf(thepipe, "DAILY %s\n", dq?"ON":"OFF");
  fprintf(thepipe, "FULLDAILY %s\n", Dq?"ON":"OFF");
  fprintf(thepipe, "HOURLY %s\n", hq?"ON":"OFF");
  fprintf(thepipe, "DOMAIN %s\n", oq?"ON":"OFF");
  fprintf(thepipe, "FULLHOSTS %s\n", Sq?"ON":"OFF");
  fprintf(thepipe, "DIRECTORY %s\n", iq?"ON":"OFF");
  fprintf(thepipe, "REQUEST %s\n", rq?"ON":"OFF");

  if (oq) {
    fprintf(thepipe, "DOMSORTBY ");
    if (os == 1)
      fprintf(thepipe, "alphabetical\n");
    else if (os <= 3)
      fprintf(thepipe, "bybytes\n");
    else
      fprintf(thepipe, "byrequests\n");

    if (on >= 0) {
      fprintf(thepipe, "DOMFLOOR ");
      if (os == 3 || os == 5)
	fprintf(thepipe, "-%.0f\n", on);
      else if (os == 2)
	fprintf(thepipe, "%.0f\n", on * 100);
      else
	fprintf(thepipe, "%.0f\n", on);
    }
  }

  if (Sq) {
    fprintf(thepipe, "HOSTSORTBY ");
    if (Ss == 1)
      fprintf(thepipe, "alphabetical\n");
    else if (Ss <= 3)
      fprintf(thepipe, "bybytes\n");
    else
      fprintf(thepipe, "byrequests\n");

    if (Sn >= 0) {
      fprintf(thepipe, "HOSTFLOOR ");
      if (Ss == 3 || Ss == 5)
	fprintf(thepipe, "-%.0f\n", Sn);
      else if (Ss == 2)
	fprintf(thepipe, "%.0f\n", Sn * 100);
      else
	fprintf(thepipe, "%.0f\n", Sn);
    }
  }

  if (iq) {
    fprintf(thepipe, "DIRSORTBY ");
    if (is == 1)
      fprintf(thepipe, "alphabetical\n");
    else if (is <= 3)
      fprintf(thepipe, "bybytes\n");
    else
      fprintf(thepipe, "byrequests\n");

    if (in >= 0) {
      fprintf(thepipe, "DIRFLOOR ");
      if (is == 3 || is == 5)
	fprintf(thepipe, "-%.0f\n", in);
      else if (is == 2)
	fprintf(thepipe, "%.0f\n", in * 100);
      else
	fprintf(thepipe, "%.0f\n", in);
    }

    fprintf(thepipe, "DIRLEVEL %d\n", dirlevel);

  }

  if (rq) {
    fprintf(thepipe, "REQSORTBY ");
    if (rs == 1)
      fprintf(thepipe, "alphabetical\n");
    else if (rs <= 3)
      fprintf(thepipe, "bybytes\n");
    else
      fprintf(thepipe, "byrequests\n");

    if (rn >= 0) {
      fprintf(thepipe, "REQFLOOR ");
      if (rs == 3 || rs == 5)
	fprintf(thepipe, "-%.0f\n", rn);
      else if (rs == 2)
	fprintf(thepipe, "%.0f\n", rn * 100);
      else
	fprintf(thepipe, "%.0f\n", rn);
    }

    fprintf(thepipe, "REQTYPE %s\n", reqtype=='f'?"ALL":"PAGES");
    fprintf(thepipe, "PAGELINKS %s\n", reqlinks=='f'?"ALL":(reqlinks=='p'?"ON":"OFF"));

  }

  if (from != NULL)
    fprintf(thepipe, "FROM %s\n", from);
  if (to != NULL)
    fprintf(thepipe, "TO %s\n", to);
  if (org != NULL)
    fprintf(thepipe, "HOSTNAME \"%s\"\n", org);
  if (home != NULL)
    fprintf(thepipe, "HOSTURL %s\n", home);
  else
    fprintf(thepipe, "HOSTURL -\n");

  /* That just leaves the only's and ignore's, which are a bit more
     complicated as we have to parse them still. Recycle 'nextarg'. */

  nextarg = strtok(fonly, " ,");   /* split at spaces and commas */
  while (nextarg != NULL) {
    fprintf(thepipe, "FILEONLY %s\n", nextarg);
    nextarg = strtok((char *)NULL, " ,");
  }

  nextarg = strtok(donly, " ,");
  while (nextarg != NULL) {
    fprintf(thepipe, "FILEONLY %s", nextarg);
    if (nextarg[strlen(nextarg) - 1] != '/')
      fprintf(thepipe, "/*\n");   /* terminate dirs with slashes */
    else
      fprintf(thepipe, "*\n");
    nextarg = strtok((char *)NULL, " ,");
  }

  nextarg = strtok(fign, " ,");
  while (nextarg != NULL) {
    fprintf(thepipe, "FILEIGNORE %s\n", nextarg);
    nextarg = strtok((char *)NULL, " ,");
  }

  nextarg = strtok(dign, " ,");
  while (nextarg != NULL) {
    fprintf(thepipe, "FILEIGNORE %s", nextarg);
    if (nextarg[strlen(nextarg) - 1] != '/')
      fprintf(thepipe, "/*\n");   /* terminate dirs with slashes */
    else
      fprintf(thepipe, "*\n");
    nextarg = strtok((char *)NULL, " ,");
  }

  return(pclose(thepipe));  /* return same value as called program */

}
