/*** analog 1.2 ***/
/* Please read Readme.html, or http://www.statslab.cam.ac.uk/~sret1/analog/  */

/*** alias.c; functions to cope with aliasing, etc. ***/

#include "analhead2.h"

flag doaliashost(char *hostn)
{   /* apply all required aliases to a hostname */
  extern flag dnsq;
  extern struct alias *hostaliashead;

  unsigned long addr;
  const char *addrp;
  struct hostent *tempp;
  struct alias *aliasp;
  flag anydone = OFF;
  int i;

  if (dnsq) {   /* look up numerical addresses */
    if (isdigit(hostn[0])) {   /* safe for non-numerical addresses starting
				  with a number; they will be unchanged. */
      addr = inet_addr(hostn);
      if (addr != INET_ADDR_ERR) {
	addrp = (const char *) &addr;
	tempp = gethostbyaddr(addrp, sizeof(struct in_addr), AF_INET);
	if (tempp != NULL) {
	  strncpy(hostn, tempp -> h_name, MAXSTRINGLENGTH - 1);
	  hostn[MAXSTRINGLENGTH - 1] = '\0';
	  anydone = ON;
	}
      }
    }
  }
	
  /* convert to lower case */

  for (i = strlen(hostn) - 1; i >= 0; i--) {
    if (isupper(hostn[i])) {
      hostn[i] = tolower(hostn[i]);
      anydone = ON;
    }
  }

  /* alias conversion from configuration file */

  aliasp = hostaliashead;

  while (aliasp -> from[0] != '\0') {
    if (strcmp(aliasp -> from, hostn) == 0) {
      strcpy(hostn, aliasp -> to);
      anydone = ON;
    }
    aliasp = aliasp -> next;
  }

  return(anydone);

}

char *reversehostname(char *hostn)
{  /* reverse an internet hostname (cam.ac.uk -> uk.ac.cam). Return a pointer
      to the reversed name, and leave the hostname changed on exit */

  char tempstr[MAXSTRINGLENGTH];
  char *tempp;
  int i = 0;

  while ((tempp = strrchr(hostn, '.')) != NULL) {
    strcpy(tempstr + i, tempp + 1);
    i = strlen(tempstr);
    tempstr[i] = '.';
    i++;
    *tempp = '\0';
  }

  strcpy(tempstr + i, hostn);

  return(strcpy(hostn, tempstr));

}


flag doaliasurl(char *filename)
{  /* apply all required aliases to a filename */

  extern int dirsufflength;
  extern struct alias *filealiashead;
  extern struct wildalias *filewaliashead;

  flag anydone = OFF, done;
  char *tempp;
  char tempstr[MAXSTRINGLENGTH];
  unsigned int tempint;
  struct alias *aliasp;
  struct wildalias *waliasp;

  /* First, change %7E to ~, etc. */
  tempp = filename;
  while ((tempp = strchr(tempp, '%')) != NULL) {
    sscanf(tempp + 1, "%2x", &tempint);
    if (tempint > 0x20 && tempint < 0x7F) {
      anydone = ON;
      *tempp = tempint;
      strcpy(tempstr, tempp + 3);
      strcpy(tempp + 1, tempstr);
      /* strcpy(tempp + 1, tempp + 3) may not be safe on all machines
	 (overlapping arguments) */
    }
    tempp++;
  }

  /* Secondly, if it ends with the DIRSUFFIX (usually index.html), strip it */

  if (dirsufflength > 0) {
    if ((strcmp(filename + MAX(strlen(filename) - dirsufflength, 0),
	       DIRSUFFIX) == 0) &&
	*(filename + MAX(strlen(filename) - dirsufflength - 1, 0)) == '/') {
      filename[strlen(filename) - dirsufflength] = '\0';
      anydone = ON;
    }
  }

  /* Thirdly, // -> /  ;  /./ -> /  ;  /spam/../ -> /  (except  at start) */
  /* We could worry about trailing /. and /.. but they should be 302 redirects
     anyway so shouldn't matter */
  /* NB On our server //Dept/ -> /Dept/, but //~sret1/ doesn't -> /~sret1/
     But that doesn't matter because the latter will be 404 not found, so
     won't ever get this far. Successes will have been interpreted in the
     following way, and that's all we care about. */

  tempp = filename;
  while ((tempp = strstr(tempp, "//")) != NULL) {
    if (tempp != filename && *(tempp - 1) == ':')
      tempp++;   /* Don't translate http:// ; just skip to next //  */
    else {
      anydone = ON;
      strcpy(tempstr, tempp + 2);
      strcpy(tempp + 1, tempstr);
    }
  }

  tempp = filename;
  while ((tempp = strstr(tempp, "/./")) != NULL) {
    anydone = ON;
    strcpy(tempstr, tempp + 3);
    strcpy(tempp + 1, tempstr);
  }

  tempp = filename;
  while ((tempp = strstr(tempp, "/../")) != NULL) {
    anydone = ON;
    strcpy(tempstr, tempp + 4);
    if (tempp != filename)  /* go back to prev slash */
    while (*(--tempp) != '/')
      ;
    strcpy(tempp + 1, tempstr);
  }

  /* Fourthly, alias conversion from config. file */

  aliasp = filealiashead;

  done = OFF;
  while (aliasp -> from[0] != '\0' && !done) {
    if (strcmp(aliasp -> from, filename) == 0) {
      strcpy(filename, aliasp -> to);
      anydone = ON;
      done = ON;
    }
    aliasp = aliasp -> next;
  }

  /* Fifthly, wild alias conversion */

  waliasp = filewaliashead;

  while (waliasp -> flength != -1 && !done) {
    if (strncmp(waliasp -> from, filename, (size_t)(waliasp -> flength)) == 0
	&& strlen(filename) + waliasp -> tlength - waliasp -> flength <
	MAXSTRINGLENGTH - 1) {   /* o/wise will overflow */
      strcpy(tempstr, waliasp -> to);
      strcpy(tempstr + waliasp -> tlength, filename + waliasp -> flength);
      strcpy(filename, tempstr);
      anydone = ON;
      done = ON;
    }
    waliasp = waliasp -> next;
  }


  return(anydone);

}


int hosttodomcode(char *hostn)
{    /* find the domain code for a certain hostname */

  extern struct domain *domainhead[];

  char domainname[MAXSTRINGLENGTH];
  register int i;

  int x;

  /* first change hostn into a domain */

  for (i = strlen(hostn) - 1; hostn[i] != '.' && i > 0; i--)
    ;     /* run back to final '.' (or initial char) */

  if (isdigit(hostn[i + 1]))
    return(DOMHASHSIZE - 1);   /* representing numerical hosts */

  if (i == 0)
    return(DOMHASHSIZE - 2);   /* representing unknown hosts */

  strcpy(domainname, hostn + i + 1);
	    
  x = (domainname[0] - 'a') * 52 + (domainname[1] - 'a') * 2 +
    (domainname[2] != '\0');

  if (x < 0 || x > DOMHASHSIZE - 3)  /* some funny characters messed it up */
    return(DOMHASHSIZE - 2);

  if (domainhead[x] -> name == NULL)
    return(DOMHASHSIZE - 2);      /* no domain at that domaincode */

  if (strcmp(domainhead[x] -> id, domainname) != 0)
    return(DOMHASHSIZE - 2);      /* right code, nevertheless wrong domain */

  return(x);

}

void urltodir(char *filename)
{  /* converts a filename to a dir for a level 'dirlevel' directory report */

  extern int dirlevel;

  register int i = 0, j;

  for (j = 0; j < dirlevel; j++) {
    if (filename[i] == '/')
      i++;
    for ( ; filename[i] != '/' && filename[i] != '\0'; i++)
      ;     /* run through to level'th slash, if any */
  }
  
  if (filename[i] == '\0')   /* not j levels; run back */
    for ( i-- ; filename[i] != '/' && i > 0; i--)
      ;

  if (filename[i] != '/')
    strcpy(filename, "[no directory]");
  else {
    filename[i + 1] = '\0';     /* Terminate it straight after the / */
    if (i == 0)
      strcpy(filename, "[root directory]");
  }

}

flag wantfile(char filename[MAXSTRINGLENGTH])
{  /* whether we want to analyse a certain file (i.e. it is not masked out) */

  extern struct stringlist *fileignorehead, *fileonlyhead;
  extern struct wstringlist *filewignorehead, *filewonlyhead;

  struct stringlist *stringp;
  struct wstringlist *wstringp;

  /* first, do any required aliases */
  doaliasurl(filename);

  /* secondly, if it matches any of the IGNOREs, throw it out straight away */
  for (stringp = fileignorehead; stringp -> name[0] != '\0';
       stringp = stringp -> next) {
    if (strcmp(filename, stringp -> name) == 0) {
      return(FALSE);
    }
  }

  for (wstringp = filewignorehead; wstringp -> length != -1;
       wstringp = wstringp -> next) {
    if (strncmp(filename, wstringp -> name,
		(size_t)(wstringp -> length)) == 0) {
      return(FALSE);
    }
  }

  /* now if there are no ONLYs, accept it */

  if (fileonlyhead -> name[0] == '\0' && filewonlyhead -> length == -1)
    return(TRUE);

  /* otherwise, it has to match one of the ONLYs */

  for (stringp = fileonlyhead; stringp -> name[0] != '\0';
       stringp = stringp -> next) {
    if (strcmp(filename, stringp -> name) == 0) {
      return(TRUE);
    }
  }

  for (wstringp = filewonlyhead; wstringp -> length != -1;
       wstringp = wstringp -> next) {
    if (strncmp(filename, wstringp -> name,
		(size_t)(wstringp -> length)) == 0) {
      return(TRUE);
    }
  }

  /* if it doesn't match any of them, we don't want it */

  return(FALSE);

}


flag wanthost(char hostn[MAXSTRINGLENGTH])
{  /* Now exactly the same for hosts */

  extern struct stringlist *hostignorehead, *hostonlyhead;
  extern struct wstringlist *hostwignorehead, *hostwonlyhead;
  extern struct wstringlist *hostnignorehead, *hostnonlyhead;

  struct stringlist *stringp;
  struct wstringlist *wstringp;

  int len;

  doaliashost(hostn);

  for (stringp = hostignorehead; stringp -> name[0] != '\0';
       stringp = stringp -> next) {
    if (strcmp(hostn, stringp -> name) == 0) {
      return(FALSE);
    }
  }

  len = strlen(hostn);

  for (wstringp = hostwignorehead; wstringp -> length != -1;
       wstringp = wstringp -> next) {
    if ((strcmp(hostn + MAX(len - wstringp -> length, 0),
		wstringp -> name) == 0) ||
	(wstringp -> name[0] == '.' &&
	 strcmp(hostn, (wstringp -> name) + 1) == 0)) {
      return(FALSE);
    }
  }

  for (wstringp = hostnignorehead; wstringp -> length != -1;
       wstringp = wstringp -> next) {
    if (isdigit(hostn[strlen(hostn) - 1]) &&  /* numerical host */
	strncmp(hostn, wstringp -> name, (size_t)(wstringp -> length)) == 0) {
      return(FALSE);
    }
  }

  if (hostonlyhead -> name[0] == '\0' && hostwonlyhead -> length == -1
      && hostnonlyhead -> length == -1)
    return(TRUE);

  for (stringp = hostonlyhead; stringp -> name[0] != '\0';
       stringp = stringp -> next) {
    if (strcmp(hostn, stringp -> name) == 0) {
      return(TRUE);
    }
  }

  for (wstringp = hostwonlyhead; wstringp -> length != -1;
       wstringp = wstringp -> next) {
    if ((strcmp(hostn + MAX(len - wstringp -> length, 0),
		wstringp -> name) == 0) ||
	(wstringp -> name[0] == '.' &&
	 strcmp(hostn, (wstringp -> name) + 1) == 0)) {
      return(TRUE);
    }
  }

  for (wstringp = hostnonlyhead; wstringp -> length != -1;
       wstringp = wstringp -> next) {
    if (isdigit(hostn[strlen(hostn) - 1]) &&  /* numerical host */
	strncmp(hostn, wstringp -> name, (size_t)(wstringp -> length)) == 0) {
      return(TRUE);
    }
  }

  return(FALSE);

}

flag ispage(char *filename)
{   /* whether a certain filename represents a page; basically the same as
       the last two functions */

  extern struct stringlist *ispagehead, *isnotpagehead;
  extern struct wstringlist *wispagehead, *wisnotpagehead;

  struct stringlist *stringp;
  struct wstringlist *wstringp;

  int len;

  /* NB we've done all aliases long ago */

  len = strlen(filename);

  for (stringp = isnotpagehead; stringp -> name[0] != '\0';
       stringp = stringp -> next) {
    if (strcmp(filename, stringp -> name) == 0) {
      return(FALSE);
    }
  }

  for (wstringp = wisnotpagehead; wstringp -> length != -1;
       wstringp = wstringp -> next) {
    if (strcmp(filename + MAX(len - wstringp -> length, 0),
	       wstringp -> name) == 0) {
      return(FALSE);
    }
  }

  /* We never return TRUE at this point, because there are always ISPAGEs */

  for (stringp = ispagehead; stringp -> name[0] != '\0';
       stringp = stringp -> next) {
    if (strcmp(filename, stringp -> name) == 0) {
      return(TRUE);
    }
  }

  for (wstringp = wispagehead; wstringp -> length != -1;
       wstringp = wstringp -> next) {
    if (strcmp(filename + MAX(len - wstringp -> length, 0),
	       wstringp -> name) == 0) {
      return(TRUE);
    }
  }

  return(FALSE);

}
