/******************************************************************
Copyright 1993 by Silicon Graphics Inc., Mountain View, California,

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Silicon Graphics not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

SILICON GRAPHICS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL SILICON GRAPHICS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* $Revision: 1.4 $ */

/* cc -o punch punch.c -lXi -lXext -lX11 */

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/extensions/XInput.h>

/*
 * XXX show how valuator events would also be handled.
 */
/* #define VAL */

Display        *dpy;

/*
 * XXX fill this table in with your own favorite commands; would be nice if
 * this was read out of a .punchrc file instead of hardcoded.
 */
char           *cmd_table[32] =
{
    "xwsh &",
    "xfig &",
    "xrn-motif &",
    "xcalc &",
    "xterm &",
    NULL,			/* the rest continues NULL */
};

Window          root;
int             white;
int             black;
int             screen;
int             scrn_width;
int             scrn_height;
Window          window;
XFontStruct    *font_info;
GC              gc;
int             ascent;
int             height;
int             width;

#define NICE_FONT "-b&h-lucida-medium-r-normal-sans-20-0-*-*-p-*-iso8859-1"

void
create_message_window()
{
    XSetWindowAttributes xswa;
    XGCValues       values;

    font_info = XLoadQueryFont(dpy, NICE_FONT);
    if (font_info == NULL) {
	fprintf(stderr, "punch: could not open fixed font\n");
	exit(1);
    }
    ascent = font_info->max_bounds.ascent;
    height = ascent + font_info->max_bounds.descent;
    width = XTextWidth(font_info, "String at least this long",
		       sizeof("String at least this long"));
    xswa.background_pixel = white;
    xswa.border_pixel = black;
    xswa.override_redirect = True;
    window = XCreateWindow(dpy, root, scrn_width - 10 - width - 10,
			   scrn_height - 10 - height - 10, width + 10,
			   height + 10, 2, CopyFromParent, CopyFromParent,
			   CopyFromParent, CWBackPixel |
			   CWBorderPixel | CWOverrideRedirect,
			   &xswa);
    values.foreground = black;
    values.background = white;
    values.font = font_info->fid;
    gc = XCreateGC(dpy, window, GCForeground | GCBackground | GCFont, &values);
}

void
display_message(message)
    char           *message;
{
    XRaiseWindow(dpy, window);
    XMapWindow(dpy, window);
    XDrawString(dpy, window, gc, 7, 5 + ascent, message, strlen(message));
    XFlush(dpy);
}

void
undisplay_message()
{
    XUnmapWindow(dpy, window);
    XFlush(dpy);
}

void
main(argc, argv)
    int             argc;
    char           *argv[];
{
    XExtensionVersion *version;
    XDeviceInfo    *device_info;
    char           *arg;
    int             num_dev;
    XID             device_id;
    XDevice        *db;
    char           *display_name;
    int             i;
    Bool            device_exists = False;
    XEvent          xevent;
    XEventClass     event_list[2];
    XDeviceButtonEvent *devbut_event = (XDeviceButtonEvent *) & xevent;
    XDeviceMotionEvent *devmot_event = (XDeviceMotionEvent *) & xevent;
    int             DeviceButtonPressType;
    int             DeviceMotionNotifyType;
    int             num_events;
    int             button;

    display_name = NULL;
    for (i = 1; i < argc; i++) {
	arg = argv[i];
	if (strcmp(arg, "-display") == 0 || strcmp(arg, "-d") == 0) {
	    if (++i >= argc) {
		fprintf(stderr, "nmbxdemo: missing argument to -display\n");
		exit(1);
	    }
	    display_name = argv[i];
	}
    }
    dpy = XOpenDisplay(display_name);
    if (dpy == NULL) {
	fprintf(stderr, "punch: cannot open display %s\n",
		XDisplayName(display_name));
	exit(1);
    }
    version = XGetExtensionVersion(dpy, "XInputExtension");
    if (version == NULL || ((int) version) == NoSuchExtension) {
	fprintf(stderr, "punch: XInputExtension not supported by X server\n");
	exit(1);
    }
    device_info = XListInputDevices(dpy, &num_dev);
    for (i = 0; i < num_dev; i++) {
	/*
	 * XXX search for SGI's device which is named "dial+buttons"; not
	 * very general
	 */
	if (!strcmp(device_info[i].name, "dial+buttons")) {
	    device_exists = True;
	    device_id = device_info[i].id;
	    break;
	}
    }
    XFreeDeviceList(device_info);
    if (!device_exists) {
	fprintf(stderr, "punch: no dial and button box found\n");
	exit(1);
    }
    db = XOpenDevice(dpy, device_id);

    screen = DefaultScreen(dpy);
    root = DefaultRootWindow(dpy);
    black = BlackPixel(dpy, screen);
    white = WhitePixel(dpy, screen);
    scrn_width = DisplayWidth(dpy, screen);
    scrn_height = DisplayHeight(dpy, screen);

    DeviceButtonPress(db, DeviceButtonPressType, event_list[0]);
    num_events = 1;
#ifdef VAL
    DeviceMotionNotify(db, DeviceMotionNotifyType, event_list[1]);
    num_events = 2;
#endif
    XSelectExtensionEvent(dpy, DefaultRootWindow(dpy), event_list, num_events);

    create_message_window();

    while (1) {
	XNextEvent(dpy, &xevent);
	if (devbut_event->type == DeviceButtonPressType) {
	    button = devbut_event->button;
	    if (button >= 1 && button <= 32 && cmd_table[button - 1] != NULL) {
		display_message(cmd_table[button - 1]);
		system(cmd_table[button - 1]);
		sleep(1);
		undisplay_message();
	    }
	}
#ifdef VAL
	else if (devmot_event->type == DeviceMotionNotifyType) {
	    int             i, v;

	    v = devmot_event->first_axis;
	    for (i = 0; i < devmot_event->axes_count; i++, v++) {
		printf("val %d = %d\n", v, devmot_event->axis_data[i]);
	    }
	}
#endif
    }
    XCloseDevice(dpy, db);
    XCloseDisplay(dpy);
}
