/*-------------------------------------------------
  overlayWidget.c

  The following program demonstrates how to access overlay bitplanes
  in OpenGL using GLwMDrawingArea widget.

  Basically, you would create two GLw widgets and have them
  overlapping each other.
  

  To compile it use

  cc -o overlayWidget overlayWidget.c -lGLw -lXm -lXt -lX11 -lGLU -lGL
 ------------------------------------------------*/ 
#include <stdio.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/keysym.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <GL/GLwMDrawA.h>


#define RGB_BLACK   0x000000  
#define RGB_RED	    0x0000ff
#define RGB_GREEN   0x00ff00

static void overlay_cmap_init(Widget glw);
void exposeCB();
void resizeCB();
void initCB();
void OVexposeCB();
void OVresizeCB();
void OVinitCB();
void OVinputCB();
void structureChanged();

GLXContext norm_context, ov_context ;
GLfloat mata[] = {1.0, 1.0, 1.0,1.0};
GLfloat matd[] = {1.0, 1.0, .165, 1.0};
GLfloat mats[] = {.5, .5, .5, 1.0};
GLfloat matsh = 100;

GLfloat lma[] = { .1, .1, .1, 1.0};
GLfloat lml = 1;

GLfloat ltp[] = {0.0, 3.0, 2.0, 0.0};
GLfloat ltc[] = { 1.0, 1.0, 1.0, 1.0};

GLUquadricObj* qobj, *qobj_ov;

static XtAppContext app;
String fallback_resources[] = {
    "*geometry: =500x500",
    "*frame*shadowType: SHADOW_IN",
    NULL
};
Widget toplevel,glw1,glw2;
main(argc, argv)
int argc;
char *argv[];
{
    Arg args[20];
    int n = 0;
    Widget form;


    toplevel = XtAppInitialize (&app, "Overlay Test", NULL, 0, &argc, argv,
                               fallback_resources, NULL, 0);


    form = XtCreateManagedWidget("form",
				   xmFormWidgetClass,
				   toplevel, args, n);

   /* create the normal GLw widget */


    n = 0;
    XtSetArg(args[n], GLwNredSize, 1);  n++;
    XtSetArg(args[n], GLwNgreenSize, 1); n++;
    XtSetArg(args[n], GLwNblueSize, 1); n++;

    XtSetArg(args[n], GLwNdoublebuffer, TRUE); n++;
    XtSetArg(args[n], GLwNrgba, TRUE); n++;

    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    
    glw1 = GLwCreateMDrawingArea (form, "glwidget",args, n);
    XtManageChild (glw1);

    XtAddCallback(glw1, GLwNexposeCallback, exposeCB, 0);
    XtAddCallback(glw1, GLwNresizeCallback, resizeCB, 0);
    XtAddCallback(glw1, GLwNginitCallback, initCB, 0);     
    /* create the overlay GLw widget */
    
    n = 0;
    XtSetArg(args[n], GLwNlevel, 1);  n++;
    XtSetArg(args[n], GLwNbufferSize, 4);  n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    glw2 = GLwCreateMDrawingArea (form, "glwidget",args, n);
    XtManageChild (glw2);

    XtAddCallback(glw2, GLwNexposeCallback, OVexposeCB, 0);
    XtAddCallback(glw2, GLwNginitCallback, OVinitCB, 0);
    XtAddCallback(glw2, GLwNinputCallback, OVinputCB, 0);
    XtAddCallback(glw2, GLwNresizeCallback, OVresizeCB, 0);
    
    XtRealizeWidget(toplevel);

    XtAppMainLoop(app);
}

drawscene ()
{
    static float angx =0.0 ,angy = 0.0;
    glClearColor(0.1,0.2,0.3,0.0);
    glClear(GL_DEPTH_BUFFER_BIT|GL_COLOR_BUFFER_BIT);

    gluSphere(qobj, 1.5, 30, 30);
    glXSwapBuffers(XtDisplay(glw1),XtWindow(glw1));

}


void initCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
GLwDrawingAreaCallbackStruct *call_data;
{
    FILE *fp;
    Arg args[1];

    int i;
    float para[4],xsize,ysize,aspect,x,y,z,bx,by,br;
    XVisualInfo *vi;
    
    XtSetArg(args[0], GLwNvisualInfo, &vi);
    XtGetValues(glw1, args, 1);

    norm_context = glXCreateContext(XtDisplay(glw1), vi, 0, GL_FALSE);
    GLwDrawingAreaMakeCurrent (w, norm_context);
    
/* Use the Widget Size to set aspect ratio */
/*----------------------------------------*/
    glMatrixMode(GL_MODELVIEW); /* multi-matrix mode */
    glEnable(GL_DEPTH_TEST);    /* use Z buffer      */  

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(.1*(450),  1,  2.0,  15.0);

    glMatrixMode(GL_MODELVIEW);
	/* OGLXXX lookat: replace UPx with vector */
    gluLookAt(0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);

/*------------------------------------
  Do the setting of lighting
 -------------------------------------*/

    glMaterialfv (GL_FRONT,GL_AMBIENT,mata);
    glMaterialfv (GL_FRONT,GL_DIFFUSE,matd);
    glMaterialfv (GL_FRONT,GL_SPECULAR,mats);
    glMaterialf (GL_FRONT,GL_SHININESS,matsh);

    glLightModelfv (GL_LIGHT_MODEL_AMBIENT, lma);
    glLightModelf (GL_LIGHT_MODEL_LOCAL_VIEWER,lml);

    glLightfv(GL_LIGHT0,GL_POSITION,ltp);
    glLightfv(GL_LIGHT0,GL_DIFFUSE,ltc);
    
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);

    qobj = gluNewQuadric();

}

void exposeCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
GLwDrawingAreaCallbackStruct *call_data;
{
    GLwDrawingAreaMakeCurrent (w, norm_context);
    drawscene ();
}

void resizeCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
GLwDrawingAreaCallbackStruct *call_data;
{
    GLwDrawingAreaMakeCurrent (w, norm_context);
    glViewport(0,0,call_data->width,call_data->height);
    drawscene ();
}

void structureChanged (w, client,event)
Widget w;
caddr_t client;
XEvent *event;
{
    if (event->type == MapNotify)
       XRaiseWindow (XtDisplay (w), XtWindow (w));
}

void OVinitCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
GLwDrawingAreaCallbackStruct *call_data;
{
    Arg args[5];
    XVisualInfo *vi;
    Colormap cmap;
    XtSetArg(args[0], GLwNvisualInfo, &vi);
    XtSetArg(args[1], XmNcolormap, &cmap);
    XtGetValues(w, args, 2);

    ov_context = glXCreateContext(XtDisplay(w), vi, 0, GL_FALSE);
    GLwDrawingAreaMakeCurrent (w, ov_context);
    
    /* add event handler to handle mapnotify events
       whenever mapped, raise the overlay window on top of
       normal window */
    
    XtAddEventHandler (w,StructureNotifyMask,False,structureChanged,NULL);
    
    glMatrixMode(GL_PROJECTION);
    glOrtho(-1, 1, -1, 1, 1, 3);
    glMatrixMode(GL_MODELVIEW);
    glTranslatef(0.0, 0.0, -4.0);
    glLineWidth(2.0);

    /* set the colormap */
    if (vi->class == PseudoColor) {
	int mapSize = 1 << vi->depth;
	int firstEntry = 0;
	int entry;
	unsigned long *pixels;

	pixels = (unsigned long *) calloc(mapSize, sizeof(unsigned long));

	if (!XAllocColorCells(XtDisplay(w) , cmap, True, NULL, 0, pixels, mapSize))
	{
	    if (!XAllocColorCells(XtDisplay(w), cmap, True, NULL, 0, pixels, mapSize-1))
	    {
		fprintf(stderr, "can't alloc enough colormap entries\n");
		exit(-1);
	    }
	    firstEntry = 1;
	}

	for (entry=firstEntry; entry<mapSize; ++entry) {
	    XColor xcol;
	    int hue = entry % 8;
	    short val = 0xffff;

	    xcol.pixel = entry;
	    xcol.red   = (hue==1 || hue==5 || hue==6 || hue==7) ? val : 0;
	    xcol.green = (hue==2 || hue==4 || hue==6 || hue==7) ? val : 0;
	    xcol.blue  = (hue==3 || hue==4 || hue==5 || hue==7) ? val : 0;
	    xcol.flags = DoRed | DoGreen | DoBlue;

	    XStoreColor(XtDisplay(w), cmap, &xcol);
	}

	free((void *) pixels);
    }

     qobj_ov = gluNewQuadric();
    
}

void OVexposeCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
GLwDrawingAreaCallbackStruct *call_data;
{
    GLwDrawingAreaMakeCurrent (w, ov_context);
    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
    glIndexf (0.0);
    glClear(GL_COLOR_BUFFER_BIT);
    glIndexf (2.);
    gluSphere(qobj_ov, 1.5, 30, 30);
}

void OVinputCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
GLwDrawingAreaCallbackStruct *call_data;
{
    KeySym keysym;
    char buffer[1];

    switch(call_data->event->type)
    {
      case KeyRelease:
	if (XLookupString((XKeyEvent *)call_data->event,buffer,1,&keysym,NULL) == 1 &&
	    keysym == (KeySym)XK_Escape)
	    exit(0);
	break;
    }
}

void OVresizeCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
GLwDrawingAreaCallbackStruct *call_data;
{
    GLwDrawingAreaMakeCurrent (w, ov_context);
    glViewport(0,0,call_data->width,call_data->height);
    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
    glIndexf (0.0);
    glClear(GL_COLOR_BUFFER_BIT);
    glIndexf (2.);
    gluSphere(qobj_ov, 1.5, 30, 30);
}


