#include "timeit.h"

//
// For ease of understanding and comparison between
// test results on WIN32 and UNIX, define sleep and
// usleep on WIN32 to be equivalent in functionality
// to the traditional UNIX functions.
//
#ifdef WIN32
#include <windows.h>
#define sleep( t )  Sleep( t*1e3 )
#define usleep( t ) Sleep( t*1e-3 )
#else
#include <unistd.h>
#endif

#include <iostream.h>

//
// dowork() - Function to occupy some time.
//
void dowork( void )
{
  sleep( 2 );
  usleep( 12345 );
}

//
// main() - Main function for timer test program.  Get a new timer.
//          Start it.  Do some work.  Stop the timer and then
//          print the results first in seconds and useconds.
//
int main( void )
{
  timeobj *tt = timeit_new();
  timeit_start( tt );
  dowork();
  timeit_stop( tt );
  
  cerr << "timeit: " << timeit_getf( tt, timeit_seconds ) << endl;
  cerr << "timeit: " << timeit_geti( tt, timeit_useconds ) << endl;
  timeit_delete( tt );

  return( 0 );
}
