#ifndef WIN32
#include "xgltrace.h"
#include "dll.h"

extern void printStat();

Bool glXMakeCurrent( Display *dpy,GLXDrawable drawable,GLXContext ctx )
{
  stat->xgl[API_glXMakeCurrent]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXMakeCurrent]);

  return ((Bool(*)(Display *,GLXDrawable,GLXContext ))lib->xglFunc[API_glXMakeCurrent])(dpy, drawable, ctx);  
}

void glXSwapBuffers( Display *dpy,GLXDrawable drawable )
{
  stat->xgl[API_glXSwapBuffers]++;
  if (file) {
      fprintf(file, "%s\n",xglNames[API_glXSwapBuffers]);
      fflush(file);
  }

  // If tracking statistics and refreshing on swapbuffer calls,
  // print the statistics and reset the counters.
  if (stat->doStat && stat->onSwap) {
      printStat();
      statReset();
  }

  ((void (*)(Display *,GLXDrawable ))lib->xglFunc[API_glXSwapBuffers])(dpy, drawable);
}

XVisualInfo* glXChooseVisual (Display *dpy, int screen, int *attribList) 
{
  stat->xgl[API_glXChooseVisual]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXChooseVisual]);

  return ((XVisualInfo *(*)(Display *,int,int *))lib->xglFunc[API_glXChooseVisual])(dpy, screen, attribList);
  
}

void glXCopyContext (Display *dpy, GLXContext src, GLXContext dst, GLuint mask)
{
  stat->xgl[API_glXCopyContext]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXCopyContext]);

  ((void(*)(Display *,GLXContext,GLXContext,GLuint))lib->xglFunc[API_glXCopyContext])(dpy, src, dst, mask);
  
}

GLXContext glXCreateContext (Display *dpy, XVisualInfo *vis, GLXContext shareList, Bool direct)
{
  stat->xgl[API_glXCreateContext]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXCreateContext]);

  return ((GLXContext(*)(Display *,XVisualInfo *,GLXContext,Bool))lib->xglFunc[API_glXCreateContext])(dpy, vis, shareList, direct);
  
}

GLXPixmap glXCreateGLXPixmap (Display *dpy, XVisualInfo *vis, Pixmap pixmap)
{
  stat->xgl[API_glXCreateGLXPixmap]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXCreateGLXPixmap]);

  return ((GLXPixmap(*)(Display *,XVisualInfo *,Pixmap))lib->xglFunc[API_glXCreateGLXPixmap])(dpy, vis, pixmap);
  
}

void glXDestroyContext (Display *dpy, GLXContext ctx)
{
  stat->xgl[API_glXDestroyContext]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXDestroyContext]);

  ((void(*)(Display *,GLXContext))lib->xglFunc[API_glXDestroyContext])(dpy, ctx);
  
}

void glXDestroyGLXPixmap (Display *dpy, GLXPixmap pix)
{
  stat->xgl[API_glXDestroyGLXPixmap]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXDestroyGLXPixmap]);

  ((void(*)(Display *,GLXPixmap))lib->xglFunc[API_glXDestroyGLXPixmap])(dpy, pix);
  
}

int glXGetConfig (Display *dpy, XVisualInfo *vis, int attrib, int *value)
{
  stat->xgl[API_glXGetConfig]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXGetConfig]);

  return ((int(*)(Display *,XVisualInfo *,int,int *))lib->xglFunc[API_glXGetConfig])(dpy, vis, attrib, value);
  
}

GLXContext glXGetCurrentContext (void)
{
  stat->xgl[API_glXGetCurrentContext]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXGetCurrentContext]);

  return ((GLXContext(*)(void))lib->xglFunc[API_glXMakeCurrent])();
  
}

GLXDrawable glXGetCurrentDrawable (void)
{
  stat->xgl[API_glXGetCurrentDrawable]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXGetCurrentDrawable]);

  return ((GLXDrawable(*)(void))lib->xglFunc[API_glXMakeCurrent])();
  
}

Bool glXIsDirect (Display *dpy, GLXContext ctx)
{
  stat->xgl[API_glXIsDirect]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXIsDirect]);

  return ((Bool(*)(Display *,GLXContext))lib->xglFunc[API_glXIsDirect])(dpy, ctx);

}

Bool glXQueryExtension (Display *dpy, int *errorBase, int *eventBase)
{
  stat->xgl[API_glXQueryExtension]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXQueryExtension]);

  return ((Bool(*)(Display *,int *,int *))lib->xglFunc[API_glXQueryExtension])(dpy, errorBase, eventBase);
  
}

Bool glXQueryVersion (Display *dpy, int *major, int *minor)
{
  stat->xgl[API_glXQueryVersion]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXQueryVersion]);

  return ((Bool(*)(Display *,int *,int *))lib->xglFunc[API_glXQueryVersion])(dpy, major, minor);
  
}

void glXUseXFont (Font font, int first, int count, int listBase)
{
  stat->xgl[API_glXUseXFont]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXUseXFont]);

  ((void(*)(Font,int,int,int))lib->xglFunc[API_glXUseXFont])(font, first, count, listBase);
  
}

void glXWaitGL (void)
{
  stat->xgl[API_glXWaitGL]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXWaitGL]);

  ((void(*)(void))lib->xglFunc[API_glXWaitGL])();
  
}

void glXWaitX (void)
{
  stat->xgl[API_glXWaitX]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXWaitX]);

  ((void(*)(void))lib->xglFunc[API_glXWaitX])();

}

const char * glXGetClientString (Display *dpy, int name )
{
  stat->xgl[API_glXGetClientString]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXGetClientString]);

  return ((const char *(*)(Display *,int))lib->xglFunc[API_glXGetClientString])(dpy, name);

}

const char * glXQueryServerString (Display *dpy, int screen, int name )
{
  stat->xgl[API_glXQueryServerString]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXQueryServerString]);

  return ((const char *(*)(Display *,int,int))lib->xglFunc[API_glXQueryServerString])(dpy, screen, name);

}

const char * glXQueryExtensionsString (Display *dpy, int screen )
{
  stat->xgl[API_glXQueryExtensionString]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXQueryExtensionString]);

  return ((const char *(*)(Display *,int))lib->xglFunc[API_glXQueryExtensionString])(dpy, screen);
  
}

Display * glXGetCurrentDisplay (void)
{
  stat->xgl[API_glXGetCurrentDisplay]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXGetCurrentDisplay]);

  return ((Display *(*)(void))lib->xglFunc[API_glXGetCurrentDisplay])();

}

GLXContextID glXGetContextIDEXT (const GLXContext ctx)
{
  stat->xgl[API_glXGetContextIDEXT]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXGetContextIDEXT]);

  return ((GLXContextID(*)(const GLXContext))lib->xglFunc[API_glXGetContextIDEXT])(ctx);
  
}

GLXDrawable glXGetCurrentDrawableEXT (void)
{
  stat->xgl[API_glXGetCurrentDrawableEXT]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXGetCurrentDrawableEXT]);

  return ((GLXDrawable(*)(void))lib->xglFunc[API_glXGetCurrentDrawableEXT])();
  
}

GLXContext glXImportContextEXT (Display *dpy, GLXContextID contextID)
{
  stat->xgl[API_glXImportContextEXT]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXImportContextEXT]);

  return ((GLXContext(*)(Display *,GLXContextID))lib->xglFunc[API_glXImportContextEXT])(dpy, contextID);
  
}

void glXFreeContextEXT (Display *dpy, GLXContext ctx)
{
  stat->xgl[API_glXFreeContextEXT]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXFreeContextEXT]);

  ((void(*)(Display *,GLXContext))lib->xglFunc[API_glXFreeContextEXT])(dpy, ctx);
  
}

int glXQueryContextInfoEXT (Display *dpy, GLXContext ctx, int attribute, int *value)
{
  stat->xgl[API_glXQueryContextInfoEXT]++;

  if (file)
    fprintf(file, "%s\n",xglNames[API_glXQueryContextInfoEXT]);

  return ((int(*)(Display *,GLXContext,int,int *))lib->xglFunc[API_glXQueryContextInfoEXT])(dpy, ctx, attribute, value);
  
}

#endif










