#include "ogltrace.h"
#include "dll.h"

WINGDIAPI void APIENTRY glAccum (GLenum op, GLfloat value) 
{
  stat->gl[API_glAccum]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glAccum]);

  ((void (*)(GLenum , GLfloat))lib->glFunc[API_glAccum])(op, value);
}

WINGDIAPI void APIENTRY glAlphaFunc (GLenum func, GLclampf ref) 
{
  stat->gl[API_glAlphaFunc]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glAlphaFunc]);

  ((void (*)(GLenum , GLclampf ))lib->glFunc[API_glAlphaFunc])(func,ref);
}

WINGDIAPI GLboolean APIENTRY glAreTexturesResident (GLsizei n, const GLuint *textures, GLboolean *residences) 
{
  stat->gl[API_glAreTexturesResident]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glAreTexturesResident]);

  return ((GLboolean (*)(GLsizei , const GLuint *, GLboolean *))lib->glFunc[API_glAreTexturesResident])(n, textures, residences);
}

WINGDIAPI void APIENTRY glArrayElement (GLint i) 
{
  stat->gl[API_glArrayElement]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glArrayElement]);

  ((void (*)(GLint ))lib->glFunc[API_glArrayElement])(i) ;
}

WINGDIAPI void APIENTRY glBegin (GLenum mode) 
{
  stat->gl[API_glBegin]++;
  if (file || stat->doStat)
    {
      primBegin(mode);
      if (file)	
	fprintf(file, "%s(%s);\n",glNames[API_glBegin], stateBegin(stat->beginEnd));
    }

  ((void (*)(GLenum))lib->glFunc[API_glBegin])(mode);
}

WINGDIAPI void APIENTRY glBindTexture (GLenum target, GLuint texture) 
{
  stat->gl[API_glBindTexture]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glBindTexture]);

  ((void (*)(GLenum, GLuint))lib->glFunc[API_glBindTexture])(target, texture);
}

WINGDIAPI void APIENTRY glBitmap (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap) 
{
  stat->gl[API_glBitmap]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glBitmap]);

  ((void (*)(GLsizei , GLsizei , GLfloat , GLfloat , GLfloat , GLfloat , const GLubyte *))lib->glFunc[API_glBitmap])(width, height, xorig, yorig, xmove, ymove, bitmap);
}

WINGDIAPI void APIENTRY glBlendFunc (GLenum sfactor, GLenum dfactor) 
{
  stat->gl[API_glBlendFunc]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glBlendFunc]);

  ((void (*)(GLenum , GLenum ))lib->glFunc[API_glBlendFunc])(sfactor, dfactor);
}

WINGDIAPI void APIENTRY glCallList (GLuint list) 
{
  stat->gl[API_glCallList]++;
  if (file)
    fprintf(file, "%s %d\n",glNames[API_glCallList], list);

  ((void (*)(GLuint ))lib->glFunc[API_glCallList])(list);
}

WINGDIAPI void APIENTRY glCallLists (GLsizei n, GLenum type, const GLvoid *lists) 
{
  stat->gl[API_glCallLists]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glCallLists]);

  ((void (*)(GLsizei , GLenum , const GLvoid *))lib->glFunc[API_glCallLists])(n, type, lists);
}

WINGDIAPI void APIENTRY glClear (GLbitfield mask)
{
  char tmp[255];

  // If tracking statistics and refreshing on glClear() and not
  // on each swapbuffer call, print the statistics and reset
  // the counters.
  if (stat->doStat && !stat->onSwap) {
    printStat();
    statReset();
  }

  stat->gl[API_glClear]++;
  if (file)
    fprintf(file, "%s %s\n",glNames[API_glClear], stateClear(tmp, mask));

  ((void (*)(GLbitfield ))lib->glFunc[API_glClear])(mask);
}

WINGDIAPI void APIENTRY glClearAccum (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
  stat->gl[API_glClearAccum]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glClearAccum]);

  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glClearAccum])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glClearColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
  stat->gl[API_glClearColor]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glClearColor]);

  ((void (*)(GLclampf , GLclampf , GLclampf , GLclampf ))lib->glFunc[API_glClearColor])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glClearDepth (GLclampd depth)
{
  stat->gl[API_glClearDepth]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glClearDepth]);

  ((void (*)(GLclampd ))lib->glFunc[API_glClearDepth])(depth);
}

WINGDIAPI void APIENTRY glClearIndex (GLfloat c)
{
  stat->gl[API_glClearIndex]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glClearIndex]);

  ((void (*)(GLfloat))lib->glFunc[API_glClearIndex])(c);
}

WINGDIAPI void APIENTRY glClearStencil (GLint s)
{
  stat->gl[API_glClearStencil]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glClearStencil]);

  ((void (*)(GLint))lib->glFunc[API_glClearStencil])(s);
}

WINGDIAPI void APIENTRY glClipPlane (GLenum plane, const GLdouble *equation)
{
  stat->gl[API_glClipPlane]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glClipPlane]);

  ((void (*)(GLenum , const GLdouble *))lib->glFunc[API_glClipPlane])(plane, equation);
}

WINGDIAPI void APIENTRY glColor3b (GLbyte red, GLbyte green, GLbyte blue)
{
  stat->gl[API_glColor3b]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3b]);

  ((void (*)(GLbyte , GLbyte , GLbyte))lib->glFunc[API_glColor3b])(red, green, blue);
}

WINGDIAPI void APIENTRY glColor3bv (const GLbyte *v)
{
  stat->gl[API_glColor3bv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3bv]);

  ((void (*)(const GLbyte *))lib->glFunc[API_glColor3bv])(v);
}

WINGDIAPI void APIENTRY glColor3d (GLdouble red, GLdouble green, GLdouble blue)
{
  stat->gl[API_glColor3d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3d]);

  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glColor3d])(red, green, blue);
}

WINGDIAPI void APIENTRY glColor3dv (const GLdouble *v)
{
  stat->gl[API_glColor3dv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3dv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glColor3dv])(v);
}

WINGDIAPI void APIENTRY glColor3f (GLfloat red, GLfloat green, GLfloat blue)
{
  stat->gl[API_glColor3f]++;
  if (file && stat->beginEnd && !stat->noData) {
    fprintf(file, "%s %f %f %f\n",glNames[API_glColor3f],red,green,blue);
    
  }

  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(red, green, blue);
}
WINGDIAPI void APIENTRY glColor3fv (const GLfloat *v)
{
  stat->gl[API_glColor3fv]++;
  if (file && stat->beginEnd && !stat->noData) {
    fprintf(file, "%s %f %f %f\n",glNames[API_glColor3fv],v[0], v[1], v[2]);
    
  }

  ((void (*)(const GLfloat *))lib->glFunc[API_glColor3fv])(v);
}

WINGDIAPI void APIENTRY glColor3i (GLint red, GLint green, GLint blue)
{
  stat->gl[API_glColor3i]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3i]);

  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glColor3i])(red, green, blue);
}

WINGDIAPI void APIENTRY glColor3iv (const GLint *v)
{
  stat->gl[API_glColor3iv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3iv]);

  ((void (*)(const GLint *))lib->glFunc[API_glColor3iv])(v);
}

WINGDIAPI void APIENTRY glColor3s (GLshort red, GLshort green, GLshort blue)
{
  stat->gl[API_glColor3s]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3s]);

  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glColor3s])(red, green, blue);
}

WINGDIAPI void APIENTRY glColor3sv (const GLshort *v)
{
  stat->gl[API_glColor3sv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3sv]);

  ((void (*)(const GLshort *))lib->glFunc[API_glColor3sv])(v);
}

WINGDIAPI void APIENTRY glColor3ub (GLubyte red, GLubyte green, GLubyte blue)
{
  stat->gl[API_glColor3ub]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3ub]);

  ((void (*)(GLubyte , GLubyte , GLubyte ))lib->glFunc[API_glColor3ub])(red, green, blue);
}

WINGDIAPI void APIENTRY glColor3ubv (const GLubyte *v)
{
  stat->gl[API_glColor3ubv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3ubv]);

  ((void (*)(const GLubyte *))lib->glFunc[API_glColor3ubv])(v);
}

WINGDIAPI void APIENTRY glColor3ui (GLuint red, GLuint green, GLuint blue)
{
  stat->gl[API_glColor3ui]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3ui]);

  ((void (*)(GLuint , GLuint , GLuint ))lib->glFunc[API_glColor3ui])(red, green, blue);
}

WINGDIAPI void APIENTRY glColor3uiv (const GLuint *v)
{
  stat->gl[API_glColor3uiv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3uiv]);

  ((void (*)(const GLuint *))lib->glFunc[API_glColor3uiv])(v);
}

WINGDIAPI void APIENTRY glColor3us (GLushort red, GLushort green, GLushort blue)
{
  stat->gl[API_glColor3us]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3us]);

  ((void (*)(GLushort , GLushort , GLushort ))lib->glFunc[API_glColor3us])(red, green, blue);
}

WINGDIAPI void APIENTRY glColor3usv (const GLushort *v)
{
  stat->gl[API_glColor3usv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor3usv]);

  ((void (*)(const GLushort *))lib->glFunc[API_glColor3usv])(v);
}

WINGDIAPI void APIENTRY glColor4b (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha)
{
  stat->gl[API_glColor4b]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4b]);

  ((void (*)(GLbyte , GLbyte , GLbyte , GLbyte ))lib->glFunc[API_glColor4b])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glColor4bv (const GLbyte *v)
{
  stat->gl[API_glColor4bv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4bv]);

  ((void (*)(const GLbyte *))lib->glFunc[API_glColor4bv])(v);
}

WINGDIAPI void APIENTRY glColor4d (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)
{
  stat->gl[API_glColor4d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4d]);

  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glColor4d])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glColor4dv (const GLdouble *v)
{
  stat->gl[API_glColor4dv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4dv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glColor4dv])(v);
}

WINGDIAPI void APIENTRY glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
  stat->gl[API_glColor4f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4f]);

  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor4f])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glColor4fv (const GLfloat *v)
{
  stat->gl[API_glColor4fv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4fv]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glColor4fv])(v);
}

WINGDIAPI void APIENTRY glColor4i (GLint red, GLint green, GLint blue, GLint alpha)
{
  stat->gl[API_glColor4i]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4i]);

  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glColor4i])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glColor4iv (const GLint *v)
{
  stat->gl[API_glColor4iv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4iv]);

  ((void (*)(const GLint *))lib->glFunc[API_glColor4iv])(v);
}

WINGDIAPI void APIENTRY glColor4s (GLshort red, GLshort green, GLshort blue, GLshort alpha)
{
  stat->gl[API_glColor4s]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4s]);

  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glColor4s])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glColor4sv (const GLshort *v)
{
  stat->gl[API_glColor4sv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4sv]);

  ((void (*)(const GLshort *))lib->glFunc[API_glColor4sv])(v);
}

WINGDIAPI void APIENTRY glColor4ub (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
  stat->gl[API_glColor4ub]++;
  if (file && stat->beginEnd && !stat->noData) {
    fprintf(file, "%s %d %d %d %d\n",glNames[API_glColor4ub],red, green, blue, alpha);
  }

  ((void (*)(GLubyte , GLubyte , GLubyte , GLubyte ))lib->glFunc[API_glColor4ub])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glColor4ubv (const GLubyte *v)
{
  stat->gl[API_glColor4ubv]++;
  if (file && stat->beginEnd && !stat->noData) {
    fprintf(file, "%s %d %d %d %d\n",glNames[API_glColor4ubv],v[0], v[1], v[2], v[3]);
    }

  ((void (*)(const GLubyte *))lib->glFunc[API_glColor4ubv])(v);
}

WINGDIAPI void APIENTRY glColor4ui (GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
  stat->gl[API_glColor4ui]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4ui]);

  ((void (*)(GLuint , GLuint , GLuint , GLuint ))lib->glFunc[API_glColor4ui])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glColor4uiv (const GLuint *v)
{
  stat->gl[API_glColor4uiv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4uiv]);

  ((void (*)(const GLuint *))lib->glFunc[API_glColor4uiv])(v);
}

WINGDIAPI void APIENTRY glColor4us (GLushort red, GLushort green, GLushort blue, GLushort alpha)
{
  stat->gl[API_glColor4us]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4us]);

  ((void (*)(GLushort , GLushort , GLushort , GLushort ))lib->glFunc[API_glColor4us])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glColor4usv (const GLushort *v)
{
  stat->gl[API_glColor4usv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColor4usv]);

  ((void (*)(const GLushort *))lib->glFunc[API_glColor4usv])(v);
}

WINGDIAPI void APIENTRY glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
  stat->gl[API_glColorMask]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColorMask]);

  ((void (*)(GLboolean , GLboolean , GLboolean , GLboolean ))lib->glFunc[API_glColorMask])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glColorMaterial (GLenum face, GLenum mode)
{
  char tmp[255];
  stat->gl[API_glColorMaterial]++;
  
  if (file || stat->doStat) {
    char *n = stateColorMaterial(tmp, face, mode);
    if (file)
      fprintf(file, "%s %s\n",glNames[API_glColorMaterial], n);
  }

  ((void (*)(GLenum , GLenum ))lib->glFunc[API_glColorMaterial])(face, mode);
}

WINGDIAPI void APIENTRY glColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
  stat->gl[API_glColorPointer]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glColorPointer]);

  ((void (*)(GLint , GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glColorPointer])(size, type, stride, pointer);
}

WINGDIAPI void APIENTRY glCopyPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
  stat->gl[API_glCopyPixels]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glCopyPixels]);

  ((void (*)(GLint , GLint , GLsizei , GLsizei , GLenum ))lib->glFunc[API_glCopyPixels])(x, y, width, height, type);
}

WINGDIAPI void APIENTRY glCopyTexImage1D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
  stat->gl[API_glCopyTexImage1D]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glCopyTexImage1D]);

  ((void (*)(GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLint ))lib->glFunc[API_glCopyTexImage1D])(target, level, internalformat, x, y, width, border);
}

WINGDIAPI void APIENTRY glCopyTexImage2D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
  stat->gl[API_glCopyTexImage2D]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glCopyTexImage2D]);

  ((void (*)(GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLsizei , GLint ))lib->glFunc[API_glCopyTexImage2D])(target, level, internalformat, x, y, width, height, border);
}

WINGDIAPI void APIENTRY glCopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
  stat->gl[API_glCopyTexSubImage1D]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glCopyTexSubImage1D]);

  ((void (*)(GLenum , GLint , GLint , GLint , GLint , GLsizei ))lib->glFunc[API_glCopyTexSubImage1D])(target, level, xoffset, x, y, width);
}

WINGDIAPI void APIENTRY glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
  stat->gl[API_glCopyTexSubImage2D]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glCopyTexSubImage2D]);

  ((void (*)(GLenum , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei ))lib->glFunc[API_glCopyTexSubImage2D])(target, level, xoffset, yoffset, x, y, width, height);
}

WINGDIAPI void APIENTRY glCullFace (GLenum mode)
{
  stat->gl[API_glCullFace]++;
  if (file)
    fprintf(file, "%s %s\n",glNames[API_glCullFace], stateCullFace(mode));

  ((void (*)(GLenum ))lib->glFunc[API_glCullFace])(mode);
}

WINGDIAPI void APIENTRY glDeleteLists (GLuint list, GLsizei range)
{
  stat->gl[API_glDeleteLists]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glDeleteLists]);

  ((void (*)(GLuint , GLsizei ))lib->glFunc[API_glDeleteLists])(list, range);
}

WINGDIAPI void APIENTRY glDeleteTextures (GLsizei n, const GLuint *textures)
{
  stat->gl[API_glDeleteTextures]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glDeleteTextures]);

  ((void (*)(GLsizei , const GLuint *))lib->glFunc[API_glDeleteTextures])(n, textures);
}

WINGDIAPI void APIENTRY glDepthFunc (GLenum func)
{
  stat->gl[API_glDepthFunc]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glDepthFunc]);

  ((void (*)(GLenum ))lib->glFunc[API_glDepthFunc])(func);
}

WINGDIAPI void APIENTRY glDepthMask (GLboolean flag)
{
  stat->gl[API_glDepthMask]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glDepthMask]);

  ((void (*)(GLboolean ))lib->glFunc[API_glDepthMask])(flag);
}

WINGDIAPI void APIENTRY glDepthRange (GLclampd zNear, GLclampd zFar)
{
  stat->gl[API_glDepthRange]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glDepthRange]);

  ((void (*)(GLclampd , GLclampd ))lib->glFunc[API_glDepthRange])(zNear, zFar);
}

WINGDIAPI void APIENTRY glDisable (GLenum cap)
{
  stat->gl[API_glDisable]++;
  if (file || stat->doStat) {
    char *n = stateAble(cap, stat->Disable);
    if (file)
      fprintf(file, "%s %s\n",glNames[API_glDisable], n);
  }

  ((void (*)(GLenum ))lib->glFunc[API_glDisable])(cap);
}

WINGDIAPI void APIENTRY glDisableClientState (GLenum array)
{
  stat->gl[API_glDisableClientState]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glDisableClientState]);

  ((void (*)(GLenum ))lib->glFunc[API_glDisableClientState])(array);
}

WINGDIAPI void APIENTRY glDrawArrays (GLenum mode, GLint first, GLsizei count)
{
  stat->gl[API_glDrawArrays]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glDrawArrays]);

  ((void (*)(GLenum , GLint , GLsizei ))lib->glFunc[API_glDrawArrays])(mode, first, count);
}

WINGDIAPI void APIENTRY glDrawBuffer (GLenum mode)
{
  stat->gl[API_glDrawBuffer]++;
	if (file)
	  fprintf(file, "%s\n",glNames[API_glDrawBuffer]);

	((void (*)(GLenum ))lib->glFunc[API_glDrawBuffer])(mode);
}

WINGDIAPI void APIENTRY glDrawElements (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices)
{
  stat->gl[API_glDrawElements]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glDrawElements]);

  ((void (*)(GLenum , GLsizei , GLenum , const GLvoid *))lib->glFunc[API_glDrawElements])(mode, count, type, indices);
}

WINGDIAPI void APIENTRY glDrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
  stat->gl[API_glDrawPixels]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glDrawPixels]);

  ((void (*)(GLsizei , GLsizei , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glDrawPixels])(width, height, format, type, pixels);
}

WINGDIAPI void APIENTRY glEdgeFlag (GLboolean flag)
{
  stat->gl[API_glEdgeFlag]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEdgeFlag]);

  ((void (*)(GLboolean ))lib->glFunc[API_glEdgeFlag])(flag);
}

WINGDIAPI void APIENTRY glEdgeFlagPointer (GLsizei stride, const GLboolean *pointer)
{
  stat->gl[API_glEdgeFlagPointer]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEdgeFlagPointer]);

  ((void (*)(GLsizei , const GLboolean *))lib->glFunc[API_glEdgeFlagPointer])(stride, pointer);
}

WINGDIAPI void APIENTRY glEdgeFlagv (const GLboolean *flag)
{
  stat->gl[API_glEdgeFlagv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEdgeFlagv]);

  ((void (*)(const GLboolean *))lib->glFunc[API_glEdgeFlagv])(flag);
}

WINGDIAPI void APIENTRY glEnable (GLenum cap)
{
  stat->gl[API_glEnable]++;
  if (file || stat->doStat) {
    char *n = stateAble(cap, stat->Enable);
    if (file)
      fprintf(file, "%s(%s);\n",glNames[API_glEnable], n);
  }

  ((void (*)(GLenum ))lib->glFunc[API_glEnable])(cap);
}

WINGDIAPI void APIENTRY glEnableClientState (GLenum array)
{
  stat->gl[API_glEnableClientState]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEnableClientState]);

  ((void (*)(GLenum ))lib->glFunc[API_glEnableClientState])(array);
}

WINGDIAPI void APIENTRY glEnd (void)
{
  stat->gl[API_glEnd]++;
  if (file)
    fprintf(file, "%s();\n",glNames[API_glEnd]);
  if (stat->doStat)
    primEnd();

  ((void (*)())lib->glFunc[API_glEnd])();
}

WINGDIAPI void APIENTRY glEndList (void)
{
  stat->gl[API_glEndList]++;
  if (file)
    fprintf(file, "%s();\n",glNames[API_glEndList]);

  ((void (*)())lib->glFunc[API_glEndList])();
}

WINGDIAPI void APIENTRY glEvalCoord1d (GLdouble u)
{
  stat->gl[API_glEvalCoord1d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalCoord1d]);

  ((void (*)(GLdouble ))lib->glFunc[API_glEvalCoord1d])(u);
}

WINGDIAPI void APIENTRY glEvalCoord1dv (const GLdouble *u)
{
  stat->gl[API_glEvalCoord1dv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalCoord1dv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glEvalCoord1dv])(u);
}

WINGDIAPI void APIENTRY glEvalCoord1f (GLfloat u)
{
  stat->gl[API_glEvalCoord1f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalCoord1f]);

  ((void (*)(GLfloat ))lib->glFunc[API_glEvalCoord1f])(u);
}

WINGDIAPI void APIENTRY glEvalCoord1fv (const GLfloat *u)
{
  stat->gl[API_glEvalCoord1fv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalCoord1fv]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glEvalCoord1fv])(u);
}

WINGDIAPI void APIENTRY glEvalCoord2d (GLdouble u, GLdouble v)
{
  stat->gl[API_glEvalCoord2d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalCoord2d]);

  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glEvalCoord2d])(u, v);
}

WINGDIAPI void APIENTRY glEvalCoord2dv (const GLdouble *u)
{
  stat->gl[API_glEvalCoord2dv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalCoord2dv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glEvalCoord2dv])(u);
}

WINGDIAPI void APIENTRY glEvalCoord2f (GLfloat u, GLfloat v)
{
  stat->gl[API_glEvalCoord2f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalCoord2f]);

  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glEvalCoord2f])(u, v);
}

WINGDIAPI void APIENTRY glEvalCoord2fv (const GLfloat *u)
{
  stat->gl[API_glEvalCoord2fv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalCoord2fv]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glEvalCoord2fv])(u);
}

WINGDIAPI void APIENTRY glEvalMesh1 (GLenum mode, GLint i1, GLint i2)
{
  stat->gl[API_glEvalMesh1]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalMesh1]);

  ((void (*)(GLenum , GLint , GLint ))lib->glFunc[API_glEvalMesh1])(mode, i1, i2);
}

WINGDIAPI void APIENTRY glEvalMesh2 (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)
{
  stat->gl[API_glEvalMesh2]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalMesh2]);

  ((void (*)(GLenum , GLint , GLint , GLint , GLint ))lib->glFunc[API_glEvalMesh2])(mode, i1, i2, j1, j2);
}

WINGDIAPI void APIENTRY glEvalPoint1 (GLint i)
{
  stat->gl[API_glEvalPoint1]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalPoint1]);

  ((void (*)(GLint ))lib->glFunc[API_glEvalPoint1])(i);
}

WINGDIAPI void APIENTRY glEvalPoint2 (GLint i, GLint j)
{
  stat->gl[API_glEvalPoint2]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glEvalPoint2]);

  ((void (*)(GLint , GLint ))lib->glFunc[API_glEvalPoint2])(i, j);
}

WINGDIAPI void APIENTRY glFeedbackBuffer (GLsizei size, GLenum type, GLfloat *buffer)
{
  stat->gl[API_glFeedbackBuffer]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glFeedbackBuffer]);

  ((void (*)(GLsizei , GLenum , GLfloat *))lib->glFunc[API_glFeedbackBuffer])(size, type, buffer);
}

WINGDIAPI void APIENTRY glFinish (void)
{
  stat->gl[API_glFinish]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glFinish]);

  ((void (*)())lib->glFunc[API_glFinish])();
}

WINGDIAPI void APIENTRY glFlush (void)
{
  stat->gl[API_glFlush]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glFlush]);

  ((void (*)())lib->glFunc[API_glFlush])();
}

WINGDIAPI void APIENTRY glFogf (GLenum pname, GLfloat param)
{
  stat->gl[API_glFogf]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glFogf]);

  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glFogf])(pname, param);
}

WINGDIAPI void APIENTRY glFogfv (GLenum pname, const GLfloat *params)
{
  stat->gl[API_glFogfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glFogfv]);

  ((void (*)(GLenum , const GLfloat *))lib->glFunc[API_glFogfv])(pname, params);
}

WINGDIAPI void APIENTRY glFogi (GLenum pname, GLint param)
{
  stat->gl[API_glFogi]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glFogi]);

  ((void (*)(GLenum , GLint ))lib->glFunc[API_glFogi])(pname, param);
}

WINGDIAPI void APIENTRY glFogiv (GLenum pname, const GLint *params)
{
  stat->gl[API_glFogiv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glFogiv]);

  ((void (*)(GLenum , const GLint *))lib->glFunc[API_glFogiv])(pname, params);
}

WINGDIAPI void APIENTRY glFrontFace (GLenum mode)
{
  stat->gl[API_glFrontFace]++;
  if (file)
    fprintf(file, "%s %s\n",glNames[API_glFrontFace], stateFrontFace(mode));

  ((void (*)(GLenum ))lib->glFunc[API_glFrontFace])(mode);
}

WINGDIAPI void APIENTRY glFrustum (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
  stat->gl[API_glFrustum]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glFrustum]);

  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glFrustum])(left, right, bottom, top, zNear, zFar);
}

WINGDIAPI GLuint APIENTRY glGenLists (GLsizei range)
{
  stat->gl[API_glGenLists]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGenLists]);

  return ((GLuint (*)(GLsizei))lib->glFunc[API_glGenLists])(range);
}


WINGDIAPI void APIENTRY glGenTextures (GLsizei n, GLuint *textures)
{
  stat->gl[API_glGenTextures]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGenTextures]);

  ((void (*)(GLsizei , GLuint *))lib->glFunc[API_glGenTextures])(n, textures);
}

WINGDIAPI void APIENTRY glGetBooleanv (GLenum pname, GLboolean *params)
{
  stat->gl[API_glGetBooleanv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetBooleanv]);

  ((void (*)(GLenum , GLboolean *))lib->glFunc[API_glGetBooleanv])(pname, params);
}

WINGDIAPI void APIENTRY glGetClipPlane (GLenum plane, GLdouble *equation)
{
  stat->gl[API_glGetClipPlane]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetClipPlane]);

  ((void (*)(GLenum , GLdouble *))lib->glFunc[API_glGetClipPlane])(plane, equation);
}

WINGDIAPI void APIENTRY glGetDoublev (GLenum pname, GLdouble *params)
{
  stat->gl[API_glGetDoublev]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetDoublev]);

  ((void (*)(GLenum , GLdouble *))lib->glFunc[API_glGetDoublev])(pname, params);
}

WINGDIAPI GLenum APIENTRY glGetError (void)
{ 
  stat->gl[API_glGetError]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetError]);

  return ((GLenum (*)())lib->glFunc[API_glGetError])();
}

WINGDIAPI void APIENTRY glGetFloatv (GLenum pname, GLfloat *params)
{
  stat->gl[API_glGetFloatv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetFloatv]);

  ((void (*)(GLenum , GLfloat *))lib->glFunc[API_glGetFloatv])(pname, params);
}

WINGDIAPI void APIENTRY glGetIntegerv (GLenum pname, GLint *params)
{
  stat->gl[API_glGetIntegerv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetIntegerv]);

  ((void (*)(GLenum , GLint *))lib->glFunc[API_glGetIntegerv])(pname, params);
}

WINGDIAPI void APIENTRY glGetLightfv (GLenum light, GLenum pname, GLfloat *params)
{
  stat->gl[API_glGetLightfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetLightfv]);

  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetLightfv])(light, pname, params);
}

WINGDIAPI void APIENTRY glGetLightiv (GLenum light, GLenum pname, GLint *params)
{
  stat->gl[API_glGetLightiv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetLightiv]);

  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetLightiv])(light, pname, params);
}

WINGDIAPI void APIENTRY glGetMapdv (GLenum target, GLenum query, GLdouble *v)
{
  stat->gl[API_glGetMapdv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetMapdv]);

  ((void (*)(GLenum , GLenum , GLdouble *))lib->glFunc[API_glGetMapdv])(target, query, v);
}

WINGDIAPI void APIENTRY glGetMapfv (GLenum target, GLenum query, GLfloat *v)
{
  stat->gl[API_glGetMapfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetMapfv]);

  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetMapfv])(target, query, v);
}

WINGDIAPI void APIENTRY glGetMapiv (GLenum target, GLenum query, GLint *v)
{
  stat->gl[API_glGetMapiv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetMapiv]);

  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetMapiv])(target, query, v);
}

WINGDIAPI void APIENTRY glGetMaterialfv (GLenum face, GLenum pname, GLfloat *params)
{
  stat->gl[API_glGetMaterialfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetMaterialfv]);

  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetMaterialfv])(face, pname, params);
}

WINGDIAPI void APIENTRY glGetMaterialiv (GLenum face, GLenum pname, GLint *params)
{
  stat->gl[API_glGetMaterialiv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetMaterialiv]);

  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetMaterialiv])(face, pname, params);
}

WINGDIAPI void APIENTRY glGetPixelMapfv (GLenum map, GLfloat *values)
{
  stat->gl[API_glGetPixelMapfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetPixelMapfv]);

  ((void (*)(GLenum , GLfloat *))lib->glFunc[API_glGetPixelMapfv])(map, values);
}

WINGDIAPI void APIENTRY glGetPixelMapuiv (GLenum map, GLuint *values)
{
  stat->gl[API_glGetPixelMapuiv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetPixelMapuiv]);

  ((void (*)(GLenum , GLuint *))lib->glFunc[API_glGetPixelMapuiv])(map, values);
}

WINGDIAPI void APIENTRY glGetPixelMapusv (GLenum map, GLushort *values)
{
  stat->gl[API_glGetPixelMapusv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetPixelMapusv]);

  ((void (*)(GLenum , GLushort *))lib->glFunc[API_glGetPixelMapusv])(map, values);
}

WINGDIAPI void APIENTRY glGetPointerv (GLenum pname, GLvoid* *params)
{
  stat->gl[API_glGetPointerv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetPointerv]);

  ((void (*)(GLenum , GLvoid* *))lib->glFunc[API_glGetPointerv])(pname, params);
}

WINGDIAPI void APIENTRY glGetPolygonStipple (GLubyte *mask)
{
  stat->gl[API_glGetPolygonStipple]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetPolygonStipple]);

  ((void (*)(GLubyte *))lib->glFunc[API_glGetPolygonStipple])(mask);
}

WINGDIAPI void APIENTRY glGetTexEnvfv (GLenum target, GLenum pname, GLfloat *params)
{
  stat->gl[API_glGetTexEnvfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetTexEnvfv]);

  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetTexEnvfv])(target, pname, params);
}

WINGDIAPI void APIENTRY glGetTexEnviv (GLenum target, GLenum pname, GLint *params)
{
  stat->gl[API_glGetTexEnviv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetTexEnviv]);

  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetTexEnviv])(target, pname, params);
}

WINGDIAPI void APIENTRY glGetTexGendv (GLenum coord, GLenum pname, GLdouble *params)
{
  stat->gl[API_glGetTexGendv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetTexGendv]);

  ((void (*)(GLenum , GLenum , GLdouble *))lib->glFunc[API_glGetTexGendv])(coord, pname, params);
}

WINGDIAPI void APIENTRY glGetTexGenfv (GLenum coord, GLenum pname, GLfloat *params)
{
  stat->gl[API_glGetTexGenfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetTexGenfv]);

  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetTexGenfv])(coord, pname, params);
}

WINGDIAPI void APIENTRY glGetTexGeniv (GLenum coord, GLenum pname, GLint *params)
{
  stat->gl[API_glGetTexGeniv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetTexGeniv]);

  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetTexGeniv])(coord, pname, params);
}

WINGDIAPI void APIENTRY glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)
{
  stat->gl[API_glGetTexImage]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetTexImage]);

  ((void (*)(GLenum , GLint , GLenum , GLenum , GLvoid *))lib->glFunc[API_glGetTexImage])(target, level, format, type, pixels);
}

WINGDIAPI void APIENTRY glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat *params)
{
  stat->gl[API_glGetTexLevelParameterfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetTexLevelParameterfv]);

  ((void (*)(GLenum , GLint , GLenum , GLfloat *))lib->glFunc[API_glGetTexLevelParameterfv])(target, level, pname, params);
}

WINGDIAPI void APIENTRY glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint *params)
{
  stat->gl[API_glGetTexLevelParameteriv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetTexLevelParameteriv]);

  ((void (*)(GLenum , GLint , GLenum , GLint *))lib->glFunc[API_glGetTexLevelParameteriv])(target, level, pname, params);
}

WINGDIAPI void APIENTRY glGetTexParameterfv (GLenum target, GLenum pname, GLfloat *params)
{
  stat->gl[API_glGetTexParameterfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetTexParameterfv]);

  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetTexParameterfv])(target, pname, params);
}

WINGDIAPI void APIENTRY glGetTexParameteriv (GLenum target, GLenum pname, GLint *params)
{
  stat->gl[API_glGetTexParameteriv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetTexParameteriv]);

  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetTexParameteriv])(target, pname, params);
}

WINGDIAPI void APIENTRY glHint (GLenum target, GLenum mode)
{
  char tmp[255];
  stat->gl[API_glHint]++;
  if (file)
    fprintf(file, "%s %s\n",glNames[API_glHint], stateHint(tmp, target, mode));
  
((void (*)(GLenum , GLenum ))lib->glFunc[API_glHint])(target, mode);
}

WINGDIAPI void APIENTRY glIndexMask (GLuint mask)
{
  stat->gl[API_glIndexMask]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexMask]);

  ((void (*)(GLuint ))lib->glFunc[API_glIndexMask])(mask);
}

WINGDIAPI void APIENTRY glIndexPointer (GLenum type, GLsizei stride, const GLvoid *pointer)
{
  stat->gl[API_glIndexPointer]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexPointer]);

  ((void (*)(GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glIndexPointer])(type, stride, pointer);
}

WINGDIAPI void APIENTRY glIndexd (GLdouble c)
{
  stat->gl[API_glIndexd]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexd]);

  ((void (*)(GLdouble ))lib->glFunc[API_glIndexd])(c);
}

WINGDIAPI void APIENTRY glIndexdv (const GLdouble *c)
{
  stat->gl[API_glIndexdv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexdv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glIndexdv])(c);
}

WINGDIAPI void APIENTRY glIndexf (GLfloat c)
{
  stat->gl[API_glIndexf]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexf]);

  ((void (*)(GLfloat ))lib->glFunc[API_glIndexf])(c);
}

WINGDIAPI void APIENTRY glIndexfv (const GLfloat *c)
{
  stat->gl[API_glIndexfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexfv]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glIndexfv])(c);
}

WINGDIAPI void APIENTRY glIndexi (GLint c)
{
  stat->gl[API_glIndexi]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexi]);

  ((void (*)(GLint ))lib->glFunc[API_glIndexi])(c);
}

WINGDIAPI void APIENTRY glIndexiv (const GLint *c)
{
  stat->gl[API_glIndexiv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexiv]);

  ((void (*)(const GLint *))lib->glFunc[API_glIndexiv])(c);
}

WINGDIAPI void APIENTRY glIndexs (GLshort c)
{
  stat->gl[API_glIndexs]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexs]);

  ((void (*)(GLshort ))lib->glFunc[API_glIndexs])(c);
}

WINGDIAPI void APIENTRY glIndexsv (const GLshort *c)
{
  stat->gl[API_glIndexsv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexsv]);

  ((void (*)(const GLshort *))lib->glFunc[API_glIndexsv])(c);
}

WINGDIAPI void APIENTRY glIndexub (GLubyte c)
{
  stat->gl[API_glIndexub]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexub]);

  ((void (*)(GLubyte ))lib->glFunc[API_glIndexub])(c);
}

WINGDIAPI void APIENTRY glIndexubv (const GLubyte *c)
{
  stat->gl[API_glIndexubv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIndexubv]);

  ((void (*)(const GLubyte *))lib->glFunc[API_glIndexubv])(c);
}

WINGDIAPI void APIENTRY glInitNames (void)
{
  stat->gl[API_glInitNames]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glInitNames]);

  ((void (*)())lib->glFunc[API_glInitNames])();
}

WINGDIAPI void APIENTRY glInterleavedArrays (GLenum format, GLsizei stride, const GLvoid *pointer)
{
  stat->gl[API_glInterleavedArrays]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glInterleavedArrays]);

  ((void (*)(GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glInterleavedArrays])(format, stride, pointer);

}

WINGDIAPI GLboolean APIENTRY glIsEnabled (GLenum cap) 
{ 
  stat->gl[API_glIsEnabled]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIsEnabled]);

  return ((GLboolean (*)(GLenum ))lib->glFunc[API_glIsEnabled])(cap);
}

WINGDIAPI GLboolean APIENTRY glIsList (GLuint list) 
{ 
  stat->gl[API_glIsList]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIsList]);

  return ((GLboolean (*)(GLuint ))lib->glFunc[API_glIsList])(list);
}

WINGDIAPI GLboolean APIENTRY glIsTexture (GLuint texture) 
{ 
  stat->gl[API_glIsTexture]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glIsTexture]);

  return ((GLboolean (*)(GLuint ))lib->glFunc[API_glIsTexture])(texture);
}

WINGDIAPI void APIENTRY glLightModelf (GLenum pname, GLfloat param)
{
  stat->gl[API_glLightModelf]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLightModelf]);

  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glLightModelf])(pname, param);
}

WINGDIAPI void APIENTRY glLightModelfv (GLenum pname, const GLfloat *params)
{
  stat->gl[API_glLightModelfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLightModelfv]);

  ((void (*)(GLenum, const GLfloat *))lib->glFunc[API_glLightModelfv])(pname, params);
}

WINGDIAPI void APIENTRY glLightModeli (GLenum pname, GLint param)
{
  stat->gl[API_glLightModeli]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLightModeli]);

  ((void (*)(GLenum , GLint ))lib->glFunc[API_glLightModeli])(pname, param);
}

WINGDIAPI void APIENTRY glLightModeliv (GLenum pname, const GLint *params)
{
  stat->gl[API_glLightModeliv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLightModeliv]);

  ((void (*)(GLenum , const GLint *))lib->glFunc[API_glLightModeliv])(pname, params);
}

WINGDIAPI void APIENTRY glLightf (GLenum light, GLenum pname, GLfloat param)
{
  stat->gl[API_glLightf]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLightf]);

  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glLightf])(light, pname, param);
}

WINGDIAPI void APIENTRY glLightfv (GLenum light, GLenum pname, const GLfloat *params)
{
  stat->gl[API_glLightfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLightfv]);

  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glLightfv])(light, pname, params);
}

WINGDIAPI void APIENTRY glLighti (GLenum light, GLenum pname, GLint param)
{
  stat->gl[API_glLighti]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLighti]);

  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glLighti])(light, pname, param);
}

WINGDIAPI void APIENTRY glLightiv (GLenum light, GLenum pname, const GLint *params)
{
  stat->gl[API_glLightiv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLightiv]);

  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glLightiv])(light, pname, params);
}

WINGDIAPI void APIENTRY glLineStipple (GLint factor, GLushort pattern)
{
  stat->gl[API_glLineStipple]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLineStipple]);

  ((void (*)(GLint , GLushort ))lib->glFunc[API_glLineStipple])(factor, pattern);
}

WINGDIAPI void APIENTRY glLineWidth (GLfloat width)
{
  stat->gl[API_glLineWidth]++;
  if (file)
    fprintf(file, "%s %f\n",glNames[API_glLineWidth], width);

  ((void (*)(GLfloat ))lib->glFunc[API_glLineWidth])(width);
}

WINGDIAPI void APIENTRY glListBase (GLuint base)
{
  stat->gl[API_glListBase]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glListBase]);

  ((void (*)(GLuint ))lib->glFunc[API_glListBase])(base);
}

WINGDIAPI void APIENTRY glLoadIdentity (void)
{
  stat->gl[API_glLoadIdentity]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLoadIdentity]);

  ((void (*)())lib->glFunc[API_glLoadIdentity])();
}

WINGDIAPI void APIENTRY glLoadMatrixd (const GLdouble *m)
{
  stat->gl[API_glLoadMatrixd]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLoadMatrixd]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glLoadMatrixd])(m);
}

WINGDIAPI void APIENTRY glLoadMatrixf (const GLfloat *m)
{
  stat->gl[API_glLoadMatrixf]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLoadMatrixf]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glLoadMatrixf])(m);
}

WINGDIAPI void APIENTRY glLoadName (GLuint name)
{
  stat->gl[API_glLoadName]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLoadName]);

  ((void (*)(GLuint ))lib->glFunc[API_glLoadName])(name);
}

WINGDIAPI void APIENTRY glLogicOp (GLenum opcode)
{
  stat->gl[API_glLogicOp]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glLogicOp]);

  ((void (*)(GLenum ))lib->glFunc[API_glLogicOp])(opcode);
}

WINGDIAPI void APIENTRY glMap1d (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)
{
  stat->gl[API_glMap1d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glMap1d]);

  ((void (*)(GLenum , GLdouble , GLdouble , GLint , GLint , const GLdouble *))lib->glFunc[API_glMap1d])(target, u1, u2, stride, order, points);
}

WINGDIAPI void APIENTRY glMap1f (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)
{
  stat->gl[API_glMap1f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glMap1f]);

  ((void (*)(GLenum , GLfloat , GLfloat , GLint , GLint , const GLfloat *))lib->glFunc[API_glMap1f])(target, u1, u2, stride, order, points);
}
WINGDIAPI void APIENTRY glMap2d (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)
{
  stat->gl[API_glMap2d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glMap2d]);

  ((void (*)(GLenum , GLdouble , GLdouble , GLint , GLint , GLdouble , GLdouble , GLint , GLint , const GLdouble *))lib->glFunc[API_glMap2d])(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

WINGDIAPI void APIENTRY glMap2f (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)
{
  stat->gl[API_glMap2f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glMap2f]);

  ((void (*)(GLenum , GLfloat , GLfloat , GLint , GLint , GLfloat , GLfloat , GLint , GLint , const GLfloat *))lib->glFunc[API_glMap2f])(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

WINGDIAPI void APIENTRY glMapGrid1d (GLint un, GLdouble u1, GLdouble u2)
{
  stat->gl[API_glMapGrid1d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glMapGrid1d]);

  ((void (*)(GLint , GLdouble , GLdouble ))lib->glFunc[API_glMapGrid1d])(un, u1, u2);
}

WINGDIAPI void APIENTRY glMapGrid1f (GLint un, GLfloat u1, GLfloat u2)
{
  stat->gl[API_glMapGrid1f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glMapGrid1f]);

  ((void (*)(GLint , GLfloat , GLfloat ))lib->glFunc[API_glMapGrid1f])(un, u1, u2);
}

WINGDIAPI void APIENTRY glMapGrid2d (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)
{
  stat->gl[API_glMapGrid2d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glMapGrid2d]);

  ((void (*)(GLint , GLdouble , GLdouble , GLint , GLdouble , GLdouble ))lib->glFunc[API_glMapGrid2d])(un, u1, u2, vn, v1, v2);
}

WINGDIAPI void APIENTRY glMapGrid2f (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)
{
  stat->gl[API_glMapGrid2f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glMapGrid2f]);

  ((void (*)(GLint , GLfloat , GLfloat , GLint , GLfloat , GLfloat ))lib->glFunc[API_glMapGrid2f])(un, u1, u2, vn, v1, v2);
}

WINGDIAPI void APIENTRY glMaterialf (GLenum face, GLenum pname, GLfloat param)
{
  char tmp[255];
  stat->gl[API_glMaterialf]++;
  
  if (file || stat->doStat) {
    char *n = stateColorMaterial(tmp, face, pname);
    if (file)
      fprintf(file, "%s %s %f\n",glNames[API_glMaterialf], n,  param);
  }

  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glMaterialf])(face, pname, param);
}

WINGDIAPI void APIENTRY glMaterialfv (GLenum face, GLenum pname, const GLfloat *params)
{
  char tmp[255];
  stat->gl[API_glMaterialfv]++;
  if (file || stat->doStat) {
    char *n = stateColorMaterial(tmp, face, pname);
    if (file)
      fprintf(file, "%s %s %f %f %f\n",glNames[API_glMaterialfv], n, params[0], params[1], params[2]);
  }

  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glMaterialfv])(face, pname, params);
}

WINGDIAPI void APIENTRY glMateriali (GLenum face, GLenum pname, GLint param)
{
  char tmp[255];
  stat->gl[API_glMateriali]++;
  if (file || stat->doStat) {
    char *n = stateColorMaterial(tmp, face, pname);
    if (file)
      fprintf(file, "%s %s %d\n",glNames[API_glMateriali],n, param);
  }

  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glMateriali])(face, pname, param);
}

WINGDIAPI void APIENTRY glMaterialiv (GLenum face, GLenum pname, const GLint *params)
{
  char tmp[255];
  stat->gl[API_glMaterialiv]++;
  if (file || stat->doStat) {
    char *n = stateColorMaterial(tmp, face, pname);
    if (file)
      fprintf(file, "%s %s %d %d %d\n",glNames[API_glMaterialiv], n,  params[0], params[1],  params[2]);
  }

  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glMaterialiv])(face, pname, params);
}

WINGDIAPI void APIENTRY glMatrixMode (GLenum mode)
{
  stat->gl[API_glMatrixMode]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glMatrixMode]);

  ((void (*)(GLenum ))lib->glFunc[API_glMatrixMode])(mode);
}

WINGDIAPI void APIENTRY glMultMatrixd (const GLdouble *m)
{
  stat->gl[API_glMultMatrixd]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glMultMatrixd]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glMultMatrixd])(m);
}

WINGDIAPI void APIENTRY glMultMatrixf (const GLfloat *m)
{
  stat->gl[API_glMultMatrixf]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glMultMatrixf]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glMultMatrixf])(m);
}

WINGDIAPI void APIENTRY glNewList (GLuint list, GLenum mode)
{
  stat->gl[API_glNewList]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glNewList]);

  ((void (*)(GLuint , GLenum ))lib->glFunc[API_glNewList])(list, mode);
}

WINGDIAPI void APIENTRY glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz)
{
  stat->gl[API_glNormal3b]++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glNormal3b]);
  }

  ((void (*)(GLbyte , GLbyte , GLbyte ))lib->glFunc[API_glNormal3b])(nx, ny, nz);
}

WINGDIAPI void APIENTRY glNormal3bv (const GLbyte *v)
{
  stat->gl[API_glNormal3bv]++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glNormal3bv]);
  }

  ((void (*)(const GLbyte *))lib->glFunc[API_glNormal3bv])(v);
}

WINGDIAPI void APIENTRY glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz)
{
  stat->gl[API_glNormal3d]++;
  if (file&& !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glNormal3d]);
  }

  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glNormal3d])(nx, ny, nz);
}

WINGDIAPI void APIENTRY glNormal3dv (const GLdouble *v)
{
  stat->gl[API_glNormal3dv]++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glNormal3dv]);
  }

  ((void (*)(const GLdouble *))lib->glFunc[API_glNormal3dv])(v);
}

WINGDIAPI void APIENTRY glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz)
{
  stat->gl[API_glNormal3f]++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glNormal3f]);
  }

  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glNormal3f])(nx, ny, nz);
}

WINGDIAPI void APIENTRY glNormal3fv (const GLfloat *v)
{
  stat->gl[API_glNormal3fv]++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glNormal3fv]);
  }

  ((void (*)(const GLfloat *))lib->glFunc[API_glNormal3fv])(v);
}

WINGDIAPI void APIENTRY glNormal3i (GLint nx, GLint ny, GLint nz)
{
  stat->gl[API_glNormal3i]++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glNormal3i]);
  }

  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glNormal3i])(nx, ny, nz);
}

WINGDIAPI void APIENTRY glNormal3iv (const GLint *v)
{
  stat->gl[API_glNormal3iv]++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glNormal3iv]);
  }

  ((void (*)(const GLint *))lib->glFunc[API_glNormal3iv])(v);
}

WINGDIAPI void APIENTRY glNormal3s (GLshort nx, GLshort ny, GLshort nz)
{
  stat->gl[API_glNormal3s]++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glNormal3s]);
  }

  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glNormal3s])(nx, ny, nz);
}

WINGDIAPI void APIENTRY glNormal3sv (const GLshort *v)
{
  stat->gl[API_glNormal3sv]++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glNormal3sv]);
  }

  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3sv])(v);
}

WINGDIAPI void APIENTRY glNormalPointer (GLenum type, GLsizei stride, const GLvoid *pointer)
{
  stat->gl[API_glNormalPointer]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glNormalPointer]);

  ((void (*)(GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glNormalPointer])(type, stride, pointer);
}

WINGDIAPI void APIENTRY glOrtho (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
  stat->gl[API_glOrtho]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glOrtho]);

  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glOrtho])(left, right, bottom, top, zNear, zFar);
}

WINGDIAPI void APIENTRY glPassThrough (GLfloat token)
{
  stat->gl[API_glPassThrough]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPassThrough]);

  ((void (*)(GLfloat ))lib->glFunc[API_glPassThrough])(token );
}

WINGDIAPI void APIENTRY glPixelMapfv (GLenum map, GLint mapsize, const GLfloat *values)
{
  stat->gl[API_glPixelMapfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPixelMapfv]);

  ((void (*)(GLenum , GLint , const GLfloat *))lib->glFunc[API_glPixelMapfv])(map, mapsize, values);
}

WINGDIAPI void APIENTRY glPixelMapuiv (GLenum map, GLint mapsize, const GLuint *values)
{
  stat->gl[API_glPixelMapuiv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPixelMapuiv]);

  ((void (*)(GLenum , GLint , const GLuint *))lib->glFunc[API_glPixelMapuiv])(map, mapsize, values);
}

WINGDIAPI void APIENTRY glPixelMapusv (GLenum map, GLint mapsize, const GLushort *values)
{
  stat->gl[API_glPixelMapusv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPixelMapusv]);

  ((void (*)(GLenum , GLint , const GLushort *))lib->glFunc[API_glPixelMapusv])(map, mapsize, values);
}

WINGDIAPI void APIENTRY glPixelStoref (GLenum pname, GLfloat param)
{
  stat->gl[API_glPixelStoref]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPixelStoref]);

  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glPixelStoref])(pname, param);
}

WINGDIAPI void APIENTRY glPixelStorei (GLenum pname, GLint param)
{
  stat->gl[API_glPixelStorei]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPixelStorei]);

  ((void (*)(GLenum , GLint ))lib->glFunc[API_glPixelStorei])(pname, param);
}

WINGDIAPI void APIENTRY glPixelTransferf (GLenum pname, GLfloat param)
{
  stat->gl[API_glPixelTransferf]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPixelTransferf]);

  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glPixelTransferf])(pname, param);
}

WINGDIAPI void APIENTRY glPixelTransferi (GLenum pname, GLint param)
{
  stat->gl[API_glPixelTransferi]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPixelTransferi]);

  ((void (*)(GLenum , GLint ))lib->glFunc[API_glPixelTransferi])(pname, param);
}

WINGDIAPI void APIENTRY glPixelZoom (GLfloat xfactor, GLfloat yfactor)
{
  stat->gl[API_glPixelZoom]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPixelZoom]);

  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glPixelZoom])(xfactor, yfactor);
}

WINGDIAPI void APIENTRY glPointSize (GLfloat size)
{
  stat->gl[API_glPointSize]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPointSize]);

  ((void (*)(GLfloat ))lib->glFunc[API_glPointSize])(size);
}

WINGDIAPI void APIENTRY glPolygonMode (GLenum face, GLenum mode)
{
  stat->gl[API_glPolygonMode]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPolygonMode]);

  ((void (*)(GLenum , GLenum ))lib->glFunc[API_glPolygonMode])(face, mode);
}

WINGDIAPI void APIENTRY glPolygonOffset (GLfloat factor, GLfloat units)
{
  stat->gl[API_glPolygonOffset]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPolygonOffset]);

  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glPolygonOffset])(factor, units);
}

WINGDIAPI void APIENTRY glPolygonStipple (const GLubyte *mask)
{
  stat->gl[API_glPolygonStipple]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPolygonStipple]);

  ((void (*)(const GLubyte *))lib->glFunc[API_glPolygonStipple])(mask);
}

WINGDIAPI void APIENTRY glPopAttrib (void)
{
  stat->gl[API_glPopAttrib]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPopAttrib]);

  ((void (*)())lib->glFunc[API_glPopAttrib])();
}

WINGDIAPI void APIENTRY glPopClientAttrib (void)
{
  stat->gl[API_glPopClientAttrib]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPopClientAttrib]);

  ((void (*)())lib->glFunc[API_glPopClientAttrib])();
}

WINGDIAPI void APIENTRY glPopMatrix (void)
{
  stat->gl[API_glPopMatrix]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPopMatrix]);

  ((void (*)())lib->glFunc[API_glPopMatrix])();
}

WINGDIAPI void APIENTRY glPopName (void)
{
  stat->gl[API_glPopName]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPopName]);

  ((void (*)())lib->glFunc[API_glPopName])();
}

WINGDIAPI void APIENTRY glPrioritizeTextures (GLsizei n, const GLuint *textures, const GLclampf *priorities)
{
  stat->gl[API_glPrioritizeTextures]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPrioritizeTextures]);

  ((void (*)(GLsizei , const GLuint *, const GLclampf *))lib->glFunc[API_glPrioritizeTextures])(n, textures, priorities);
}

WINGDIAPI void APIENTRY glPushAttrib (GLbitfield mask)
{
  stat->gl[API_glPushAttrib]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPushAttrib]);

  ((void (*)(GLbitfield ))lib->glFunc[API_glPushAttrib])(mask);
}

WINGDIAPI void APIENTRY glPushClientAttrib (GLbitfield mask)
{
  stat->gl[API_glPushClientAttrib]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPushClientAttrib]);

  ((void (*)(GLbitfield ))lib->glFunc[API_glPushClientAttrib])(mask);
}

WINGDIAPI void APIENTRY glPushMatrix (void)
{
  stat->gl[API_glPushMatrix]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPushMatrix]);

  ((void (*)())lib->glFunc[API_glPushMatrix])();
}

WINGDIAPI void APIENTRY glPushName (GLuint name)
{
  stat->gl[API_glPushName]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glPushName]);

  ((void (*)(GLuint ))lib->glFunc[API_glPushName])(name);
}

WINGDIAPI void APIENTRY glRasterPos2d (GLdouble x, GLdouble y)
{
  stat->gl[API_glRasterPos2d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos2d]);

  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glRasterPos2d])(x, y);
}

WINGDIAPI void APIENTRY glRasterPos2dv (const GLdouble *v)
{
  stat->gl[API_glRasterPos2dv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos2dv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glRasterPos2dv])(v);
}

WINGDIAPI void APIENTRY glRasterPos2f (GLfloat x, GLfloat y)
{
  stat->gl[API_glRasterPos2f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos2f]);

  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glRasterPos2f])(x, y);
}

WINGDIAPI void APIENTRY glRasterPos2fv (const GLfloat *v)
{
  stat->gl[API_glRasterPos2fv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos2fv]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glRasterPos2fv])(v);
}

WINGDIAPI void APIENTRY glRasterPos2i (GLint x, GLint y)
{
  stat->gl[API_glRasterPos2i]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos2i]);

  ((void (*)(GLint , GLint ))lib->glFunc[API_glRasterPos2i])(x, y);
}

WINGDIAPI void APIENTRY glRasterPos2iv (const GLint *v)
{
  stat->gl[API_glRasterPos2iv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos2iv]);

  ((void (*)(const GLint *))lib->glFunc[API_glRasterPos2iv])(v);
}

WINGDIAPI void APIENTRY glRasterPos2s (GLshort x, GLshort y)
{
  stat->gl[API_glRasterPos2s]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos2s]);

  ((void (*)(GLshort , GLshort ))lib->glFunc[API_glRasterPos2s])(x, y);
}

WINGDIAPI void APIENTRY glRasterPos2sv (const GLshort *v)
{
  stat->gl[API_glRasterPos2sv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos2sv]);

  ((void (*)(const GLshort *))lib->glFunc[API_glRasterPos2sv])(v);
}

WINGDIAPI void APIENTRY glRasterPos3d (GLdouble x, GLdouble y, GLdouble z)
{
  stat->gl[API_glRasterPos3d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos3d]);

  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRasterPos3d])(x, y, z);
}

WINGDIAPI void APIENTRY glRasterPos3dv (const GLdouble *v)
{
  stat->gl[API_glRasterPos3dv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos3dv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glRasterPos3dv])(v);
}

WINGDIAPI void APIENTRY glRasterPos3f (GLfloat x, GLfloat y, GLfloat z)
{
  stat->gl[API_glRasterPos3f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos3f]);

  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRasterPos3f])(x, y, z);
}

WINGDIAPI void APIENTRY glRasterPos3fv (const GLfloat *v)
{
  stat->gl[API_glRasterPos3fv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos3fv]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glRasterPos3fv])(v);
}

WINGDIAPI void APIENTRY glRasterPos3i (GLint x, GLint y, GLint z)
{
  stat->gl[API_glRasterPos3i]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos3i]);

  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glRasterPos3i])(x, y, z);
}

WINGDIAPI void APIENTRY glRasterPos3iv (const GLint *v)
{
  stat->gl[API_glRasterPos3iv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos3iv]);

  ((void (*)(const GLint *))lib->glFunc[API_glRasterPos3iv])(v);
}

WINGDIAPI void APIENTRY glRasterPos3s (GLshort x, GLshort y, GLshort z)
{
  stat->gl[API_glRasterPos3s]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos3s]);

  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glRasterPos3s])(x, y, z);
}

WINGDIAPI void APIENTRY glRasterPos3sv (const GLshort *v)
{
  stat->gl[API_glRasterPos3sv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos3sv]);

  ((void (*)(const GLshort *))lib->glFunc[API_glRasterPos3sv])(v);
}

WINGDIAPI void APIENTRY glRasterPos4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
  stat->gl[API_glRasterPos4d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos4d]);

  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRasterPos4d])(x, y, z, w);
}

WINGDIAPI void APIENTRY glRasterPos4dv (const GLdouble *v)
{
  stat->gl[API_glRasterPos4dv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos4dv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glRasterPos4dv])(v);
}

WINGDIAPI void APIENTRY glRasterPos4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
  stat->gl[API_glRasterPos4f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos4f]);

  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRasterPos4f])(x, y, z, w);
}

WINGDIAPI void APIENTRY glRasterPos4fv (const GLfloat *v)
{
  stat->gl[API_glRasterPos4fv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos4fv]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glRasterPos4fv])(v);
}

WINGDIAPI void APIENTRY glRasterPos4i (GLint x, GLint y, GLint z, GLint w)
{
  stat->gl[API_glRasterPos4i]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos4i]);

  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glRasterPos4i])(x, y, z, w);
}

WINGDIAPI void APIENTRY glRasterPos4iv (const GLint *v)
{
  stat->gl[API_glRasterPos4iv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos4iv]);

  ((void (*)(const GLint *))lib->glFunc[API_glRasterPos4iv])(v);
}

WINGDIAPI void APIENTRY glRasterPos4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
  stat->gl[API_glRasterPos4s]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos4s]);

  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glRasterPos4s])(x, y, z, w);
}

WINGDIAPI void APIENTRY glRasterPos4sv (const GLshort *v)
{
  stat->gl[API_glRasterPos4sv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRasterPos4sv]);

  ((void (*)(const GLshort *))lib->glFunc[API_glRasterPos4sv])(v);
}

WINGDIAPI void APIENTRY glReadBuffer (GLenum mode)
{
  stat->gl[API_glReadBuffer]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glReadBuffer]);

  ((void (*)(GLenum ))lib->glFunc[API_glReadBuffer])(mode);
}

WINGDIAPI void APIENTRY glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)
{
  stat->gl[API_glReadPixels]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glReadPixels]);

  ((void (*)(GLint , GLint , GLsizei , GLsizei , GLenum , GLenum , GLvoid *))lib->glFunc[API_glReadPixels])(x, y, width, height, format, type, pixels);
}

WINGDIAPI void APIENTRY glRectd (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)
{
  stat->gl[API_glRectd]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRectd]);

  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRectd])(x1, y1, x2, y2);
}

WINGDIAPI void APIENTRY glRectdv (const GLdouble *v1, const GLdouble *v2)
{
  stat->gl[API_glRectdv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRectdv]);

  ((void (*)(const GLdouble *, const GLdouble *))lib->glFunc[API_glRectdv])(v1, v2);
}

WINGDIAPI void APIENTRY glRectf (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)
{
  stat->gl[API_glRectf]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRectf]);

  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRectf])(x1, y1, x2, y2);
}

WINGDIAPI void APIENTRY glRectfv (const GLfloat *v1, const GLfloat *v2)
{
  stat->gl[API_glRectfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRectfv]);

  ((void (*)(const GLfloat *, const GLfloat *))lib->glFunc[API_glRectfv])(v1, v2);
}

WINGDIAPI void APIENTRY glRecti (GLint x1, GLint y1, GLint x2, GLint y2)
{
  stat->gl[API_glRecti]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRecti]);

  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glRecti])(x1, y1, x2, y2);
}

WINGDIAPI void APIENTRY glRectiv (const GLint *v1, const GLint *v2)
{
  stat->gl[API_glRectiv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRectiv]);

  ((void (*)(const GLint *, const GLint *))lib->glFunc[API_glRectiv])(v1, v2);
}

WINGDIAPI void APIENTRY glRects (GLshort x1, GLshort y1, GLshort x2, GLshort y2)
{
  stat->gl[API_glRects]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRects]);

  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glRects])(x1, y1, x2, y2);
}

WINGDIAPI void APIENTRY glRectsv (const GLshort *v1, const GLshort *v2)
{
  stat->gl[API_glRectsv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRectsv]);

  ((void (*)(const GLshort *, const GLshort *))lib->glFunc[API_glRectsv])(v1, v2);
}

WINGDIAPI GLint APIENTRY glRenderMode (GLenum mode)
{ 
  stat->gl[API_glRenderMode]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRenderMode]);

  return ((GLint (*)(GLenum ))lib->glFunc[API_glRenderMode])(mode);
}

WINGDIAPI void APIENTRY glRotated (GLdouble angle, GLdouble x, GLdouble y, GLdouble z)
{
  stat->gl[API_glRotated]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRotated]);

  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRotated])(angle, x, y, z);
}

WINGDIAPI void APIENTRY glRotatef (GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
  stat->gl[API_glRotatef]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glRotatef]);

  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRotatef])(angle, x, y, z);
}

WINGDIAPI void APIENTRY glScaled (GLdouble x, GLdouble y, GLdouble z)
{
  stat->gl[API_glScaled]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glScaled]);

  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glScaled])(x, y, z);
}

WINGDIAPI void APIENTRY glScalef (GLfloat x, GLfloat y, GLfloat z)
{
  stat->gl[API_glScalef]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glScalef]);

  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glScalef])(x, y, z);
}

WINGDIAPI void APIENTRY glScissor (GLint x, GLint y, GLsizei width, GLsizei height)
{
  stat->gl[API_glScissor]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glScissor]);

  ((void (*)(GLint , GLint , GLsizei , GLsizei ))lib->glFunc[API_glScissor])(x, y, width, height);
}

WINGDIAPI void APIENTRY glSelectBuffer (GLsizei size, GLuint *buffer)
{
  stat->gl[API_glSelectBuffer]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glSelectBuffer]);

  ((void (*)(GLsizei , GLuint *))lib->glFunc[API_glSelectBuffer])(size, buffer);
}

WINGDIAPI void APIENTRY glShadeModel (GLenum mode)
{
  stat->gl[API_glShadeModel]++;
  if (file)
    fprintf(file, "%s %s\n",glNames[API_glShadeModel], stateShadeModel(mode));

  ((void (*)(GLenum ))lib->glFunc[API_glShadeModel])(mode);
}

WINGDIAPI void APIENTRY glStencilFunc (GLenum func, GLint ref, GLuint mask)
{
  stat->gl[API_glStencilFunc]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glStencilFunc]);

  ((void (*)(GLenum , GLint , GLuint ))lib->glFunc[API_glStencilFunc])(func, ref, mask);
}

WINGDIAPI void APIENTRY glStencilMask (GLuint mask)
{
  stat->gl[API_glStencilMask]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glStencilMask]);

  ((void (*)(GLuint ))lib->glFunc[API_glStencilMask])(mask);
}

WINGDIAPI void APIENTRY glStencilOp (GLenum fail, GLenum zfail, GLenum zpass)
{
  stat->gl[API_glStencilOp]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glStencilOp]);

  ((void (*)(GLenum , GLenum , GLenum ))lib->glFunc[API_glStencilOp])(fail, zfail, zpass);
}

WINGDIAPI void APIENTRY glTexCoord1d (GLdouble s)
{
  stat->gl[API_glTexCoord1d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord1d]);

  ((void (*)(GLdouble ))lib->glFunc[API_glTexCoord1d])(s);
}

WINGDIAPI void APIENTRY glTexCoord1dv (const GLdouble *v)
{
  stat->gl[API_glTexCoord1dv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord1dv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord1dv])(v);
}

WINGDIAPI void APIENTRY glTexCoord1f (GLfloat s)
{
  stat->gl[API_glTexCoord1f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord1f]);

  ((void (*)(GLfloat ))lib->glFunc[API_glTexCoord1f])(s);
}

WINGDIAPI void APIENTRY glTexCoord1fv (const GLfloat *v)
{
  stat->gl[API_glTexCoord1fv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord1fv]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord1fv])(v);
}

WINGDIAPI void APIENTRY glTexCoord1i (GLint s)
{
  stat->gl[API_glTexCoord1i]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord1i]);

  ((void (*)(GLint ))lib->glFunc[API_glTexCoord1i])(s);
}

WINGDIAPI void APIENTRY glTexCoord1iv (const GLint *v)
{
  stat->gl[API_glTexCoord1iv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord1iv]);

  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord1iv])(v);
}

WINGDIAPI void APIENTRY glTexCoord1s (GLshort s)
{
  stat->gl[API_glTexCoord1s]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord1s]);

  ((void (*)(GLshort ))lib->glFunc[API_glTexCoord1s])(s);
}

WINGDIAPI void APIENTRY glTexCoord1sv (const GLshort *v)
{
  stat->gl[API_glTexCoord1sv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord1sv]);

  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord1sv])(v);
}

WINGDIAPI void APIENTRY glTexCoord2d (GLdouble s, GLdouble t)
{
  stat->gl[API_glTexCoord2d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord2d]);

  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glTexCoord2d])(s, t);
}

WINGDIAPI void APIENTRY glTexCoord2dv (const GLdouble *v)
{
  stat->gl[API_glTexCoord2dv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord2dv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord2dv])(v);
}

WINGDIAPI void APIENTRY glTexCoord2f (GLfloat s, GLfloat t)
{
  stat->gl[API_glTexCoord2f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord2f]);

  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glTexCoord2f])(s, t);
}

WINGDIAPI void APIENTRY glTexCoord2fv (const GLfloat *v)
{
  stat->gl[API_glTexCoord2fv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord2fv]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord2fv])(v);
}

WINGDIAPI void APIENTRY glTexCoord2i (GLint s, GLint t)
{
  stat->gl[API_glTexCoord2i]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord2i]);

  ((void (*)(GLint , GLint ))lib->glFunc[API_glTexCoord2i])(s, t);
}

WINGDIAPI void APIENTRY glTexCoord2iv (const GLint *v)
{
  stat->gl[API_glTexCoord2iv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord2iv]);

  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord2iv])(v);
}

WINGDIAPI void APIENTRY glTexCoord2s (GLshort s, GLshort t)
{
  stat->gl[API_glTexCoord2s]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord2s]);

  ((void (*)(GLshort , GLshort ))lib->glFunc[API_glTexCoord2s])(s, t);
}

WINGDIAPI void APIENTRY glTexCoord2sv (const GLshort *v)
{
  stat->gl[API_glTexCoord2sv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord2sv]);

  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord2sv])(v);
}

WINGDIAPI void APIENTRY glTexCoord3d (GLdouble s, GLdouble t, GLdouble r)
{
  stat->gl[API_glTexCoord3d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord3d]);

  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glTexCoord3d])(s, t, r);
}

WINGDIAPI void APIENTRY glTexCoord3dv (const GLdouble *v)
{
  stat->gl[API_glTexCoord3dv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord3dv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord3dv])(v);
}

WINGDIAPI void APIENTRY glTexCoord3f (GLfloat s, GLfloat t, GLfloat r)
{
  stat->gl[API_glTexCoord3f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord3f]);

  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glTexCoord3f])(s, t, r);
}

WINGDIAPI void APIENTRY glTexCoord3fv (const GLfloat *v)
{
  stat->gl[API_glTexCoord3fv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord3fv]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord3fv])(v);
}

WINGDIAPI void APIENTRY glTexCoord3i (GLint s, GLint t, GLint r)
{
  stat->gl[API_glTexCoord3i]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord3i]);

  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glTexCoord3i])(s, t, r);
}

WINGDIAPI void APIENTRY glTexCoord3iv (const GLint *v)
{
  stat->gl[API_glTexCoord3iv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord3iv]);

  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord3iv])(v);
}

WINGDIAPI void APIENTRY glTexCoord3s (GLshort s, GLshort t, GLshort r)
{
  stat->gl[API_glTexCoord3s]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord3s]);

  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glTexCoord3s])(s, t, r);
}

WINGDIAPI void APIENTRY glTexCoord3sv (const GLshort *v)
{
  stat->gl[API_glTexCoord3sv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord3sv]);

  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord3sv])(v);
}

WINGDIAPI void APIENTRY glTexCoord4d (GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
  stat->gl[API_glTexCoord4d]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord4d]);

  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glTexCoord4d])(s, t, r, q);
}

WINGDIAPI void APIENTRY glTexCoord4dv (const GLdouble *v)
{
  stat->gl[API_glTexCoord4dv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord4dv]);

  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord4dv])(v);
}

WINGDIAPI void APIENTRY glTexCoord4f (GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
  stat->gl[API_glTexCoord4f]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord4f]);

  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glTexCoord4f])(s, t, r, q);
}

WINGDIAPI void APIENTRY glTexCoord4fv (const GLfloat *v)
{
  stat->gl[API_glTexCoord4fv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord4fv]);

  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord4fv])(v);
}

WINGDIAPI void APIENTRY glTexCoord4i (GLint s, GLint t, GLint r, GLint q)
{
  stat->gl[API_glTexCoord4i]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord4i]);

  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glTexCoord4i])(s, t, r, q);
}

WINGDIAPI void APIENTRY glTexCoord4iv (const GLint *v)
{
  stat->gl[API_glTexCoord4iv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord4iv]);

  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord4iv])(v);
}

WINGDIAPI void APIENTRY glTexCoord4s (GLshort s, GLshort t, GLshort r, GLshort q)
{
  stat->gl[API_glTexCoord4s]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord4s]);

  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glTexCoord4s])(s, t, r, q);
}

WINGDIAPI void APIENTRY glTexCoord4sv (const GLshort *v)
{
  stat->gl[API_glTexCoord4sv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoord4sv]);

  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord4sv])(v);
}

WINGDIAPI void APIENTRY glTexCoordPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
  stat->gl[API_glTexCoordPointer]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexCoordPointer]);

  ((void (*)(GLint , GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glTexCoordPointer])(size, type, stride, pointer);
}

WINGDIAPI void APIENTRY glTexEnvf (GLenum target, GLenum pname, GLfloat param)
{
  stat->gl[API_glTexEnvf]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexEnvf]);

  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glTexEnvf])(target, pname, param);
}

WINGDIAPI void APIENTRY glTexEnvfv (GLenum target, GLenum pname, const GLfloat *params)
{
  stat->gl[API_glTexEnvfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexEnvfv]);

  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glTexEnvfv])(target, pname, params);
}

WINGDIAPI void APIENTRY glTexEnvi (GLenum target, GLenum pname, GLint param)
{
  stat->gl[API_glTexEnvi]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexEnvi]);

  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glTexEnvi])(target, pname, param);
}

WINGDIAPI void APIENTRY glTexEnviv (GLenum target, GLenum pname, const GLint *params)
{
  stat->gl[API_glTexEnviv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexEnviv]);

  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glTexEnviv])(target, pname, params);
}

WINGDIAPI void APIENTRY glTexGend (GLenum coord, GLenum pname, GLdouble param)
{
  stat->gl[API_glTexGend]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexGend]);

  ((void (*)(GLenum , GLenum , GLdouble ))lib->glFunc[API_glTexGend])(coord, pname, param);
}

WINGDIAPI void APIENTRY glTexGendv (GLenum coord, GLenum pname, const GLdouble *params)
{
  stat->gl[API_glTexGendv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexGendv]);

  ((void (*)(GLenum , GLenum , const GLdouble *))lib->glFunc[API_glTexGendv])(coord, pname, params);
}

WINGDIAPI void APIENTRY glTexGenf (GLenum coord, GLenum pname, GLfloat param)
{
  stat->gl[API_glTexGenf]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexGenf]);

  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glTexGenf])(coord, pname, param);
}

WINGDIAPI void APIENTRY glTexGenfv (GLenum coord, GLenum pname, const GLfloat *params)
{
  stat->gl[API_glTexGenfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexGenfv]);

  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glTexGenfv])(coord, pname, params);
}

WINGDIAPI void APIENTRY glTexGeni (GLenum coord, GLenum pname, GLint param)
{
  stat->gl[API_glTexGeni]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexGeni]);

  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glTexGeni])(coord, pname, param);
}

WINGDIAPI void APIENTRY glTexGeniv (GLenum coord, GLenum pname, const GLint *params)
{
  stat->gl[API_glTexGeniv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexGeniv]);

  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glTexGeniv])(coord, pname, params);
}

WINGDIAPI void APIENTRY glTexImage1D (GLenum target, GLint level, GLint components, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
  stat->gl[API_glTexImage1D]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexImage1D]);

  ((void (*)(GLenum , GLint , GLint , GLsizei , GLint , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexImage1D])(target, level, components, width, border, format, type, pixels);
}

WINGDIAPI void APIENTRY glTexImage2D (GLenum target, GLint level, GLint components, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
  stat->gl[API_glTexImage2D]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexImage2D]);

  ((void (*)(GLenum , GLint , GLint , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexImage2D])(target, level, components, width, height, border, format, type, pixels);
}

WINGDIAPI void APIENTRY glTexImage3D (GLenum target, GLint level, GLenum components, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
  stat->gl[API_glTexImage3D]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexImage3D]);

  ((void (*)(GLenum , GLint , GLint , GLsizei , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexImage3D])(target, level, components, width, height, depth, border, format, type, pixels);
}

WINGDIAPI void APIENTRY glTexParameterf (GLenum target, GLenum pname, GLfloat param)
{
  stat->gl[API_glTexParameterf]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexParameterf]);

  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glTexParameterf])(target, pname, param);
}

WINGDIAPI void APIENTRY glTexParameterfv (GLenum target, GLenum pname, const GLfloat *params)
{
  stat->gl[API_glTexParameterfv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexParameterfv]);

  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glTexParameterfv])(target, pname, params);
}

WINGDIAPI void APIENTRY glTexParameteri (GLenum target, GLenum pname, GLint param)
{
  stat->gl[API_glTexParameteri]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexParameteri]);

  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glTexParameteri])(target, pname, param);
}

WINGDIAPI void APIENTRY glTexParameteriv (GLenum target, GLenum pname, const GLint *params)
{
  stat->gl[API_glTexParameteriv]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexParameteriv]);

  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glTexParameteriv])(target, pname, params);
}

WINGDIAPI void APIENTRY glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
  stat->gl[API_glTexSubImage1D]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexSubImage1D]);

  ((void (*)(GLenum , GLint , GLint , GLsizei , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexSubImage1D])(target, level, xoffset, width, format, type, pixels);
}

WINGDIAPI void APIENTRY glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
  stat->gl[API_glTexSubImage2D]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTexSubImage2D]);

  ((void (*)(GLenum , GLint , GLint , GLint , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexSubImage2D])(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

WINGDIAPI void APIENTRY glTranslated (GLdouble x, GLdouble y, GLdouble z)
{
  stat->gl[API_glTranslated]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTranslated]);

  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glTranslated])(x, y, z);
}

WINGDIAPI void APIENTRY glTranslatef (GLfloat x, GLfloat y, GLfloat z)
{
  stat->gl[API_glTranslatef]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glTranslatef]);

  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glTranslatef])(x, y, z);
}

WINGDIAPI void APIENTRY glVertex2d (GLdouble x, GLdouble y)
{
  stat->gl[API_glVertex2d]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex2d]);
  }

  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glVertex2d])(x, y);
}

WINGDIAPI void APIENTRY glVertex2dv (const GLdouble *v)
{
  stat->gl[API_glVertex2dv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex2dv]);
    
  }

  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex2dv])(v);
}

WINGDIAPI void APIENTRY glVertex2f (GLfloat x, GLfloat y)
{
  stat->gl[API_glVertex2f]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex2f]);
  }

  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glVertex2f])(x, y);
}

WINGDIAPI void APIENTRY glVertex2fv (const GLfloat *v)
{
  stat->gl[API_glVertex2fv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex2fv]);
  }

  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex2fv])(v);
}

WINGDIAPI void APIENTRY glVertex2i (GLint x, GLint y)
{
  stat->gl[API_glVertex2i]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex2i]);
  }

  ((void (*)(GLint , GLint ))lib->glFunc[API_glVertex2i])(x, y);
}

WINGDIAPI void APIENTRY glVertex2iv (const GLint *v)
{
  stat->gl[API_glVertex2iv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex2iv]);
  }

  ((void (*)(const GLint *))lib->glFunc[API_glVertex2iv])(v);
}

WINGDIAPI void APIENTRY glVertex2s (GLshort x, GLshort y)
{
  stat->gl[API_glVertex2s]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex2s]);
  }

  ((void (*)(GLshort , GLshort ))lib->glFunc[API_glVertex2s])(x, y);
}

WINGDIAPI void APIENTRY glVertex2sv (const GLshort *v)
{
  stat->gl[API_glVertex2sv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex2sv]);
  }

  ((void (*)(const GLshort *))lib->glFunc[API_glVertex2sv])(v);
}

WINGDIAPI void APIENTRY glVertex3d (GLdouble x, GLdouble y, GLdouble z)
{
  stat->gl[API_glVertex3d]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex3d]);
  }

  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glVertex3d])(x, y, z);
}

WINGDIAPI void APIENTRY glVertex3dv (const GLdouble *v)
{
  stat->gl[API_glVertex3dv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex3dv]);
  }

  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex3dv])(v);
}

WINGDIAPI void APIENTRY glVertex3f (GLfloat x, GLfloat y, GLfloat z)
{
  stat->gl[API_glVertex3f]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex3f]);
  }

  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glVertex3f])(x, y, z);
}

WINGDIAPI void APIENTRY glVertex3fv (const GLfloat *v)
{
  stat->gl[API_glVertex3fv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex3fv]);
  }

  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex3fv])(v);
}

WINGDIAPI void APIENTRY glVertex3i (GLint x, GLint y, GLint z)
{
  stat->gl[API_glVertex3i]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex3i]);
  }

  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glVertex3i])(x, y, z);
}

WINGDIAPI void APIENTRY glVertex3iv (const GLint *v)
{
  stat->gl[API_glVertex3iv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex3iv]);
  }

  ((void (*)(const GLint *))lib->glFunc[API_glVertex3iv])(v);
}

WINGDIAPI void APIENTRY glVertex3s (GLshort x, GLshort y, GLshort z)
{
  stat->gl[API_glVertex3s]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex3s]);
  }

  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glVertex3s])(x, y, z);
}

WINGDIAPI void APIENTRY glVertex3sv (const GLshort *v)
{
  stat->gl[API_glVertex3sv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex3sv]);
  }

  ((void (*)(const GLshort *))lib->glFunc[API_glVertex3sv])(v);
}

WINGDIAPI void APIENTRY glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
  stat->gl[API_glVertex4d]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex4d]);
  }

  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glVertex4d])(x, y, z, w);
}

WINGDIAPI void APIENTRY glVertex4dv (const GLdouble *v)
{
  stat->gl[API_glVertex4dv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex4dv]);
  }

  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex4dv])(v);
}

WINGDIAPI void APIENTRY glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
  stat->gl[API_glVertex4f]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex4f]);
  }

  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glVertex4f])(x, y, z, w);
}

WINGDIAPI void APIENTRY glVertex4fv (const GLfloat *v)
{
  stat->gl[API_glVertex4fv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex4fv]);
  }

  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex4fv])(v);
}

WINGDIAPI void APIENTRY glVertex4i (GLint x, GLint y, GLint z, GLint w)
{
  stat->gl[API_glVertex4i]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex4i]);
  }

  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glVertex4i])(x, y, z, w);
}

WINGDIAPI void APIENTRY glVertex4iv (const GLint *v)
{
  stat->gl[API_glVertex4iv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex4iv]);
  }

  ((void (*)(const GLint *))lib->glFunc[API_glVertex4iv])(v);
}

WINGDIAPI void APIENTRY glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
  stat->gl[API_glVertex4s]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex4s]);
  }

  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glVertex4s])(x, y, z, w);
}

WINGDIAPI void APIENTRY glVertex4sv (const GLshort *v)
{
  stat->gl[API_glVertex4sv]++;
  stat->Primit.vertexCount++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertex4sv]);
  }

  ((void (*)(const GLshort *))lib->glFunc[API_glVertex4sv])(v);
}

WINGDIAPI void APIENTRY glVertexPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
  stat->gl[API_glVertexPointer]++;
  if (file && !stat->noData) {
    fprintf(file, "%s\n",glNames[API_glVertexPointer]);
  }

  ((void (*)(GLint , GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glVertexPointer])(size, type, stride, pointer);
}

WINGDIAPI void APIENTRY glViewport (GLint x, GLint y, GLsizei width, GLsizei height)
{
  stat->gl[API_glViewport]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glViewport]);

  ((void  (*)(GLint , GLint , GLsizei , GLsizei ))lib->glFunc[API_glViewport])(x, y, width, height);
}

WINGDIAPI const GLubyte * APIENTRY glGetString (GLenum name)
{ 
  stat->gl[API_glGetString]++;
  if (file)
    fprintf(file, "%s\n",glNames[API_glGetString]);

  return ((const GLubyte * (*)(GLenum))lib->glFunc[API_glGetString])(name);
}
