#ifndef __dll_h_
#define __dll_h_

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "ogltrace.h"
#ifdef WIN32
#include <io.h>
#include <fcntl.h>
#include "wgltrace.h"
#else
#include <dlfcn.h>
#include "xgltrace.h"
#endif

#include "total.h"
#include "state.h"

#define IO_BUF_SIZE 255

typedef struct LIB_REC {

#ifdef WIN32
  // Handle to opengl32.dll.
  HMODULE glDLL;

  // Function pointers to real OpenGL and WGL functions.
  FARPROC glFunc[TOTAL_GL];
  FARPROC wglFunc[TOTAL_WGL];
#else

  // Pointers to libGL.so and libGLcore.so DSOs.
  void *glDLL;
  void *glCore;
  
  // Function pointers to real OpenGL and GLX functions.
  void *glFunc[TOTAL_GL];
  void *xglFunc[TOTAL_XGL];
#endif
} LIB_REC;

extern STATI *stat;
extern int doStat;
extern void callEntry();
extern void statReset();
extern struct LIB_REC *lib;
extern FILE *file;
extern FILE *recordStati;
extern int beginEnd;
extern int noData;
extern int onSwap;
extern void primEnd();
extern void primBegin(int mode);
#endif /* __dll_h_ */ 
