#include "dll.h"

struct LIB_REC *lib = NULL;
FILE *file = NULL;
STATI *stat = NULL;
FILE *recordStati = NULL;

#ifdef linux
extern "C"
void DllMain();

class forceInit {
public:
  forceInit() { DllMain(); }
  ~forceInit() {}
};

static forceInit a;
#endif

//
// statReset() - Reset structure which tracks state information.
//
void statReset()
{
  memset(&stat->gl, 0, 4*336);
  memset(&stat->Enable, 0, sizeof(int)*TOTAL_STATE);
  memset(&stat->Disable, 0, sizeof(int)*TOTAL_STATE);
  memset(&stat->Material, 0, sizeof(int)*TOTAL_MAT*3);
  memset(&stat->Primit, 0,sizeof(PRIM));
}

//
// env() - Initialize flags according to environment variables.
//
void env()
{
  lib = new LIB_REC;  /*(LIB_REC *)malloc(sizeof(LIB_REC));*/
  lib->glDLL = NULL;
  stat =  new STATI; /*(STATI *)malloc(sizeof(STATI));*/
#ifdef WIN32
  memset(&stat->wgl, 0, sizeof(int)*TOTAL_WGL);
#else
  memset(&stat->xgl, 0, sizeof(int)*TOTAL_XGL);
#endif
  statReset();

  // OGL_ONSWAP environment variable indicates that statistics 
  // should be refreshed on each swap buffer call.  Default is
  // to refresh statistics on each glClear call.
  if (getenv("OGL_ONSWAP")) {
    stat->onSwap = 1;
  } else {
    stat->onSwap = 0;
  }

  // OGL_TRACE environment variable indicates that trace 
  // information should be written to a file.  OGL_NODATA
  // environment variable controls amount of data put in
  // trace file.  When OGL_NODATA is set, only function
  // calls are place in the resulting trace file.  This
  // reduces the size of the resulting file.
  if (getenv("OGL_TRACE")) {
    file = fopen("ogltrace.txt","w");
    if (getenv("OGL_NODATA")) {
      stat->noData = 1;
    } else {
      stat->noData = 0;
    }
  }
  
  // OGL_STATI environment variable indicates that trace information
  // should be output to the console window.  Default is to not
  // output trace information to the console window.
  if (getenv("OGL_STATI")) {
    stat->doStat = 1;
  } else {
    stat->doStat = 0;
  }

  // OGL_STATRECORD environement variable indicates that per-frame
  // trace statistics should be output to an output file.  The
  // default is to not output per-frame primitive statistics.
  if (getenv("OGL_STATRECORD")) {
      recordStati = fopen("statrecord.txt","w");
  }

  // OGL_STATMAT environement variable indicates that statistics
  // on glMaterial calls should be placed in the trace output.
  if (getenv("OGL_STATMAT")) {
    stat->printMat = 1;
  } else {
    stat->printMat = 0;
  }

  // OGL_STATABLE environment variable indicates that statistics
  // on glEnable/glDisable calls should be placed in the trace
  // output.
  if (getenv("OGL_STATABLE")) {
    stat->printState = 1;      
  } else {
    stat->printState = 0;
  }

  // OGL_STATPRIM environment variable indicates that primitive
  // statistics should be placed in the traced output.
  if (getenv("OGL_STATPRIM")) {
    stat->printPrim = 1;
  } else {
    stat->printPrim = 0;
  }

  stat->beginEnd = 0;
}

#ifndef WIN32
//
// getSymbol() - Helper function for loading OpenGL and GLX
//               function pointers in the case of UNIX.  First
//               look for function in glDLL, then if not 
//               look in glCore DSO.  In the case of linux,
//               all symbols are in libGL.so.
//
void* getSymbol( char* name )
{
  void *p;
  
  p = dlsym( lib->glDLL, name );
  if(!p) {
#ifndef linux
    p = dlsym( lib->glCore, name );
#endif

    if(!p) {
      printf("symbol %s not found\n", name);
      return NULL;
    }
  }
  return p;
}
#endif

//
// callEntry() - Initialize arrays for function pointers to OpenGL
//               WGL and GLX calls by opening the appropriate 
//               shared libraries and get the addresses for each
//               entry point function.
//
void callEntry()
{
  int i;
#ifdef WIN32
  char buf[IO_BUF_SIZE];
  
  // Win32 case.  Build path to OpenGL DLL, then load it
  // to get a handle to use with GetProcAddress function.
  if (lib->glDLL == NULL) {
    GetSystemDirectory(buf, IO_BUF_SIZE);
    strcat(buf, "\\opengl32.dll");
    if ((lib->glDLL = LoadLibrary(buf)) == NULL)  {
      fprintf(stderr, "can t load %s\n",buf);
      exit(EXIT_FAILURE);
    }

    // Initialize function pointers for each OpenGL function. 
    for (i = 0; i < TOTAL_GL; i++) {
      lib->glFunc[i] = GetProcAddress(lib->glDLL, glNames[i]);
    }
      
    // Initialize function pointers for each WGL function.
    for (i = 0; i < TOTAL_WGL; i++) {
      if ((lib->wglFunc[i] = GetProcAddress(lib->glDLL,
					    wglNames[i])) == NULL) {
	exit(EXIT_FAILURE);
      }
    }
  }
#else

  // Unix case.  OpenGL and GLX calls can be in one of two
  // different DSOs.  Load libGL.so and libGLcore.so and
  // and keep a pointer to each.  In the case of linux,
  // there is no libGLcore.so.
  if (lib->glDLL == NULL) {
    lib->glDLL   = dlopen("libGL.so",RTLD_LAZY);
    if (lib->glDLL == NULL ) {
      printf("Error cannot load libGL.so \n");
      exit(EXIT_FAILURE);
    }
#ifndef linux
    lib->glCore   = dlopen("libGLcore.so",RTLD_LAZY);
    if (lib->glCore == NULL ) {
      printf("Error cannot load libGLcore.so \n");
      exit(EXIT_FAILURE);
    }
#endif
  }

  // Initialize function pointers for each OpenGL function.
  for (i = 0; i < TOTAL_GL; i++) {
      lib->glFunc[i] = getSymbol(glNames[i]);
  }

  // Initialize function pointers for each GLX function.
  for (i = 0; i < TOTAL_XGL; i++) {
    lib->xglFunc[i] = getSymbol(xglNames[i]);
  }
#endif
}

//
// DllMain() - DLL/DSO entry point function.
//
#ifdef WIN32
BOOL APIENTRY DllMain(HMODULE hModule, ULONG reason, LPVOID reserved)
{
   int hCrt;
   FILE *hf;
   
   // In Win32 case.
   //
   // At DLL_PROCESS_ATTACH, intialize console for tracing output 
   // and initialize stderr.  Also initialize state tracing.
   //
   // AT DLL_PROCESS_DETACH, close open files.
   //
   switch (reason) {
     
   case DLL_PROCESS_ATTACH:
     env();
     FreeConsole();
     AllocConsole();
     hCrt = _open_osfhandle( (long)GetStdHandle(STD_OUTPUT_HANDLE), _O_TEXT );
     hf = _fdopen(hCrt, "w");
     *stdout = *hf;
     setvbuf(stdout, NULL, _IONBF, 0);

     // Setup stderr
     hCrt = _open_osfhandle( (long)GetStdHandle(STD_ERROR_HANDLE), _O_TEXT );
     hf = _fdopen(hCrt, "w");
     *stderr = *hf;
     setvbuf(stderr, NULL, _IONBF, 0);
     break;
   
   case DLL_THREAD_ATTACH:
     break;

   case DLL_PROCESS_DETACH:
     if (file) {
       fclose(file);
       file  = NULL;
     }

     if (recordStati) {
       fclose(recordStati);
       recordStati  = NULL;
     }
     break;

   case DLL_THREAD_DETACH:
     break;
   }
   return TRUE;
}
#else
extern "C"
void DllMain(void)
{
  // UNIX case.
  //
  // Query environment and initialize state for tracing.  Setup
  // arrays of function pointers for OpenGL and GLX API call.
  fprintf(stderr,"Inside DllMain\n");
  env();
  callEntry();
}
#endif

