#ifndef __state_h_
#define __state_h_

#include "total.h"

enum {
   BACK,
   FRONT,
   FRONT_AND_BACK,
};

enum {
   count_mat,
   SHININESS,
   AMBIENT,
   DIFFUSE,
   SPECULAR,
   EMISSION,
   AMBIENT_AND_DIFFUSE,
};

static char *faceNames[3] = {
	   "GL_BACK",
   "GL_FRONT",
   "GL_FRONT_AND_BACK"};


static char *matNames[TOTAL_MAT] = {
	"count ",
   "GL_SHININESS",
   "GL_AMBIENT",
   "GL_DIFFUSE",
   "GL_SPECULAR",
   "GL_EMISSION",
   "GL_AMBIENT_AND_DIFFUSE"
};

enum {
	count_state,
	ALPHA_TEST,
	BLEND,	
	COLOR_MATERIAL,
	CULL_FACE,
	DEPTH_TEST,
	DITHER,
	FOG,
	LIGHT0,
	LIGHT1,
	LIGHTING,
	LINE_SMOOTH,
	LINE_STIPPLE,
	NORMALIZE,
	POINT_SMOOTH,
	POLYGON_STIPPLE,
	SCISSOR_TEST,
	STENCIL_TEST,
	UNKNOWN,
};

static char *primNames[TOTAL_PRIM] = {
		 "GL_POINTS",
		 "GL_LINES",		
		 "GL_LINE_STRIP",		
		 "GL_LINE_LOOP",
		 "GL_TRIANGLES",
		 "GL_TRIANGLE_STRIP",
		 "GL_TRIANGLE_FAN",
		 "GL_QUADS",
		 "GL_QUAD_STRIP",
		 "GL_POLYGON"};

static char *stateNames[TOTAL_STATE] = {
	"GL_ALPHA_TEST",
	"GL_BLEND",	
	"GL_COLOR_MATERIAL",
	"GL_CULL_FACE",
	"GL_DEPTH_TEST",
	"GL_DITHER",
	"GL_FOG",
	"GL_LIGHT0",
	"GL_LIGHT1",
	"GL_LIGHTING",
	"GL_LINE_SMOOTH",
	"GL_LINE_STIPPLE",
	"GL_NORMALIZE",
	"GL_POINT_SMOOTH",
	"GL_POLYGON_STIPPLE",
	"GL_SCISSOR_TEST",
	"GL_STENCIL_TEST",
	"GL_UNKNOWN"
};

typedef struct prim {
	int maxi[TOTAL_PRIM];
	int count[TOTAL_PRIM];
	int beCount[TOTAL_PRIM];
	int vertexCount;
} PRIM;

typedef struct stati {
    int gl[TOTAL_GL];
#ifdef WIN32
	int wgl[TOTAL_WGL];
#else
	int xgl[TOTAL_XGL];
#endif
	int Enable[TOTAL_STATE];
	int Disable[TOTAL_STATE];
	int printMat;
	int printState;
	int printPrim;
	int Material[TOTAL_MAT][3];
	PRIM Primit;
} STATI;

#endif
