#include "oglstub.h"
#include "dll.h"

// No longer define these here as they are defined by the makefile.
//#define NO_RAST
//#define NO_GEOM
//#define NO_VERTEX
//#define NO_NORMAL
//#define NO_TEXTURE
//#define NO_PIXEL
//#define NO_DATA
//#define NO_PIXOPS
//#define SHORT_NORMALS
//#define NO_MATERIAL
//#define COLOR_PRIM
//#define NO_LIGHT
//#define SMALL_LINE

/*************************************************************/ 
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glAccum (GLenum op, GLfloat value) 
{
  ((void (*)(GLenum , GLfloat))lib->glFunc[API_glAccum])(op, value);
}

WINGDIAPI void APIENTRY glAlphaFunc (GLenum func, GLclampf ref) 
{
  ((void (*)(GLenum , GLclampf ))lib->glFunc[API_glAlphaFunc])(func,ref);
}

WINGDIAPI GLboolean APIENTRY glAreTexturesResident (GLsizei n, const GLuint *textures, GLboolean *residences) 
{
  return ((GLboolean (*)(GLsizei , const GLuint *, GLboolean *))lib->glFunc[API_glAreTexturesResident])(n, textures, residences);
}

WINGDIAPI void APIENTRY glArrayElement (GLint i) 
{
  ((void (*)(GLint ))lib->glFunc[API_glArrayElement])(i) ;
}
#endif

//
// glBegin() Section.
//

//
// When environment variable COLOR_PRIM is set, draw triangle strips 
// in red, triangle fans in green, independent triangles in blue, quads
// in purple and quad strips in yellow to display the decomposition of
// the scene into different primitive types. 
//
#ifdef COLOR_PRIM
WINGDIAPI void APIENTRY glBegin (GLenum mode) 
{
  switch (mode) {
  case GL_TRIANGLE_STRIP:
    ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(1,0,0);
    break;
  case GL_TRIANGLE_FAN:
    ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(0,1,0);
    break;
  case GL_TRIANGLES:
    ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(0,0,1);
    break;
  case GL_QUADS:
    ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(1,0,1);
    break;
  case GL_QUAD_STRIP:
    ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(1,1,0);
    break;
  }
  ((void (*)(GLenum))lib->glFunc[API_glBegin])(mode);
}

//
// Otherwise, stub is pass through to graphics system function.
//
#else
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glBegin (GLenum mode) 
{
  ((void (*)(GLenum))lib->glFunc[API_glBegin])(mode);
}
#endif
#endif


#if defined (WIN32) || defined(linux)
WINGDIAPI void APIENTRY glBindTexture (GLenum target, GLuint texture) 
{
  ((void (*)(GLenum, GLuint))lib->glFunc[API_glBindTexture])(target, texture);
}

WINGDIAPI void APIENTRY glBitmap (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap) 
{
  ((void (*)(GLsizei , GLsizei , GLfloat , GLfloat , GLfloat , GLfloat , const GLubyte *))lib->glFunc[API_glBitmap])(width, height, xorig, yorig, xmove, ymove, bitmap);
}

WINGDIAPI void APIENTRY glBlendFunc (GLenum sfactor, GLenum dfactor) 
{
  ((void (*)(GLenum , GLenum ))lib->glFunc[API_glBlendFunc])(sfactor, dfactor);
}

WINGDIAPI void APIENTRY glCallList (GLuint list) 
{
  ((void (*)(GLuint ))lib->glFunc[API_glCallList])(list);
}

WINGDIAPI void APIENTRY glCallLists (GLsizei n, GLenum type, const GLvoid *lists) 
{
  ((void (*)(GLsizei , GLenum , const GLvoid *))lib->glFunc[API_glCallLists])(n, type, lists);
}
#endif

//
// glClear() Section.
//

//
// When COLOR_PRIM environment variable is set, enable GL_COLOR_MATERIAL
// OpenGL state variables before calling glClear graphics system function.
//
#if defined (COLOR_PRIM)
WINGDIAPI void APIENTRY glClear (GLbitfield mask)
{
  ((void (*)(GLenum ))lib->glFunc[API_glEnable])(GL_COLOR_MATERIAL);
  ((void (*)(GLbitfield ))lib->glFunc[API_glClear])(mask);
}
#else

//
// Otherwise, stub is pass through to graphics system function.
//
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glClear (GLbitfield mask)
{
  ((void (*)(GLbitfield ))lib->glFunc[API_glClear])(mask);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glClearAccum (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
	((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glClearAccum])(red, green, blue, alpha);
}
WINGDIAPI void APIENTRY glClearColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
	((void (*)(GLclampf , GLclampf , GLclampf , GLclampf ))lib->glFunc[API_glClearColor])(red, green, blue, alpha);
}
WINGDIAPI void APIENTRY glClearDepth (GLclampd depth)
{
	((void (*)(GLclampd ))lib->glFunc[API_glClearDepth])(depth);
}
WINGDIAPI void APIENTRY glClearIndex (GLfloat c)
{
	((void (*)(GLfloat))lib->glFunc[API_glClearIndex])(c);
}
WINGDIAPI void APIENTRY glClearStencil (GLint s)
{
	((void (*)(GLint))lib->glFunc[API_glClearStencil])(s);
}
WINGDIAPI void APIENTRY glClipPlane (GLenum plane, const GLdouble *equation)
{
	((void (*)(GLenum , const GLdouble *))lib->glFunc[API_glClipPlane])(plane, equation);
}
#endif

//
// glColor() Section.
//

//
// When COLOR_PRIM environment variable is defined, triangle strips
// are drawn in red, triangle fans in blue and independent triangles
// in green inorder to display the decomposition of the scene into
// the different primitive types.  So, when COLOR_PRIM is set, 
// don't pass down color values to the graphics subsystem, simply
// return.
//
#if defined (COLOR_PRIM)
WINGDIAPI void APIENTRY glColor3b (GLbyte red, GLbyte green, GLbyte blue)
{
}

WINGDIAPI void APIENTRY glColor3bv (const GLbyte *v)
{
}

WINGDIAPI void APIENTRY glColor3d (GLdouble red, GLdouble green, GLdouble blue)
{
}

WINGDIAPI void APIENTRY glColor3dv (const GLdouble *v)
{
}

WINGDIAPI void APIENTRY glColor3f (GLfloat red, GLfloat green, GLfloat blue)
{
}

WINGDIAPI void APIENTRY glColor3fv (const GLfloat *v)
{
}

WINGDIAPI void APIENTRY glColor3i (GLint red, GLint green, GLint blue)
{
}

WINGDIAPI void APIENTRY glColor3iv (const GLint *v)
{
}

WINGDIAPI void APIENTRY glColor3s (GLshort red, GLshort green, GLshort blue)
{
}

WINGDIAPI void APIENTRY glColor3sv (const GLshort *v)
{
}

WINGDIAPI void APIENTRY glColor3ub (GLubyte red, GLubyte green, GLubyte blue)
{
}

WINGDIAPI void APIENTRY glColor3ubv (const GLubyte *v)
{
}

WINGDIAPI void APIENTRY glColor3ui (GLuint red, GLuint green, GLuint blue)
{
}

WINGDIAPI void APIENTRY glColor3uiv (const GLuint *v)
{
}

WINGDIAPI void APIENTRY glColor3us (GLushort red, GLushort green, GLushort blue)
{
}

WINGDIAPI void APIENTRY glColor3usv (const GLushort *v)
{
}

WINGDIAPI void APIENTRY glColor4b (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha)
{
}

WINGDIAPI void APIENTRY glColor4bv (const GLbyte *v)
{
}

WINGDIAPI void APIENTRY glColor4d (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)
{
}

WINGDIAPI void APIENTRY glColor4dv (const GLdouble *v)
{
}

WINGDIAPI void APIENTRY glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
}

WINGDIAPI void APIENTRY glColor4fv (const GLfloat *v)
{
}

WINGDIAPI void APIENTRY glColor4i (GLint red, GLint green, GLint blue, GLint alpha)
{
}

WINGDIAPI void APIENTRY glColor4iv (const GLint *v)
{
}

WINGDIAPI void APIENTRY glColor4s (GLshort red, GLshort green, GLshort blue, GLshort alpha)
{
}

WINGDIAPI void APIENTRY glColor4sv (const GLshort *v)
{
}

WINGDIAPI void APIENTRY glColor4ub (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
}

WINGDIAPI void APIENTRY glColor4ubv (const GLubyte *v)
{
}

WINGDIAPI void APIENTRY glColor4ui (GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
}

WINGDIAPI void APIENTRY glColor4uiv (const GLuint *v)
{
}

WINGDIAPI void APIENTRY glColor4us (GLushort red, GLushort green, GLushort blue, GLushort alpha)
{
}

WINGDIAPI void APIENTRY glColor4usv (const GLushort *v)
{
}
#else
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glColor3b (GLbyte red, GLbyte green, GLbyte blue)
{
  ((void (*)(GLbyte , GLbyte , GLbyte))lib->glFunc[API_glColor3b])(red, green, blue);
}
WINGDIAPI void APIENTRY glColor3bv (const GLbyte *v)
{
  ((void (*)(const GLbyte *))lib->glFunc[API_glColor3bv])(v);
}
WINGDIAPI void APIENTRY glColor3d (GLdouble red, GLdouble green, GLdouble blue)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glColor3d])(red, green, blue);
}
WINGDIAPI void APIENTRY glColor3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glColor3dv])(v);
}
WINGDIAPI void APIENTRY glColor3f (GLfloat red, GLfloat green, GLfloat blue)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(red, green, blue);
}
WINGDIAPI void APIENTRY glColor3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glColor3fv])(v);
}
WINGDIAPI void APIENTRY glColor3i (GLint red, GLint green, GLint blue)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glColor3i])(red, green, blue);
}
WINGDIAPI void APIENTRY glColor3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glColor3iv])(v);
}
WINGDIAPI void APIENTRY glColor3s (GLshort red, GLshort green, GLshort blue)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glColor3s])(red, green, blue);
}
WINGDIAPI void APIENTRY glColor3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glColor3sv])(v);
}
WINGDIAPI void APIENTRY glColor3ub (GLubyte red, GLubyte green, GLubyte blue)
{
  ((void (*)(GLubyte , GLubyte , GLubyte ))lib->glFunc[API_glColor3ub])(red, green, blue);
}
WINGDIAPI void APIENTRY glColor3ubv (const GLubyte *v)
{
  ((void (*)(const GLubyte *))lib->glFunc[API_glColor3ubv])(v);
}
WINGDIAPI void APIENTRY glColor3ui (GLuint red, GLuint green, GLuint blue)
{
  ((void (*)(GLuint , GLuint , GLuint ))lib->glFunc[API_glColor3ui])(red, green, blue);
}
WINGDIAPI void APIENTRY glColor3uiv (const GLuint *v)
{
  ((void (*)(const GLuint *))lib->glFunc[API_glColor3uiv])(v);
}
WINGDIAPI void APIENTRY glColor3us (GLushort red, GLushort green, GLushort blue)
{
  ((void (*)(GLushort , GLushort , GLushort ))lib->glFunc[API_glColor3us])(red, green, blue);
}
WINGDIAPI void APIENTRY glColor3usv (const GLushort *v)
{
  ((void (*)(const GLushort *))lib->glFunc[API_glColor3usv])(v);
}
WINGDIAPI void APIENTRY glColor4b (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha)
{
  ((void (*)(GLbyte , GLbyte , GLbyte , GLbyte ))lib->glFunc[API_glColor4b])(red, green, blue, alpha);
}
WINGDIAPI void APIENTRY glColor4bv (const GLbyte *v)
{
  ((void (*)(const GLbyte *))lib->glFunc[API_glColor4bv])(v);
}
WINGDIAPI void APIENTRY glColor4d (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glColor4d])(red, green, blue, alpha);
}
WINGDIAPI void APIENTRY glColor4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glColor4dv])(v);
}
WINGDIAPI void APIENTRY glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor4f])(red, green, blue, alpha);
}
WINGDIAPI void APIENTRY glColor4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glColor4fv])(v);
}
WINGDIAPI void APIENTRY glColor4i (GLint red, GLint green, GLint blue, GLint alpha)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glColor4i])(red, green, blue, alpha);
}
WINGDIAPI void APIENTRY glColor4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glColor4iv])(v);
}
WINGDIAPI void APIENTRY glColor4s (GLshort red, GLshort green, GLshort blue, GLshort alpha)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glColor4s])(red, green, blue, alpha);
}
WINGDIAPI void APIENTRY glColor4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glColor4sv])(v);
}
WINGDIAPI void APIENTRY glColor4ub (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
  ((void (*)(GLubyte , GLubyte , GLubyte , GLubyte ))lib->glFunc[API_glColor4ub])(red, green, blue, alpha);
}
WINGDIAPI void APIENTRY glColor4ubv (const GLubyte *v)
{
  ((void (*)(const GLubyte *))lib->glFunc[API_glColor4ubv])(v);
}
WINGDIAPI void APIENTRY glColor4ui (GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
  ((void (*)(GLuint , GLuint , GLuint , GLuint ))lib->glFunc[API_glColor4ui])(red, green, blue, alpha);
}
WINGDIAPI void APIENTRY glColor4uiv (const GLuint *v)
{
  ((void (*)(const GLuint *))lib->glFunc[API_glColor4uiv])(v);
}
WINGDIAPI void APIENTRY glColor4us (GLushort red, GLushort green, GLushort blue, GLushort alpha)
{
  ((void (*)(GLushort , GLushort , GLushort , GLushort ))lib->glFunc[API_glColor4us])(red, green, blue, alpha);
}
WINGDIAPI void APIENTRY glColor4usv (const GLushort *v)
{
  ((void (*)(const GLushort *))lib->glFunc[API_glColor4usv])(v);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
  ((void (*)(GLboolean , GLboolean , GLboolean , GLboolean ))lib->glFunc[API_glColorMask])(red, green, blue, alpha);
}

WINGDIAPI void APIENTRY glColorMaterial (GLenum face, GLenum mode)
{
  ((void (*)(GLenum , GLenum ))lib->glFunc[API_glColorMaterial])(face, mode);
}

WINGDIAPI void APIENTRY glColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLint , GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glColorPointer])(size, type, stride, pointer);
}

//
// glCopyPixels() Section.
//

//
// When NO_PIXEL or NO_DATA environment variables are defined, no pixel 
// data is sent to the graphics subsystem.  As a result, glCopyPixels is
// stubbed out and simply returns.
//
#if defined (NO_PIXEL) || defined (NO_DATA)
WINGDIAPI void APIENTRY glCopyPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
}

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glCopyPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
  ((void (*)(GLint , GLint , GLsizei , GLsizei , GLenum ))lib->glFunc[API_glCopyPixels])(x, y, width, height, type);
}
#endif
#endif

WINGDIAPI void APIENTRY glCopyTexImage1D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
  ((void (*)(GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLint ))lib->glFunc[API_glCopyTexImage1D])(target, level, internalformat, x, y, width, border);
}

WINGDIAPI void APIENTRY glCopyTexImage2D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
  ((void (*)(GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLsizei , GLint ))lib->glFunc[API_glCopyTexImage2D])(target, level, internalformat, x, y, width, height, border);
}

WINGDIAPI void APIENTRY glCopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
  ((void (*)(GLenum , GLint , GLint , GLint , GLint , GLsizei ))lib->glFunc[API_glCopyTexSubImage1D])(target, level, xoffset, x, y, width);
}

WINGDIAPI void APIENTRY glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
  ((void (*)(GLenum , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei ))lib->glFunc[API_glCopyTexSubImage2D])(target, level, xoffset, yoffset, x, y, width, height);
}

WINGDIAPI void APIENTRY glCullFace (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glCullFace])(mode);
}

WINGDIAPI void APIENTRY glDeleteLists (GLuint list, GLsizei range)
{
  ((void (*)(GLuint , GLsizei ))lib->glFunc[API_glDeleteLists])(list, range);
}

WINGDIAPI void APIENTRY glDeleteTextures (GLsizei n, const GLuint *textures)
{
  ((void (*)(GLsizei , const GLuint *))lib->glFunc[API_glDeleteTextures])(n, textures);
}

WINGDIAPI void APIENTRY glDepthFunc (GLenum func)
{
  ((void (*)(GLenum ))lib->glFunc[API_glDepthFunc])(func);
}

WINGDIAPI void APIENTRY glDepthMask (GLboolean flag)
{
  ((void (*)(GLboolean ))lib->glFunc[API_glDepthMask])(flag);
}

WINGDIAPI void APIENTRY glDepthRange (GLclampd zNear, GLclampd zFar)
{
  ((void (*)(GLclampd , GLclampd ))lib->glFunc[API_glDepthRange])(zNear, zFar);
}
#endif

//
// glDisable() Section.
//

//
// When COLOR_PRIM environment variable is set, triangle strips are
// drawn in red, triangle fans in blue and independent triangles in
// green to display the decomposition of the scene in the different
// primitive types.  If COLOR_PRIM is set, don't disable the OpenGL
// GL_COLOR_MATERIAL state.
//
#if defined (COLOR_PRIM)
WINGDIAPI void APIENTRY glDisable (GLenum cap)
{
  if (cap != GL_COLOR_MATERIAL)
    ((void (*)(GLenum ))lib->glFunc[API_glDisable])(cap);
}

//
// Otherwise, stub is pass through to graphics system function.
//
#else
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glDisable (GLenum cap)
{
  ((void (*)(GLenum ))lib->glFunc[API_glDisable])(cap);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glDisableClientState (GLenum array)
{
  ((void (*)(GLenum ))lib->glFunc[API_glDisableClientState])(array);
}

WINGDIAPI void APIENTRY glDrawArrays (GLenum mode, GLint first, GLsizei count)
{
  ((void (*)(GLenum , GLint , GLsizei ))lib->glFunc[API_glDrawArrays])(mode, first, count);
}

WINGDIAPI void APIENTRY glDrawBuffer (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glDrawBuffer])(mode);
}

WINGDIAPI void APIENTRY glDrawElements (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices)
{
  ((void (*)(GLenum , GLsizei , GLenum , const GLvoid *))lib->glFunc[API_glDrawElements])(mode, count, type, indices);
}


//
// glDrawPixels() Section.
//

//
// When NO_PIXEL or NO_DATA environment variables are defined, no pixel 
// data is sent to the graphics subsystem.  As a result, glDrawPixels is
// stubbed out and simply returns.
//
#if defined (NO_PIXEL) || defined (NO_DATA)
WINGDIAPI void APIENTRY glDrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
}

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glDrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLsizei , GLsizei , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glDrawPixels])(width, height, format, type, pixels);
}
#endif
#endif

WINGDIAPI void APIENTRY glEdgeFlag (GLboolean flag)
{
  ((void (*)(GLboolean ))lib->glFunc[API_glEdgeFlag])(flag);
}
WINGDIAPI void APIENTRY glEdgeFlagPointer (GLsizei stride, const GLboolean *pointer)
{
  ((void (*)(GLsizei , const GLboolean *))lib->glFunc[API_glEdgeFlagPointer])(stride, pointer);
}

WINGDIAPI void APIENTRY glEdgeFlagv (const GLboolean *flag)
{
  ((void (*)(const GLboolean *))lib->glFunc[API_glEdgeFlagv])(flag);
}
#endif

//
// glEnable() Section.
//

//
// If the NO_LIGHT environment variable is set, don't enable lighting.
// Effectively ignore calls to glEnable which enable lighting.
//
#if defined ( NO_LIGHT )
WINGDIAPI void APIENTRY glEnable (GLenum cap)
{
  if (cap != GL_LIGHTING)
    ((void (*)(GLenum ))lib->glFunc[API_glEnable])(cap);
}


//
// If the NO_PIXELOPS environment variable is set, don't enable 
// per-pixel operations.  Do this by ignoring all calls to 
// glEnable which enable per-pixel operations.
#elif defined (NO_PIXOPS )

WINGDIAPI void APIENTRY glEnable (GLenum cap)
{
  if ((cap != GL_ALPHA_TEST) || (cap != GL_BLEND) ||
      (cap != GL_COLOR_LOGIC_OP) || (cap != GL_DEPTH_TEST) ||
      (cap != GL_DITHER) || (cap != GL_FOG) ||
      (cap != GL_INDEX_LOGIC_OP) || (cap != GL_LINE_SMOOTH) || 
      (cap != GL_LINE_STIPPLE) || (cap != GL_POLYGON_SMOOTH) ||
      (cap != GL_POINT_SMOOTH) || (cap != GL_POLYGON_STIPPLE) || 
      (cap != GL_SCISSOR_TEST) || (cap != GL_STENCIL_TEST))
    ((void (*)(GLenum ))lib->glFunc[API_glEnable])(cap);
}

//
// Otherwise, stub is a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glEnable (GLenum cap)
{
  ((void (*)(GLenum ))lib->glFunc[API_glEnable])(cap);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glEnableClientState (GLenum array)
{
  ((void (*)(GLenum ))lib->glFunc[API_glEnableClientState])(array);
}

WINGDIAPI void APIENTRY glEnd (void)
{
  ((void (*)())lib->glFunc[API_glEnd])();
}

WINGDIAPI void APIENTRY glEndList (void)
{
  ((void (*)())lib->glFunc[API_glEndList])();
}

WINGDIAPI void APIENTRY glEvalCoord1d (GLdouble u)
{
  ((void (*)(GLdouble ))lib->glFunc[API_glEvalCoord1d])(u);
}

WINGDIAPI void APIENTRY glEvalCoord1dv (const GLdouble *u)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glEvalCoord1dv])(u);
}

WINGDIAPI void APIENTRY glEvalCoord1f (GLfloat u)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glEvalCoord1f])(u);
}

WINGDIAPI void APIENTRY glEvalCoord1fv (const GLfloat *u)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glEvalCoord1fv])(u);
}

WINGDIAPI void APIENTRY glEvalCoord2d (GLdouble u, GLdouble v)
{
  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glEvalCoord2d])(u, v);
}

WINGDIAPI void APIENTRY glEvalCoord2dv (const GLdouble *u)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glEvalCoord2dv])(u);
}

WINGDIAPI void APIENTRY glEvalCoord2f (GLfloat u, GLfloat v)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glEvalCoord2f])(u, v);
}

WINGDIAPI void APIENTRY glEvalCoord2fv (const GLfloat *u)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glEvalCoord2fv])(u);
}

WINGDIAPI void APIENTRY glEvalMesh1 (GLenum mode, GLint i1, GLint i2)
{
  ((void (*)(GLenum , GLint , GLint ))lib->glFunc[API_glEvalMesh1])(mode, i1, i2);
}

WINGDIAPI void APIENTRY glEvalMesh2 (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)
{
  ((void (*)(GLenum , GLint , GLint , GLint , GLint ))lib->glFunc[API_glEvalMesh2])(mode, i1, i2, j1, j2);
}

WINGDIAPI void APIENTRY glEvalPoint1 (GLint i)
{
  ((void (*)(GLint ))lib->glFunc[API_glEvalPoint1])(i);
}

WINGDIAPI void APIENTRY glEvalPoint2 (GLint i, GLint j)
{
  ((void (*)(GLint , GLint ))lib->glFunc[API_glEvalPoint2])(i, j);
}

WINGDIAPI void APIENTRY glFeedbackBuffer (GLsizei size, GLenum type, GLfloat *buffer)
{
  ((void (*)(GLsizei , GLenum , GLfloat *))lib->glFunc[API_glFeedbackBuffer])(size, type, buffer);
}

WINGDIAPI void APIENTRY glFinish (void)
{
  ((void (*)())lib->glFunc[API_glFinish])();
}

WINGDIAPI void APIENTRY glFlush (void)
{
  ((void (*)())lib->glFunc[API_glFlush])();
}

WINGDIAPI void APIENTRY glFogf (GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glFogf])(pname, param);
}

WINGDIAPI void APIENTRY glFogfv (GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , const GLfloat *))lib->glFunc[API_glFogfv])(pname, params);
}

WINGDIAPI void APIENTRY glFogi (GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLint ))lib->glFunc[API_glFogi])(pname, param);
}

WINGDIAPI void APIENTRY glFogiv (GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , const GLint *))lib->glFunc[API_glFogiv])(pname, params);
}

WINGDIAPI void APIENTRY glFrontFace (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glFrontFace])(mode);
}

WINGDIAPI void APIENTRY glFrustum (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glFrustum])(left, right, bottom, top, zNear, zFar);
}

WINGDIAPI GLuint APIENTRY glGenLists (GLsizei range)
{
  return ((GLuint (*)(GLsizei))lib->glFunc[API_glGenLists])(range);
}

WINGDIAPI void APIENTRY glGenTextures (GLsizei n, GLuint *textures)
{
  ((void (*)(GLsizei , GLuint *))lib->glFunc[API_glGenTextures])(n, textures);
}

WINGDIAPI void APIENTRY glGetBooleanv (GLenum pname, GLboolean *params)
{
  ((void (*)(GLenum , GLboolean *))lib->glFunc[API_glGetBooleanv])(pname, params);
}

WINGDIAPI void APIENTRY glGetClipPlane (GLenum plane, GLdouble *equation)
{
  ((void (*)(GLenum , GLdouble *))lib->glFunc[API_glGetClipPlane])(plane, equation);
}

WINGDIAPI void APIENTRY glGetDoublev (GLenum pname, GLdouble *params)
{
  ((void (*)(GLenum , GLdouble *))lib->glFunc[API_glGetDoublev])(pname, params);
}

WINGDIAPI GLenum APIENTRY glGetError (void)
{ 
  return ((GLenum (*)())lib->glFunc[API_glGetError])();
}

WINGDIAPI void APIENTRY glGetFloatv (GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLfloat *))lib->glFunc[API_glGetFloatv])(pname, params);
}

WINGDIAPI void APIENTRY glGetIntegerv (GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLint *))lib->glFunc[API_glGetIntegerv])(pname, params);
}

WINGDIAPI void APIENTRY glGetLightfv (GLenum light, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetLightfv])(light, pname, params);
}

WINGDIAPI void APIENTRY glGetLightiv (GLenum light, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetLightiv])(light, pname, params);
}

WINGDIAPI void APIENTRY glGetMapdv (GLenum target, GLenum query, GLdouble *v)
{
  ((void (*)(GLenum , GLenum , GLdouble *))lib->glFunc[API_glGetMapdv])(target, query, v);
}

WINGDIAPI void APIENTRY glGetMapfv (GLenum target, GLenum query, GLfloat *v)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetMapfv])(target, query, v);
}

WINGDIAPI void APIENTRY glGetMapiv (GLenum target, GLenum query, GLint *v)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetMapiv])(target, query, v);
}

WINGDIAPI void APIENTRY glGetMaterialfv (GLenum face, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetMaterialfv])(face, pname, params);
}

WINGDIAPI void APIENTRY glGetMaterialiv (GLenum face, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetMaterialiv])(face, pname, params);
}

WINGDIAPI void APIENTRY glGetPixelMapfv (GLenum map, GLfloat *values)
{
  ((void (*)(GLenum , GLfloat *))lib->glFunc[API_glGetPixelMapfv])(map, values);
}

WINGDIAPI void APIENTRY glGetPixelMapuiv (GLenum map, GLuint *values)
{
  ((void (*)(GLenum , GLuint *))lib->glFunc[API_glGetPixelMapuiv])(map, values);
}

WINGDIAPI void APIENTRY glGetPixelMapusv (GLenum map, GLushort *values)
{
  ((void (*)(GLenum , GLushort *))lib->glFunc[API_glGetPixelMapusv])(map, values);
}

WINGDIAPI void APIENTRY glGetPointerv (GLenum pname, GLvoid* *params)
{
  ((void (*)(GLenum , GLvoid* *))lib->glFunc[API_glGetPointerv])(pname, params);
}

WINGDIAPI void APIENTRY glGetPolygonStipple (GLubyte *mask)
{
  ((void (*)(GLubyte *))lib->glFunc[API_glGetPolygonStipple])(mask);
}

WINGDIAPI void APIENTRY glGetTexEnvfv (GLenum target, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetTexEnvfv])(target, pname, params);
}

WINGDIAPI void APIENTRY glGetTexEnviv (GLenum target, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetTexEnviv])(target, pname, params);
}

WINGDIAPI void APIENTRY glGetTexGendv (GLenum coord, GLenum pname, GLdouble *params)
{
  ((void (*)(GLenum , GLenum , GLdouble *))lib->glFunc[API_glGetTexGendv])(coord, pname, params);
}

WINGDIAPI void APIENTRY glGetTexGenfv (GLenum coord, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetTexGenfv])(coord, pname, params);
}

WINGDIAPI void APIENTRY glGetTexGeniv (GLenum coord, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetTexGeniv])(coord, pname, params);
}

WINGDIAPI void APIENTRY glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLenum , GLenum , GLvoid *))lib->glFunc[API_glGetTexImage])(target, level, format, type, pixels);
}

WINGDIAPI void APIENTRY glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLint , GLenum , GLfloat *))lib->glFunc[API_glGetTexLevelParameterfv])(target, level, pname, params);
}

WINGDIAPI void APIENTRY glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLint , GLenum , GLint *))lib->glFunc[API_glGetTexLevelParameteriv])(target, level, pname, params);
}

WINGDIAPI void APIENTRY glGetTexParameterfv (GLenum target, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetTexParameterfv])(target, pname, params);
}

WINGDIAPI void APIENTRY glGetTexParameteriv (GLenum target, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetTexParameteriv])(target, pname, params);
}

WINGDIAPI void APIENTRY glHint (GLenum target, GLenum mode)
{
  ((void (*)(GLenum , GLenum ))lib->glFunc[API_glHint])(target, mode);
}

WINGDIAPI void APIENTRY glIndexMask (GLuint mask)
{
  ((void (*)(GLuint ))lib->glFunc[API_glIndexMask])(mask);
}

WINGDIAPI void APIENTRY glIndexPointer (GLenum type, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glIndexPointer])(type, stride, pointer);
}

WINGDIAPI void APIENTRY glIndexd (GLdouble c)
{
  ((void (*)(GLdouble ))lib->glFunc[API_glIndexd])(c);
}

WINGDIAPI void APIENTRY glIndexdv (const GLdouble *c)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glIndexdv])(c);
}

WINGDIAPI void APIENTRY glIndexf (GLfloat c)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glIndexf])(c);
}

WINGDIAPI void APIENTRY glIndexfv (const GLfloat *c)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glIndexfv])(c);
}

WINGDIAPI void APIENTRY glIndexi (GLint c)
{
  ((void (*)(GLint ))lib->glFunc[API_glIndexi])(c);
}

WINGDIAPI void APIENTRY glIndexiv (const GLint *c)
{
  ((void (*)(const GLint *))lib->glFunc[API_glIndexiv])(c);
}

WINGDIAPI void APIENTRY glIndexs (GLshort c)
{
  ((void (*)(GLshort ))lib->glFunc[API_glIndexs])(c);
}

WINGDIAPI void APIENTRY glIndexsv (const GLshort *c)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glIndexsv])(c);
}

WINGDIAPI void APIENTRY glIndexub (GLubyte c)
{
  ((void (*)(GLubyte ))lib->glFunc[API_glIndexub])(c);
}

WINGDIAPI void APIENTRY glIndexubv (const GLubyte *c)
{
  ((void (*)(const GLubyte *))lib->glFunc[API_glIndexubv])(c);
}

WINGDIAPI void APIENTRY glInitNames (void)
{
  ((void (*)())lib->glFunc[API_glInitNames])();
}

WINGDIAPI void APIENTRY glInterleavedArrays (GLenum format, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glInterleavedArrays])(format, stride, pointer);

}

WINGDIAPI GLboolean APIENTRY glIsEnabled (GLenum cap) 
{ 
  return ((GLboolean (*)(GLenum ))lib->glFunc[API_glIsEnabled])(cap);
}

WINGDIAPI GLboolean APIENTRY glIsList (GLuint list) 
{ 
  return ((GLboolean (*)(GLuint ))lib->glFunc[API_glIsList])(list);
}

WINGDIAPI GLboolean APIENTRY glIsTexture (GLuint texture) 
{ 
  return ((GLboolean (*)(GLuint ))lib->glFunc[API_glIsTexture])(texture);
}

WINGDIAPI void APIENTRY glLightModelf (GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glLightModelf])(pname, param);
}

WINGDIAPI void APIENTRY glLightModelfv (GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum, const GLfloat *))lib->glFunc[API_glLightModelfv])(pname, params);
}

WINGDIAPI void APIENTRY glLightModeli (GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLint ))lib->glFunc[API_glLightModeli])(pname, param);
}

WINGDIAPI void APIENTRY glLightModeliv (GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , const GLint *))lib->glFunc[API_glLightModeliv])(pname, params);
}

WINGDIAPI void APIENTRY glLightf (GLenum light, GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glLightf])(light, pname, param);
}

WINGDIAPI void APIENTRY glLightfv (GLenum light, GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glLightfv])(light, pname, params);
}

WINGDIAPI void APIENTRY glLighti (GLenum light, GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glLighti])(light, pname, param);
}

WINGDIAPI void APIENTRY glLightiv (GLenum light, GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glLightiv])(light, pname, params);
}

WINGDIAPI void APIENTRY glLineStipple (GLint factor, GLushort pattern)
{
  ((void (*)(GLint , GLushort ))lib->glFunc[API_glLineStipple])(factor, pattern);
}
#endif

//
// glLineWidth() Section.
//

//
//
//
#ifdef SMALL_LINE
WINGDIAPI void APIENTRY glLineWidth (GLfloat width)
{
}
#else
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glLineWidth (GLfloat width)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glLineWidth])(width);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glListBase (GLuint base)
{
  ((void (*)(GLuint ))lib->glFunc[API_glListBase])(base);
}

WINGDIAPI void APIENTRY glLoadIdentity (void)
{
  ((void (*)())lib->glFunc[API_glLoadIdentity])();
}

WINGDIAPI void APIENTRY glLoadMatrixd (const GLdouble *m)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glLoadMatrixd])(m);
}

WINGDIAPI void APIENTRY glLoadMatrixf (const GLfloat *m)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glLoadMatrixf])(m);
}

WINGDIAPI void APIENTRY glLoadName (GLuint name)
{
  ((void (*)(GLuint ))lib->glFunc[API_glLoadName])(name);
}

WINGDIAPI void APIENTRY glLogicOp (GLenum opcode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glLogicOp])(opcode);
}

WINGDIAPI void APIENTRY glMap1d (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)
{
  ((void (*)(GLenum , GLdouble , GLdouble , GLint , GLint , const GLdouble *))lib->glFunc[API_glMap1d])(target, u1, u2, stride, order, points);
}

WINGDIAPI void APIENTRY glMap1f (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)
{
  ((void (*)(GLenum , GLfloat , GLfloat , GLint , GLint , const GLfloat *))lib->glFunc[API_glMap1f])(target, u1, u2, stride, order, points);
}

WINGDIAPI void APIENTRY glMap2d (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)
{
  ((void (*)(GLenum , GLdouble , GLdouble , GLint , GLint , GLdouble , GLdouble , GLint , GLint , const GLdouble *))lib->glFunc[API_glMap2d])(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

WINGDIAPI void APIENTRY glMap2f (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)
{
  ((void (*)(GLenum , GLfloat , GLfloat , GLint , GLint , GLfloat , GLfloat , GLint , GLint , const GLfloat *))lib->glFunc[API_glMap2f])(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

WINGDIAPI void APIENTRY glMapGrid1d (GLint un, GLdouble u1, GLdouble u2)
{
  ((void (*)(GLint , GLdouble , GLdouble ))lib->glFunc[API_glMapGrid1d])(un, u1, u2);
}

WINGDIAPI void APIENTRY glMapGrid1f (GLint un, GLfloat u1, GLfloat u2)
{
  ((void (*)(GLint , GLfloat , GLfloat ))lib->glFunc[API_glMapGrid1f])(un, u1, u2);
}
WINGDIAPI void APIENTRY glMapGrid2d (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)
{
  ((void (*)(GLint , GLdouble , GLdouble , GLint , GLdouble , GLdouble ))lib->glFunc[API_glMapGrid2d])(un, u1, u2, vn, v1, v2);
}

WINGDIAPI void APIENTRY glMapGrid2f (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)
{
  ((void (*)(GLint , GLfloat , GLfloat , GLint , GLfloat , GLfloat ))lib->glFunc[API_glMapGrid2f])(un, u1, u2, vn, v1, v2);
}
#endif

//
// glMaterial() Section.
//

//
// In the case that the NO_MATERIAL environment variable is set, stub
// out all glMaterial calls so that they simply return and don't provide
// any functionality.
//
#if defined (NO_MATERIAL)
WINGDIAPI void APIENTRY glMaterialf (GLenum face, GLenum pname, GLfloat param)
{
}
WINGDIAPI void APIENTRY glMaterialfv (GLenum face, GLenum pname, const GLfloat *params)
{
}
WINGDIAPI void APIENTRY glMateriali (GLenum face, GLenum pname, GLint param)
{
}
WINGDIAPI void APIENTRY glMaterialiv (GLenum face, GLenum pname, const GLint *params)
{
}

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glMaterialf (GLenum face, GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glMaterialf])(face, pname, param);
}

WINGDIAPI void APIENTRY glMaterialfv (GLenum face, GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glMaterialfv])(face, pname, params);
}

WINGDIAPI void APIENTRY glMateriali (GLenum face, GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glMateriali])(face, pname, param);
}

WINGDIAPI void APIENTRY glMaterialiv (GLenum face, GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glMaterialiv])(face, pname, params);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glMatrixMode (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glMatrixMode])(mode);
}

WINGDIAPI void APIENTRY glMultMatrixd (const GLdouble *m)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glMultMatrixd])(m);
}

WINGDIAPI void APIENTRY glMultMatrixf (const GLfloat *m)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glMultMatrixf])(m);
}
WINGDIAPI void APIENTRY glNewList (GLuint list, GLenum mode)
{
  ((void (*)(GLuint , GLenum ))lib->glFunc[API_glNewList])(list, mode);
}
#endif

//
// glNormal() Section.
//

//
// When the SHORT_NORMALS environment variable is set, the normal vector
// (1, 0, 0) is sent as short integers to the graphics subsystem.  Normal
// vector values sent by the application are ignored.  This reduces the
// bandwidth required by the application and simulates the performance
// that could be achieved if normals within the application were converted
// to short integers.
//
#ifdef SHORT_NORMALS
static GLshort nns[] = {1, 0, 0};
WINGDIAPI void APIENTRY glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz)
{
  ((void (*)(GLbyte , GLbyte , GLbyte ))lib->glFunc[API_glNormal3b])(1, 0, 0);
}

WINGDIAPI void APIENTRY glNormal3bv (const GLbyte *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3bv])(nns);
}

WINGDIAPI void APIENTRY glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glNormal3s])(1, 0, 0);
}

WINGDIAPI void APIENTRY glNormal3dv (const GLdouble *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3sv])(nns);
}

WINGDIAPI void APIENTRY glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glNormal3s])(1, 0, 0);
}

WINGDIAPI void APIENTRY glNormal3fv (const GLfloat *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3sv])(nns);
}

WINGDIAPI void APIENTRY glNormal3i (GLint nx, GLint ny, GLint nz)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glNormal3s])(1, 0, 0);
}

WINGDIAPI void APIENTRY glNormal3iv (const GLint *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3sv])(nns);
}

WINGDIAPI void APIENTRY glNormal3s (GLshort nx, GLshort ny, GLshort nz)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glNormal3s])(nx, ny, nz);
}

WINGDIAPI void APIENTRY glNormal3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3sv])(v);
}

//
// Otherwise, if the NO_NORMAL, or NO_DATA environment variables
// are set, stub out all glNormal calls so that no normal vector
// data is sent to the graphics subsystem.
//
#elif defined (NO_NORMAL) || defined (NO_DATA)
WINGDIAPI void APIENTRY glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz)
{
}

WINGDIAPI void APIENTRY glNormal3bv (const GLbyte *v)
{
}

WINGDIAPI void APIENTRY glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz)
{
}

WINGDIAPI void APIENTRY glNormal3dv (const GLdouble *v)
{
}

WINGDIAPI void APIENTRY glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz)
{
}

WINGDIAPI void APIENTRY glNormal3fv (const GLfloat *v)
{
}

WINGDIAPI void APIENTRY glNormal3i (GLint nx, GLint ny, GLint nz)
{
}

WINGDIAPI void APIENTRY glNormal3iv (const GLint *v)
{
}

WINGDIAPI void APIENTRY glNormal3s (GLshort nx, GLshort ny, GLshort nz)
{
}

WINGDIAPI void APIENTRY glNormal3sv (const GLshort *v)
{
}

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz)
{
  ((void (*)(GLbyte , GLbyte , GLbyte ))lib->glFunc[API_glNormal3b])(nx, ny, nz);
}

WINGDIAPI void APIENTRY glNormal3bv (const GLbyte *v)
{
  ((void (*)(const GLbyte *))lib->glFunc[API_glNormal3bv])(v);
}

WINGDIAPI void APIENTRY glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glNormal3d])(nx, ny, nz);
}

WINGDIAPI void APIENTRY glNormal3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glNormal3dv])(v);
}

WINGDIAPI void APIENTRY glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glNormal3f])(nx, ny, nz);
}

WINGDIAPI void APIENTRY glNormal3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glNormal3fv])(v);
}

WINGDIAPI void APIENTRY glNormal3i (GLint nx, GLint ny, GLint nz)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glNormal3i])(nx, ny, nz);
}

WINGDIAPI void APIENTRY glNormal3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glNormal3iv])(v);
}

WINGDIAPI void APIENTRY glNormal3s (GLshort nx, GLshort ny, GLshort nz)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glNormal3s])(nx, ny, nz);
}
WINGDIAPI void APIENTRY glNormal3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3sv])(v);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glNormalPointer (GLenum type, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glNormalPointer])(type, stride, pointer);
}

WINGDIAPI void APIENTRY glOrtho (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glOrtho])(left, right, bottom, top, zNear, zFar);
}

WINGDIAPI void APIENTRY glPassThrough (GLfloat token)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glPassThrough])(token );
}

WINGDIAPI void APIENTRY glPixelMapfv (GLenum map, GLint mapsize, const GLfloat *values)
{
  ((void (*)(GLenum , GLint , const GLfloat *))lib->glFunc[API_glPixelMapfv])(map, mapsize, values);
}

WINGDIAPI void APIENTRY glPixelMapuiv (GLenum map, GLint mapsize, const GLuint *values)
{
  ((void (*)(GLenum , GLint , const GLuint *))lib->glFunc[API_glPixelMapuiv])(map, mapsize, values);
}

WINGDIAPI void APIENTRY glPixelMapusv (GLenum map, GLint mapsize, const GLushort *values)
{
  ((void (*)(GLenum , GLint , const GLushort *))lib->glFunc[API_glPixelMapusv])(map, mapsize, values);
}

WINGDIAPI void APIENTRY glPixelStoref (GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glPixelStoref])(pname, param);
}

WINGDIAPI void APIENTRY glPixelStorei (GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLint ))lib->glFunc[API_glPixelStorei])(pname, param);
}

WINGDIAPI void APIENTRY glPixelTransferf (GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glPixelTransferf])(pname, param);
}

WINGDIAPI void APIENTRY glPixelTransferi (GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLint ))lib->glFunc[API_glPixelTransferi])(pname, param);
}

WINGDIAPI void APIENTRY glPixelZoom (GLfloat xfactor, GLfloat yfactor)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glPixelZoom])(xfactor, yfactor);
}

WINGDIAPI void APIENTRY glPointSize (GLfloat size)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glPointSize])(size);
}

WINGDIAPI void APIENTRY glPolygonMode (GLenum face, GLenum mode)
{
  ((void (*)(GLenum , GLenum ))lib->glFunc[API_glPolygonMode])(face, mode);
}
#endif

#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glPolygonOffset (GLfloat factor, GLfloat units)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glPolygonOffset])(factor, units);
}

WINGDIAPI void APIENTRY glPolygonStipple (const GLubyte *mask)
{
  ((void (*)(const GLubyte *))lib->glFunc[API_glPolygonStipple])(mask);
}

WINGDIAPI void APIENTRY glPopAttrib (void)
{
  ((void (*)())lib->glFunc[API_glPopAttrib])();
}

WINGDIAPI void APIENTRY glPopClientAttrib (void)
{
  ((void (*)())lib->glFunc[API_glPopClientAttrib])();
}

WINGDIAPI void APIENTRY glPopMatrix (void)
{
  ((void (*)())lib->glFunc[API_glPopMatrix])();
}

WINGDIAPI void APIENTRY glPopName (void)
{
  ((void (*)())lib->glFunc[API_glPopName])();
}

WINGDIAPI void APIENTRY glPrioritizeTextures (GLsizei n, const GLuint *textures, const GLclampf *priorities)
{
  ((void (*)(GLsizei , const GLuint *, const GLclampf *))lib->glFunc[API_glPrioritizeTextures])(n, textures, priorities);
}

WINGDIAPI void APIENTRY glPushAttrib (GLbitfield mask)
{
  ((void (*)(GLbitfield ))lib->glFunc[API_glPushAttrib])(mask);
}

WINGDIAPI void APIENTRY glPushClientAttrib (GLbitfield mask)
{
  ((void (*)(GLbitfield ))lib->glFunc[API_glPushClientAttrib])(mask);
}

WINGDIAPI void APIENTRY glPushMatrix (void)
{
  ((void (*)())lib->glFunc[API_glPushMatrix])();
}

WINGDIAPI void APIENTRY glPushName (GLuint name)
{
  ((void (*)(GLuint ))lib->glFunc[API_glPushName])(name);
}

WINGDIAPI void APIENTRY glRasterPos2d (GLdouble x, GLdouble y)
{
  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glRasterPos2d])(x, y);
}

WINGDIAPI void APIENTRY glRasterPos2dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glRasterPos2dv])(v);
}

WINGDIAPI void APIENTRY glRasterPos2f (GLfloat x, GLfloat y)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glRasterPos2f])(x, y);
}

WINGDIAPI void APIENTRY glRasterPos2fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glRasterPos2fv])(v);
}

WINGDIAPI void APIENTRY glRasterPos2i (GLint x, GLint y)
{
  ((void (*)(GLint , GLint ))lib->glFunc[API_glRasterPos2i])(x, y);
}

WINGDIAPI void APIENTRY glRasterPos2iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glRasterPos2iv])(v);
}

WINGDIAPI void APIENTRY glRasterPos2s (GLshort x, GLshort y)
{
  ((void (*)(GLshort , GLshort ))lib->glFunc[API_glRasterPos2s])(x, y);
}

WINGDIAPI void APIENTRY glRasterPos2sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glRasterPos2sv])(v);
}

WINGDIAPI void APIENTRY glRasterPos3d (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRasterPos3d])(x, y, z);
}

WINGDIAPI void APIENTRY glRasterPos3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glRasterPos3dv])(v);
}

WINGDIAPI void APIENTRY glRasterPos3f (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRasterPos3f])(x, y, z);
}

WINGDIAPI void APIENTRY glRasterPos3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glRasterPos3fv])(v);
}

WINGDIAPI void APIENTRY glRasterPos3i (GLint x, GLint y, GLint z)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glRasterPos3i])(x, y, z);
}

WINGDIAPI void APIENTRY glRasterPos3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glRasterPos3iv])(v);
}

WINGDIAPI void APIENTRY glRasterPos3s (GLshort x, GLshort y, GLshort z)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glRasterPos3s])(x, y, z);
}

WINGDIAPI void APIENTRY glRasterPos3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glRasterPos3sv])(v);
}

WINGDIAPI void APIENTRY glRasterPos4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRasterPos4d])(x, y, z, w);
}

WINGDIAPI void APIENTRY glRasterPos4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glRasterPos4dv])(v);
}

WINGDIAPI void APIENTRY glRasterPos4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRasterPos4f])(x, y, z, w);
}

WINGDIAPI void APIENTRY glRasterPos4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glRasterPos4fv])(v);
}

WINGDIAPI void APIENTRY glRasterPos4i (GLint x, GLint y, GLint z, GLint w)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glRasterPos4i])(x, y, z, w);
}

WINGDIAPI void APIENTRY glRasterPos4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glRasterPos4iv])(v);
}

WINGDIAPI void APIENTRY glRasterPos4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glRasterPos4s])(x, y, z, w);
}

WINGDIAPI void APIENTRY glRasterPos4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glRasterPos4sv])(v);
}

WINGDIAPI void APIENTRY glReadBuffer (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glReadBuffer])(mode);
}

//
// glReadPixels() Section.
//

//
// When NO_PIXEL or NO_DATA environment variables are defined, no pixel 
// data is sent to the graphics subsystem.  As a result, glReadPixels is
// stubbed out and simply returns.
//
#if defined (NO_PIXEL) || defined (NO_DATA)
WINGDIAPI void APIENTRY glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)
{
}

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)
{
  ((void (*)(GLint , GLint , GLsizei , GLsizei , GLenum , GLenum , GLvoid *))lib->glFunc[API_glReadPixels])(x, y, width, height, format, type, pixels);
}
#endif
#endif

WINGDIAPI void APIENTRY glRectd (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRectd])(x1, y1, x2, y2);
}

WINGDIAPI void APIENTRY glRectdv (const GLdouble *v1, const GLdouble *v2)
{
  ((void (*)(const GLdouble *, const GLdouble *))lib->glFunc[API_glRectdv])(v1, v2);
}

WINGDIAPI void APIENTRY glRectf (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRectf])(x1, y1, x2, y2);
}

WINGDIAPI void APIENTRY glRectfv (const GLfloat *v1, const GLfloat *v2)
{
  ((void (*)(const GLfloat *, const GLfloat *))lib->glFunc[API_glRectfv])(v1, v2);
}

WINGDIAPI void APIENTRY glRecti (GLint x1, GLint y1, GLint x2, GLint y2)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glRecti])(x1, y1, x2, y2);
}

WINGDIAPI void APIENTRY glRectiv (const GLint *v1, const GLint *v2)
{
  ((void (*)(const GLint *, const GLint *))lib->glFunc[API_glRectiv])(v1, v2);
}

WINGDIAPI void APIENTRY glRects (GLshort x1, GLshort y1, GLshort x2, GLshort y2)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glRects])(x1, y1, x2, y2);
}

WINGDIAPI void APIENTRY glRectsv (const GLshort *v1, const GLshort *v2)
{
  ((void (*)(const GLshort *, const GLshort *))lib->glFunc[API_glRectsv])(v1, v2);
}

WINGDIAPI GLint APIENTRY glRenderMode (GLenum mode)
{ 
  return ((GLint (*)(GLenum ))lib->glFunc[API_glRenderMode])(mode);
}

WINGDIAPI void APIENTRY glRotated (GLdouble angle, GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRotated])(angle, x, y, z);
}

WINGDIAPI void APIENTRY glRotatef (GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRotatef])(angle, x, y, z);
}

WINGDIAPI void APIENTRY glScaled (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glScaled])(x, y, z);
}

WINGDIAPI void APIENTRY glScalef (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glScalef])(x, y, z);
}

WINGDIAPI void APIENTRY glScissor (GLint x, GLint y, GLsizei width, GLsizei height)
{
  ((void (*)(GLint , GLint , GLsizei , GLsizei ))lib->glFunc[API_glScissor])(x, y, width, height);
}

WINGDIAPI void APIENTRY glSelectBuffer (GLsizei size, GLuint *buffer)
{
  ((void (*)(GLsizei , GLuint *))lib->glFunc[API_glSelectBuffer])(size, buffer);
}

WINGDIAPI void APIENTRY glShadeModel (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glShadeModel])(mode);
}

WINGDIAPI void APIENTRY glStencilFunc (GLenum func, GLint ref, GLuint mask)
{
  ((void (*)(GLenum , GLint , GLuint ))lib->glFunc[API_glStencilFunc])(func, ref, mask);
}

WINGDIAPI void APIENTRY glStencilMask (GLuint mask)
{
  ((void (*)(GLuint ))lib->glFunc[API_glStencilMask])(mask);
}

WINGDIAPI void APIENTRY glStencilOp (GLenum fail, GLenum zfail, GLenum zpass)
{
  ((void (*)(GLenum , GLenum , GLenum ))lib->glFunc[API_glStencilOp])(fail, zfail, zpass);
}

WINGDIAPI void APIENTRY glTexCoord1d (GLdouble s)
{
  ((void (*)(GLdouble ))lib->glFunc[API_glTexCoord1d])(s);
}

WINGDIAPI void APIENTRY glTexCoord1dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord1dv])(v);
}

WINGDIAPI void APIENTRY glTexCoord1f (GLfloat s)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glTexCoord1f])(s);
}

WINGDIAPI void APIENTRY glTexCoord1fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord1fv])(v);
}

WINGDIAPI void APIENTRY glTexCoord1i (GLint s)
{
  ((void (*)(GLint ))lib->glFunc[API_glTexCoord1i])(s);
}

WINGDIAPI void APIENTRY glTexCoord1iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord1iv])(v);
}

WINGDIAPI void APIENTRY glTexCoord1s (GLshort s)
{
  ((void (*)(GLshort ))lib->glFunc[API_glTexCoord1s])(s);
}

WINGDIAPI void APIENTRY glTexCoord1sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord1sv])(v);
}

WINGDIAPI void APIENTRY glTexCoord2d (GLdouble s, GLdouble t)
{
  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glTexCoord2d])(s, t);
}

WINGDIAPI void APIENTRY glTexCoord2dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord2dv])(v);
}

WINGDIAPI void APIENTRY glTexCoord2f (GLfloat s, GLfloat t)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glTexCoord2f])(s, t);
}

WINGDIAPI void APIENTRY glTexCoord2fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord2fv])(v);
}

WINGDIAPI void APIENTRY glTexCoord2i (GLint s, GLint t)
{
  ((void (*)(GLint , GLint ))lib->glFunc[API_glTexCoord2i])(s, t);
}

WINGDIAPI void APIENTRY glTexCoord2iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord2iv])(v);
}

WINGDIAPI void APIENTRY glTexCoord2s (GLshort s, GLshort t)
{
  ((void (*)(GLshort , GLshort ))lib->glFunc[API_glTexCoord2s])(s, t);
}

WINGDIAPI void APIENTRY glTexCoord2sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord2sv])(v);
}

WINGDIAPI void APIENTRY glTexCoord3d (GLdouble s, GLdouble t, GLdouble r)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glTexCoord3d])(s, t, r);
}

WINGDIAPI void APIENTRY glTexCoord3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord3dv])(v);
}

WINGDIAPI void APIENTRY glTexCoord3f (GLfloat s, GLfloat t, GLfloat r)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glTexCoord3f])(s, t, r);
}

WINGDIAPI void APIENTRY glTexCoord3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord3fv])(v);
}

WINGDIAPI void APIENTRY glTexCoord3i (GLint s, GLint t, GLint r)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glTexCoord3i])(s, t, r);
}

WINGDIAPI void APIENTRY glTexCoord3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord3iv])(v);
}

WINGDIAPI void APIENTRY glTexCoord3s (GLshort s, GLshort t, GLshort r)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glTexCoord3s])(s, t, r);
}

WINGDIAPI void APIENTRY glTexCoord3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord3sv])(v);
}

WINGDIAPI void APIENTRY glTexCoord4d (GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glTexCoord4d])(s, t, r, q);
}

WINGDIAPI void APIENTRY glTexCoord4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord4dv])(v);
}

WINGDIAPI void APIENTRY glTexCoord4f (GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glTexCoord4f])(s, t, r, q);
}

WINGDIAPI void APIENTRY glTexCoord4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord4fv])(v);
}

WINGDIAPI void APIENTRY glTexCoord4i (GLint s, GLint t, GLint r, GLint q)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glTexCoord4i])(s, t, r, q);
}

WINGDIAPI void APIENTRY glTexCoord4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord4iv])(v);
}

WINGDIAPI void APIENTRY glTexCoord4s (GLshort s, GLshort t, GLshort r, GLshort q)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glTexCoord4s])(s, t, r, q);
}

WINGDIAPI void APIENTRY glTexCoord4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord4sv])(v);
}

WINGDIAPI void APIENTRY glTexCoordPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLint , GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glTexCoordPointer])(size, type, stride, pointer);
}

WINGDIAPI void APIENTRY glTexEnvf (GLenum target, GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glTexEnvf])(target, pname, param);
}

WINGDIAPI void APIENTRY glTexEnvfv (GLenum target, GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glTexEnvfv])(target, pname, params);
}

WINGDIAPI void APIENTRY glTexEnvi (GLenum target, GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glTexEnvi])(target, pname, param);
}

WINGDIAPI void APIENTRY glTexEnviv (GLenum target, GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glTexEnviv])(target, pname, params);
}

WINGDIAPI void APIENTRY glTexGend (GLenum coord, GLenum pname, GLdouble param)
{
  ((void (*)(GLenum , GLenum , GLdouble ))lib->glFunc[API_glTexGend])(coord, pname, param);
}

WINGDIAPI void APIENTRY glTexGendv (GLenum coord, GLenum pname, const GLdouble *params)
{
  ((void (*)(GLenum , GLenum , const GLdouble *))lib->glFunc[API_glTexGendv])(coord, pname, params);
}

WINGDIAPI void APIENTRY glTexGenf (GLenum coord, GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glTexGenf])(coord, pname, param);
}

WINGDIAPI void APIENTRY glTexGenfv (GLenum coord, GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glTexGenfv])(coord, pname, params);
}

WINGDIAPI void APIENTRY glTexGeni (GLenum coord, GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glTexGeni])(coord, pname, param);
}

WINGDIAPI void APIENTRY glTexGeniv (GLenum coord, GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glTexGeniv])(coord, pname, params);
}

//
// glTexImage Section.
//

//
// When the NO_TEXTURE or NO_DATA environment variables are set, don't 
// send texture data to the graphics subsystem, simply return.
//
#if defined ( NO_TEXTURE ) || defined ( NO_DATA )
WINGDIAPI void APIENTRY glTexImage1D (GLenum target, GLint level, GLint components, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
}

WINGDIAPI void APIENTRY glTexImage2D (GLenum target, GLint level, GLint components, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
}

WINGDIAPI void APIENTRY glTexImage3D (GLenum target, GLint level, GLenum components, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
}

#else

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#if defined(WIN32) || defined(linux)

WINGDIAPI void APIENTRY glTexImage1D (GLenum target, GLint level, GLint components, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLsizei , GLint , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexImage1D])(target, level, components, width, border, format, type, pixels);
}

WINGDIAPI void APIENTRY glTexImage2D (GLenum target, GLint level, GLint components, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexImage2D])(target, level, components, width, height, border, format, type, pixels);
}

WINGDIAPI void APIENTRY glTexImage3D (GLenum target, GLint level, GLenum components, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLsizei , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexImage3D])(target, level, components, width, height, depth, border, format, type, pixels);
}
#endif
#endif

WINGDIAPI void APIENTRY glTexParameterf (GLenum target, GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glTexParameterf])(target, pname, param);
}

WINGDIAPI void APIENTRY glTexParameterfv (GLenum target, GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glTexParameterfv])(target, pname, params);
}

WINGDIAPI void APIENTRY glTexParameteri (GLenum target, GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glTexParameteri])(target, pname, param);
}

WINGDIAPI void APIENTRY glTexParameteriv (GLenum target, GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glTexParameteriv])(target, pname, params);
}

//
// glTexSubImage Section.
//

//
// When the NO_TEXTURE or NO_DATA environment variable is set, don't 
// send texture data to the graphics subsystem, simply return.
//
#if defined ( NO_TEXTURE ) || defined ( NO_DATA )
WINGDIAPI void APIENTRY glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
}

WINGDIAPI void APIENTRY glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
}

WINGDIAPI void APIENTRY glTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
}
#else

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLsizei , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexSubImage1D])(target, level, xoffset, width, format, type, pixels);
}

WINGDIAPI void APIENTRY glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLint , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexSubImage2D])(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

WINGDIAPI void APIENTRY glTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexSubImage2D])(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}
#endif
#endif

WINGDIAPI void APIENTRY glTranslated (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glTranslated])(x, y, z);
}

WINGDIAPI void APIENTRY glTranslatef (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glTranslatef])(x, y, z);
}
#endif

//
// glVertex() Section.
//

//
// When the NO_RAST environment variable is set, send all vertices
// to the graphics subsystem using a single vertex (1, 0, 0).  This
// effectively eliminates rasterization while maintaining geometric
// calculations.  In this case, vertex coordinates passed in by the
// application are ignored, and the coordinates (1, 0), (1, 0, 0)
// or (1, 0, 0, 1) are sent for each vertex depending upon then
// number of coordinates required.
//

#ifdef  NO_RAST
static GLdouble nd[] = {1.0, 0.0, 0.0, 1.0};
static GLfloat nf[] = {1.0, 0.0, 0.0, 1.0};
static GLint ni[] = {1, 0, 0, 1};
static GLshort ns[] = {1, 0, 0, 1};

WINGDIAPI void APIENTRY glVertex2d (GLdouble x, GLdouble y)
{
  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glVertex2d])(1.0, 0.0);
}
WINGDIAPI void APIENTRY glVertex2dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex2dv])(nd);
}
WINGDIAPI void APIENTRY glVertex2f (GLfloat x, GLfloat y)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glVertex2f])(1.0, 0.0);
}
WINGDIAPI void APIENTRY glVertex2fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex2fv])(nf);
}
WINGDIAPI void APIENTRY glVertex2i (GLint x, GLint y)
{
  ((void (*)(GLint , GLint ))lib->glFunc[API_glVertex2i])(1, 0);
}
WINGDIAPI void APIENTRY glVertex2iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex2iv])(ni);
}
WINGDIAPI void APIENTRY glVertex2s (GLshort x, GLshort y)
{
  ((void (*)(GLshort , GLshort ))lib->glFunc[API_glVertex2s])(1, 0);
}
WINGDIAPI void APIENTRY glVertex2sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex2sv])(ns);
}
WINGDIAPI void APIENTRY glVertex3d (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glVertex3d])(1.0, 0.0, 0.0);
}
WINGDIAPI void APIENTRY glVertex3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex3dv])(nd);
}
WINGDIAPI void APIENTRY glVertex3f (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glVertex3f])(1.0, 0.0, 0.0);
}
WINGDIAPI void APIENTRY glVertex3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex3fv])(nf);
}
WINGDIAPI void APIENTRY glVertex3i (GLint x, GLint y, GLint z)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glVertex3i])(1, 0, 0);
}
WINGDIAPI void APIENTRY glVertex3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex3iv])(ni);
}
WINGDIAPI void APIENTRY glVertex3s (GLshort x, GLshort y, GLshort z)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glVertex3s])(1, 0, 0);
}
WINGDIAPI void APIENTRY glVertex3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex3sv])(ns);
}
WINGDIAPI void APIENTRY glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glVertex4d])(1.0, 0.0, 0.0, 1.0);
}
WINGDIAPI void APIENTRY glVertex4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex4dv])(nd);
}
WINGDIAPI void APIENTRY glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glVertex4f])(1.0, 0.0, 0.0, 1.0);
}
WINGDIAPI void APIENTRY glVertex4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex4fv])(nf);
}
WINGDIAPI void APIENTRY glVertex4i (GLint x, GLint y, GLint z, GLint w)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glVertex4i])(1, 0, 0, 1);
}
WINGDIAPI void APIENTRY glVertex4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex4iv])(ni);
}
WINGDIAPI void APIENTRY glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glVertex4s])(1, 0, 0, 1);
}
WINGDIAPI void APIENTRY glVertex4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex4sv])(ns);
}

//
// Otherwise, if the NO_GEOM environment variable is set, stub functions
// pass color data to the graphics subsystem inorder to maintain the
// data flow but remove graphics processing requirements.
//
#elif defined (NO_GEOM)
static GLdouble cd[] = {1.0, 0.0, 0.0};
static GLfloat cf[] = {1.0, 0.0, 0.0};
static GLint ci[] = {1, 0, 0};
static GLshort cs[] = {1, 0, 0};

WINGDIAPI void APIENTRY glVertex2d (GLdouble x, GLdouble y)
{
  ((void (*)(GLdouble , GLdouble, GLdouble ))lib->glFunc[API_glColor3d])(1.0, 0.0, 0.0);
}

WINGDIAPI void APIENTRY glVertex2dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glColor3dv])(cd);
}

WINGDIAPI void APIENTRY glVertex2f (GLfloat x, GLfloat y)
{
  ((void (*)(GLfloat , GLfloat, GLfloat ))lib->glFunc[API_glColor3f])(1.0, 0.0, 0.0);
}

WINGDIAPI void APIENTRY glVertex2fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glColor3fv])(cf);
}

WINGDIAPI void APIENTRY glVertex2i (GLint x, GLint y)
{
  ((void (*)(GLint , GLint, GLint ))lib->glFunc[API_glColor3i])(1, 0, 0);
}

WINGDIAPI void APIENTRY glVertex2iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glColor3iv])(ci);
}

WINGDIAPI void APIENTRY glVertex2s (GLshort x, GLshort y)
{
  ((void (*)(GLshort , GLshort, GLshort ))lib->glFunc[API_glColor3s])(1, 0, 0);
}

WINGDIAPI void APIENTRY glVertex2sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glColor3sv])(cs);
}

WINGDIAPI void APIENTRY glVertex3d (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glColor3d])(1.0, 0.0, 0.0);
}

WINGDIAPI void APIENTRY glVertex3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glColor3dv])(cd);
}

WINGDIAPI void APIENTRY glVertex3f (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(1.0, 0.0, 0.0);
}

WINGDIAPI void APIENTRY glVertex3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glColor3fv])(cf);
}

WINGDIAPI void APIENTRY glVertex3i (GLint x, GLint y, GLint z)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glColor3i])(1, 0, 0);
}

WINGDIAPI void APIENTRY glVertex3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glColor3iv])(ci);
}

WINGDIAPI void APIENTRY glVertex3s (GLshort x, GLshort y, GLshort z)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glColor3s])(1, 0, 0);
}

WINGDIAPI void APIENTRY glVertex3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glColor3sv])(cs);
}

WINGDIAPI void APIENTRY glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glColor3d])(1.0, 0.0, 0.0);
}

WINGDIAPI void APIENTRY glVertex4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glColor3dv])(cd);
}

WINGDIAPI void APIENTRY glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(1.0, 0.0, 0.0);
}

WINGDIAPI void APIENTRY glVertex4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glColor3fv])(cf);
}

WINGDIAPI void APIENTRY glVertex4i (GLint x, GLint y, GLint z, GLint w)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glColor3i])(1, 0, 0);
}

WINGDIAPI void APIENTRY glVertex4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glColor3iv])(ci);
}

WINGDIAPI void APIENTRY glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glColor3s])(1, 0, 0);
}

WINGDIAPI void APIENTRY glVertex4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glColor3sv])(cs);
}

//
// Otherwise, if NO_DATA or NO_VERTEX environment variables are set, 
// functions are simply stubs which return without passing any data 
// to the graphics subsystem or performing any other useful functionality.
//
#elif defined (NO_VERTEX) || defined ( NO_DATA )

WINGDIAPI void APIENTRY glVertex2d (GLdouble x, GLdouble y)
{
}

WINGDIAPI void APIENTRY glVertex2dv (const GLdouble *v)
{
}

WINGDIAPI void APIENTRY glVertex2f (GLfloat x, GLfloat y)
{
}

WINGDIAPI void APIENTRY glVertex2fv (const GLfloat *v)
{
}

WINGDIAPI void APIENTRY glVertex2i (GLint x, GLint y)
{
}

WINGDIAPI void APIENTRY glVertex2iv (const GLint *v)
{
}

WINGDIAPI void APIENTRY glVertex2s (GLshort x, GLshort y)
{
}

WINGDIAPI void APIENTRY glVertex2sv (const GLshort *v)
{
}

WINGDIAPI void APIENTRY glVertex3d (GLdouble x, GLdouble y, GLdouble z)
{
}

WINGDIAPI void APIENTRY glVertex3dv (const GLdouble *v)
{
}

WINGDIAPI void APIENTRY glVertex3f (GLfloat x, GLfloat y, GLfloat z)
{
}

WINGDIAPI void APIENTRY glVertex3fv (const GLfloat *v)
{
}

WINGDIAPI void APIENTRY glVertex3i (GLint x, GLint y, GLint z)
{
}

WINGDIAPI void APIENTRY glVertex3iv (const GLint *v)
{
}

WINGDIAPI void APIENTRY glVertex3s (GLshort x, GLshort y, GLshort z)
{
}

WINGDIAPI void APIENTRY glVertex3sv (const GLshort *v)
{
}

WINGDIAPI void APIENTRY glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
}

WINGDIAPI void APIENTRY glVertex4dv (const GLdouble *v)
{
}

WINGDIAPI void APIENTRY glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
}

WINGDIAPI void APIENTRY glVertex4fv (const GLfloat *v)
{
}

WINGDIAPI void APIENTRY glVertex4i (GLint x, GLint y, GLint z, GLint w)
{
}

WINGDIAPI void APIENTRY glVertex4iv (const GLint *v)
{
}

WINGDIAPI void APIENTRY glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
}

WINGDIAPI void APIENTRY glVertex4sv (const GLshort *v)
{
}
#else

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glVertex2d (GLdouble x, GLdouble y)
{
  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glVertex2d])(x, y);
}

WINGDIAPI void APIENTRY glVertex2dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex2dv])(v);
}

WINGDIAPI void APIENTRY glVertex2f (GLfloat x, GLfloat y)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glVertex2f])(x, y);
}

WINGDIAPI void APIENTRY glVertex2fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex2fv])(v);
}

WINGDIAPI void APIENTRY glVertex2i (GLint x, GLint y)
{
  ((void (*)(GLint , GLint ))lib->glFunc[API_glVertex2i])(x, y);
}

WINGDIAPI void APIENTRY glVertex2iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex2iv])(v);
}

WINGDIAPI void APIENTRY glVertex2s (GLshort x, GLshort y)
{
  ((void (*)(GLshort , GLshort ))lib->glFunc[API_glVertex2s])(x, y);
}

WINGDIAPI void APIENTRY glVertex2sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex2sv])(v);
}

WINGDIAPI void APIENTRY glVertex3d (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glVertex3d])(x, y, z);
}

WINGDIAPI void APIENTRY glVertex3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex3dv])(v);
}

WINGDIAPI void APIENTRY glVertex3f (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glVertex3f])(x, y, z);
}

WINGDIAPI void APIENTRY glVertex3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex3fv])(v);
}

WINGDIAPI void APIENTRY glVertex3i (GLint x, GLint y, GLint z)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glVertex3i])(x, y, z);
}

WINGDIAPI void APIENTRY glVertex3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex3iv])(v);
}

WINGDIAPI void APIENTRY glVertex3s (GLshort x, GLshort y, GLshort z)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glVertex3s])(x, y, z);
}

WINGDIAPI void APIENTRY glVertex3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex3sv])(v);
}

WINGDIAPI void APIENTRY glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glVertex4d])(x, y, z, w);
}

WINGDIAPI void APIENTRY glVertex4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex4dv])(v);
}

WINGDIAPI void APIENTRY glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glVertex4f])(x, y, z, w);
}

WINGDIAPI void APIENTRY glVertex4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex4fv])(v);
}

WINGDIAPI void APIENTRY glVertex4i (GLint x, GLint y, GLint z, GLint w)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glVertex4i])(x, y, z, w);
}

WINGDIAPI void APIENTRY glVertex4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex4iv])(v);
}

WINGDIAPI void APIENTRY glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glVertex4s])(x, y, z, w);
}

WINGDIAPI void APIENTRY glVertex4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex4sv])(v);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
WINGDIAPI void APIENTRY glVertexPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLint , GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glVertexPointer])(size, type, stride, pointer);
}

WINGDIAPI void APIENTRY glViewport (GLint x, GLint y, GLsizei width, GLsizei height)
{
  ((void  (*)(GLint , GLint , GLsizei , GLsizei ))lib->glFunc[API_glViewport])(x, y, width, height);
}

WINGDIAPI const GLubyte * APIENTRY glGetString (GLenum name)
{ 
  return ((const GLubyte * (*)(GLenum))lib->glFunc[API_glGetString])(name);
}
#endif
