#include <iostream.h>
#include <fstream.h>

#include <timeit.h>

const int num = 150;

double y[num][num][num];

/* prototypes */
void setup_data();
void ijk_loop( ofstream & );
void kji_loop( ofstream & );
void ikj_loop( ofstream & );

/* initializes a big array */
void setup_data()
{
  long i,j,k;

  cout << "num = " << num << endl;
  for (i=0;i<num;i++)
    for (j=0;j<num;j++)
      for (k=0;k<num;k++)
	y[i][j][k] = i+j+k;
}

/*
 * three different traversals of the same data
*/

void ijk_loop( ofstream & oo )
{
  long i,j,k;
  double sum = 0;

  for (i=0;i<num;i++) 
    for (j=0;j<num;j++) 
      for (k=0;k<num;k++) 
	sum += y[i][j][k];
   
  oo << sum;
}

void kji_loop( ofstream & oo )
{
  long i,j,k;
  double sum = 0;

  for (k=0;k<num;k++) 
    for (j=0;j<num;j++) 
      for (i=0;i<num;i++) 
	sum += y[i][j][k];

  oo << sum;
}

void ikj_loop( ofstream & oo )
{
  long i,j,k;
  double sum = 0;

  for (i=0;i<num;i++) 
    for (k=0;k<num;k++) 
      for (j=0;j<num;j++)
	sum += y[i][j][k];

  oo << sum;
}

/*
 * create a bunch of data,
 * traverse it three ways,
 * time it, and exit.
 */

int main()
{
  /*
   * create data sink - some compilers optimize away
   * calculations that are performed but never used.
   * this ofstream is created to dump the results
   * somewhere (/dev/null) so they are 'used'.
   */
  ofstream dump;
  dump.open( "/dev/null" );

  /* setup timer */
  timeobj *tt = timeit_new();

  /* initialize data */
  setup_data();

  /* test loops */
  timeit_start( tt );
  ijk_loop( dump );
  timeit_stop( tt );
  cout << "ijk time: "
       << timeit_getf( tt, timeit_seconds ) << endl;
  timeit_start( tt );
  kji_loop( dump );
  timeit_stop( tt );
  cout << "kji time: "
       << timeit_getf( tt, timeit_seconds ) << endl;
  timeit_start( tt );
  ikj_loop( dump );
  timeit_stop( tt );
  cout << "ikj time: "
       << timeit_getf( tt, timeit_seconds ) << endl;

  /* cleanup timer, data sink */
  dump.close();
  delete tt;
  
  return( 0 );
}
