#include <iostream.h>

typedef struct wordtest
{
  char aa;  /* fills 1 byte, pads to end of word */
  float bb; /* fills 1-word on 32bit platforms, and is word-aligned */
} wordtest;

/*
 * only struct foo will be discussed, as wordsize is different on
 * different platforms.
 *
 * foo, below, contains alternating char and float variables.
 * on a 32-bit (4byte) wordsize platform, each single char
 * (one byte) can fall anywhere within a word. that is,
 * if two char fall in succession within a word, then
 * the total size for those two chars will still be a single
 * word. however a float occupies an entire word (4-bytes)
 * and must begin on a word boundary. so, in our example
 * below, the 5 data elements, 3 chars, 2 floats, require
 * 20 total bytes, or 5 words total.
 *
 * if we then look at foo_packed, in which all the types
 * are sorted so that like-types are together, we now have
 * this same data structure occupying only 3 words, or
 * 12 bytes total. quite obviously, this is more efficient
 * in terms of total space, as well as being able to
 * fit more in a single page of cache.
 */

/* ------------------ c data ------------------ */

typedef struct foo
{
  char   aa; /* fills 1 byte,  pads to end of word */
  float  bb; /* fills 4 bytes */
  char   cc; /* fills 1 byte,  pads to end of word */
  float  dd; /* fills 4 bytes */
  char   ee; /* fills 1 byte,  pads to end of word */
} foo;

typedef struct foo_packed
{
  char   aa; /* fills 1 byte  */
  char   cc; /* fills 1 byte  */
  char   ee; /* fills 1 byte  */
  float  bb; /* fills 4 bytes */
  float  dd; /* fills 4 bytes */
} foo_packed;

typedef struct bar
{
  char   aa; /* fills 1 byte  */
  double bb; /* fills 8 bytes */
  char   cc; /* fills 1 byte  */
  double dd; /* fills 8 bytes */
  char   ee; /* fills 1 byte  */
} bar;

typedef struct bar_packed
{
  char   aa; /* fills 1 byte */
  char   cc; /* fills 1 byte */
  char   ee; /* fills 1 byte, pads 5 */
  double bb; /* fills 8 bytes */
  double dd; /* fills 8 bytes */
} bar_packed;

typedef struct gak
{
  char   aa; /* fills 1 byte */
  short  bb; /* fills 2 bytes */
  char   cc; /* fills 1 byte */
  short  dd; /* fills 2 bytes */
  char   ee; /* fills 1 byte */
} gak;

typedef struct gak_packed
{
  char   aa; /* fills 1 byte  */
  char   cc; /* fills 1 byte  */
  char   ee; /* fills 1 byte  */
  short  bb; /* fills 2 bytes */
  short  dd; /* fills 2 bytes */
} gak_packed;

typedef struct feh
{
  char   aa; /* fills 1 byte   */
  bar    bb; /* fills 32 bytes */
  char   cc; /* fills 1 byte   */
  bar    dd; /* fills 32 bytes */
  char   ee; /* fills 1 byte   */
} feh;

typedef struct feh_packed
{
  char   aa; /* fills 1 byte  */
  char   cc; /* fills 1 byte  */
  char   ee; /* fills 1 byte  */
  bar    bb; /* fills 2 bytes */
  bar    dd; /* fills 2 bytes */
} feh_packed;

/* ------------------ c++ data ------------------ */

class boog
{
 public:
  char aa;
  float bb;
  char cc;
  float dd;
  char ee;
};

class boog_packed
{
 public:
  char aa;
  char cc;
  char ee;
  float bb;
  float dd;
};

class foog
{
 public:
  char   aa; /* fills 1 byte */
  bar    bb; /* fills 2 bytes */
  char   cc; /* fills 1 byte */
  bar    dd; /* fills 2 bytes */
  char   ee; /* fills 1 byte, pads 5 */
};

class foog_packed
{
 public: 
  char   aa; /* fills 1 byte */
  char   cc; /* fills 1 byte */
  char   ee; /* fills 1 byte */
  bar    bb; /* fills 2 bytes */
  bar    dd; /* fills 2 bytes */
};

int main( void )
{
  cout << "wordsize: " << sizeof( wordtest )/2 << " bytes"
    << endl << endl;

  cout << " --- c data packing --- " << endl << endl;

  cout << "largest element in gak is a short,  size: "
    << sizeof( short ) << endl;
  cout << "sizeof gak        : " << sizeof( gak ) << endl;
  cout << "sizeof gak_packed : " << sizeof( gak_packed ) << endl;
  cout << endl;

  cout << "largest element in foo is a float,  size: "
    << sizeof( float ) << endl;
  cout << "sizeof foo        : " << sizeof( foo ) << endl;
  cout << "sizeof foo_packed : " << sizeof( foo_packed ) << endl;
  cout << endl;

  cout << "largest element in bar is a double, size: "
    << sizeof( double ) << endl;
  cout << "sizeof bar        : " << sizeof( bar ) << endl;
  cout << "sizeof bar_packed : " << sizeof( bar_packed ) << endl;
  cout << endl;

  cout << "largest element in feh is a bar,    size: "
    << sizeof( bar ) << endl;
  cout << "sizeof feh        : " << sizeof( feh ) << endl;
  cout << "sizeof feh_packed : " << sizeof( feh_packed ) << endl;
  cout << endl;

  cout << " --- c++ data packing --- " << endl << endl;

  cout << "largest element in boog is a float, size: "
    << sizeof( float ) << endl;
  cout << "sizeof boog        : " << sizeof( boog ) << endl;
  cout << "sizeof boog_packed : " << sizeof( boog_packed ) << endl;
  cout << endl;

  cout << "largest element in foog is a bar,   size: "
    << sizeof( bar ) << endl;
  cout << "sizeof foog        : " << sizeof( feh ) << endl;
  cout << "sizeof foog_packed : " << sizeof( feh_packed ) << endl;
  cout << endl;
}



