#include <iostream.h>
#include <stdlib.h>

#include <GL/glut.h>

#include "scenegraph.h"
#include "timeit.h"

void doRender( calSceneMgr *);
void doKeyboard( calSceneMgr *, unsigned char, int, int );

main( int argc, char **argv )
{
  int  numNodes = 50000;

  if ( argc > 1 ) numNodes = atoi( argv[1] );

  // create new scene graph 
  calSceneMgr *scene      = new calSceneMgr();
  scene->initGfx( 500, 500, "State" );

  calSceneMgr::set( scene );
  scene->build( numNodes );

  scene->keyboard( doKeyboard );
  scene->mainLoop( doRender );
}

void doKeyboard( calSceneMgr *, unsigned char key, int, int )
{
  switch ( key ) {
    case 27:
    case 'q':
      exit( 0 );

    case 'r':
      glutPostRedisplay();
      break;
  }
}

void doRender( calSceneMgr *scene )
{
  calStateMgr *plainState = new plainStateMgr();
  calStateMgr *smartState = new smartStateMgr();
  scene->stateMgr() = plainState;

  timeobj *timer = timeit_new();

  cout << "Rendering normal scene: ";
  timeit_start( timer );
  scene->render();
  timeit_stop( timer );
  cout << timeit_getf( timer, timeit_seconds ) << endl;

  // change out the state manager to something mo' better and render
  cout << "Rendering smart state scene: ";
  scene->stateMgr() = smartState;
  timeit_start( timer );
  scene->render();
  timeit_stop( timer );
  cout << timeit_getf( timer, timeit_seconds ) << endl;

  // sort the scene and render with the smart state mgr
  cout << "Rendering sorted smart state scene: ";
  calSceneMgr *sorted = new calSceneMgr( *scene );
  calSceneMgr::set( sorted );
  sorted->sort();

  sorted->stateMgr() = smartState;
  timeit_start( timer );
  sorted->render();
  timeit_stop( timer );
  cout << timeit_getf( timer, timeit_seconds ) << endl;

  // use the sorted scene, but put the plain state mgr back
  cout << "Rendering sorted plain state scene: ";
  sorted->stateMgr() = plainState;
  timeit_start( timer );
  sorted->render();
  timeit_stop( timer );
  cout << timeit_getf( timer, timeit_seconds ) << endl;

  cout << endl;

  calSceneMgr::set( scene );
  delete plainState;
  delete smartState;
}

