#include "oglstub.h"
#include "dll.h"

// No longer define these here as they are defined by the makefile.
//#define NO_RAST
//#define NO_GEOM
//#define NO_VERTEX
//#define NO_NORMAL
//#define NO_TEXTURE
//#define NO_PIXEL
//#define NO_DATA
//#define NO_PIXOPS
//#define SHORT_NORMALS
//#define NO_MATERIAL
//#define COLOR_PRIM
//#define NO_LIGHT
//#define SMALL_LINE

/*************************************************************/ 
#if defined(WIN32) || defined(linux)
void glAccum (GLenum op, GLfloat value) 
{
  ((void (*)(GLenum , GLfloat))lib->glFunc[API_glAccum])(op, value);
}

void glAlphaFunc (GLenum func, GLclampf ref) 
{
  ((void (*)(GLenum , GLclampf ))lib->glFunc[API_glAlphaFunc])(func,ref);
}

GLboolean glAreTexturesResident (GLsizei n, const GLuint *textures, GLboolean *residences) 
{
  return ((GLboolean (*)(GLsizei , const GLuint *, GLboolean *))lib->glFunc[API_glAreTexturesResident])(n, textures, residences);
}

void glArrayElement (GLint i) 
{
  ((void (*)(GLint ))lib->glFunc[API_glArrayElement])(i) ;
}
#endif

//
// glBegin() Section.
//

//
// When environment variable COLOR_PRIM is set, draw triangle strips 
// in red, triangle fans in green, independent triangles in blue, quads
// in purple and quad strips in yellow to display the decomposition of
// the scene into different primitive types. 
//
#ifdef COLOR_PRIM
void glBegin (GLenum mode) 
{
  switch (mode) {
  case GL_TRIANGLE_STRIP:
    ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(1,0,0);
    break;
  case GL_TRIANGLE_FAN:
    ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(0,1,0);
    break;
  case GL_TRIANGLES:
    ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(0,0,1);
    break;
  case GL_QUADS:
    ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(1,0,1);
    break;
  case GL_QUAD_STRIP:
    ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(1,1,0);
    break;
  }
  ((void (*)(GLenum))lib->glFunc[API_glBegin])(mode);
}

//
// Otherwise, stub is pass through to graphics system function.
//
#else
#if defined(WIN32) || defined(linux)
void glBegin (GLenum mode) 
{
  ((void (*)(GLenum))lib->glFunc[API_glBegin])(mode);
}
#endif
#endif


#if defined (WIN32) || defined(linux)
void glBindTexture (GLenum target, GLuint texture) 
{
  ((void (*)(GLenum, GLuint))lib->glFunc[API_glBindTexture])(target, texture);
}

void glBitmap (GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap) 
{
  ((void (*)(GLsizei , GLsizei , GLfloat , GLfloat , GLfloat , GLfloat , const GLubyte *))lib->glFunc[API_glBitmap])(width, height, xorig, yorig, xmove, ymove, bitmap);
}

void glBlendFunc (GLenum sfactor, GLenum dfactor) 
{
  ((void (*)(GLenum , GLenum ))lib->glFunc[API_glBlendFunc])(sfactor, dfactor);
}

void glCallList (GLuint list) 
{
  ((void (*)(GLuint ))lib->glFunc[API_glCallList])(list);
}

void glCallLists (GLsizei n, GLenum type, const GLvoid *lists) 
{
  ((void (*)(GLsizei , GLenum , const GLvoid *))lib->glFunc[API_glCallLists])(n, type, lists);
}
#endif

//
// glClear() Section.
//

//
// When COLOR_PRIM environment variable is set, enable GL_COLOR_MATERIAL
// OpenGL state variables before calling glClear graphics system function.
//
#if defined (COLOR_PRIM)
void glClear (GLbitfield mask)
{
  ((void (*)(GLenum ))lib->glFunc[API_glEnable])(GL_COLOR_MATERIAL);
  ((void (*)(GLbitfield ))lib->glFunc[API_glClear])(mask);
}
#else

//
// Otherwise, stub is pass through to graphics system function.
//
#if defined(WIN32) || defined(linux)
void glClear (GLbitfield mask)
{
  ((void (*)(GLbitfield ))lib->glFunc[API_glClear])(mask);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
void glClearAccum (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
	((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glClearAccum])(red, green, blue, alpha);
}
void glClearColor (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
	((void (*)(GLclampf , GLclampf , GLclampf , GLclampf ))lib->glFunc[API_glClearColor])(red, green, blue, alpha);
}
void glClearDepth (GLclampd depth)
{
	((void (*)(GLclampd ))lib->glFunc[API_glClearDepth])(depth);
}
void glClearIndex (GLfloat c)
{
	((void (*)(GLfloat))lib->glFunc[API_glClearIndex])(c);
}
void glClearStencil (GLint s)
{
	((void (*)(GLint))lib->glFunc[API_glClearStencil])(s);
}
void glClipPlane (GLenum plane, const GLdouble *equation)
{
	((void (*)(GLenum , const GLdouble *))lib->glFunc[API_glClipPlane])(plane, equation);
}
#endif

//
// glColor() Section.
//

//
// When COLOR_PRIM environment variable is defined, triangle strips
// are drawn in red, triangle fans in blue and independent triangles
// in green inorder to display the decomposition of the scene into
// the different primitive types.  So, when COLOR_PRIM is set, 
// don't pass down color values to the graphics subsystem, simply
// return.
//
#if defined (COLOR_PRIM)
void glColor3b (GLbyte red, GLbyte green, GLbyte blue)
{
}

void glColor3bv (const GLbyte *v)
{
}

void glColor3d (GLdouble red, GLdouble green, GLdouble blue)
{
}

void glColor3dv (const GLdouble *v)
{
}

void glColor3f (GLfloat red, GLfloat green, GLfloat blue)
{
}

void glColor3fv (const GLfloat *v)
{
}

void glColor3i (GLint red, GLint green, GLint blue)
{
}

void glColor3iv (const GLint *v)
{
}

void glColor3s (GLshort red, GLshort green, GLshort blue)
{
}

void glColor3sv (const GLshort *v)
{
}

void glColor3ub (GLubyte red, GLubyte green, GLubyte blue)
{
}

void glColor3ubv (const GLubyte *v)
{
}

void glColor3ui (GLuint red, GLuint green, GLuint blue)
{
}

void glColor3uiv (const GLuint *v)
{
}

void glColor3us (GLushort red, GLushort green, GLushort blue)
{
}

void glColor3usv (const GLushort *v)
{
}

void glColor4b (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha)
{
}

void glColor4bv (const GLbyte *v)
{
}

void glColor4d (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)
{
}

void glColor4dv (const GLdouble *v)
{
}

void glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
}

void glColor4fv (const GLfloat *v)
{
}

void glColor4i (GLint red, GLint green, GLint blue, GLint alpha)
{
}

void glColor4iv (const GLint *v)
{
}

void glColor4s (GLshort red, GLshort green, GLshort blue, GLshort alpha)
{
}

void glColor4sv (const GLshort *v)
{
}

void glColor4ub (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
}

void glColor4ubv (const GLubyte *v)
{
}

void glColor4ui (GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
}

void glColor4uiv (const GLuint *v)
{
}

void glColor4us (GLushort red, GLushort green, GLushort blue, GLushort alpha)
{
}

void glColor4usv (const GLushort *v)
{
}
#else
#if defined(WIN32) || defined(linux)
void glColor3b (GLbyte red, GLbyte green, GLbyte blue)
{
  ((void (*)(GLbyte , GLbyte , GLbyte))lib->glFunc[API_glColor3b])(red, green, blue);
}
void glColor3bv (const GLbyte *v)
{
  ((void (*)(const GLbyte *))lib->glFunc[API_glColor3bv])(v);
}
void glColor3d (GLdouble red, GLdouble green, GLdouble blue)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glColor3d])(red, green, blue);
}
void glColor3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glColor3dv])(v);
}
void glColor3f (GLfloat red, GLfloat green, GLfloat blue)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(red, green, blue);
}
void glColor3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glColor3fv])(v);
}
void glColor3i (GLint red, GLint green, GLint blue)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glColor3i])(red, green, blue);
}
void glColor3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glColor3iv])(v);
}
void glColor3s (GLshort red, GLshort green, GLshort blue)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glColor3s])(red, green, blue);
}
void glColor3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glColor3sv])(v);
}
void glColor3ub (GLubyte red, GLubyte green, GLubyte blue)
{
  ((void (*)(GLubyte , GLubyte , GLubyte ))lib->glFunc[API_glColor3ub])(red, green, blue);
}
void glColor3ubv (const GLubyte *v)
{
  ((void (*)(const GLubyte *))lib->glFunc[API_glColor3ubv])(v);
}
void glColor3ui (GLuint red, GLuint green, GLuint blue)
{
  ((void (*)(GLuint , GLuint , GLuint ))lib->glFunc[API_glColor3ui])(red, green, blue);
}
void glColor3uiv (const GLuint *v)
{
  ((void (*)(const GLuint *))lib->glFunc[API_glColor3uiv])(v);
}
void glColor3us (GLushort red, GLushort green, GLushort blue)
{
  ((void (*)(GLushort , GLushort , GLushort ))lib->glFunc[API_glColor3us])(red, green, blue);
}
void glColor3usv (const GLushort *v)
{
  ((void (*)(const GLushort *))lib->glFunc[API_glColor3usv])(v);
}
void glColor4b (GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha)
{
  ((void (*)(GLbyte , GLbyte , GLbyte , GLbyte ))lib->glFunc[API_glColor4b])(red, green, blue, alpha);
}
void glColor4bv (const GLbyte *v)
{
  ((void (*)(const GLbyte *))lib->glFunc[API_glColor4bv])(v);
}
void glColor4d (GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glColor4d])(red, green, blue, alpha);
}
void glColor4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glColor4dv])(v);
}
void glColor4f (GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor4f])(red, green, blue, alpha);
}
void glColor4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glColor4fv])(v);
}
void glColor4i (GLint red, GLint green, GLint blue, GLint alpha)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glColor4i])(red, green, blue, alpha);
}
void glColor4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glColor4iv])(v);
}
void glColor4s (GLshort red, GLshort green, GLshort blue, GLshort alpha)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glColor4s])(red, green, blue, alpha);
}
void glColor4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glColor4sv])(v);
}
void glColor4ub (GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
  ((void (*)(GLubyte , GLubyte , GLubyte , GLubyte ))lib->glFunc[API_glColor4ub])(red, green, blue, alpha);
}
void glColor4ubv (const GLubyte *v)
{
  ((void (*)(const GLubyte *))lib->glFunc[API_glColor4ubv])(v);
}
void glColor4ui (GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
  ((void (*)(GLuint , GLuint , GLuint , GLuint ))lib->glFunc[API_glColor4ui])(red, green, blue, alpha);
}
void glColor4uiv (const GLuint *v)
{
  ((void (*)(const GLuint *))lib->glFunc[API_glColor4uiv])(v);
}
void glColor4us (GLushort red, GLushort green, GLushort blue, GLushort alpha)
{
  ((void (*)(GLushort , GLushort , GLushort , GLushort ))lib->glFunc[API_glColor4us])(red, green, blue, alpha);
}
void glColor4usv (const GLushort *v)
{
  ((void (*)(const GLushort *))lib->glFunc[API_glColor4usv])(v);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
void glColorMask (GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
  ((void (*)(GLboolean , GLboolean , GLboolean , GLboolean ))lib->glFunc[API_glColorMask])(red, green, blue, alpha);
}

void glColorMaterial (GLenum face, GLenum mode)
{
  ((void (*)(GLenum , GLenum ))lib->glFunc[API_glColorMaterial])(face, mode);
}

void glColorPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLint , GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glColorPointer])(size, type, stride, pointer);
}

//
// glCopyPixels() Section.
//

//
// When NO_PIXEL or NO_DATA environment variables are defined, no pixel 
// data is sent to the graphics subsystem.  As a result, glCopyPixels is
// stubbed out and simply returns.
//
#if defined (NO_PIXEL) || defined (NO_DATA)
void glCopyPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
}

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
void glCopyPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
  ((void (*)(GLint , GLint , GLsizei , GLsizei , GLenum ))lib->glFunc[API_glCopyPixels])(x, y, width, height, type);
}
#endif
#endif

void glCopyTexImage1D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
  ((void (*)(GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLint ))lib->glFunc[API_glCopyTexImage1D])(target, level, internalformat, x, y, width, border);
}

void glCopyTexImage2D (GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
  ((void (*)(GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLsizei , GLint ))lib->glFunc[API_glCopyTexImage2D])(target, level, internalformat, x, y, width, height, border);
}

void glCopyTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
  ((void (*)(GLenum , GLint , GLint , GLint , GLint , GLsizei ))lib->glFunc[API_glCopyTexSubImage1D])(target, level, xoffset, x, y, width);
}

void glCopyTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
  ((void (*)(GLenum , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei ))lib->glFunc[API_glCopyTexSubImage2D])(target, level, xoffset, yoffset, x, y, width, height);
}

void glCullFace (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glCullFace])(mode);
}

void glDeleteLists (GLuint list, GLsizei range)
{
  ((void (*)(GLuint , GLsizei ))lib->glFunc[API_glDeleteLists])(list, range);
}

void glDeleteTextures (GLsizei n, const GLuint *textures)
{
  ((void (*)(GLsizei , const GLuint *))lib->glFunc[API_glDeleteTextures])(n, textures);
}

void glDepthFunc (GLenum func)
{
  ((void (*)(GLenum ))lib->glFunc[API_glDepthFunc])(func);
}

void glDepthMask (GLboolean flag)
{
  ((void (*)(GLboolean ))lib->glFunc[API_glDepthMask])(flag);
}

void glDepthRange (GLclampd zNear, GLclampd zFar)
{
  ((void (*)(GLclampd , GLclampd ))lib->glFunc[API_glDepthRange])(zNear, zFar);
}
#endif

//
// glDisable() Section.
//

//
// When COLOR_PRIM environment variable is set, triangle strips are
// drawn in red, triangle fans in blue and independent triangles in
// green to display the decomposition of the scene in the different
// primitive types.  If COLOR_PRIM is set, don't disable the OpenGL
// GL_COLOR_MATERIAL state.
//
#if defined (COLOR_PRIM)
void glDisable (GLenum cap)
{
  if (cap != GL_COLOR_MATERIAL)
    ((void (*)(GLenum ))lib->glFunc[API_glDisable])(cap);
}

//
// Otherwise, stub is pass through to graphics system function.
//
#else
#if defined(WIN32) || defined(linux)
void glDisable (GLenum cap)
{
  ((void (*)(GLenum ))lib->glFunc[API_glDisable])(cap);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
void glDisableClientState (GLenum array)
{
  ((void (*)(GLenum ))lib->glFunc[API_glDisableClientState])(array);
}

void glDrawArrays (GLenum mode, GLint first, GLsizei count)
{
  ((void (*)(GLenum , GLint , GLsizei ))lib->glFunc[API_glDrawArrays])(mode, first, count);
}

void glDrawBuffer (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glDrawBuffer])(mode);
}

void glDrawElements (GLenum mode, GLsizei count, GLenum type, const GLvoid *indices)
{
  ((void (*)(GLenum , GLsizei , GLenum , const GLvoid *))lib->glFunc[API_glDrawElements])(mode, count, type, indices);
}


//
// glDrawPixels() Section.
//

//
// When NO_PIXEL or NO_DATA environment variables are defined, no pixel 
// data is sent to the graphics subsystem.  As a result, glDrawPixels is
// stubbed out and simply returns.
//
#if defined (NO_PIXEL) || defined (NO_DATA)
void glDrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
}

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
void glDrawPixels (GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLsizei , GLsizei , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glDrawPixels])(width, height, format, type, pixels);
}
#endif
#endif

void glEdgeFlag (GLboolean flag)
{
  ((void (*)(GLboolean ))lib->glFunc[API_glEdgeFlag])(flag);
}
void glEdgeFlagPointer (GLsizei stride, const GLboolean *pointer)
{
  ((void (*)(GLsizei , const GLboolean *))lib->glFunc[API_glEdgeFlagPointer])(stride, pointer);
}

void glEdgeFlagv (const GLboolean *flag)
{
  ((void (*)(const GLboolean *))lib->glFunc[API_glEdgeFlagv])(flag);
}
#endif

//
// glEnable() Section.
//

//
// If the NO_LIGHT environment variable is set, don't enable lighting.
// Effectively ignore calls to glEnable which enable lighting.
//
#if defined ( NO_LIGHT )
void glEnable (GLenum cap)
{
  if (cap != GL_LIGHTING)
    ((void (*)(GLenum ))lib->glFunc[API_glEnable])(cap);
}


//
// If the NO_PIXELOPS environment variable is set, don't enable 
// per-pixel operations.  Do this by ignoring all calls to 
// glEnable which enable per-pixel operations.
#elif defined (NO_PIXOPS )

void glEnable (GLenum cap)
{
  if ((cap != GL_ALPHA_TEST) || (cap != GL_BLEND) ||
      (cap != GL_COLOR_LOGIC_OP) || (cap != GL_DEPTH_TEST) ||
      (cap != GL_DITHER) || (cap != GL_FOG) ||
      (cap != GL_INDEX_LOGIC_OP) || (cap != GL_LINE_SMOOTH) || 
      (cap != GL_LINE_STIPPLE) || (cap != GL_POLYGON_SMOOTH) ||
      (cap != GL_POINT_SMOOTH) || (cap != GL_POLYGON_STIPPLE) || 
      (cap != GL_SCISSOR_TEST) || (cap != GL_STENCIL_TEST))
    ((void (*)(GLenum ))lib->glFunc[API_glEnable])(cap);
}

//
// Otherwise, stub is a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
void glEnable (GLenum cap)
{
  ((void (*)(GLenum ))lib->glFunc[API_glEnable])(cap);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
void glEnableClientState (GLenum array)
{
  ((void (*)(GLenum ))lib->glFunc[API_glEnableClientState])(array);
}

void glEnd (void)
{
  ((void (*)())lib->glFunc[API_glEnd])();
}

void glEndList (void)
{
  ((void (*)())lib->glFunc[API_glEndList])();
}

void glEvalCoord1d (GLdouble u)
{
  ((void (*)(GLdouble ))lib->glFunc[API_glEvalCoord1d])(u);
}

void glEvalCoord1dv (const GLdouble *u)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glEvalCoord1dv])(u);
}

void glEvalCoord1f (GLfloat u)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glEvalCoord1f])(u);
}

void glEvalCoord1fv (const GLfloat *u)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glEvalCoord1fv])(u);
}

void glEvalCoord2d (GLdouble u, GLdouble v)
{
  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glEvalCoord2d])(u, v);
}

void glEvalCoord2dv (const GLdouble *u)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glEvalCoord2dv])(u);
}

void glEvalCoord2f (GLfloat u, GLfloat v)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glEvalCoord2f])(u, v);
}

void glEvalCoord2fv (const GLfloat *u)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glEvalCoord2fv])(u);
}

void glEvalMesh1 (GLenum mode, GLint i1, GLint i2)
{
  ((void (*)(GLenum , GLint , GLint ))lib->glFunc[API_glEvalMesh1])(mode, i1, i2);
}

void glEvalMesh2 (GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)
{
  ((void (*)(GLenum , GLint , GLint , GLint , GLint ))lib->glFunc[API_glEvalMesh2])(mode, i1, i2, j1, j2);
}

void glEvalPoint1 (GLint i)
{
  ((void (*)(GLint ))lib->glFunc[API_glEvalPoint1])(i);
}

void glEvalPoint2 (GLint i, GLint j)
{
  ((void (*)(GLint , GLint ))lib->glFunc[API_glEvalPoint2])(i, j);
}

void glFeedbackBuffer (GLsizei size, GLenum type, GLfloat *buffer)
{
  ((void (*)(GLsizei , GLenum , GLfloat *))lib->glFunc[API_glFeedbackBuffer])(size, type, buffer);
}

void glFinish (void)
{
  ((void (*)())lib->glFunc[API_glFinish])();
}

void glFlush (void)
{
  ((void (*)())lib->glFunc[API_glFlush])();
}

void glFogf (GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glFogf])(pname, param);
}

void glFogfv (GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , const GLfloat *))lib->glFunc[API_glFogfv])(pname, params);
}

void glFogi (GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLint ))lib->glFunc[API_glFogi])(pname, param);
}

void glFogiv (GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , const GLint *))lib->glFunc[API_glFogiv])(pname, params);
}

void glFrontFace (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glFrontFace])(mode);
}

void glFrustum (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glFrustum])(left, right, bottom, top, zNear, zFar);
}

GLuint glGenLists (GLsizei range)
{
  return ((GLuint (*)(GLsizei))lib->glFunc[API_glGenLists])(range);
}

void glGenTextures (GLsizei n, GLuint *textures)
{
  ((void (*)(GLsizei , GLuint *))lib->glFunc[API_glGenTextures])(n, textures);
}

void glGetBooleanv (GLenum pname, GLboolean *params)
{
  ((void (*)(GLenum , GLboolean *))lib->glFunc[API_glGetBooleanv])(pname, params);
}

void glGetClipPlane (GLenum plane, GLdouble *equation)
{
  ((void (*)(GLenum , GLdouble *))lib->glFunc[API_glGetClipPlane])(plane, equation);
}

void glGetDoublev (GLenum pname, GLdouble *params)
{
  ((void (*)(GLenum , GLdouble *))lib->glFunc[API_glGetDoublev])(pname, params);
}

GLenum glGetError (void)
{ 
  return ((GLenum (*)())lib->glFunc[API_glGetError])();
}

void glGetFloatv (GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLfloat *))lib->glFunc[API_glGetFloatv])(pname, params);
}

void glGetIntegerv (GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLint *))lib->glFunc[API_glGetIntegerv])(pname, params);
}

void glGetLightfv (GLenum light, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetLightfv])(light, pname, params);
}

void glGetLightiv (GLenum light, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetLightiv])(light, pname, params);
}

void glGetMapdv (GLenum target, GLenum query, GLdouble *v)
{
  ((void (*)(GLenum , GLenum , GLdouble *))lib->glFunc[API_glGetMapdv])(target, query, v);
}

void glGetMapfv (GLenum target, GLenum query, GLfloat *v)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetMapfv])(target, query, v);
}

void glGetMapiv (GLenum target, GLenum query, GLint *v)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetMapiv])(target, query, v);
}

void glGetMaterialfv (GLenum face, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetMaterialfv])(face, pname, params);
}

void glGetMaterialiv (GLenum face, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetMaterialiv])(face, pname, params);
}

void glGetPixelMapfv (GLenum map, GLfloat *values)
{
  ((void (*)(GLenum , GLfloat *))lib->glFunc[API_glGetPixelMapfv])(map, values);
}

void glGetPixelMapuiv (GLenum map, GLuint *values)
{
  ((void (*)(GLenum , GLuint *))lib->glFunc[API_glGetPixelMapuiv])(map, values);
}

void glGetPixelMapusv (GLenum map, GLushort *values)
{
  ((void (*)(GLenum , GLushort *))lib->glFunc[API_glGetPixelMapusv])(map, values);
}

void glGetPointerv (GLenum pname, GLvoid* *params)
{
  ((void (*)(GLenum , GLvoid* *))lib->glFunc[API_glGetPointerv])(pname, params);
}

void glGetPolygonStipple (GLubyte *mask)
{
  ((void (*)(GLubyte *))lib->glFunc[API_glGetPolygonStipple])(mask);
}

void glGetTexEnvfv (GLenum target, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetTexEnvfv])(target, pname, params);
}

void glGetTexEnviv (GLenum target, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetTexEnviv])(target, pname, params);
}

void glGetTexGendv (GLenum coord, GLenum pname, GLdouble *params)
{
  ((void (*)(GLenum , GLenum , GLdouble *))lib->glFunc[API_glGetTexGendv])(coord, pname, params);
}

void glGetTexGenfv (GLenum coord, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetTexGenfv])(coord, pname, params);
}

void glGetTexGeniv (GLenum coord, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetTexGeniv])(coord, pname, params);
}

void glGetTexImage (GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLenum , GLenum , GLvoid *))lib->glFunc[API_glGetTexImage])(target, level, format, type, pixels);
}

void glGetTexLevelParameterfv (GLenum target, GLint level, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLint , GLenum , GLfloat *))lib->glFunc[API_glGetTexLevelParameterfv])(target, level, pname, params);
}

void glGetTexLevelParameteriv (GLenum target, GLint level, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLint , GLenum , GLint *))lib->glFunc[API_glGetTexLevelParameteriv])(target, level, pname, params);
}

void glGetTexParameterfv (GLenum target, GLenum pname, GLfloat *params)
{
  ((void (*)(GLenum , GLenum , GLfloat *))lib->glFunc[API_glGetTexParameterfv])(target, pname, params);
}

void glGetTexParameteriv (GLenum target, GLenum pname, GLint *params)
{
  ((void (*)(GLenum , GLenum , GLint *))lib->glFunc[API_glGetTexParameteriv])(target, pname, params);
}

void glHint (GLenum target, GLenum mode)
{
  ((void (*)(GLenum , GLenum ))lib->glFunc[API_glHint])(target, mode);
}

void glIndexMask (GLuint mask)
{
  ((void (*)(GLuint ))lib->glFunc[API_glIndexMask])(mask);
}

void glIndexPointer (GLenum type, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glIndexPointer])(type, stride, pointer);
}

void glIndexd (GLdouble c)
{
  ((void (*)(GLdouble ))lib->glFunc[API_glIndexd])(c);
}

void glIndexdv (const GLdouble *c)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glIndexdv])(c);
}

void glIndexf (GLfloat c)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glIndexf])(c);
}

void glIndexfv (const GLfloat *c)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glIndexfv])(c);
}

void glIndexi (GLint c)
{
  ((void (*)(GLint ))lib->glFunc[API_glIndexi])(c);
}

void glIndexiv (const GLint *c)
{
  ((void (*)(const GLint *))lib->glFunc[API_glIndexiv])(c);
}

void glIndexs (GLshort c)
{
  ((void (*)(GLshort ))lib->glFunc[API_glIndexs])(c);
}

void glIndexsv (const GLshort *c)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glIndexsv])(c);
}

void glIndexub (GLubyte c)
{
  ((void (*)(GLubyte ))lib->glFunc[API_glIndexub])(c);
}

void glIndexubv (const GLubyte *c)
{
  ((void (*)(const GLubyte *))lib->glFunc[API_glIndexubv])(c);
}

void glInitNames (void)
{
  ((void (*)())lib->glFunc[API_glInitNames])();
}

void glInterleavedArrays (GLenum format, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glInterleavedArrays])(format, stride, pointer);

}

GLboolean glIsEnabled (GLenum cap) 
{ 
  return ((GLboolean (*)(GLenum ))lib->glFunc[API_glIsEnabled])(cap);
}

GLboolean glIsList (GLuint list) 
{ 
  return ((GLboolean (*)(GLuint ))lib->glFunc[API_glIsList])(list);
}

GLboolean glIsTexture (GLuint texture) 
{ 
  return ((GLboolean (*)(GLuint ))lib->glFunc[API_glIsTexture])(texture);
}

void glLightModelf (GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glLightModelf])(pname, param);
}

void glLightModelfv (GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum, const GLfloat *))lib->glFunc[API_glLightModelfv])(pname, params);
}

void glLightModeli (GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLint ))lib->glFunc[API_glLightModeli])(pname, param);
}

void glLightModeliv (GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , const GLint *))lib->glFunc[API_glLightModeliv])(pname, params);
}

void glLightf (GLenum light, GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glLightf])(light, pname, param);
}

void glLightfv (GLenum light, GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glLightfv])(light, pname, params);
}

void glLighti (GLenum light, GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glLighti])(light, pname, param);
}

void glLightiv (GLenum light, GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glLightiv])(light, pname, params);
}

void glLineStipple (GLint factor, GLushort pattern)
{
  ((void (*)(GLint , GLushort ))lib->glFunc[API_glLineStipple])(factor, pattern);
}
#endif

//
// glLineWidth() Section.
//

//
//
//
#ifdef SMALL_LINE
void glLineWidth (GLfloat width)
{
}
#else
#if defined(WIN32) || defined(linux)
void glLineWidth (GLfloat width)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glLineWidth])(width);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
void glListBase (GLuint base)
{
  ((void (*)(GLuint ))lib->glFunc[API_glListBase])(base);
}

void glLoadIdentity (void)
{
  ((void (*)())lib->glFunc[API_glLoadIdentity])();
}

void glLoadMatrixd (const GLdouble *m)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glLoadMatrixd])(m);
}

void glLoadMatrixf (const GLfloat *m)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glLoadMatrixf])(m);
}

void glLoadName (GLuint name)
{
  ((void (*)(GLuint ))lib->glFunc[API_glLoadName])(name);
}

void glLogicOp (GLenum opcode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glLogicOp])(opcode);
}

void glMap1d (GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)
{
  ((void (*)(GLenum , GLdouble , GLdouble , GLint , GLint , const GLdouble *))lib->glFunc[API_glMap1d])(target, u1, u2, stride, order, points);
}

void glMap1f (GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)
{
  ((void (*)(GLenum , GLfloat , GLfloat , GLint , GLint , const GLfloat *))lib->glFunc[API_glMap1f])(target, u1, u2, stride, order, points);
}

void glMap2d (GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)
{
  ((void (*)(GLenum , GLdouble , GLdouble , GLint , GLint , GLdouble , GLdouble , GLint , GLint , const GLdouble *))lib->glFunc[API_glMap2d])(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

void glMap2f (GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)
{
  ((void (*)(GLenum , GLfloat , GLfloat , GLint , GLint , GLfloat , GLfloat , GLint , GLint , const GLfloat *))lib->glFunc[API_glMap2f])(target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points);
}

void glMapGrid1d (GLint un, GLdouble u1, GLdouble u2)
{
  ((void (*)(GLint , GLdouble , GLdouble ))lib->glFunc[API_glMapGrid1d])(un, u1, u2);
}

void glMapGrid1f (GLint un, GLfloat u1, GLfloat u2)
{
  ((void (*)(GLint , GLfloat , GLfloat ))lib->glFunc[API_glMapGrid1f])(un, u1, u2);
}
void glMapGrid2d (GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)
{
  ((void (*)(GLint , GLdouble , GLdouble , GLint , GLdouble , GLdouble ))lib->glFunc[API_glMapGrid2d])(un, u1, u2, vn, v1, v2);
}

void glMapGrid2f (GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)
{
  ((void (*)(GLint , GLfloat , GLfloat , GLint , GLfloat , GLfloat ))lib->glFunc[API_glMapGrid2f])(un, u1, u2, vn, v1, v2);
}
#endif

//
// glMaterial() Section.
//

//
// In the case that the NO_MATERIAL environment variable is set, stub
// out all glMaterial calls so that they simply return and don't provide
// any functionality.
//
#if defined (NO_MATERIAL)
void glMaterialf (GLenum face, GLenum pname, GLfloat param)
{
}
void glMaterialfv (GLenum face, GLenum pname, const GLfloat *params)
{
}
void glMateriali (GLenum face, GLenum pname, GLint param)
{
}
void glMaterialiv (GLenum face, GLenum pname, const GLint *params)
{
}

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
void glMaterialf (GLenum face, GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glMaterialf])(face, pname, param);
}

void glMaterialfv (GLenum face, GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glMaterialfv])(face, pname, params);
}

void glMateriali (GLenum face, GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glMateriali])(face, pname, param);
}

void glMaterialiv (GLenum face, GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glMaterialiv])(face, pname, params);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
void glMatrixMode (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glMatrixMode])(mode);
}

void glMultMatrixd (const GLdouble *m)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glMultMatrixd])(m);
}

void glMultMatrixf (const GLfloat *m)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glMultMatrixf])(m);
}
void glNewList (GLuint list, GLenum mode)
{
  ((void (*)(GLuint , GLenum ))lib->glFunc[API_glNewList])(list, mode);
}
#endif

//
// glNormal() Section.
//

//
// When the SHORT_NORMALS environment variable is set, the normal vector
// (1, 0, 0) is sent as short integers to the graphics subsystem.  Normal
// vector values sent by the application are ignored.  This reduces the
// bandwidth required by the application and simulates the performance
// that could be achieved if normals within the application were converted
// to short integers.
//
#ifdef SHORT_NORMALS
static GLshort nns[] = {1, 0, 0};
void glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz)
{
  ((void (*)(GLbyte , GLbyte , GLbyte ))lib->glFunc[API_glNormal3b])(1, 0, 0);
}

void glNormal3bv (const GLbyte *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3bv])(nns);
}

void glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glNormal3s])(1, 0, 0);
}

void glNormal3dv (const GLdouble *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3sv])(nns);
}

void glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glNormal3s])(1, 0, 0);
}

void glNormal3fv (const GLfloat *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3sv])(nns);
}

void glNormal3i (GLint nx, GLint ny, GLint nz)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glNormal3s])(1, 0, 0);
}

void glNormal3iv (const GLint *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3sv])(nns);
}

void glNormal3s (GLshort nx, GLshort ny, GLshort nz)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glNormal3s])(nx, ny, nz);
}

void glNormal3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3sv])(v);
}

//
// Otherwise, if the NO_NORMAL, or NO_DATA environment variables
// are set, stub out all glNormal calls so that no normal vector
// data is sent to the graphics subsystem.
//
#elif defined (NO_NORMAL) || defined (NO_DATA)
void glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz)
{
}

void glNormal3bv (const GLbyte *v)
{
}

void glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz)
{
}

void glNormal3dv (const GLdouble *v)
{
}

void glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz)
{
}

void glNormal3fv (const GLfloat *v)
{
}

void glNormal3i (GLint nx, GLint ny, GLint nz)
{
}

void glNormal3iv (const GLint *v)
{
}

void glNormal3s (GLshort nx, GLshort ny, GLshort nz)
{
}

void glNormal3sv (const GLshort *v)
{
}

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
void glNormal3b (GLbyte nx, GLbyte ny, GLbyte nz)
{
  ((void (*)(GLbyte , GLbyte , GLbyte ))lib->glFunc[API_glNormal3b])(nx, ny, nz);
}

void glNormal3bv (const GLbyte *v)
{
  ((void (*)(const GLbyte *))lib->glFunc[API_glNormal3bv])(v);
}

void glNormal3d (GLdouble nx, GLdouble ny, GLdouble nz)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glNormal3d])(nx, ny, nz);
}

void glNormal3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glNormal3dv])(v);
}

void glNormal3f (GLfloat nx, GLfloat ny, GLfloat nz)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glNormal3f])(nx, ny, nz);
}

void glNormal3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glNormal3fv])(v);
}

void glNormal3i (GLint nx, GLint ny, GLint nz)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glNormal3i])(nx, ny, nz);
}

void glNormal3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glNormal3iv])(v);
}

void glNormal3s (GLshort nx, GLshort ny, GLshort nz)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glNormal3s])(nx, ny, nz);
}
void glNormal3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glNormal3sv])(v);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
void glNormalPointer (GLenum type, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glNormalPointer])(type, stride, pointer);
}

void glOrtho (GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glOrtho])(left, right, bottom, top, zNear, zFar);
}

void glPassThrough (GLfloat token)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glPassThrough])(token );
}

void glPixelMapfv (GLenum map, GLint mapsize, const GLfloat *values)
{
  ((void (*)(GLenum , GLint , const GLfloat *))lib->glFunc[API_glPixelMapfv])(map, mapsize, values);
}

void glPixelMapuiv (GLenum map, GLint mapsize, const GLuint *values)
{
  ((void (*)(GLenum , GLint , const GLuint *))lib->glFunc[API_glPixelMapuiv])(map, mapsize, values);
}

void glPixelMapusv (GLenum map, GLint mapsize, const GLushort *values)
{
  ((void (*)(GLenum , GLint , const GLushort *))lib->glFunc[API_glPixelMapusv])(map, mapsize, values);
}

void glPixelStoref (GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glPixelStoref])(pname, param);
}

void glPixelStorei (GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLint ))lib->glFunc[API_glPixelStorei])(pname, param);
}

void glPixelTransferf (GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLfloat ))lib->glFunc[API_glPixelTransferf])(pname, param);
}

void glPixelTransferi (GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLint ))lib->glFunc[API_glPixelTransferi])(pname, param);
}

void glPixelZoom (GLfloat xfactor, GLfloat yfactor)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glPixelZoom])(xfactor, yfactor);
}

void glPointSize (GLfloat size)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glPointSize])(size);
}

void glPolygonMode (GLenum face, GLenum mode)
{
  ((void (*)(GLenum , GLenum ))lib->glFunc[API_glPolygonMode])(face, mode);
}
#endif

#if defined(WIN32) || defined(linux)
void glPolygonOffset (GLfloat factor, GLfloat units)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glPolygonOffset])(factor, units);
}

void glPolygonStipple (const GLubyte *mask)
{
  ((void (*)(const GLubyte *))lib->glFunc[API_glPolygonStipple])(mask);
}

void glPopAttrib (void)
{
  ((void (*)())lib->glFunc[API_glPopAttrib])();
}

void glPopClientAttrib (void)
{
  ((void (*)())lib->glFunc[API_glPopClientAttrib])();
}

void glPopMatrix (void)
{
  ((void (*)())lib->glFunc[API_glPopMatrix])();
}

void glPopName (void)
{
  ((void (*)())lib->glFunc[API_glPopName])();
}

void glPrioritizeTextures (GLsizei n, const GLuint *textures, const GLclampf *priorities)
{
  ((void (*)(GLsizei , const GLuint *, const GLclampf *))lib->glFunc[API_glPrioritizeTextures])(n, textures, priorities);
}

void glPushAttrib (GLbitfield mask)
{
  ((void (*)(GLbitfield ))lib->glFunc[API_glPushAttrib])(mask);
}

void glPushClientAttrib (GLbitfield mask)
{
  ((void (*)(GLbitfield ))lib->glFunc[API_glPushClientAttrib])(mask);
}

void glPushMatrix (void)
{
  ((void (*)())lib->glFunc[API_glPushMatrix])();
}

void glPushName (GLuint name)
{
  ((void (*)(GLuint ))lib->glFunc[API_glPushName])(name);
}

void glRasterPos2d (GLdouble x, GLdouble y)
{
  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glRasterPos2d])(x, y);
}

void glRasterPos2dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glRasterPos2dv])(v);
}

void glRasterPos2f (GLfloat x, GLfloat y)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glRasterPos2f])(x, y);
}

void glRasterPos2fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glRasterPos2fv])(v);
}

void glRasterPos2i (GLint x, GLint y)
{
  ((void (*)(GLint , GLint ))lib->glFunc[API_glRasterPos2i])(x, y);
}

void glRasterPos2iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glRasterPos2iv])(v);
}

void glRasterPos2s (GLshort x, GLshort y)
{
  ((void (*)(GLshort , GLshort ))lib->glFunc[API_glRasterPos2s])(x, y);
}

void glRasterPos2sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glRasterPos2sv])(v);
}

void glRasterPos3d (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRasterPos3d])(x, y, z);
}

void glRasterPos3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glRasterPos3dv])(v);
}

void glRasterPos3f (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRasterPos3f])(x, y, z);
}

void glRasterPos3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glRasterPos3fv])(v);
}

void glRasterPos3i (GLint x, GLint y, GLint z)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glRasterPos3i])(x, y, z);
}

void glRasterPos3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glRasterPos3iv])(v);
}

void glRasterPos3s (GLshort x, GLshort y, GLshort z)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glRasterPos3s])(x, y, z);
}

void glRasterPos3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glRasterPos3sv])(v);
}

void glRasterPos4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRasterPos4d])(x, y, z, w);
}

void glRasterPos4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glRasterPos4dv])(v);
}

void glRasterPos4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRasterPos4f])(x, y, z, w);
}

void glRasterPos4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glRasterPos4fv])(v);
}

void glRasterPos4i (GLint x, GLint y, GLint z, GLint w)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glRasterPos4i])(x, y, z, w);
}

void glRasterPos4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glRasterPos4iv])(v);
}

void glRasterPos4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glRasterPos4s])(x, y, z, w);
}

void glRasterPos4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glRasterPos4sv])(v);
}

void glReadBuffer (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glReadBuffer])(mode);
}

//
// glReadPixels() Section.
//

//
// When NO_PIXEL or NO_DATA environment variables are defined, no pixel 
// data is sent to the graphics subsystem.  As a result, glReadPixels is
// stubbed out and simply returns.
//
#if defined (NO_PIXEL) || defined (NO_DATA)
void glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)
{
}

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#else
#if defined(WIN32) || defined(linux)
void glReadPixels (GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)
{
  ((void (*)(GLint , GLint , GLsizei , GLsizei , GLenum , GLenum , GLvoid *))lib->glFunc[API_glReadPixels])(x, y, width, height, format, type, pixels);
}
#endif
#endif

void glRectd (GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRectd])(x1, y1, x2, y2);
}

void glRectdv (const GLdouble *v1, const GLdouble *v2)
{
  ((void (*)(const GLdouble *, const GLdouble *))lib->glFunc[API_glRectdv])(v1, v2);
}

void glRectf (GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRectf])(x1, y1, x2, y2);
}

void glRectfv (const GLfloat *v1, const GLfloat *v2)
{
  ((void (*)(const GLfloat *, const GLfloat *))lib->glFunc[API_glRectfv])(v1, v2);
}

void glRecti (GLint x1, GLint y1, GLint x2, GLint y2)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glRecti])(x1, y1, x2, y2);
}

void glRectiv (const GLint *v1, const GLint *v2)
{
  ((void (*)(const GLint *, const GLint *))lib->glFunc[API_glRectiv])(v1, v2);
}

void glRects (GLshort x1, GLshort y1, GLshort x2, GLshort y2)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glRects])(x1, y1, x2, y2);
}

void glRectsv (const GLshort *v1, const GLshort *v2)
{
  ((void (*)(const GLshort *, const GLshort *))lib->glFunc[API_glRectsv])(v1, v2);
}

GLint glRenderMode (GLenum mode)
{ 
  return ((GLint (*)(GLenum ))lib->glFunc[API_glRenderMode])(mode);
}

void glRotated (GLdouble angle, GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glRotated])(angle, x, y, z);
}

void glRotatef (GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glRotatef])(angle, x, y, z);
}

void glScaled (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glScaled])(x, y, z);
}

void glScalef (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glScalef])(x, y, z);
}

void glScissor (GLint x, GLint y, GLsizei width, GLsizei height)
{
  ((void (*)(GLint , GLint , GLsizei , GLsizei ))lib->glFunc[API_glScissor])(x, y, width, height);
}

void glSelectBuffer (GLsizei size, GLuint *buffer)
{
  ((void (*)(GLsizei , GLuint *))lib->glFunc[API_glSelectBuffer])(size, buffer);
}

void glShadeModel (GLenum mode)
{
  ((void (*)(GLenum ))lib->glFunc[API_glShadeModel])(mode);
}

void glStencilFunc (GLenum func, GLint ref, GLuint mask)
{
  ((void (*)(GLenum , GLint , GLuint ))lib->glFunc[API_glStencilFunc])(func, ref, mask);
}

void glStencilMask (GLuint mask)
{
  ((void (*)(GLuint ))lib->glFunc[API_glStencilMask])(mask);
}

void glStencilOp (GLenum fail, GLenum zfail, GLenum zpass)
{
  ((void (*)(GLenum , GLenum , GLenum ))lib->glFunc[API_glStencilOp])(fail, zfail, zpass);
}

void glTexCoord1d (GLdouble s)
{
  ((void (*)(GLdouble ))lib->glFunc[API_glTexCoord1d])(s);
}

void glTexCoord1dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord1dv])(v);
}

void glTexCoord1f (GLfloat s)
{
  ((void (*)(GLfloat ))lib->glFunc[API_glTexCoord1f])(s);
}

void glTexCoord1fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord1fv])(v);
}

void glTexCoord1i (GLint s)
{
  ((void (*)(GLint ))lib->glFunc[API_glTexCoord1i])(s);
}

void glTexCoord1iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord1iv])(v);
}

void glTexCoord1s (GLshort s)
{
  ((void (*)(GLshort ))lib->glFunc[API_glTexCoord1s])(s);
}

void glTexCoord1sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord1sv])(v);
}

void glTexCoord2d (GLdouble s, GLdouble t)
{
  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glTexCoord2d])(s, t);
}

void glTexCoord2dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord2dv])(v);
}

void glTexCoord2f (GLfloat s, GLfloat t)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glTexCoord2f])(s, t);
}

void glTexCoord2fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord2fv])(v);
}

void glTexCoord2i (GLint s, GLint t)
{
  ((void (*)(GLint , GLint ))lib->glFunc[API_glTexCoord2i])(s, t);
}

void glTexCoord2iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord2iv])(v);
}

void glTexCoord2s (GLshort s, GLshort t)
{
  ((void (*)(GLshort , GLshort ))lib->glFunc[API_glTexCoord2s])(s, t);
}

void glTexCoord2sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord2sv])(v);
}

void glTexCoord3d (GLdouble s, GLdouble t, GLdouble r)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glTexCoord3d])(s, t, r);
}

void glTexCoord3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord3dv])(v);
}

void glTexCoord3f (GLfloat s, GLfloat t, GLfloat r)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glTexCoord3f])(s, t, r);
}

void glTexCoord3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord3fv])(v);
}

void glTexCoord3i (GLint s, GLint t, GLint r)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glTexCoord3i])(s, t, r);
}

void glTexCoord3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord3iv])(v);
}

void glTexCoord3s (GLshort s, GLshort t, GLshort r)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glTexCoord3s])(s, t, r);
}

void glTexCoord3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord3sv])(v);
}

void glTexCoord4d (GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glTexCoord4d])(s, t, r, q);
}

void glTexCoord4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glTexCoord4dv])(v);
}

void glTexCoord4f (GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glTexCoord4f])(s, t, r, q);
}

void glTexCoord4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glTexCoord4fv])(v);
}

void glTexCoord4i (GLint s, GLint t, GLint r, GLint q)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glTexCoord4i])(s, t, r, q);
}

void glTexCoord4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glTexCoord4iv])(v);
}

void glTexCoord4s (GLshort s, GLshort t, GLshort r, GLshort q)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glTexCoord4s])(s, t, r, q);
}

void glTexCoord4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glTexCoord4sv])(v);
}

void glTexCoordPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLint , GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glTexCoordPointer])(size, type, stride, pointer);
}

void glTexEnvf (GLenum target, GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glTexEnvf])(target, pname, param);
}

void glTexEnvfv (GLenum target, GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glTexEnvfv])(target, pname, params);
}

void glTexEnvi (GLenum target, GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glTexEnvi])(target, pname, param);
}

void glTexEnviv (GLenum target, GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glTexEnviv])(target, pname, params);
}

void glTexGend (GLenum coord, GLenum pname, GLdouble param)
{
  ((void (*)(GLenum , GLenum , GLdouble ))lib->glFunc[API_glTexGend])(coord, pname, param);
}

void glTexGendv (GLenum coord, GLenum pname, const GLdouble *params)
{
  ((void (*)(GLenum , GLenum , const GLdouble *))lib->glFunc[API_glTexGendv])(coord, pname, params);
}

void glTexGenf (GLenum coord, GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glTexGenf])(coord, pname, param);
}

void glTexGenfv (GLenum coord, GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glTexGenfv])(coord, pname, params);
}

void glTexGeni (GLenum coord, GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glTexGeni])(coord, pname, param);
}

void glTexGeniv (GLenum coord, GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glTexGeniv])(coord, pname, params);
}

//
// glTexImage Section.
//

//
// When the NO_TEXTURE or NO_DATA environment variables are set, don't 
// send texture data to the graphics subsystem, simply return.
//
#if defined ( NO_TEXTURE ) || defined ( NO_DATA )
void glTexImage1D (GLenum target, GLint level, GLint components, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
}

void glTexImage2D (GLenum target, GLint level, GLint components, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
}

void glTexImage3D (GLenum target, GLint level, GLenum components, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
}

#else

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#if defined(WIN32) || defined(linux)

void glTexImage1D (GLenum target, GLint level, GLint components, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLsizei , GLint , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexImage1D])(target, level, components, width, border, format, type, pixels);
}

void glTexImage2D (GLenum target, GLint level, GLint components, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexImage2D])(target, level, components, width, height, border, format, type, pixels);
}

void glTexImage3D (GLenum target, GLint level, GLenum components, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLsizei , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexImage3D])(target, level, components, width, height, depth, border, format, type, pixels);
}
#endif
#endif

void glTexParameterf (GLenum target, GLenum pname, GLfloat param)
{
  ((void (*)(GLenum , GLenum , GLfloat ))lib->glFunc[API_glTexParameterf])(target, pname, param);
}

void glTexParameterfv (GLenum target, GLenum pname, const GLfloat *params)
{
  ((void (*)(GLenum , GLenum , const GLfloat *))lib->glFunc[API_glTexParameterfv])(target, pname, params);
}

void glTexParameteri (GLenum target, GLenum pname, GLint param)
{
  ((void (*)(GLenum , GLenum , GLint ))lib->glFunc[API_glTexParameteri])(target, pname, param);
}

void glTexParameteriv (GLenum target, GLenum pname, const GLint *params)
{
  ((void (*)(GLenum , GLenum , const GLint *))lib->glFunc[API_glTexParameteriv])(target, pname, params);
}

//
// glTexSubImage Section.
//

//
// When the NO_TEXTURE or NO_DATA environment variable is set, don't 
// send texture data to the graphics subsystem, simply return.
//
#if defined ( NO_TEXTURE ) || defined ( NO_DATA )
void glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
}

void glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
}

void glTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
}
#else

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#if defined(WIN32) || defined(linux)
void glTexSubImage1D (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLsizei , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexSubImage1D])(target, level, xoffset, width, format, type, pixels);
}

void glTexSubImage2D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLint , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexSubImage2D])(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

void glTexSubImage3D (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
  ((void (*)(GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *))lib->glFunc[API_glTexSubImage2D])(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}
#endif
#endif

void glTranslated (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glTranslated])(x, y, z);
}

void glTranslatef (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glTranslatef])(x, y, z);
}
#endif

//
// glVertex() Section.
//

//
// When the NO_RAST environment variable is set, send all vertices
// to the graphics subsystem using a single vertex (1, 0, 0).  This
// effectively eliminates rasterization while maintaining geometric
// calculations.  In this case, vertex coordinates passed in by the
// application are ignored, and the coordinates (1, 0), (1, 0, 0)
// or (1, 0, 0, 1) are sent for each vertex depending upon then
// number of coordinates required.
//

#ifdef  NO_RAST
static GLdouble nd[] = {1.0, 0.0, 0.0, 1.0};
static GLfloat nf[] = {1.0, 0.0, 0.0, 1.0};
static GLint ni[] = {1, 0, 0, 1};
static GLshort ns[] = {1, 0, 0, 1};

void glVertex2d (GLdouble x, GLdouble y)
{
  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glVertex2d])(1.0, 0.0);
}
void glVertex2dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex2dv])(nd);
}
void glVertex2f (GLfloat x, GLfloat y)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glVertex2f])(1.0, 0.0);
}
void glVertex2fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex2fv])(nf);
}
void glVertex2i (GLint x, GLint y)
{
  ((void (*)(GLint , GLint ))lib->glFunc[API_glVertex2i])(1, 0);
}
void glVertex2iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex2iv])(ni);
}
void glVertex2s (GLshort x, GLshort y)
{
  ((void (*)(GLshort , GLshort ))lib->glFunc[API_glVertex2s])(1, 0);
}
void glVertex2sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex2sv])(ns);
}
void glVertex3d (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glVertex3d])(1.0, 0.0, 0.0);
}
void glVertex3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex3dv])(nd);
}
void glVertex3f (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glVertex3f])(1.0, 0.0, 0.0);
}
void glVertex3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex3fv])(nf);
}
void glVertex3i (GLint x, GLint y, GLint z)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glVertex3i])(1, 0, 0);
}
void glVertex3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex3iv])(ni);
}
void glVertex3s (GLshort x, GLshort y, GLshort z)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glVertex3s])(1, 0, 0);
}
void glVertex3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex3sv])(ns);
}
void glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glVertex4d])(1.0, 0.0, 0.0, 1.0);
}
void glVertex4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex4dv])(nd);
}
void glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glVertex4f])(1.0, 0.0, 0.0, 1.0);
}
void glVertex4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex4fv])(nf);
}
void glVertex4i (GLint x, GLint y, GLint z, GLint w)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glVertex4i])(1, 0, 0, 1);
}
void glVertex4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex4iv])(ni);
}
void glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glVertex4s])(1, 0, 0, 1);
}
void glVertex4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex4sv])(ns);
}

//
// Otherwise, if the NO_GEOM environment variable is set, stub functions
// pass color data to the graphics subsystem inorder to maintain the
// data flow but remove graphics processing requirements.
//
#elif defined (NO_GEOM)
static GLdouble cd[] = {1.0, 0.0, 0.0};
static GLfloat cf[] = {1.0, 0.0, 0.0};
static GLint ci[] = {1, 0, 0};
static GLshort cs[] = {1, 0, 0};

void glVertex2d (GLdouble x, GLdouble y)
{
  ((void (*)(GLdouble , GLdouble, GLdouble ))lib->glFunc[API_glColor3d])(1.0, 0.0, 0.0);
}

void glVertex2dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glColor3dv])(cd);
}

void glVertex2f (GLfloat x, GLfloat y)
{
  ((void (*)(GLfloat , GLfloat, GLfloat ))lib->glFunc[API_glColor3f])(1.0, 0.0, 0.0);
}

void glVertex2fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glColor3fv])(cf);
}

void glVertex2i (GLint x, GLint y)
{
  ((void (*)(GLint , GLint, GLint ))lib->glFunc[API_glColor3i])(1, 0, 0);
}

void glVertex2iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glColor3iv])(ci);
}

void glVertex2s (GLshort x, GLshort y)
{
  ((void (*)(GLshort , GLshort, GLshort ))lib->glFunc[API_glColor3s])(1, 0, 0);
}

void glVertex2sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glColor3sv])(cs);
}

void glVertex3d (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glColor3d])(1.0, 0.0, 0.0);
}

void glVertex3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glColor3dv])(cd);
}

void glVertex3f (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(1.0, 0.0, 0.0);
}

void glVertex3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glColor3fv])(cf);
}

void glVertex3i (GLint x, GLint y, GLint z)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glColor3i])(1, 0, 0);
}

void glVertex3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glColor3iv])(ci);
}

void glVertex3s (GLshort x, GLshort y, GLshort z)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glColor3s])(1, 0, 0);
}

void glVertex3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glColor3sv])(cs);
}

void glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glColor3d])(1.0, 0.0, 0.0);
}

void glVertex4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glColor3dv])(cd);
}

void glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glColor3f])(1.0, 0.0, 0.0);
}

void glVertex4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glColor3fv])(cf);
}

void glVertex4i (GLint x, GLint y, GLint z, GLint w)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glColor3i])(1, 0, 0);
}

void glVertex4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glColor3iv])(ci);
}

void glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glColor3s])(1, 0, 0);
}

void glVertex4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glColor3sv])(cs);
}

//
// Otherwise, if NO_DATA or NO_VERTEX environment variables are set, 
// functions are simply stubs which return without passing any data 
// to the graphics subsystem or performing any other useful functionality.
//
#elif defined (NO_VERTEX) || defined ( NO_DATA )

void glVertex2d (GLdouble x, GLdouble y)
{
}

void glVertex2dv (const GLdouble *v)
{
}

void glVertex2f (GLfloat x, GLfloat y)
{
}

void glVertex2fv (const GLfloat *v)
{
}

void glVertex2i (GLint x, GLint y)
{
}

void glVertex2iv (const GLint *v)
{
}

void glVertex2s (GLshort x, GLshort y)
{
}

void glVertex2sv (const GLshort *v)
{
}

void glVertex3d (GLdouble x, GLdouble y, GLdouble z)
{
}

void glVertex3dv (const GLdouble *v)
{
}

void glVertex3f (GLfloat x, GLfloat y, GLfloat z)
{
}

void glVertex3fv (const GLfloat *v)
{
}

void glVertex3i (GLint x, GLint y, GLint z)
{
}

void glVertex3iv (const GLint *v)
{
}

void glVertex3s (GLshort x, GLshort y, GLshort z)
{
}

void glVertex3sv (const GLshort *v)
{
}

void glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
}

void glVertex4dv (const GLdouble *v)
{
}

void glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
}

void glVertex4fv (const GLfloat *v)
{
}

void glVertex4i (GLint x, GLint y, GLint z, GLint w)
{
}

void glVertex4iv (const GLint *v)
{
}

void glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
}

void glVertex4sv (const GLshort *v)
{
}
#else

//
// Otherwise, stubs are a pass through to graphics system functions.
//
#if defined(WIN32) || defined(linux)
void glVertex2d (GLdouble x, GLdouble y)
{
  ((void (*)(GLdouble , GLdouble ))lib->glFunc[API_glVertex2d])(x, y);
}

void glVertex2dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex2dv])(v);
}

void glVertex2f (GLfloat x, GLfloat y)
{
  ((void (*)(GLfloat , GLfloat ))lib->glFunc[API_glVertex2f])(x, y);
}

void glVertex2fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex2fv])(v);
}

void glVertex2i (GLint x, GLint y)
{
  ((void (*)(GLint , GLint ))lib->glFunc[API_glVertex2i])(x, y);
}

void glVertex2iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex2iv])(v);
}

void glVertex2s (GLshort x, GLshort y)
{
  ((void (*)(GLshort , GLshort ))lib->glFunc[API_glVertex2s])(x, y);
}

void glVertex2sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex2sv])(v);
}

void glVertex3d (GLdouble x, GLdouble y, GLdouble z)
{
  ((void (*)(GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glVertex3d])(x, y, z);
}

void glVertex3dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex3dv])(v);
}

void glVertex3f (GLfloat x, GLfloat y, GLfloat z)
{
  ((void (*)(GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glVertex3f])(x, y, z);
}

void glVertex3fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex3fv])(v);
}

void glVertex3i (GLint x, GLint y, GLint z)
{
  ((void (*)(GLint , GLint , GLint ))lib->glFunc[API_glVertex3i])(x, y, z);
}

void glVertex3iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex3iv])(v);
}

void glVertex3s (GLshort x, GLshort y, GLshort z)
{
  ((void (*)(GLshort , GLshort , GLshort ))lib->glFunc[API_glVertex3s])(x, y, z);
}

void glVertex3sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex3sv])(v);
}

void glVertex4d (GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
  ((void (*)(GLdouble , GLdouble , GLdouble , GLdouble ))lib->glFunc[API_glVertex4d])(x, y, z, w);
}

void glVertex4dv (const GLdouble *v)
{
  ((void (*)(const GLdouble *))lib->glFunc[API_glVertex4dv])(v);
}

void glVertex4f (GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
  ((void (*)(GLfloat , GLfloat , GLfloat , GLfloat ))lib->glFunc[API_glVertex4f])(x, y, z, w);
}

void glVertex4fv (const GLfloat *v)
{
  ((void (*)(const GLfloat *))lib->glFunc[API_glVertex4fv])(v);
}

void glVertex4i (GLint x, GLint y, GLint z, GLint w)
{
  ((void (*)(GLint , GLint , GLint , GLint ))lib->glFunc[API_glVertex4i])(x, y, z, w);
}

void glVertex4iv (const GLint *v)
{
  ((void (*)(const GLint *))lib->glFunc[API_glVertex4iv])(v);
}

void glVertex4s (GLshort x, GLshort y, GLshort z, GLshort w)
{
  ((void (*)(GLshort , GLshort , GLshort , GLshort ))lib->glFunc[API_glVertex4s])(x, y, z, w);
}

void glVertex4sv (const GLshort *v)
{
  ((void (*)(const GLshort *))lib->glFunc[API_glVertex4sv])(v);
}
#endif
#endif

#if defined(WIN32) || defined(linux)
void glVertexPointer (GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
  ((void (*)(GLint , GLenum , GLsizei , const GLvoid *))lib->glFunc[API_glVertexPointer])(size, type, stride, pointer);
}

void  glViewport (GLint x, GLint y, GLsizei width, GLsizei height)
{
  ((void  (*)(GLint , GLint , GLsizei , GLsizei ))lib->glFunc[API_glViewport])(x, y, width, height);
}

const GLubyte * glGetString (GLenum name)
{ 
  return ((const GLubyte * (*)(GLenum))lib->glFunc[API_glGetString])(name);
}
#endif
