#include <iostream.h>
#include <stdlib.h>
#include <timeit.h>

int sum;
/*
 * this routine tests non-interleaved vert/norm/tcoord traversal
 */

void alloc_non_interleaved( const int arraysize, float *&verts, float *&normals, float *&tcoords )
{
  int ii;
  
  /* allocate & assign vert */
  verts = new float[ arraysize*3 ];
  for( ii=0; ii<arraysize*3; ii++ )
    {
      verts[ ii ] = (float)ii;
    }

  /* allocate & assign normal */
  normals = new float[ arraysize*3 ];
  for( ii=0; ii<arraysize*3; ii++ )
    {
      normals[ ii ] = (float)ii;
    }

  /* allocate & assign texture */
  tcoords = new float[ arraysize*2 ];
  for( ii=0; ii<arraysize*2; ii++ )
    {
      tcoords[ ii ] = (float)ii;
    }
}

float time_non_interleaved( const int arraysize, float *verts, float *normals, float *tcoords )
{
  const int niters = 1000;
  const int ncomps = 3;
  const int tcomps = 2;
  timeobj *tt = timeit_new();
  /* time some data traversal */
  timeit_start( tt );
  for ( int iters = 0; iters < niters; iters++ ) 
    {
    for( int jj=0; jj<arraysize; jj++ )
      {
	sum = verts[ jj*ncomps+0 ] + verts[ jj*ncomps+1 ] + 
	      verts[ jj*ncomps+2 ] +
	      normals[ jj*ncomps+0 ] + normals[ jj*ncomps+1 ] + 
              normals[ jj*ncomps+2 ] +
	      tcoords[ jj*tcomps+0 ] + tcoords[ jj*tcomps+1 ];
      }
    }
  timeit_stop( tt );

  float time = timeit_getf( tt, timeit_seconds );
  timeit_delete( tt );
  return( time );
}

/*
 * this routine tests interleaved vert/norm/tcoord traversal
 */

void alloc_interleaved( const int arraysize, float *&verts )
{
  int ii;
  int ncomps = 3+3+2;

  /* allocate & assign vert/norm/tcoord */
  verts = new float[ arraysize*ncomps ];

  int v = 0, n = 0, t = 0;

  for( ii=0; ii<arraysize*ncomps; ii += ncomps )
    {
      verts[ ii + 0 ] = (float)v++;
      verts[ ii + 1 ] = (float)v++;
      verts[ ii + 2 ] = (float)v++;
      verts[ ii + 3 ] = (float)n++;
      verts[ ii + 4 ] = (float)n++;
      verts[ ii + 5 ] = (float)n++;
      verts[ ii + 6 ] = (float)t++;
      verts[ ii + 7 ] = (float)t++;
    }
}

float time_interleaved( const int arraysize, float *verts )
{
  const int niters = 1000;
  const int ncomps = 3+3+2;
  timeobj *tt = timeit_new();

  /* time some data traversal */
  timeit_start( tt );
  for ( int iters = 0; iters < niters; iters++ ) 
    {
      for( int jj=0; jj<arraysize; jj++ )
	{
	  sum = verts[ jj*ncomps+0 ] + verts[ jj*ncomps+1 ] +
                verts[ jj*ncomps+2 ] +
	        verts[ jj*ncomps+3 ] + verts[ jj*ncomps+4 ] + 
                verts[ jj*ncomps+5 ] +
	        verts[ jj*ncomps+6 ] + verts[ jj*ncomps+7 ];
	}
    }
  timeit_stop( tt );

  float time = timeit_getf( tt, timeit_seconds );
  timeit_delete( tt );
  return( time );
}

/*
 * try it with these options initially:
 *  ./go.exe 10 100 10
 */

int main( int argc, char **argv  )
{
  if ( argc < 3 )
    {
      cerr << "usage: " << argv[ 0 ]
	<< " <arraylength_start> <arraylength_end> <arraylength_step>"
	<< endl;
      exit( -1 );
    }
  
  int arraysizebgn = atoi( argv[ 1 ] );
  int arraysizeend = atoi( argv[ 2 ] );
  int arraysizestep = atoi( argv[ 3 ] );

  float *verts, *normals, *tcoords;
  float *interleaved;

  alloc_non_interleaved( arraysizeend, verts, normals, tcoords );
  alloc_interleaved( arraysizeend, interleaved );

  float t0, t1;

#define MKTABLE  cout.width(15) << cout.fill(' ') << cout.setf(ios::left, ios::adjustfield)

  MKTABLE;
  cout << "nverts";
  MKTABLE;
  cout << "interleaved";
  MKTABLE;
  cout << "non-interleaved" << endl;

  for( int ii=arraysizebgn; ii<arraysizeend; ii+=arraysizestep )
    {
      sum = 0;
      t1 = time_non_interleaved( ii, verts, normals, tcoords );
      sum = 0;
      t0 = time_interleaved( ii, interleaved );

      MKTABLE;
      cout << ii;
      MKTABLE;
      cout << t0; 
      MKTABLE;
      cout << t1 << endl;
    }
}



