.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutReshapeFunc 3GLUT "3.4" "GLUT" "GLUT"
.SH NAME
glutReshapeFunc - sets the reshape callback for the current window. 
.SH SYNTAX
.nf
.LP
void glutReshapeFunc(void (*func)(int width, int height));
.fi
.SH ARGUMENTS
.IP \fIfunc\fP 1i
The new reshape callback function. 
.SH DESCRIPTION
glutReshapeFunc sets the reshape callback for the current window. The
reshape callback is triggered when a window is reshaped. A reshape
callback is also triggered immediately before a window's first display
callback after a window is created or whenever an overlay for the window
is established. The width and height parameters of the callback specify
the new window size in pixels. Before the callback, the current window is
set to the window that has been reshaped. 

If a reshape callback is not registered for a window or NULL is passed to
glutReshapeFunc (to deregister a previously registered callback), the
default reshape callback is used. This default callback will simply call
glViewport(0,0,width,height) on the normal plane (and on the
overlay if one exists). 

If an overlay is established for the window, a single reshape callback is
generated. It is the callback's responsibility to update both the normal
plane and overlay for the window (changing the layer in use as necessary). 

When a top-level window is reshaped, subwindows are not reshaped. It is
up to the GLUT program to manage the size and positions of subwindows
within a top-level window. Still, reshape callbacks will be triggered for
subwindows when their size is changed using glutReshapeWindow.
.SH SEE ALSO
glutDisplayFunc, glutReshapeWindow
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
