.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.TH glutInitDisplayMode 3GLUT "3.4" "GLUT" "GLUT"
.SH NAME
glutInitDisplayMode - sets the initial display mode. 
.SH SYNTAX
.nf
.LP
void glutInitDisplayMode(unsigned int mode);
.fi
.SH ARGUMENTS
.IP \fImode\fP 1i
Display mode, normally the bitwise {\em OR}-ing of GLUT display mode bit masks.
See values below:
.TP 8
.B GLUT_RGBA
Bit mask to select an RGBA mode window. This is the default if
neither GLUT_RGBA nor GLUT_INDEX are specified. 
.TP 8
.B GLUT_RGB
An alias for GLUT_RGBA. 
.TP 8
.B GLUT_INDEX
Bit mask to select a color index mode window. This overrides
GLUT_RGBA if it is also specified. 
.TP 8
.B GLUT_SINGLE
Bit mask to select a single buffered window. This is the default if
neither GLUT_DOUBLE or GLUT_SINGLE are specified. 
.TP 8
.B GLUT_DOUBLE
Bit mask to select a double buffered window. This overrides
GLUT_SINGLE if it is also specified. 
.TP 8
.B GLUT_ACCUM
Bit mask to select a window with an accumulation buffer. 
.TP 8
.B GLUT_ALPHA
Bit mask to select a window with an alpha component to the color
buffer(s). 
.TP 8
.B GLUT_DEPTH
Bit mask to select a window with a depth buffer. 
.TP 8
.B GLUT_STENCIL
Bit mask to select a window with a stencil buffer. 
.TP 8
.B GLUT_MULTISAMPLE
Bit mask to select a window with multisampling support. If
multisampling is not available, a non-multisampling window will
automatically be chosen. Note: both the OpenGL client-side and
server-side implementations must support the
GLX_SAMPLE_SGIS extension for multisampling to be available. 
.TP 8
.B GLUT_STEREO
Bit mask to select a stereo window. 
.TP 8
.B GLUT_LUMINANCE
Bit mask to select a window with a ``luminance'' color model.
This model provides the functionality of OpenGL's RGBA color
model, but the green and blue components are not maintained in
the frame buffer. Instead each pixel's red component is converted
to an index between zero and
glutGet(GLUT_WINDOW_COLORMAP_SIZE)-1 and looked up in
a per-window color map to determine the color of pixels within
the window. The initial colormap of GLUT_LUMINANCE windows
is initialized to be a linear gray ramp, but can be modified with
GLUT's colormap routines. 
.SH DESCRIPTION
The initial display mode is used when creating top-level windows,
subwindows, and overlays to determine the OpenGL display mode for
the to-be-created window or overlay. 

Note that GLUT_RGBA selects the RGBA color model, but it does not
request any bits of alpha (sometimes called an alpha buffer or destination
alpha) be allocated. To request alpha, specify GLUT_ALPHA. The same
applies to GLUT_LUMINANCE. 
.SH GLUT_LUMINANCE IMPLEMENTATION NOTES
GLUT_LUMINANCE is not supported on most OpenGL platforms. 
.SH SEE ALSO
glutInit, glutCreateWindow
.SH AUTHOR
Mark J. Kilgard (mjk@sgi.com)
