#include "CGIForm.h"
#include "ReadOnlyMLA.h"

static	CGIForm form("mlaform", MLA_FORMFORM);

static const char*
nextchr(const char* cp, char c, const char* ep)
{
    for (; cp < ep; cp++)
	if (*cp == c)
	    return (cp);
    return (NULL);
}

int
main(int argc, char* argv[])
{
    form.setupArgs(argc, argv);

    ReadOnlyMLA* mla = form.readMLA();
    if (mla == NULL)
	return (-1);

    size_t size;
    const char* cp;
    form.readForm(*mla, cp, size);
    const char* ep = cp + size;
    const char* tp = nextchr(cp, '%', ep);
    if (tp) {
	do {
	    fwrite(cp, tp-cp, 1, stdout);
	    cp = tp+1;
	    switch (*cp++) {
	    case '+':		// forms-related escapes
		form.printEscapes(stdout, *mla, *cp++);
		break;
	    default:
		printf("%c%c", '%', cp[-1]);
		break;
	    }
	} while (cp < ep && (tp = nextchr(cp, '%', ep)));
    }
    fwrite(cp, ep-cp, 1, stdout);
    return (0);
}
