#include "SortedMsgArray.h"
#include "CGIForm.h"
#include "ReadOnlyMLA.h"

#define	NOMSG	((mnum_t) -1)

static	CGIForm form("mlafetch", MLA_MSGFORM);
static	mnum_t nextmsg = NOMSG;
static	mnum_t prevmsg = NOMSG;
static	mnum_t nextthread = NOMSG;
static	mnum_t prevthread = NOMSG;
static	u_int nhits;

static	void scan(FILE*, const MLA&, const MailMsg&, const char*, const char*);

int
main(int argc, char* argv[])
{
    form.setupArgs(argc, argv);

    ReadOnlyMLA* mla = form.readMLA();
    if (mla == NULL)
	return (-1);

    if (form.getMsgNum() >= mla->getMsgCount())
	mla->fatal("Invalid message number %u, there are only %u messages"
	    " in the database", form.getMsgNum(), mla->getMsgCount());

    const char* data;
    size_t size;
    form.readForm(*mla, data, size);

    /*
     * Setup the hit set from the encoded information
     * passed through the environment and calculate the
     * next/prev message and thread.
     */
    const MailMsg& msg = mla->getMsgTable()[form.getMsgNum()];
    SortedMailMsgArray hits;
    hits.mla = mla;
    if (form.getHitSet() != "")
	hits.decode(form.getHitSet());
    nhits = hits.length();
    u_int i;
    for (i = 0; i < nhits; i++)
	if (hits[i] == &msg)
	    break;
    if (i > 0) {
	prevmsg = hits[i-1]->msgnum;
	// NB: obvious for loop here generates bad code with -O
	u_int j = i-1;
	do {
	    tnum_t t = hits[j]->thread;
	    if (t != msg.thread) {
		prevthread = mla->getThreadTable()[t];
		break;
	    }
	} while (j--);
    }
    if (i+1 < nhits) {
	nextmsg = hits[i+1]->msgnum;
	for (u_int j = i+1; j < nhits; j++) {
	    tnum_t t = hits[j]->thread;
	    if (t != msg.thread) {
		nextthread = mla->getThreadTable()[t];
		break;
	    }
	}
    }

    scan(stdout, *mla, msg, data, data+size);
    return (0);
}

static mnum_t
nextInParentThread(const MLA& mla, mnum_t m, mnum_t pnum)
{
    const MailMsg* table = mla.getMsgTable();
    if (pnum == 0)
	return ((mnum_t) -1);
    const MailMsg& pmsg = table[pnum-1];
    u_int n = pmsg.nreplies;
    if (n > 1) {
	const mnum_t* replies = mla.getReplyTable();
	const mnum_t* ix = &replies[pmsg.replynum];
	for (u_int i = 0; n > 4; i += 3, n -= 3) {
	    if (ix[0] == m) return (ix[1]);
	    if (ix[1] == m) return (ix[2]);
	    if (ix[2] == m) return (replies[ix[3]]);
	    ix = &replies[ix[3]];
	}
	switch (n) {
	case 4: if (ix[2] == m) return (ix[3]);
	case 3: if (ix[1] == m) return (ix[2]);
	case 2: if (ix[0] == m) return (ix[1]);
	}
    }
    return (nextInParentThread(mla, pmsg.msgnum, pmsg.parent));
}

static mnum_t
nextInThread(const MLA& mla, mnum_t m, mnum_t pnum)
{
    const MailMsg* table = mla.getMsgTable();
    if (table[m].hasReplies()) {
	/*
	 * There are replies to this message so the
	 * ``next in the thread'' is the first reply.
	 */
	const MailMsg& msg = table[m];
	return (msg.nreplies > 1 ?
	    mla.getReplyTable()[msg.replynum] : msg.replynum);
    } else {
	/*
	 * No replies to this message, consult the
	 * parent for the next reply in its list.
	 */
	return (nextInParentThread(mla, m, pnum));
    }
}

static const char*
nextchr(const char* cp, char c, const char* ep)
{
    for (; cp < ep; cp++)
	if (*cp == c)
	    return (cp);
    return (NULL);
}

static const char*
doif(fxBool b, FILE* fp, const MLA& mla, mnum_t m,
    const char* cp, const char* ep)
{
    const char* tp = nextchr(cp+1, cp[0], ep);
    if (b)
	scan(fp, mla, mla.getMsgTable()[m], cp+1, tp ? tp : ep);
    return (tp ? tp+1 : ep);
}

static void
scan(FILE* fp, const MLA& mla, const MailMsg& msg, const char* cp, const char* ep)
{
    const char* tp = nextchr(cp, '%', ep);
    if (tp) {
	do {
	    fwrite(cp, tp-cp, 1, fp);
	    cp = tp+1;
	    switch (*cp++) {
	    case 'a':		// email address
		CGIForm::printString(fp, mla.checkstr(msg.emailaddr));
		break;
	    case 'b':		// message body
		fflush(fp);
		mla.printMsgBody(fp, msg);
		break;
	    case 'd':		// Date: line
		CGIForm::printString(fp, mla.checkstr(msg.date));
		break;
	    case 'f':		// From:-style line
		CGIForm::printString(fp, mla.checkstr(msg.emailaddr));
		if (msg.name != msg.emailaddr) {
		    fputs(" (", fp);
		    CGIForm::printString(fp, mla.checkstr(msg.name));
		    putc(')', fp);
		}
		break;
	    case 'm':		// message id
		CGIForm::printString(fp, mla.checkstr(msg.msgid));
		break;
	    case 'n':		// name of sender
		CGIForm::printString(fp, mla.checkstr(msg.name));
		break;
	    case 'q':		// query argument string
		CGIForm::printFetchArgs(fp, msg.msgnum, form.getQueryString());
		break;
	    case 'r':		// reply-to address
		CGIForm::printString(fp, mla.checkstr(msg.replytoaddr));
		break;
	    case 's':		// subject line
		CGIForm::printString(fp, mla.checkstr(msg.subject));
		break;
	    case 't':		// To: line
		CGIForm::printString(fp, mla.checkstr(msg.to));
		break;

	    case '?':		// conditional escapes
		switch (*cp++) {
		case '<':		// previous thread
		    cp = doif(prevthread != NOMSG, fp, mla, prevthread, cp, ep);
		    break;
		case '>':		// next thread
		    cp = doif(nextthread != NOMSG, fp, mla, nextthread, cp, ep);
		    break;
		case 'n':		// next in thread
		    { mnum_t n = nextInThread(mla, msg.msgnum, msg.parent);
		      cp = doif(n != NOMSG, fp, mla, n, cp, ep);
		    }
		    break;
		case '-':		// previous message
		    cp = doif(prevmsg != NOMSG, fp, mla, prevmsg, cp, ep);
		    break;
		case '+':		// next message
		    cp = doif(nextmsg != NOMSG, fp, mla, nextmsg, cp, ep);
		    break;
		case 'p':		// parent message
		    cp = doif(msg.parent != 0, fp, mla, msg.parent-1, cp, ep);
		    break;
		default:
		    fprintf(fp, "%c?%c", '%', cp[-1]);
		    break;
		}
		break;
	    case '+':		// forms-related escapes
		form.printEscapes(fp, mla, *cp++);
		break;
	    default:
		fprintf(fp, "%c%c", '%', cp[-1]);
		break;
	    }
	} while (cp < ep && (tp = nextchr(cp, '%', ep)));
    }
    fwrite(cp, ep-cp, 1, fp);
}
