#ifndef _ixDB_
#define	_ixDB_

/*
 * Keyword Index database support.
 */
#include "MailMsg.h"
#include "db.h"
#include <stdarg.h>

class fxStr;
class WordSplit;
class fxStrSet;
class SpellDict;
class WeightDict;

class ixDB {
public:
    typedef mnum_t docid_t;		// documents are mail messages
    typedef u_int weight_t;		// relevance ranking weight
    typedef struct {
	docid_t	   id;		// document id (ref to document db)
	weight_t   w;		// calculated weight
    } ixRec;
private:
    DB*		db;		// open database file
    fxStrSet*	stopList;	// set of words in stop list
    fxBool	stopListDirty;	// stop list needs to be updated
    fxBool	stopListRead;	// stop list in db has been read
    u_short	minWordLength;	// min length of a word
    u_short	maxWordLength;	// max length of a word
    u_short	wordNum;	// word number in message/file
    u_int	totalWords;	// total words indexd in message/file
    u_int	stoppedWords;	// words discarded by stop list
    u_int	shortWords;	// words discarded 'cuz of minWordLength
    u_int	longWords;	// words discarded 'cuz of maxWordLength
    WordSplit*	split;		// word splitter
    fxBool	splitInfoDirty;	// word splitter info needs to be updated
    SpellDict*	dict;		// dictionary for stripping suffixes
    int		trace;		// trace work
    WeightDict*	wdict;		// word weights for file

    friend class ixDBItem;

    void getStopList();
    void putStopList();

    void getSplitInfo();
    void putSplitInfo();
protected:
    virtual void vprintMsg(const char* fmt, va_list ap) const;
    virtual void error(const char* fmt ...) const;
public:
    ixDB(DB*);
    virtual ~ixDB();

    DB* getDB();

    int getTracing() const;		// trace indexing work
    void setTracing(int);

    SpellDict* getDictionary() const;
    void setDictionary(SpellDict*);	// stemming dictionary
    void addStopList(const char* word);	// add to stop list
    u_int getStoppedWords() const;	// # words discarded by stop list

    u_short getMinWordLength() const;	// min index word length (chars)
    void setMinWordLength(u_short);
    u_int getTooShortWords() const;	// # words discarded by min word length

    u_short getMaxWordLength() const;	// max index word length (chars)
    void setMaxWordLength(u_short);
    u_int getTooLongWords() const;	// # words discarded by max word length

    u_int getTotalWords() const;	// # words index in msg/file

    void beginDocument();		// reset counters for new document
    void indexStr(fxStr& s, u_int weight);
    void endDocument(docid_t docid);	// flush index information to database

    fxBool Fetch(const fxStr&, DBT&);	// fetch index info for specified word
    fxBool Fetch(const char*, DBT&);	// fetch index info for specified word
    fxBool Fetch(const char*, size_t len, DBT&);

    fxBool First(DBT& key, DBT& cont);	// get first key
    fxBool Next(DBT& key, DBT& cont);	// get next sequential key

    fxBool Sync();			// flush index db info to disk
};
#endif /* _ixDB_ */
