#include "ReadWriteMLA.h"
#include "Sys.h"
#include "StackBuffer.h"
#include "db.h"
#include <errno.h>

static u_int
convURL(fxStr& body, u_int off, u_int& len)
{
    fxStr anchor = body.cut(off, body.next(off, " )>&\n\",][\t\\")-off);
    u_int l = anchor.length();
    if (l > 0 && (anchor[l-1] == '.' || anchor[l-1] == '*'))
	anchor.resize(l-1);
    body.insert("<a href=\"" | anchor | "\">" | anchor | "</a>", off);
    len = body.length();		// recalculate for caller
    return (off + 2*l + 14);		// NB: 14 is off by 1 intentionally
}

/*
 * Convert URLs in the body of a message to links and
 * any magic characters to their appropriate HTML
 * escape codes.  Beware that this logic will not do
 * what is desired if fed HTML as input!
 */
static void
convHTML(fxStr& body)
{
    u_int i = 0;
    u_int len = body.length();
    while (i < len) {
	switch (body[i]) {
	case ':':				// potential URL
	    if (i >= 6) {
		switch (body[i-6]) {
		case 'g':
		    if (strncmp(&body[i-6], "gopher://", 9) == 0)
			i = convURL(body, i-6, len);
		    break;
		case 't':
		    if (strncmp(&body[i-6], "telnet://", 9) == 0)
			i = convURL(body, i-6, len);
		    break;
		case 'm':
		    if (strncmp(&body[i-6], "mailto:", 7) == 0)
			i = convURL(body, i-6, len);
		    break;
		default: goto case4;
		}
	    } else if (i >= 4) {
	    case4:
		switch (body[i-4]) {
		case 'h':
		    if (strncmp(&body[i-4], "http://", 7) == 0)
			i = convURL(body, i-4, len);
		    break;
		case 'w':
		    if (strncmp(&body[i-4], "wais://", 7) == 0)
			i = convURL(body, i-4, len);
		    break;
		case 'n':
		    if (strncmp(&body[i-4], "news:", 5) == 0)
			i = convURL(body, i-4, len);
		    break;
		case 'f':
		    if (strncmp(&body[i-4], "file://", 7) == 0) {
			i = convURL(body, i-4, len);
			break;
		    }
		    /* fall thru... */
		default: goto case3;
		}
	    } else if (i >= 3) {
	    case3:
		switch (body[i-3]) {
		case 'f':
		    if (strncmp(&body[i-3], "ftp://", 6) == 0)
			i = convURL(body, i-3, len);
		    break;
		}
	    }
	    break;
	case '<':
	    body.remove(i,1); body.insert("&lt;", i);
	    i += 4; len += 3;
	    continue;
	case '>':
	    body.remove(i,1); body.insert("&gt;", i);
	    i += 4; len += 3;
	    continue;
	case '&':
	    body.remove(i,1); body.insert("&amp;", i);
	    i += 5; len += 4;
	    continue;
	}
	i++;
    }
}

/*
 * Write article body to the article database.
 */
fxBool
ReadWriteMLA::writeArticle(const MailMsg& msg, fxStr& body, fxBool processBody)
{
    if (!msgdb && !openMsgDB(O_RDWR|O_CREAT))
	return (FALSE);
    if (processBody)
	convHTML(body);
    z_stream zstream;
    zstream.zalloc = NULL;
    zstream.zfree = NULL;
    zstream.opaque = NULL;
    zstream.data_type = Z_BINARY;
    fxStackBuffer buf;
    if (deflateInit(&zstream, Z_DEFAULT_COMPRESSION) == Z_OK) {
	buf.put((char) 0);			// token to indicate zlib data
	char obuf[32*1024];			// XXX better if page-aligned
	zstream.next_out = (Bytef*) obuf;
	zstream.avail_out = sizeof (obuf);
	zstream.next_in = (Bytef*) &body[0];
	zstream.avail_in = body.length();
	do {
	    if (deflate(&zstream, Z_NO_FLUSH) != Z_OK) {
		error("zlib compressor error: %s", zstream.msg);
		goto bad;
	    }
	    if (zstream.avail_out == 0) {
		buf.put(obuf, sizeof (obuf));
		zstream.next_out = (Bytef*) obuf;
		zstream.avail_out = sizeof (obuf);
	    }
	} while (zstream.avail_in > 0);
	int dstate;
	do {
	    switch (dstate = deflate(&zstream, Z_FINISH)) {
	    case Z_STREAM_END:
	    case Z_OK:
		if (zstream.avail_out != sizeof (obuf)) {
		    buf.put(obuf, sizeof (obuf) - zstream.avail_out);
		    zstream.next_out = (Bytef*) obuf;
		    zstream.avail_out = sizeof (obuf);
		}
		break;
	    default:
		error("zlib compressor error: %s", zstream.msg);
		goto bad;
	    }
	} while (dstate != Z_STREAM_END);
bad:
	deflateEnd(&zstream);
    } else {
	buf.put((char) 1);			// token for uncompressed data
	buf.put(body, body.length());
    }
    if (trace) {
	printf("Msg %u, %.1fx compression (%u -> %u)", msg.msgnum,
	    (float) body.length() / (float) buf.getLength(),
	    body.length(), buf.getLength());
	if (buf.getLength() > maxmsgsize)
	    printf(" [spillover]");
	printf(".\n");
    }
    char filename[1024];
    DBT key;
    key.data = (void*) &msg.msgnum;
    key.size = sizeof (msg.msgnum);
    DBT data;
    data.data = (char*) buf;
    data.size = buf.getLength();
    if (data.size > maxmsgsize) {
	sprintf(filename, "%.5d", msg.msgnum);
	int fd = Sys::open(filename, O_WRONLY|O_CREAT|O_TRUNC, 0644);
	if (fd >= 0) {
	    // NB: skip type code when writing data
	    if (Sys::write(fd, &buf[1], data.size-1) != data.size-1) {
		error("%s (spillover file for msg %u): %s",
		    filename, msg.msgnum, strerror(errno));
		Sys::close(fd);
		Sys::unlink(filename);
		return (FALSE);
	    }
	    Sys::close(fd);
	    int type = buf[0];				// original type
	    buf.reset();
	    buf.put((char)(10+type));			// mark indirection
	    buf.put(filename, strlen(filename)+1);
	    data.data = (char*) buf;
	    data.size = buf.getLength();
	} else
	    warning("failed to create spillover file for msg %u; "
		"storing it inline", msg.msgnum);
    }
    switch ((*msgdb->put)(msgdb, &key, &data, overwrite ? 0 : R_NOOVERWRITE)) {
    case -1:
	error("Unable to \"put\" msg %u, errno %u", msg.msgnum, errno);
	return (FALSE);
    case 1:
	if (!overwrite)
	    warning("existing msg %u not overwritten", msg.msgnum);
	break;
    }
    // NB: msgdb is closed later...
    return (TRUE);
}
