#ifndef _WordSplit_
#define	_WordSplit_

#include "Types.h"


const int WS_UPPER    = 0x01;		// upper case alphabetic
const int WS_LOWER    = 0x02;		// lower case alphabetic
const int WS_ALPHA    = 0x03;		// any kind of alphabetic
const int WS_DIGIT    = 0x04;		// numeral (digit)
const int WS_SPACE    = 0x08;		// spacing character
const int WS_PUNCT    = 0x10;		// punctuation mark
const int WS_CNTRL    = 0x20;		// control character
const int WS_HEXDIGIT = 0x40;		// numeral (digit)

class WordSplit {
protected:
    char*	cp;
    char*	ebuf;
    u_char	typeInfo[256];
    char*	charMap;
    u_short	allDigits	: 1,
		allHexDigits	: 1,
		hyphenated	: 1,
		skipNums	: 1,
		skipHexadecimals: 1,
		breakAtHyphen	: 1,
		mapUpperToLower	: 1;

    void initMap();

    int isAscii(int c);
    int isDigit(int c);
    int isHexDigit(int c);
    int isLeader(int c);
    int isBody(int c);
    int mapChar(int c);
public:
    WordSplit(fxBool acceptHyphenation = TRUE,
	fxBool mapCase = FALSE,
	fxBool skipNumbers = FALSE);
    ~WordSplit();

    void setString(char* buf, int len = 0);
    char* nextWord(int& len);
// query of last word recognized
    fxBool isNumber()			{ return (allDigits); }
    fxBool isHexNumber()		{ return (allHexDigits); }
    fxBool isHyphenated()		{ return (hyphenated); }
// character classification control
    void addClassification(char*, int bits);
    void clrClassification(int bits, char* = 0);
    void setClassification(char*, int bits);
    void setMapping(char*);
// input handling controls
    void acceptHyphenation(fxBool b)	{ breakAtHyphen = !b; }
    void skipNumbers(fxBool b)		{ skipNums = b; }
    void skipHexNumbers(fxBool b)	{ skipHexadecimals = b; }
    void mapCase(fxBool b);
};
#endif
