#ifndef _Suffix_
#define _Suffix_

#include "Types.h"

/*
 * Suffix manipulation class.
 *
 * This is a base class that provides suffix removal
 * and derivation support.  It depends on subclass
 * methods to do dictionary lookup and related processing.
 */
class Suffix {
public:
    typedef fxBool (Suffix::*Rule)(char*, char*, char*, int);
    struct suftab {
	char	*suf;		// reversed matching suffix
				// primary rule checking
	Rule	p1;		// rule checking routine
	int	n1;		// delta offset at which suffix is checked
	char*	d1;		// deletion transformation rule
	char*	a1;		// addition transformation rule
				// secondary rule checking
	Rule	p2;
	int	n2;
	char*	d2;
	char*	a2;
    };
private:
    char*	word;		// word construction area
    short	wspace;		// amount of space allocated to word
    short	derivlevel;	// deepest derivation level
    char*	deriv[20];	// derivation table

    static const suftab suffixtab[];
    static const char* prefixtab[];	

    void getword(char*, int);
    const char* checkPrefix(char**, char*);
    fxBool monosyl(char*, char*);
    fxBool putsuf(char*, char*, int);
    fxBool putw(char*, char*, int);
    char* skipv(char*);
    fxBool suffix(char*, int);
    fxBool vowel(int);
/* rule methods */
    fxBool strip(char*, char*, char*, int);
    fxBool an(char*, char*, char*, int);
    fxBool s(char*, char*, char*, int);
    fxBool es(char*, char*, char*, int);
    fxBool ily(char*, char*, char*, int);
    fxBool ncy(char*, char*, char*, int);
    fxBool CCe(char*, char*, char*, int);
    fxBool VCe(char*, char*, char*, int);
    fxBool bility(char*, char*, char*, int);
    fxBool tion(char*, char*, char*, int);
    fxBool ize(char*, char*, char*, int);
    fxBool y_to_e(char*, char*, char*, int);
    fxBool i_to_y(char*, char*, char*, int);
    fxBool nop(char*, char*, char*, int);
    fxBool metry(char*, char*, char*, int);
public:
    Suffix(int space = 0);
    virtual ~Suffix();

    virtual fxBool Defined(char*, int = 0);	// check for word definition
    virtual void Expand(char*, int = 0);	// expand words w/ suffix rules
    virtual void Strip(char*, int& len);	// strip word of all suffixes

    virtual fxBool dictLookup(char*, int);
};
#endif /* _Suffix_ */
