#ifndef _SpellDict_
#define	_SpellDict_

#include "Suffix.h"

/*
 * Spelling Checker Class that checks words
 * with the standard UNIX dictionary and the
 * suffix stripping class.
 */
class SpellDict : public Suffix {
    int		fd;		// open hashlist file
    const short* hash;		// mapped hashlist contents
    size_t	hashsize;	// size of mapped file
    long**	pow2;		//

    SpellDict(int fd, const short* hash, size_t hashsize);

    int	get(u_long h);
public:
    ~SpellDict();

    static SpellDict* open(const char* hlistFile);

    virtual fxBool dictLookup(char*, int);
};
#endif /* _SpellDict_ */
