#ifndef _SortedMsgArray_
#define	_SortedMsgArray_

#include "ReadOnlyMLA.h"

class SortedMailMsgArray : public MailMsgArray {
public:
    SortedMailMsgArray();
    SortedMailMsgArray(u_int size);
    SortedMailMsgArray(SortedMailMsgArray const& o);
    ~SortedMailMsgArray();

    fxBool reverse;		// reverse sort array
    const MLA* mla;		// associated MLA for getting strings
    u_int maxlevels;		// max indentation for printing threads

    void encode(fxStr&) const;
    void decode(const char*);

    virtual void print(FILE*, const char* query) const;
    void printMsg(FILE*, const MailMsg&) const;
    void printMsg(FILE*, const MailMsg&, const char*) const;
    void printReply(FILE*, const MailMsg&, int l, const char*) const;
    void printReplies(FILE*, const MailMsg&, int l, const char*) const;
protected:
    SortedMailMsgArray(u_int esize, u_int num, void* data);
};

#define	fxDECLARE_SortedMsgArray(ARRAY)					\
class ARRAY : public SortedMailMsgArray {				\
public:									\
    ARRAY();								\
    ARRAY(u_int size);							\
    ARRAY(ARRAY const&a);						\
    ~ARRAY();								\
    virtual void print(FILE*, const char*) const;			\
protected:								\
    ARRAY(u_int esize, u_int num, void *data);				\
    virtual int compareElements(void const *, void const *) const;	\
};									\
__enddef__

#define	fxIMPLEMENT_SortedMsgArray(ARRAY)				\
    ARRAY::ARRAY() {}							\
    ARRAY::ARRAY(u_int size) : SortedMailMsgArray(size) {}		\
    ARRAY::ARRAY(ARRAY const& o) : SortedMailMsgArray(o) {}		\
    ARRAY::ARRAY(u_int esize, u_int num, void* data) :			\
	SortedMailMsgArray(esize, num, data) {}				\
    ARRAY::~ARRAY() {}							\
__enddef__
#endif /* _SortedMsgArray_ */
