#include "SortedMsgArray.h"
#include "CGIForm.h"

SortedMailMsgArray::SortedMailMsgArray()
{
    reverse = FALSE;
    mla = NULL;
}
SortedMailMsgArray::SortedMailMsgArray(u_int size) : MailMsgArray(size)
{
    reverse = FALSE;
    mla = NULL;
}
SortedMailMsgArray::SortedMailMsgArray(SortedMailMsgArray const& o)
    : MailMsgArray(o)
{
    reverse = o.reverse;
    mla = o.mla;
}
SortedMailMsgArray::SortedMailMsgArray(u_int esize, u_int num, void* data)
    : MailMsgArray(esize, num, data)
{
    reverse = FALSE;
    mla = NULL;
}
SortedMailMsgArray::~SortedMailMsgArray() {}

void SortedMailMsgArray::print(FILE*, const char*) const {}

void
SortedMailMsgArray::printMsg(FILE* fp, const MailMsg& msg) const
{
    fputs("<B>", fp);
    CGIForm::printString(fp, mla->checkstr(msg.subject));
    fprintf(fp, "</B> <I>%s</I>\n", mla->checkstr(msg.name));
}

void
SortedMailMsgArray::printMsg(FILE* fp, const MailMsg& msg, const char* query) const
{
    fprintf(fp, "<A HREF=\"?Msg=%d&%s\"><B>", msg.msgnum, query);
    CGIForm::printString(fp, mla->checkstr(msg.subject));
    fprintf(fp, "</B></A> <I>%s</I>\n", mla->checkstr(msg.name));
}

void
SortedMailMsgArray::printReply(FILE* fp, const MailMsg& msg, int l, const char* query) const
{
    if (l < maxlevels)
	fprintf(fp, "<UL>\n");
    fputs("<LI> ", fp);
    if (find(&msg) != fx_invalidArrayIndex)
	printMsg(fp, msg, query);
    else
	printMsg(fp, msg);
    if (msg.hasReplies())
	printReplies(fp, msg, l+1, query);
    if (l < maxlevels)
	fprintf(fp, "</UL>\n");
}

void
SortedMailMsgArray::printReplies(FILE* fp, const MailMsg& msg, int l, const char* query) const
{
    u_int n = msg.nreplies;
    if (n > 1) {
	const mnum_t* replies = mla->getReplyTable();
	const MailMsg* table = mla->getMsgTable();
	const mnum_t* ix = &replies[msg.replynum];
	for (u_int i = 0; n > 4; i += 3, n -= 3) {
	    printReply(fp, table[ix[0]], l, query);
	    printReply(fp, table[ix[1]], l, query);
	    printReply(fp, table[ix[2]], l, query);
	    ix = &replies[ix[3]];
	}
	switch (n) {
	case 4: printReply(fp, table[*ix++], l, query);
	case 3: printReply(fp, table[*ix++], l, query);
	case 2: printReply(fp, table[*ix++], l, query);
	case 1: printReply(fp, table[*ix], l, query);
	}
    } else
	printReply(fp, mla->getMsgTable()[msg.replynum], l, query);
}

/*
 * Sigh, to pass the hit set through the URL we have to
 * encode it using a limited ASCII subset.  We could add
 * some characters to the alphabet, but unless we can get
 * 85 we won't be able to reduce the number of characters
 * required to represent a 32-bit quantity.
 */
static const char alphabet[] = {
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L',
    'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X',
    'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j',
    'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
    'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7',
    '8', '9',
};
#define	AR	sizeof (alphabet)
#define	ENC(c)	alphabet[c]

/*
 * Craft a compact representation of the array for
 * passing through the environment to each mlafetch
 * that's invoked to fetch& display a document.  We
 * use an ASCII representation of the bit-packed binary
 * values.  The string is encoded as follows:
 *
 * Bit Length	Value
 *    16	N # msg numbers in hit set
 *    16	B = # bits/msg number
 *    32	base msg number (min)
 *     B	msg delta #0
 *     B	msg delta #1
 *    ...
 *     B	msg delta #N-1
 *
 * where msg deltas are just the message number minus
 * base msg number (the min of the set of messages).
 */
void
SortedMailMsgArray::encode(fxStr& str) const
{
    u_int nhits = length();
    fxAssert(nhits <= 0xffff, "Too many hits to encode; must fit in 16 bits");
    /*
     * Deduce msg number range.
     */
    u_int max = 0;
    u_int min = 999999;
    u_int i;
    for (i = 0; i < nhits; i++) {
	mnum_t m = (*this)[i]->msgnum;
	if (m < min)
	    min = m;
	if (m > max)
	    max = m;
    }
    /*
     * Calculate the number of bits required
     * to hold values in the range of msg #s.
     */
    u_int range = max-min;
    u_int nbits = 0;
    for (; range > 0; nbits++)
	range >>= 1;
    size_t cc = (2 + howmany(nhits*nbits, 32)) * sizeof (u_int);
    void* data = malloc(cc);
    /*
     * Setup encoded hitset ``header'':
     *   # msg numbers
     *   # bits/msg number
     *   minimum msg number
     */
    u_int* lp = (u_int*) data;
    *lp++ = (nhits<<16) | nbits;
    *lp++ = min;
    /*
     * Bit stuff message number deltas.
     */
    u_int w = 0;
    u_int bits = 0;
    for (i = 0; i < nhits; i++) {
	u_int m = (*this)[i]->msgnum - min;
	if (bits+nbits > 32) {
	    u_int space = 32-bits;
	    if (space)			// NB: <<32 == <<0!
		w |= m << bits;
	    *lp++ = w;
	    w = m >> space;
	    bits = nbits - space;
	} else {
	    w |= m << bits;
	    bits += nbits;
	}
    }
    if (bits)
	*lp++ = w;
    str.append("&Hits=");
    u_int off = str.length();
    str.resize(off+3*cc+1);
    char* cp = &str[off];
    lp = (u_int*) data;
    for (cc /= sizeof (long); cc > 0; cc--) {
	u_int w = *lp++;
	u_int q;
	q = w/(AR*AR*AR*AR*AR);	w -= q*AR*AR*AR*AR*AR;	cp[0] = ENC(q);
	q = w/(AR*AR*AR*AR);	w -= q*AR*AR*AR*AR;	cp[1] = ENC(q);
	q = w/(AR*AR*AR);	w -= q*AR*AR*AR;	cp[2] = ENC(q);
	q = w/(AR*AR);		w -= q*AR*AR;		cp[3] = ENC(q);
	q = w/(AR);		w -= q*AR;		cp[4] = ENC(q);
						    	cp[5] = ENC(w);
	cp += 6;
    }
    str.resize(cp - (char*) str);
    free(data);
}

static	u_char invalpha[256];

static void
setupDecoder(void)
{
    for (u_int i = 0; i < AR; i++)
	invalpha[alphabet[i]] = i;
}

#define	DEC(c)	invalpha[c]

static u_int
decodeWord(const char* cp)
{
    u_int w;
    w = DEC(cp[0]);
    w = AR*w + DEC(cp[1]);
    w = AR*w + DEC(cp[2]);
    w = AR*w + DEC(cp[3]);
    w = AR*w + DEC(cp[4]);
    w = AR*w + DEC(cp[5]);
    return (w);
}

/*
 * Decode the compact representation of the hit set
 * passed through the environment (see above).
 */
void
SortedMailMsgArray::decode(const char* cp)
{
    setupDecoder();
    u_int w = decodeWord(cp);
    u_int nhits = w>>16;
    u_int nbits = w&0xffff;
    if (nhits > 0xffff || nbits > 32) {		// bogus
	fprintf(stderr, "Bogus decoded hit count (%u) or bit count (%u).\n",
	    nhits, nbits);
	return;
    }
    if (nhits == 0)
	return;
    mnum_t min = decodeWord(cp += 6);
    u_int nmsgs = mla->getMsgCount();
    if (min >= nmsgs) {				// bogus
	fprintf(stderr, "Bogus decoded min msgs number (%u).\n", min);
	return;
    }
    resize(nhits);
    const MailMsg* table = mla->getMsgTable();
    u_int mask = 0xffffffff>>(32-nbits);
    u_int bits = 32;				// force immediate refill
    w = 0;
    for (u_int i = 0; i < nhits; i++) {
	u_int delta = w;
	if (bits+nbits > 32) {
	    w = decodeWord(cp += 6);
	    delta |= w << (32-bits);
	    bits = nbits+bits-32;
	    w >>= bits;
	} else {
	    bits += nbits;
	    w >>= nbits;
	}
	delta &= mask;
	if (min+delta >= nmsgs) {
	    fprintf(stderr, "Bogus decoded message index %u", min+delta);
	    delta = nmsgs-min-1;
	}
	(*this)[i] = &table[min+delta];
    }
}
