/*	$Header: /usr/people/sam/fax/html/tools/MLA/RCS/Set.h,v 1.2 1995/03/21 03:00:57 sam Exp $ */
/*
 * Copyright (c) 1990, 1991, 1992, 1993, 1994, 1995 Sam Leffler
 * Copyright (c) 1991, 1992, 1993, 1994, 1995 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#ifndef _Set_
#define	_Set_

#include "stdlib.h"
#include "Types.h"
#include "Array.h"
#include "Str.h"
#include "DSmacros.h"

class fxSetIter;
class fxSet;

//
//
//  fxSet interface
/*******************************************

class SET(ELEMENT) : public fxSet {
public:
    SET();
    SET(SET const &);
    virtual ~SET();
    u_int size() const;
    u_int getKeySize() const;
    SET& operator=(SET const &);
    void add(ELEMENT const &);
    void remove(ELEMENT);
    fxBool contains(ELEMENT const &) const;		// returns 1 or 0
    SET& operator&=(SET const &);
    SET& operator|=(SET const &);
    SET& operator-=(SET const &);
    fxObj *copy() const;
protected:
    virtual u_long hashKey(void const *) const;
    virtual int compareKeys(void const *, void const *) const; // 0 => equal
    virtual void copyKey(void const *, void *) const;
    virtual void destroyKey(void *) const;
}

class SETIter(SET,ELEMENT) : public fxSetIter {
public:
    SETIter();
    SETIter(SET const &);
    operator=(SET const &);
    operator++();
    u_int removed();
    u_int notDone();
}

*******************************************/

//----------------------------------------------------------------------

class fxSetBucket {
public:
    fxSetBucket(void *kv,fxSetBucket *n) {kvmem=kv; next=n;}
    ~fxSetBucket();

    void *kvmem;
    fxSetBucket *next;
};

fxDECLARE_PtrArray(fxSetBuckets, fxSetBucket *);
fxDECLARE_PtrArray(fxSetIters, fxSetIter *);

#define fxSetVirtuals()						\
    virtual u_long hashKey(void const *) const;			\
    virtual int compareKeys(void const *, void const *) const;	\
    virtual void copyKey(void const *, void *) const;		\
    virtual void destroyKey(void *) const;			\
__enddef__

//----------------------------------------------------------------------

class fxSet : public fxObj {
    friend class fxSetIter;
public:
    u_int size() const { return numKeys; }
    u_int getKeySize() const { return keysize; }

protected:
    fxSet(u_int ksize, u_int initsize=0);
    fxSet(fxSet const&);
    virtual ~fxSet();

    void cleanup();

    void operator=(fxSet const&);

    fxBool contains(void const*) const;
    void* find(void const*) const;
    void remove(void const*);
    void add(void const*);

    fxSetVirtuals()

    void addIter(fxSetIter*);
    void removeIter(fxSetIter*);
    void invalidateIters(fxSetBucket const*) const;

    void operator|=(fxSet const&);
    void operator&=(fxSet const&);
    void operator-=(fxSet const&);

    u_int numKeys;
    u_int keysize;
    fxSetBuckets buckets;
    fxSetIters iters;
};

//----------------------------------------------------------------------

class fxSetIter {
    friend class fxSet;
public:
    fxSetIter();
    virtual ~fxSetIter();
    fxSetIter(fxSet&);
    void operator=(fxSet&);	// not a const argument!
    void operator++()	  { increment(); }
    void operator++(int)  { increment(); }
    u_int removed() const { return invalid; }
    u_int notDone() const { return node != 0; }
protected:
    void const* getKey() const;
    void advanceToValid();
    void increment();

    // this is 0 if iterator isn't valid yet.
    fxSet* set;
    u_int bucket;        

    // this is 1 if the element was deleted.
    u_int invalid:1;

    // If "invalid", this points to the next node. If 0, there are no more nodes
    fxSetBucket* node; 
};

//----------------------------------------------------------------------

#define fxDECLARE_SetIter(SET,ELEMENT)					\
class fxCAT(SET,Iter) : public fxSetIter { /*XXX*/			\
public:									\
    fxCAT(SET,Iter)();							\
    fxCAT(SET,Iter)(SET &);						\
    fxCAT(SET,Iter)(SET *);						\
    operator ELEMENT const &() const					\
	{ return *(ELEMENT const *)fxSetIter::getKey(); }		\
    ELEMENT const & element() const					\
	{ return *(ELEMENT const *)fxSetIter::getKey(); }		\
}									\
__enddef__

#define fxIMPLEMENT_SetIter(SET,ELEMENT)				\
    fxCAT(SET,Iter)::fxCAT(SET,Iter)() : fxSetIter()	{}		\
    fxCAT(SET,Iter)::fxCAT(SET,Iter)(SET &d) : fxSetIter((fxSet &)d) {}	\
    fxCAT(SET,Iter)::fxCAT(SET,Iter)(SET *d) : fxSetIter(*(fxSet *)d) {}\
__enddef__

//----------------------------------------------------------------------

#define fxDECLARE_Set(SET,ELEMENT) 					\
class SET : public fxSet {/*XXX*/					\
public:									\
    SET(u_int initsize=0);						\
    ~SET();								\
    void operator=(SET const &d)					\
	{fxSet::operator=((fxSet const &)d);}				\
    fxBool contains(ELEMENT const &k) const				\
	{return fxSet::contains(&k);}					\
    ELEMENT const *find(ELEMENT const &k) const				\
	{return (ELEMENT const *)fxSet::find(&k);}			\
    void add(ELEMENT const &k)						\
	{fxSet::add(&k);}						\
    void remove(ELEMENT k)						\
	{fxSet::remove(&k);}						\
    SET *operator&() { return this; }					\
    SET& operator&=(SET const &d)					\
	{fxSet::operator&=((fxSet const &)d); return *this;}		\
    SET& operator|=(SET const &d)					\
	{fxSet::operator|=((fxSet const &)d); return *this;}		\
    SET& operator-=(SET const &d)					\
	{fxSet::operator-=((fxSet const &)d); return *this;}		\
protected:								\
    fxSetVirtuals()							\
};									\
fxDECLARE_SetIter(SET,ELEMENT);						\
fxDECLARE_Ptr(SET);							\
__enddef__


// StrSet: the element is a fxStr object. The
// user only has to define copyValue and destroyValue.

#define fxDECLARE_StrSet(SET) fxDECLARE_Set(SET,fxStr)
#define fxDECLARE_PtrSet(SET,ELEMENT) fxDECLARE_Set(SET,ELEMENT)

//----------------------------------------------------------------------

#define fxIMPLEMENT_BasicSetMethods(SET,ELEMENT)			\
    SET::SET(u_int initsize) :						\
        fxSet(sizeof(ELEMENT),initsize) {} 				\
    SET::~SET() { cleanup(); }						\
    fxIMPLEMENT_SetIter(SET,ELEMENT)					\
__enddef__

#define fxIMPLEMENT_StrSetMethods(SET)					\
    fxIMPLEMENT_copyObj(SET,Key,fxStr)					\
    fxIMPLEMENT_destroyObj(SET,Key,fxStr)				\
    u_long SET::hashKey(void const *element) const			\
	{ return ((fxStr const *)element)->hash(); }			\
    int SET::compareKeys(void const *element1,				\
		void const *element2) const				\
	{ return ::compare(*(fxStr const *)element1,			\
	    *(fxStr const *)element2); }				\
__enddef__

#define fxIMPLEMENT_PtrSetMethods(SET,ELEMENT)				\
    fxIMPLEMENT_copyPtr(SET,Key,ELEMENT)				\
    fxIMPLEMENT_destroyPtr(SET,Key,ELEMENT)				\
    u_long SET::hashKey(void const *element) const			\
	{ return u_long((*(u_int const *)(element)) >> 2); }		\
    int SET::compareKeys(void const *element1,				\
	void const *element2) const					\
	{ return (*(char * const *)element1 - *(char * const *)element2); }\
__enddef__

//----------------------------------------------------------------------

#define fxIMPLEMENT_Set(SET,ELEMENT)					\
    fxIMPLEMENT_BasicSetMethods(SET,ELEMENT)				\
__enddef__

#define fxIMPLEMENT_StrSet(SET)						\
    fxIMPLEMENT_BasicSetMethods(SET,fxStr)				\
    fxIMPLEMENT_StrSetMethods(SET)					\
__enddef__

#define fxIMPLEMENT_PtrSet(SET,ELEMENT)					\
    fxIMPLEMENT_BasicSetMethods(SET,ELEMENT)				\
    fxIMPLEMENT_PtrSetMethods(SET,ELEMENT)				\
__enddef__
#endif /* _Set_ */
