#ifndef _ReadWriteMLA_
#define	_ReadWriteMLA_

#include "MLA.h"

class SpellDict;

/*
 * Update-able MLA with parsing support.
 */
class ReadWriteMLA : public MLA {
private:
#define	HASHSIZE	2027	// NB: prime
    mnum_t* hashtab[HASHSIZE];	// hash table for locating new messages
    u_int oldmsgs;		// number of msgs read from db
    u_int lineno;		// line number during parsing
    fxBool sort;		// if true, must sort messages by time
    fxBool overwrite;		// overwrite article files
    fxBool compactPool;		// compact string pool when updating
    fxStr defAddr;		// info for under-qualified email addresses
    fxStr thisyear;		// current year info for dates
    fxStr timezonestr;		// local timezone info for dates
    fxStr inputFile;		// filename being parsed
    SpellDict* dict;		// optional dictionary for indexing

    ReadWriteMLA(const char* toc);

// support for adding new messages
    void addMessage(MailMsg&, const char* inreply, u_int startline);
    void addHashEntry(u_int h, const MailMsg& msg);
    void addReply(MailMsg&, MailMsg& reply);
    void setParent(MailMsg& msg, MailMsg& parent, const char* inreply);
    MailMsg* findReply(const char* inreply, u_int& subjMatch);
    MailMsg* findOldReply(const char* inreply, u_int& subjMatch);
    fxBool checkSubjects(const MailMsg& m, const MailMsg& p);
    fxBool subjcmp(const MailMsg&, const MailMsg&);
    static const char* stripre(const char*);
// stuff for dynamic growth of the database
    void grow(void);
    void purgeHashTable(void);
// support for updating thread state and writing the database
    fxBool writeArticle(const MailMsg&, fxStr& body, fxBool processBody);
// parsing support
    void nextMessage(FILE*, fxStr& date);
    void collectContinuation(FILE* fp, fxStr& s);
    fxBool getfromdate(const char* line, fxStr& date);
    static void getname(const char* value, fxStr& name, fxStr& email);
    static void getid(const char* value, fxStr& msgid);
    static void getreply(const char* value, fxStr& reply);
    static fxBool isRe(const char* cp);
protected:
    virtual void vprintMsg(const char* fmt, va_list ap) const;
public:
    ReadWriteMLA(const char* toc,
	u_int maxmsg, u_int avgmsgsize, u_int maxmsgsize);
    virtual ~ReadWriteMLA();

    static ReadWriteMLA* readMLA(const char* file);

    void setTOCFile(const char*);
    void setMsgFile(const char*);
    void setIXFile(const char*);
    void setMsgSeparator(const char*);
    void setDefaultAddr(const char*);
    void addStopList(const char*);
    void setDictionary(const char*);
    void setMinWordLength(u_int);
    void setMaxWordLength(u_int);

    void setOverwrite(fxBool);
    void setCompactPool(fxBool);

    void setInputFile(const char*);
    void setupParsing(void);
    fxBool load(FILE*, fxBool skipToStart = FALSE, fxBool processBody = TRUE);
    fxBool update(void);
};
#endif /* _ReadWriteMLA_ */
