#ifndef _ReadOnlyMLA_
#define	_ReadOnlyMLA_

#include "MLA.h"
#include "Array.h"

fxDECLARE_PtrArray(MailMsgArray, const MailMsg*);

class RegEx;

/*
 * Read-only Mailing List Archive.  The data structures
 * and their handling are designed to read and manipulate
 * as little file data as possible.  No file-related data
 * is touched so that the file can be memory-mapped read-only
 * to further optimize query performance.
 */
class ReadOnlyMLA : public MLA {
protected:
    ReadOnlyMLA(const char* toc);
public:
    virtual ~ReadOnlyMLA();

    static ReadOnlyMLA* readMLA(const char* file);

    void query(MailMsgArray&, u_int, time_t&, time_t&, RegEx*, RegEx*, fxBool&);
};
#endif /* _ReadOnlyMLA_ */
