#include "ReadOnlyMLA.h"
#include "Sys.h"
#include <sys/file.h>			// for LOCK_*
#include <sys/mman.h>

ReadOnlyMLA::ReadOnlyMLA(const char* toc) : MLA(toc)
{
}
ReadOnlyMLA::~ReadOnlyMLA() {}

ReadOnlyMLA*
ReadOnlyMLA::readMLA(const char* file)
{
    int fd;
    if (openMLA(file, O_RDONLY, fd)) {
	flock(fd, LOCK_SH);
	ReadOnlyMLA* mla = new ReadOnlyMLA(file);
	if (mla->setupMLA(fd, PROT_READ, MAP_SHARED))
	    return (mla);
	delete mla;
    }
    return (NULL);
}

#include "RegEx.h"

/*
 * Do a simple query using a date-range and
 * optional from & subject regular expressions.
 */
void
ReadOnlyMLA::query(MailMsgArray& hits,
    u_int maxhits,
    time_t& begin, time_t& end,
    RegEx* fromPat, RegEx* subjPat,
    fxBool& more
)
{
    more = FALSE;
    if (nmsgs == 0)
	return;
    if (begin == 0)
	begin = table[sorted[0]].datetime;
    if (end == 0)
	end = table[sorted[nmsgs-1]].datetime;
    // constrain hits to those that fall in the date range
    u_int b = 0, e = nmsgs;
    for (;;) {
	u_int m = (b+e) / 2;
	if (table[sorted[m]].datetime < begin) {
	    if (b == m) break;
	    b = m;
	} else {
	    if (e == m) break;
	    e = m;
	}
    }
    u_int i = b; e = nmsgs;
    for (;;) {
	u_int m = (b+e) / 2;
	if (end < table[sorted[m]].datetime) {
	    if (e == m) break;
	    e = m;
	} else {
	    if (b == m) break;
	    b = m;
	}
    }
    if (fromPat && subjPat) {
	for (; i < e; i++) {
	    const MailMsg& msg = table[sorted[i]];
	    if (!fromPat->Find(checkstr(msg.name)) && 
		!fromPat->Find(checkstr(msg.emailaddr)))
		continue;
	    if (!subjPat->Find(checkstr(msg.subject)))
		continue;
	    hits.append(&msg);
	    if (hits.length() == maxhits) {
		more = TRUE;
		break;
	    }
	}
    } else if (fromPat) {
	for (; i < e; i++) {
	    const MailMsg& msg = table[sorted[i]];
	    if (!fromPat->Find(checkstr(msg.name)) && 
		!fromPat->Find(checkstr(msg.emailaddr)))
		continue;
	    hits.append(&msg);
	    if (hits.length() == maxhits) {
		more = TRUE;
		break;
	    }
	}
    } else if (subjPat) {
	for (; i < e; i++) {
	    const MailMsg& msg = table[sorted[i]];
	    if (!subjPat->Find(checkstr(msg.subject)))
		continue;
	    hits.append(&msg);
	    if (hits.length() == maxhits) {
		more = TRUE;
		break;
	    }
	}
    } else {
	if (e-i > maxhits) {
	    e = i+maxhits;
	    more = TRUE;
	}
	for (; i < e; i++)
	    hits.append(&table[sorted[i]]);
    }
}

fxIMPLEMENT_PtrArray(MailMsgArray, const MailMsg*);
