#ifndef _MailMsg_
#define	_MailMsg_

#include "Types.h"

typedef	unsigned int tnum_t;	// thread number
typedef	unsigned int mnum_t;	// message number

class fxStr;
class MLA;

/*
 * Mail message descriptor.  Each message in a mailing
 * list archive has one of these.  Message reply relationships
 * are kept so that threads of conversation can be extracted.
 * This structure is constructed without pointers and without
 * C++ articles that would require a vtable.  This makes it
 * possible to mmap the array of message descriptors from the
 * database file and minimize setup overhead for queries.
 */
struct MailMsg {
    mnum_t msgnum;		// message number
    tnum_t thread;		// top-level thread for this message
    mnum_t parent;		// parent if this is a reply
    u_int maybereply;		// parent uncertain (linkage based on subject)
    time_t datetime;		// converted from UNIX-style From date
    const char* name;		// name of sender
    const char* emailaddr;	// email address of sender
    const char* replytoaddr;	// email address for replies
    const char* to;		// To: line
    const char* date;		// Date: line
    const char* subject;	// Subject: line
    const char* msgid;		// message id
    u_int nreplies;		// count of replies to this message
    /*
     * If there is a single reply, then this is the message number of
     * the reply; otherwise it's an index into the spillover reply table.
     */
    mnum_t replynum;		// message/offset into the MLA reply table

    MailMsg() {}
    ~MailMsg() {}

    static const char* months[12];
    static const int monthdays[12];

    void setup(mnum_t);

    int operator==(const MailMsg& other) const
	{ return (this == &other); }
    int operator!=(const MailMsg& other) const
	{ return (this != &other); }

    void print(FILE*, const MLA&) const;
    void printHeader(FILE*, const MLA&) const;

    fxBool hasReplies() const	{ return nreplies != 0; }

    // XXX these don't really belong here...
    static time_t cvtFromDate(const char* date);
    static time_t cvtDeliveryDate(const char* date);
    static time_t cvtQueryDate(const fxStr& date);
};
#endif /* _MailMsg_ */
