#ifndef _CGIForm_
#define	_CGIForm_

#include "MailMsg.h"
#include "Str.h"

struct tm;
class MLA;
class ReadOnlyMLA;
class RegEx;
class MailMsgArray;

#define	MLA_FORMFORM	"mla-form.html"
#define	MLA_QUERYFORM	"mla-query.html"
#define	MLA_MSGFORM	"mla-msg.html"

class CGIForm {
private:
    u_int	maxhits;		// max hits for query
    u_int	maxlevels;		// max thread levels for query results
    fxStr	scheme;			// collation scheme
    time_t	beginTime;		// starting time for query
    time_t	endTime;		// ending time for query
    fxStr	subjPat;		// Subject: pattern string for query
    fxStr	fromPat;		// From: pattern string for query
    fxBool	reverse;		// reverse sort query results
    fxBool	ignoreCase;		// ignore upper-lower case for query
    fxBool	isCGI;			// CGI app or run from command line
    fxStr	queryString;		// query string from environment
    fxStr	hitset;			// hitset passed through environment
    mnum_t	msgnum;			// initial message number
    fxStr	dir;			// MLA directory pathname
    fxStr	tocFile;		// MLA table of contents filename
    fxStr	formFile;		// HTML form filename
    const char*	appName;		// application name
    int		trace;			// MLA tracing level

    void parseQueryString(char* env);
    void parseArgcArgv(int argc, char* argv[]);
public:
    CGIForm(const char* app, const char* form);
    virtual ~CGIForm();

    virtual void setupArgs(int, char*[]);
    virtual void usage(void) const;

    ReadOnlyMLA* readMLA() const;
    void readForm(const MLA&, const char*&, size_t&) const;

    mnum_t getMsgNum() const		{ return msgnum; }
    const fxStr& getHitSet() const	{ return hitset; }
    fxStr& getQueryString()		{ return queryString; }
    const fxStr& getScheme() const	{ return scheme; }
    const fxStr& getFromPat() const	{ return fromPat; }
    const fxStr& getSubjPat() const	{ return subjPat; }
    time_t getBeginTime() const		{ return beginTime; }
    time_t getEndTime() const		{ return endTime; }
    u_int getMaxHits() const		{ return maxhits; }
    u_int getMaxLevels() const		{ return maxlevels; }
    fxBool getReverse() const		{ return reverse; }
    fxBool getIgnoreCase() const	{ return ignoreCase; }

    void query(ReadOnlyMLA& mla, MailMsgArray& hits,
	RegEx* fromPat, RegEx* subjPat, fxBool& more);

    static void printString(FILE*, const char*);
    static void printFetchArgs(FILE*, mnum_t, const char*);
    static void printDate(FILE*, const tm&);
    static void printDateTime(FILE*, const tm&);

    virtual void printEscapes(FILE*, const MLA&, char);

    virtual void printCollateForm(FILE*, fxBool);
    virtual void printDateForm(FILE*, const char*,
		    const tm&, const tm&, const tm&);
    virtual void printIgnoreCaseForm(FILE*, fxBool);
    virtual void printMaxHitsForm(FILE*, u_int maxhits);
    virtual void printMaxLevelsForm(FILE*, u_int levels);
    virtual void printSchemeForm(FILE*, const char* def);
};
#endif /* _CGIForm_ */
