#!/usr/bin/perl 
#
# Program: lw360f.pl
# Version: 1.01
# Author: Michael Breuer (mbreuer@majjas.com)
# Copying: GPL
# 
# See the README file.
#
# *** CHANGES ***
# 1.01: Removed printf (debug code)
#       Fixed -c if no comment (faxcover)
#       Works with Hylafax 4.0b15 (will NOT work with 3.x).
#
#**************************************************************
# These may be customized for your site.
$SENDFAX="/usr/local/bin/sendfax";
$FAXCOVER="/usr/local/bin/faxcover";
$TEMPCVR="/tmp/__lw360_cvr$$";
$TEMPFAX="/tmp/__lw360_fax$$";
$TMPTIFF="/tmp/__lw360_tiff$$";
$TMPCAPTURE="/tmp/__lw360_tmp$$";
$CAT="/bin/cat";
$GS="/usr/bin/gs";
$RM="/bin/rm -f";
#
# You should not have to change anything below this line,
#
$start=1;
$lines=0;
$notify="-D";
%cmdlist=(
	'RecipientOrg' =>1,
	'DialCallee' =>2,
	'RecipientName' =>3,
	'CalleePhone' =>4,
	'SenderName' =>5,
	'CallerPhone' =>6,
	'SenderPhone' =>7,
	'MaxRetries' =>8,
	'RetryInterval' =>9,
	'FaxType' =>10,
	'nPages' =>11
);
open(TEMPFILE, ">$TMPCAPTURE");
while ($start==1 && ($_=<STDIN>)) {
        printf(TEMPFILE $_);
	$lines++;
	chop($_);
	if (/^%[!^]PS-Adobe-3\.0/i) {
		$start=0;
	} else {
		@commands=split(/\//,$_);
		foreach (@commands) {
			s/^\\//;
			s/def//;
			if (/^CoverNote/) {
				s/CoverNote\[//;
				s/\]//;
				s/\(//g;
				(@comments)=split(/\)/, $_);
			} else {
				s/\)//;
				($tmp,$rest)=split(/\(/, $_,2);
				if (!$rest) {
					($tmp,$rest)=split(/ /, $tmp, 2);
				}
				$cmd{$tmp}="'" . $rest . "'";
			}
		}
	}
}
$options="";
$sfoptions="-D -n -R ";
if ($cmd{'RecipientOrg'}) {$options = $options . " " . "-x " . $cmd{'RecipientOrg'};}
if ($cmd{'DialCallee'}) {
   $_=$cmd{'DialCallee'};
   s/T//;
   s/'//g;
   $sfoptions= $sfoptions . " " . "-d" . $_;}
if ($cmd{'RecipientName'}) {$options = $options . " " . "-t " . $cmd{'RecipientName'};}
if ($cmd{'CalleePhone'}) {$options = $options . " " . "-n " . $cmd{'CalleePhone'};}
if ($cmd{'SenderName'}) {$options = $options . " " . "-f " . $cmd{'SenderName'};}
#if ($cmd{'CallerPhone'}) {$options = $options . " " . "-? " . $cmd{'CallerPhone'};}
#if ($cmd{'SenderPhone'}) {$options = $options . " " . "-i " . $cmd{'SenderPhone'};}
if ($cmd{'MaxRetries'}) {
   $_=$cmd{'MaxRetries'};
   s/'//g;
   s/ //g;
   if ($_ > 0) {$sfoptions = $sfoptions . " " . "-t " . $_;}
}
#if ($cmd{'RetryInterval'}) {$sfoptions = $sfoptions . " " . "-? " . $cmd{'RetryInterval'};}
#if ($cmd{'FaxType'}) {$options = $options . " " . "-? " . $cmd{'FaxType'};}
if ($cmd{'nPages'}) {
   $_ = $cmd{'nPages'};
   s/ //g;
   s/'//g;
   $options = $options . " " . "-p " . $cmd{'nPages'};}
$cmt="";
foreach (@comments) {
	$cmt = $cmt . $_ . "
";
}	
chop($cmt);
if (length($cmt)) {$cmt = "-c " . $cmt;}
$hdr="%!PS-Adobe-2.0 EPSF-2.0";
if ($lines > 1) {
   open(FAXCOVER, "$FAXCOVER $options '$cmt' |");
   open(TEMPCVR, ">$TEMPCVR");
   while ($_=<FAXCOVER>) {print(TEMPCVR $_);}
   close(FAXCOVER);
   close(TEMPCVR);
#  $hdr="%^PS-Adobe-2.0 EPSF-2.0";
} else {$TEMPCVR="";}
   
open(TEMPFAX,">$TEMPFAX");
printf(TEMPFAX "$hdr\n");
while ($_=<STDIN>) {print(TEMPFAX $_);}
close(TEMPFAX);
if ($lines==1) {
   `$CAT $TEMPFAX | lpr -P ps`;
   open(OUTPUT, "|lpr -P ps");
} else
{
#  `$CAT $TEMPCVR $TEMPFAX | $GS -sDEVICE=tiffg3 -dNOPAUSE -dSAFER -sOutputFile=$TMPTIFF -r196 -q - 1>/dev/null 2>&1`;
#   `$CAT $TMPTIFF | $SENDFAX $sfoptions 1>/dev/null`;
    `$SENDFAX -v -v $sfoptions $TEMPCVR $TEMPFAX 1>/dev/null`;
}
`$RM $TEMPCVR`
`$RM $TEMPFAX`;
