#!/usr/local/bin/perl
#
# Copyright 1996 Rick Morris, Pacific Interconnect Inc.
# This program is published under the GNU public license.
# You may do what you wish with this program.
# If you make any major and/or useful changes, please send them
# to rmorris@pinc.com
#
# faxout.cgi   send one or more faxes from an HTML form.
#              cover page may be included or sent on its own
#
#

$| = 1;

$tmpfaxcover="/tmp/sfaxcover.$$";
$faxcover='faxcover';				# location of faxcover binary

use CGI;
$query = new CGI;
require "ctime.pl";
$tt = &ctime(time());
chop($tt);
$sendfax = "/usr/local/bin/sendfax.orig";
print STDOUT "Content-type: text/html\n\n";




print $query->dump;

print"<pre>";

@fax = $query->param('fax');
$to = $query->param('ToName');
$phone = $query->param('ToNumber');
$company = $query->param('ToCompany');
$from = $query->param('FromName');
$cover = $query->param('Cover');
$regard = $query->param('Regarding');
$comments = $query->param('Comments');
$comment =~ s/\n//g;
$comment =~ s/\r//g;
#print "faxes being sent are @fax\n";
#print "It is going to $to at $phone\n";
#print "You, $from, will be notified by e-mail of the progress\n";

# now check the args and fill them in.
#

push(@args, '-P', 'high');
push(@args, '-m', '-D');
push(@args, '-f', "$from");
push(@args, '-d', "$phone");
push(@args, '-n');

# cover page??
if($cover =~ /Yes/){
	#
	# Since we want to be able to only send a cover page, we call
	# faxcover by hand
	#

	push(@faxcoverargs, '-r', $regard) if $regard;
	push(@faxcoverargs, '-x', $company) if $company;
	push(@faxcoverargs, '-c', $comments) if $comments;
	push(@faxcoverargs, '-t', "$to");
	push(@faxcoverargs, '-f', "$from");
	push(@faxcoverargs, '-n', "$phone");

	print "$faxcover @faxcoverargs \> $tmpfaxcover\n";

	#
	# Sigh.  I wish open() could take argument as lists and assign
	# each element to argv[], like system() and exec() can.
	#

	open(COVEROUT, ">$tmpfaxcover") ||
	     &abort("Could not open temporary file for cover page, aborting");

	if (($pid = fork()) == 0) {
		open(STDOUT, ">&COVEROUT");
		exec($faxcover, @faxcoverargs);
	}

	waitpid($pid, 0);

	if ($?) {
		&abort("faxcover failed, fax was not sent");
	}
	print "A cover page is being sent\n";
	push(@args,$tmpfaxcover);
} else {
	print "No cover page is being sent\n";
}

push(@args, "@fax");
push(@args, "2>&1");

chdir("/usr/spool/fax/pinc");
print"Performing $sendfax @args\n";

open(LOG, ">>/var/spool/fax/log/sendlog");
print LOG "$tt web $sendfax @args\n";
close(LOG);
$reply = `$sendfax @args`;
print "\nI got back from sendfax:\n$reply";
if($reply =~ /request/){
	print "Looks like your fax went out OK\n";
} else {
	$error = $? >>8;
	print "Looks like there was a problem.\n Error code is $?";
}
