/*	$Header: /usr/people/sam/fax/contrib/faxview/RCS/FAXViewer.c++,v 1.21 1994/04/01 19:46:54 sam Exp sam $
/*
 * Copyright (c) 1994 Sam Leffler
 * Copyright (c) 1994 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <Vk/VkApp.h>

#include "tiffio.h"
#include "FAXViewer.h"

static XrmOptionDescRec cmdOptions[] = {
    { "-help",		"*help",		XrmoptionNoArg,
      (caddr_t) "True" },
    { "-big",		"*small",		XrmoptionNoArg,
      (caddr_t) "False" },
    { "-small",		"*small",		XrmoptionNoArg,
      (caddr_t) "True" },
    { "-lsb",		"*fillOrder",		XrmoptionNoArg,
      (caddr_t) FILLORDER_LSB2MSB },
    { "-msb",		"*fillOrder",		XrmoptionNoArg,
      (caddr_t) FILLORDER_MSB2LSB },
    { "-uudecode",	"*uudecode",		XrmoptionNoArg,
      (caddr_t) "True" },
};

void
main(int argc, char **argv)
{
    VkApp* app =
	new VkApp("FaxView", &argc, argv, cmdOptions, XtNumber(cmdOptions));
    if (app->argc() > 1) {
	fprintf(stderr, "%s: Illegal argument '%s'\n",
	    app->argv(0), app->argv(1));
	fprintf(stderr, "Usage: faxview [-filename database-file]\n");
	exit(1);
    }
    FAXViewer* viewer = new FAXViewer("FAXViewer");
    viewer->show();
    app->run();
    /*NOTREACHED*/
}
