/*	$Header: /usr/people/sam/fax/contrib/faxview/RCS/Rect.h,v 1.4 1995/01/15 01:31:28 sam Exp $ */
/*
 * Copyright (c) 1990, 1991, 1992, 1993 Sam Leffler
 * Copyright (c) 1991, 1992, 1993 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#ifndef _Rect_
#define	_Rect_

#include "Types.h"

// A simple rectangle class

struct Rect {
    int x, y, w, h;

    Rect();
    Rect(const Rect &a);
    Rect(int xx, int yy, int ww, int hh);

    void set(int xx, int yy, int ww, int hh);

    fxBool inside(int xx, int yy) const;
    fxBool inside(const Rect& other) const;

    fxBool operator!=(const Rect& other) const;
    fxBool operator==(const Rect& other) const;

    fxBool hasArea() const;
};

inline Rect::Rect()
    { /*garbage*/ }
inline Rect::Rect(const Rect &a)
    { x = a.x; y = a.y; w = a.w; h = a.h; }
inline Rect::Rect(int xx, int yy, int ww, int hh)
    { x = xx; y = yy; w = ww; h = hh; }
inline void Rect::set(int xx, int yy, int ww, int hh)
    { x = xx; y = yy; w = ww; h = hh; }
inline fxBool Rect::inside(int xx, int yy) const
    { return (x <= xx && xx < x + w && y <= yy && yy < y + h); }
inline fxBool Rect::inside(const Rect& other) const
    { return inside(other.x, other.y) &&
	inside(other.x + other.w - 1, other.y + other.h - 1); }
inline fxBool Rect::operator!=(const Rect& other) const
    { return (x != other.x || y != other.y || w != other.w || h != other.h); }
inline fxBool Rect::operator==(const Rect& other) const
    { return (x == other.x && y == other.y && w == other.w && h == other.h); }
inline fxBool Rect::hasArea() const
    { return (w > 0) && (h > 0); }
#endif /* _Rect_ */
