/*	$Header: /usr/people/sam/fax/contrib/faxview/RCS/FAXViewer.h,v 1.4 1994/10/11 00:25:21 sam Exp $ */
/*
 * Copyright (c) 1990, 1991, 1992, 1993 Sam Leffler
 * Copyright (c) 1991, 1992, 1993 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */
#ifndef _FAXViewer_
#define	_FAXViewer_

#include "Types.h"
#include "Str.h"
#include "ImageView.h"
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

class FAXViewer {
public:
    enum {
	ButtonFile,
	ButtonPage,
	ButtonContrast,
	ButtonOrient,
    };
private:
    TIFF*	tif;
    ImageView*	pageView;
    Bitmap*	page;
    fxStr	filename;
    fxStr	printCmd;
    short	curPageNum;
    short	maxPageNum;
    short	minPageNum;
    int		curDirnum;
    int		maxDirnum;
    int		curangle;
    fxBool	removeFile;
    struct Page {
	fxBool	print;
	fxBool	read;
	int	orient;
    };
    Page*	pages;
    Cursor	prevCursor;
    Widget	shellWidget;
    Widget	formWidget;
    Widget	listWidget;
    Widget	labelWidget;
    Widget	imageWidget;
    u_long	xRedMask;
    u_long	xGreenMask;
    u_long	xBlueMask;
    Colormap	xColormap;
    XSetWindowAttributes window_attributes;

    static String buttonStrings[];
    static XrmOptionDescRec shellOptions[];
    static XtResource clientResources[];
    static Arg formArgs[];
    static Arg listArgs[];
    static Arg labelArgs[];
    static Arg imageArgs[];
    static XtActionsRec actionsTable[];
    static char translationsTable[];

    void usage(const char* appName);
    void uudecode(FILE* in, fxStr& filename);
    void setupPageMenu();
    void selectPage(u_short);
    void setLabel();
    void updateOrient(int o);
    void getVisual();

    void setContrast(Contrast);

    void beginSlowOperation();
    void endSlowOperation();
public:
    FAXViewer();
    ~FAXViewer();

    void initialize(int argc, char** argv);
    void open();
    void close();
    void expose(XEvent*);

    void gotoDirectory(int dirnum);
    void gotoNextPage();
    void gotoPrevPage();
    void rotatePage();
    void flipPage();

    void setLinearContrast();
    void setExpContrast();
    void setExp50Contrast();
    void setExp60Contrast();
    void setExp70Contrast();
    void setOrientation(int orient);
    void printPage();
    void printAll();
    void print();
};
inline void FAXViewer::gotoNextPage()
    { gotoDirectory(fxmin(curDirnum+1,maxDirnum)); }
inline void FAXViewer::gotoPrevPage()
    { gotoDirectory(fxmax(curDirnum-1,0)); }
#endif /* _FAXViewer_ */
