#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/SoXtRenderArea.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/Xt/viewers/SoXtFullViewer.h>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/actions/SoGLRenderAction.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <X11/IntrinsicP.h>
#include <X11/X.h>
#include "viewer.h"
#include "tsViewer.h"
#include "tsSync.h"
#include <signal.h>
#include <sys/signal.h>

#define VERS_MSG "3Pipe Viewer - Version 1.2\n"

//---------------------------------------------------------------------------
char *createString(char *s)
//---------------------------------------------------------------------------
	{
	char *r;
	if (!s) return 0;
	r=(char*) malloc(strlen(s)+1);
	if (!r) return 0;
	strcpy(r, s);
	return r;
	}
	
//---------------------------------------------------------------------------
int InitViewerInfo(ViewerInfo &vi, int &argc, char **argv)
//---------------------------------------------------------------------------
	{
	char tmp[256];
	int  i, j=2;

	
	// first clear vi
	memset(&vi, 0, sizeof(ViewerInfo));
	vi.isSync=1;
	vi.hasDeco=0;
	vi.wa=54.0;
	vi.ha=46.0;
	vi.sa=49.0;	
	// process arguments
	for (i=2;i<argc;i++)
		{
		if		(!strcmp(argv[i], "-d")) vi.hasDeco=1; 
		else if (!strcmp(argv[i], "-ns")) vi.isSync=0;
		else if (!strcmp(argv[i], "-h")) return 0;
		else if ((!strcmp(argv[i], "-t")) && (i<argc-1)) vi.title=createString(argv[++i]);
		else if ((!strcmp(argv[i], "-k")) && (i<argc-1)) vi.keyPath=createString(argv[++i]);
		else if ((!strcmp(argv[i], "-f")) && (i<argc-1)) vi.filename=createString(argv[++i]);
		else if ((!strcmp(argv[i], "-p1")) && (i<argc-1)) vi.name1=createString(argv[++i]);
		else if ((!strcmp(argv[i], "-p2")) && (i<argc-1)) vi.name2=createString(argv[++i]);
		else if ((!strcmp(argv[i], "-wa")) && (i<argc-1)) vi.wa=atof(argv[++i]);
		else if ((!strcmp(argv[i], "-ha")) && (i<argc-1)) vi.ha=atof(argv[++i]);
		else if ((!strcmp(argv[i], "-sa")) && (i<argc-1)) vi.sa=atof(argv[++i]);
		else
			{
			//printf("unrecognized option %s ignored\n", argv[i]);
			argv[j++]=argv[i];
			}
		}
	
	// get defaults
	if (!vi.keyPath)	vi.keyPath=createString(".shared_arena");
	if (!vi.name1)	    vi.name1=createString("pipe1.fifo");
	if (!vi.name2)		vi.name2=createString("pipe2.fifo");
	
	// get command
	if (argc<2) return VIEWER_KILL_SYNC;
	
	if (argv[1][0]=='i') return VIEWER_SHOW_INFO;
	if (argv[1][0]=='k') return VIEWER_KILL_SYNC;

	vi.nr=atoi(argv[1]);
	if ((vi.nr<1) || (vi.nr>3)) return 0;
	if (!vi.filename)	vi.filename=createString(vi.nr==1?"inner.iv":vi.nr==2?"outer1.iv":"outer2.iv");
	if (!vi.title)		{sprintf(tmp, "Viewer %d", vi.nr); vi.title=createString(tmp);}

	argc=j;
	
	return VIEWER_SHOW;
	}

//---------------------------------------------------------------------------
void printUsage()
//---------------------------------------------------------------------------
	{
	printf(VERS_MSG"\n");
	printf("Usage: viewer 1|2|3|i|k [options]\n");
	printf("Argument:\n");
	printf("1-3              :indicates the viewer to open\n");
	printf("i                :show current info\n");
	printf("k                :kill shared area (i.e. disable sync when a deadlock occurs\n");
	printf("\n");
	printf("Options:\n");
	printf("-h               :displays this message\n");
	printf("-ns              :do synchronize viewers via semaphores\n");
	printf("-d               :show decorations of window\n");
	printf("-nd              :no decorations (default)\n");
	printf("-t title         :title of window (only with -d)\n");
	printf("-f file          :filename for scenegraph,  the default for viewer 1\n");
	printf("                  is inner.iv,  and for the viewer 2 and 3 outer1/2.iv\n");
	printf("-k keypath       :keypath for semaphores. the default is the argv[0]\n");
//	printf("-p1 path         :the name for the first named pipe,  default pipe1.fifo\n");
//	printf("-p2 path         :the name for the secodn named pipe,  default pipe2.fifo\n");
	printf("-wa degrees      :the width angle of the camera (default: 54)\n");
	printf("-ha degrees      :the height angle of the camera (default: 46)\n");
	printf("-sa degrees      :the distance angle of the cameras (default: 49)\n");
	}
		
//---------------------------------------------------------------------------
void main(int argc, char *argv[]) 
//---------------------------------------------------------------------------
	{
	ViewerInfo vi;
	int        ret;
	ret=InitViewerInfo(vi, argc, argv);
	
	if (!ret)
		{
		printUsage();
		return;
		}
	else if (ret==VIEWER_SHOW_INFO)
		{
		fprintf(stderr, "Viewer: Show Info (%s)\n", vi.keyPath);
		semInfo(vi.keyPath);
		return;	
		}
	else if (ret==VIEWER_KILL_SYNC)
		{
		fprintf(stderr, "Viewer: Kill all shared objects\n");
		/*semKill(vi.keyPath);*/
		return;
		}

	printf(VERS_MSG);
	printf("Starting up Viewer %d\n", vi.nr);
	if (vi.nr==3) vi.nr=4;
	
	// create X shell	
    XtAppContext appContext;
    Widget shell = XtVaAppInitialize(
            &appContext,                // context will be returned
            "Inventor",                 // application class
            NULL, 0,                    // options
            (int *) &argc, argv, NULL,  // command line args in/out
			XmNmwmDecorations, vi.hasDeco,
			NULL);                      // termination

	// init inventor an x
	SoXt::init(shell);

	// read file
	SoInput input;
	if (!input.openFile(vi.filename))
		{
		fprintf(stderr, "Can't open Inventorfile %s\n", vi.filename);
		return;
		}
	fprintf(stderr,"viewer %d: Reading file %s\n", (vi.nr==4?3:vi.nr), vi.filename);
	SoSeparator *root=SoDB::readAll(&input);
	if (!root) return;

	// create and init viewer
	vi.v= new tsViewer(shell, vi.title, 1);
	vi.v->setDecoration(0);
vi.v->setBackgroundColor(SbColor(0.5,0.5,0.8));	
vi.v->setBorder(0);
	vi.v->setSceneGraph(root);       // important to be before the initSync !!
	vi.v->setTitle(vi.title);
	vi.v->viewAll();
	vi.v->show();  
	SoXt::show(shell); 
	vi.v->initSync(&vi);

	// if we are viewer 1, no further treatment is nesc.
	if (vi.nr==1) {SoXt::mainLoop();return;}
	
	// otherwise we have to handle the events, and send some to viewer 1    
    XEvent event;
	Display *dpy=0;
	int send;
	int width;
	XWindowAttributes attr;
	XGetWindowAttributes(vi.v->getDisplay(), XtWindow(shell),&attr);
	if (vi.nr==2)
		width=-attr.width;
	else 
		width=attr.width;
		
	for (;;)
		{
		//fprintf(stderr, "waiting for next event...");
        SoXt::nextEvent(appContext, &event);
		//fprintf(stderr, "..ok\n");
		//if ((sBlock->flag)&vi.nr) vi.v->render();
		if (sBlock->doSync) vi.v->render();
		
		// if viewer 1 is open
		if ((!dpy) && (sBlock->window[0]))
			{
			fprintf(stderr, "viewer %d: open display to viewer 1 (%s)...",vi.nr==4?3:vi.nr, sBlock->display_name[0]);
			dpy=sBlock->display[0]=XOpenDisplay(sBlock->display_name[0]);
			if (!dpy) fprintf(stderr, "failed\n"); else fprintf(stderr, "ok\n");
			}
		send=0;
		if ((event.type==ButtonPress) || (event.type==ButtonRelease))
			{
			if (event.xbutton.button!=3)
				{
				event.xbutton.x+=width;
				send=1;
				}
			}
		else if (event.type==MotionNotify)
			{
			if (!(event.xbutton.state&Button3Mask))
				{
				event.xmotion.x+=width;
				send=1;		 
				}
			}
		if (send)
			{	
			event.xany.window=sBlock->window[0];
			if (!XSendEvent(dpy, sBlock->window[0],0, 0, &event))
				printf("XSendEvent failed.\n");
			XFlush(dpy);
			}
		else
			{
			SoXt::dispatchEvent(&event);
			}
		}
}

