
#ifndef  _TS_VIEWER_
#define  _TS_VIEWER_

#include <Inventor/Xt/viewers/SoXtWalkViewer.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/sensors/SoNodeSensor.h>
#include <Inventor/nodes/SoLabel.h>
#include "viewer.h"

class tsViewer : public SoXtWalkViewer {
  public:
    tsViewer(
	Widget parent = NULL,
	const char *name = NULL, 
	SbBool buildInsideParent = TRUE, 
	SoXtFullViewer::BuildFlag flag = BUILD_ALL, 
	SoXtViewer::Type type = BROWSER);
    ~tsViewer();

	void initSync(ViewerInfo *vi);
	void getCameraPosition();
	void setCameraPosition();
	void notifyAllOthers();
	
  protected:
    virtual	void redraw();

   	ViewerInfo*			 vi;
	SoPerspectiveCamera* cam;
	
  private:
	int isInit;
	int lastState;
	float widtha;
	float heighta;
	float degree;
	SoNodeSensor* cameraSensor;
	SoNode* hvmanager;
	
	static void cameraSensorCB(void *data, SoSensor *sensor);
	};

#endif  /* _TS_VIEWER_ */
