#include "tsViewer.h"
#include "tsSync.h"
#include <Inventor/actions/SoSearchAction.h>
#include <Inventor/SoType.h>
#include <Inventor/fields/SoSFInt32.h>

//-------------------------------------------------------------------------
tsViewer::tsViewer(Widget parent, const char *name, SbBool buildInsideParent, SoXtFullViewer::BuildFlag flag, SoXtViewer::Type type): SoXtWalkViewer(parent, name, buildInsideParent, flag, type)
//-------------------------------------------------------------------------
	{
	isInit=0;
	cameraSensor=0;
	cam=0;
	vi=0;
	widtha=54.0;
	heighta=46.0;
	degree=50.0;
	lastState=-1;
	hvmanager=0;
	}


//-------------------------------------------------------------------------
tsViewer::~tsViewer()
//-------------------------------------------------------------------------
	{
	if (cameraSensor)
		{
		cameraSensor->detach();
		delete cameraSensor;
		}
		
	if (sBlock->display[vi->nr-1]) XCloseDisplay(sBlock->display[vi->nr-1]);
	sBlock->display[vi->nr-1]=0;
	sBlock->window[vi->nr-1]=0;
	}
	
//-------------------------------------------------------------------------
void tsViewer::cameraSensorCB(void *data, SoSensor *)
//-------------------------------------------------------------------------
	{
	tsViewer *me=(tsViewer*) data;
	if (me->vi->nr==1)
		me->setCameraPosition();	
	}
	
//-------------------------------------------------------------------------
void tsViewer::setCameraPosition()
//-------------------------------------------------------------------------
	{
	// only viewer 1 is allowed to do this
	if (vi->nr!=1) return;
	
	// check if sm is init
	if (!isInit) return;
	
	// lock the shm-area
	semLockCam();
	
	// copy the values in the shm
	SbVec3f		vec;
	float		angle;
	smCamera *sCamera=&(sBlock->cam);
	
	sCamera->viewportMapping=cam->viewportMapping.getValue();
	vec=cam->position.getValue();
	sCamera->position.x=vec[0];
	sCamera->position.y=vec[1];
	sCamera->position.z=vec[2];
	cam->orientation.getValue(vec, angle);
	sCamera->orientation.axis.x=vec[0];
	sCamera->orientation.axis.y=vec[1];
	sCamera->orientation.axis.z=vec[2];
	sCamera->orientation.angle=angle;
	sCamera->aspectRatio=cam->aspectRatio.getValue();
	sCamera->nearDistance=cam->nearDistance.getValue();
	sCamera->farDistance=cam->farDistance.getValue();
	sCamera->focalDistance=cam->focalDistance.getValue();
	sCamera->heightAngle=cam->heightAngle.getValue();

	// unlock the cam
	semUnLockCam();	

	// call the other viewers
	sBlock->flag=6;
	notifyAllOthers();
	}

//-------------------------------------------------------------------------
void tsViewer::getCameraPosition()
//-------------------------------------------------------------------------
	{
	// only viewers 2 and 3 must do this
	if (vi->nr==1) return;
	
	// check if shm is initialized
	if (!isInit) return;
	
	if (!(sBlock->flag&vi->nr)) return;
	
	// lock the shm-area
	semLockCam();
	
	// copy the values from the shm
	SbVec3f		vec;
	float		angle, wa, ha, ar;
	smCamera *sCamera=&(sBlock->cam);
	
	cam->enableNotify(0);
	
	cam->viewportMapping=sCamera->viewportMapping;
	vec=SbVec3f(sCamera->position.x, 
				sCamera->position.y, 
				sCamera->position.z);
	cam->position.setValue(vec);
	vec=SbVec3f(sCamera->orientation.axis.x, 
				sCamera->orientation.axis.y, 
				sCamera->orientation.axis.z);
	angle=sCamera->orientation.angle;
	ar=cam->aspectRatio=sCamera->aspectRatio;
	ha=cam->heightAngle=sCamera->heightAngle;
	// rotate camera
	if (vi->nr==2)
		wa=(M_PI/180.0)*vi->sa; //ha*ar;
	else 
		wa=-(M_PI/180.0)*vi->sa; //-ha*ar;

	SbRotation newRot=SbRotation(SbVec3f(0.0,1.0, 0.0), wa);
	
	
	cam->orientation=newRot*SbRotation(vec, angle);
	cam->nearDistance=sCamera->nearDistance;
	cam->farDistance=sCamera->farDistance;
	cam->focalDistance=sCamera->focalDistance;
	
	// unlock
	semUnLockCam();
	sBlock->flag&=~vi->nr;
	sBlock->doSync|=vi->nr;
	
	cam->enableNotify(1);
	}
	
//-------------------------------------------------------------------------
void tsViewer::initSync(ViewerInfo *v)
//-------------------------------------------------------------------------
	{
	vi=v;
	
	cam=(SoPerspectiveCamera*) getCamera();
	if (!cam) {printf("Fatal,  no camera\n"); return;}
    setHeadlight(0);
	cam->viewportMapping.setValue(SoCamera::LEAVE_ALONE);
	heighta=vi->ha;
	widtha=vi->wa;
	cam->aspectRatio.setValue(widtha/heighta);
	cam->heightAngle.setValue((M_PI/180.0)*heighta);
	
	// find the hvmanager
	SoSearchAction* sa=new SoSearchAction;
	if (vi->nr==1)
		sa->setType(SoType::fromName("HvManager"));
	else
		sa->setType(SoType::fromName("HvManagerP"));
	sa->setFind(SoSearchAction::TYPE);
	sa->apply(getSceneGraph());
	SoPath *path=sa->getPath();
	if (path)
		{
		fprintf(stderr, "HvManager found\n");
		hvmanager=path->getTail();
		}
	else
		{
		fprintf(stderr, "HvManager NOT found\n");
		hvmanager=0;
		}
		
	// init the shared-stuff	
 	if (!semInit(vi->keyPath, vi->nr))
		{
		vi->isSync=0;
		isInit=0;
		printf("Init Sync failed.\n");
		return;
		}
	
	// get the shared camera	
	SoPerspectiveCamera* sc;
	sc=(SoPerspectiveCamera*) SoPerspectiveCamera::getByName("SHARED_CAMERA");

	// init the x-stuff
	strcpy(sBlock->display_name[vi->nr-1], DisplayString(getDisplay()));
	sBlock->display[vi->nr-1]=0;
	sBlock->window[vi->nr-1]=getOverlayWindow();

	// check if main viewer (=1), then 
	if (vi->nr==1)
		{
		// set shared camera
		if (sc) 
			{
			printf("viewer 1: shared camera found\n");
			cam->orientation.connectFrom(&sc->orientation);
			sc->orientation.connectFrom(&cam->orientation);
			cam->position.connectFrom(&sc->position);
			sc->position.connectFrom(&cam->position);
			}
		else
			{
			printf("viewer 1: shared camera not found\n");
			}

		sBlock->doSync=0;
		// create a node sensor on our camera
		cameraSensor=new SoNodeSensor(tsViewer::cameraSensorCB, this);
		cameraSensor->setPriority(0);
		cameraSensor->attach(cam);
		isInit=1; 
		setCameraPosition();
		}
	// otherwise, if we are a "slave" viewer
	else
		{
		if (sc) sc->enableNotify(0);
		isInit=1; 
		getCameraPosition();
		}
}


//-------------------------------------------------------------------------
void tsViewer::notifyAllOthers()
//-------------------------------------------------------------------------
	{
	XEvent event;
	event.type=ClientMessage;
	event.xclient.message_type=0;
	event.xclient.format=8;

	// open display's
	if ((sBlock->window[1]) && (!sBlock->display[1]))
		{
		printf("viewer 1: open display to viewer 2 (%s)\n",sBlock->display_name[1]);
		sBlock->display[1]=XOpenDisplay(sBlock->display_name[1]);
		if (!sBlock->display[1]) printf("failed\n");
		}
	if ((sBlock->window[3]) && (!sBlock->display[3]))
		{
		printf("viewer 1: open display to viewer 3 (%s)\n", sBlock->display_name[3]);
		sBlock->display[3]=XOpenDisplay(sBlock->display_name[2]);
		if (!sBlock->display[3]) printf("failed\n");
		}
		
	// send messages
	if ((sBlock->display[1]) && (vi->nr!=2))
		{
		if (!XSendEvent(sBlock->display[1], sBlock->window[1], 0, 0, &event))
			printf("XSendEvent(2) failed.\n");
		else
			{
			XFlush(sBlock->display[1]);
			sBlock->doSync|=vi->nr;
			}
		}
	
	if ((sBlock->display[3]) && (vi->nr!=4))
		{
		if (!XSendEvent(sBlock->display[3], sBlock->window[3], 0, 0, &event))
			printf("XSendEvent(3) failed.\n");
		else
			{
			XFlush(sBlock->display[3]);
			sBlock->doSync|=vi->nr;
			}
		}
	}
		
////////////////////////////////////////////////////////////////////////
//
// This routine draws the scene graph (called by expose events and the
// scene graph sensor)
//
// use: virtual protected
//
void
tsViewer::redraw()
//
////////////////////////////////////////////////////////////////////////
{
    // return if we are not visible or if we need to wait for an expose
    // event (case when the sensor triggers but we know that an expose
    // event will come along and we don't want 2 redraws).
    if (!isVisible() || waitForExpose)	return;
	
	// check if we have the newest sceengraph state
	int st=0;
	if ((hvmanager) && (vi->isSync))
		{
		SoSFInt32 *fld=(SoSFInt32*) hvmanager->getField("_grphstate");
		if (!fld)
			{
			fprintf(stderr, "FATAL: no _grphstate in HvManager\n");
			}
		else
			{
			st=sBlock->state[vi->nr-1]=fld->getValue();
			}
		if (st<sBlock->state[0]) return;
		}

	if (st!=lastState) sBlock->doSync|=vi->nr;
	
	// set the window
    glXMakeCurrent(getDisplay(), getNormalWindow(), getNormalContext());
    
    // see if we need to temporary draw to the front buffer (which
    // is set when we display a new scene or get an expose event)
    if (drawToFrontBuffer && isDrawToFrontBufferEnable() && isDoubleBuffer()) {
	
	// ??? workaround bug 301010 - it seems that redrawing to the front
	// ??? of a window that might not be on the screen ( isVisible() might
	// ??? be incorect in a few cases) will confuse the GFX hardware
	// ??? of some machine (Xtrem and Indy24).
	// 
	// ??? Note: this also fixes 298058 (redrawing to the front window
	// ??? on indigo starter gfx, which happened all the time).
	//
	if (isRGBMode()) {
	    SbColor color = getBackgroundColor();
	    glClearColor(color[0], color[1], color[2], 0);
	} else
	    glClearIndex(getBackgroundIndex());
	glClear(GL_COLOR_BUFFER_BIT);
	glXSwapBuffers(getDisplay(), getNormalWindow());
	// ??? end of BUG workaround
	
	glReadBuffer(GL_FRONT); // Needed for acbuf antialiasing
	glDrawBuffer(GL_FRONT);
    }
    
	
    // swap those buffers!
    if (isDoubleBuffer())
		{
		if (drawToFrontBuffer && isDrawToFrontBufferEnable())
			{
			// no need to swap here - instead restore the buffer and 
			// clear the flag now that we have drawn to the front buffer

			getCameraPosition();
			actualRedraw();
			if ((sBlock->doSync) && (vi->isSync)) semLock1();
			if ((sBlock->doSync) && (vi->isSync)) semLock2();
			glReadBuffer(GL_BACK); // Needed for acbuf antialiasing
			glDrawBuffer(GL_BACK);
			//if ((sBlock->doSync) && (vi->isSync)) semLock3();
			glFlush();
			}
		else
			{
			getCameraPosition();
			actualRedraw();

			// check if we have the newest sceengraph state
			if ((hvmanager) && (vi->isSync))
				{
				SoSFInt32 *fld=(SoSFInt32*) hvmanager->getField("_grphstate");
				if (!fld)
					{
					fprintf(stderr, "FATAL: no _grphstate in HvManager\n");
					}
				else
					{
					st=sBlock->state[vi->nr-1]=fld->getValue();
					}
				if (st<sBlock->state[0]) return;
				}
			if (st!=lastState) sBlock->doSync|=vi->nr;
			
			if ((sBlock->doSync) && (vi->isSync))
				{ 
				if (sBlock->lock[vi->nr-1]==0)
					{
					sBlock->lock[vi->nr-1]=1;
					semLock1();
					}

				/* last chance to get new state */
				if ((hvmanager) && (vi->isSync))
					{
					SoSFInt32 *fld=(SoSFInt32*) hvmanager->getField("_grphstate");
					st=sBlock->state[vi->nr-1]=fld->getValue();
					if (st!=sBlock->state[0]) return;
					}

				if (sBlock->flag&vi->nr)
					{
					getCameraPosition();
					actualRedraw();
					}

				sBlock->lock[vi->nr-1]=2;
				semLock2();
				
				/* for debug */
				if ((hvmanager) && (vi->isSync))
					{
					SoSFInt32 *fld=(SoSFInt32*) hvmanager->getField("_grphstate");
					st=sBlock->state[vi->nr-1]=fld->getValue();
					if (st!=sBlock->state[0]) 
						fprintf(stderr, "Viewer %d: after lock 2 states doesn't match (me:%d his:%d\n",vi->nr,  st,sBlock->state[0] );
					}

				
				glXSwapBuffers(getDisplay(), getNormalWindow());
				if (vi->nr==1) sBlock->nofSwaps++;
				sBlock->lock[vi->nr-1]=3;
				//semLock3();
				}
			else
				{
				if (sBlock->flag&vi->nr)
					{
					getCameraPosition();
					actualRedraw();
					}
				if ((sBlock->doSync) && (vi->isSync))
					{
					sBlock->lock[vi->nr-1]=11;
					semLock1();
					sBlock->lock[vi->nr-1]=12;
					semLock2();
					glXSwapBuffers(getDisplay(), getNormalWindow());
					if (vi->nr==1) sBlock->nofSwaps++;
					sBlock->lock[vi->nr-1]=13;
					//semLock3();
					}
				else
					{
					glXSwapBuffers(getDisplay(), getNormalWindow());
					if (vi->nr==1) sBlock->nofSwaps++;
					}
				}
			}
		sBlock->lock[vi->nr-1]=0;
		}
    else	// if (isDoubleBuffer())
		{
		getCameraPosition();
		actualRedraw();
		glFlush();
		}
    
	// reset syncflag
	sBlock->doSync&=~vi->nr;
	lastState=st;
	
    // clear this flag now that we have drawn
    drawToFrontBuffer = FALSE;
}
				  
