//----------------------------------------------------------------------
// tsTopology.h
//
// This implements the classes for keeping track of the topology of
// a scene graph
//----------------------------------------------------------------------
#ifndef _TS_TOPOLOGY_
#define _TS_TOPOLOGY_

#include <Inventor/nodes/SoNode.h>
#include <Inventor/nodes/SoGroup.h>
#include <Inventor/SoLists.h>
#include <Inventor/SoPath.h>
#include <inttypes.h>

#define TOP_INSERT_ID 0
#define TOP_REMOVE_ID 1   // use -1 as index to remove all childs
#define TOP_REPLACE_ID 2
#define TOP_REMOVEALL_ID 3

//----------------------------------------------------------------------
class tsTopGroup
//----------------------------------------------------------------------
	{
	public:
		tsTopGroup();
		tsTopGroup(uint32_t i);
		~tsTopGroup();
		
		// methods 
		             dump(int level);
		tsTopGroup*  append(tsTopGroup* o);
		tsTopGroup*  insert(tsTopGroup* o, int pos);
		tsTopGroup*  replace(tsTopGroup* o, int pos);
		tsTopGroup*  remove(int pos);
		int			 removeAll();
		tsTopGroup*  find(uint32_t id);
		
		// members
		uint32_t	 id;
		int			 nofChilds;
		tsTopGroup*	 first;
		tsTopGroup*  next;
		tsTopGroup*  prev;

	};

//----------------------------------------------------------------------
class tsTopology
//----------------------------------------------------------------------
	{
	public:
		tsTopology();
		~tsTopology();
		
		int		init(SoNode *node);
		int		update(SoPath *path, int record);
		int		truncate();
		void	setBinary(int b) {isbinary=b;}
		int		getBinary() {return isbinary;}
		int		dump();

		// these lists should be private, so use them as READONLY !!!!
				
		SbIntList	commList;	// this indicates the command which was
								// performed
		SoPathList	pathList;	// this indicates the path to the group
								// node
		SbIntList	chldList;   // and this the index of the child in that
								// group node
		SbPList		grphList;   // if the comm is INSERT or REPLACE, this
								// lists holds pointer to a buffer cont.
								// the descr. of the graph
	private:
		int			updateGroup(tsTopGroup* g, SoPath *p, int record);
		tsTopGroup* buildGroup(SoNode *node);
		int			addChange(int cmd, SoPath *path, int idx, SoNode *nd);
		void*		getGraphDesc(SoNode *nd);
		
		tsTopGroup* root;
		int			isbinary;
	};

#endif
