#ifndef _TS_SYNC_H
#define _TS_SYNC_H

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <ulocks.h>

typedef struct
	{
	float x;
	float y;
	float z;
	} smVec3f;

typedef struct
	{
	smVec3f axis;
	float   angle;
	} smRotation;
		
typedef struct
	{
	int			viewportMapping;
	smVec3f		position;
    smRotation	orientation;
	float		aspectRatio;
	float		nearDistance;
	float		farDistance;
	float		focalDistance;
	float		heightAngle;
	} smCamera;

typedef struct
	{
    barrier_t   *barrier1;
    barrier_t   *barrier2;
    barrier_t   *barrier3;
	usema_t		*semCam;
	int			 flag;
	int			 renderFlag;
	char	     display_name[4][256]; 
	Display*	 display[4];            
	Window		 window[4];
	int			 state[4];
	int			 lock[4];
	int			 doSync;
	int			 nofSwaps;
	smCamera     cam;
	} smBlock;

int semInfo(char *arenaPath);
int semInit(char *arenaPath, int nr);
int semLock1();
int semLock2();
int semLock3();
int semLockCam();
int semUnLockCam();

/* shared variables */
extern smBlock *sBlock;


#endif /* _TS_SYNC_H_ */
