#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <errno.h>
#include <stdio.h>
#include <ulocks.h>
#include <unistd.h>
#include <sys/times.h>
#include <limits.h>

// here a little hack, because curses.h isn't defined for C++ 
extern "C"
	{
	void	 *initscr();	
	int      move(int, int);
	int		 addstr(char *);
	int		 refresh(void);
	};

 
	
#include "tsSync.h"


smBlock *sBlock=0;
usptr_t *arena;

/*----------------------------------------------------------------------*/
int semInfo(char *arenaPath)
/*----------------------------------------------------------------------*/
	{
	int i;
	char   tmp[256];
	long   lastTime;
	long   lastNofSwaps, totSwaps;
	struct tms t;
	double totTime;

	/* init shared arena */
	semInit(arenaPath,0);
	
	/* init the curses */
	initscr();
	lastTime=times(&t);
	lastNofSwaps=sBlock->nofSwaps;
	while (1)
		{
		move(0, 0);
		addstr("Timing:");
		totTime=(double)(times(&t)-lastTime)/(double)CLK_TCK;
		totSwaps=sBlock->nofSwaps-lastNofSwaps;
		sprintf(tmp, "%d swaps during %f seconds: %f frames per second\n\n", 
			totSwaps,totTime,(double)totSwaps/totTime);
		addstr(tmp);
		lastTime=times(&t);
		lastNofSwaps=sBlock->nofSwaps;
			 
		sprintf(tmp, "\nShared Block:\n");
		addstr(tmp);
		sprintf(tmp, "Flag :%d\n", sBlock->flag);
		addstr(tmp);
		sprintf(tmp, "Sync :%d\n", sBlock->doSync);
		addstr(tmp);
		for (i=0;i<4;i++)
			if (i!=2) 
				{
				sprintf(tmp, "Display Name %d:%s\n", i+1, sBlock->display_name[i]);
				addstr(tmp);
				}
		for (i=0;i<4;i++)
			if (i!=2) 
				{
				sprintf(tmp, "Graph State  %d:%d\n", i+1, sBlock->state[i]);
				addstr(tmp);
				}
		for (i=0;i<4;i++)
			if (i!=2 && sBlock->lock[i])
				{
				sprintf(tmp, "Viewer %d is in lock %d\n", i+1, sBlock->lock[i]);
				addstr(tmp);
				}
		addstr("\n\n\n");
		refresh();
		sleep(2);
		}
	}
	
/*----------------------------------------------------------------------*/
void initSMBlock()
/*----------------------------------------------------------------------*/
	{
	sBlock=(smBlock*) usmalloc(sizeof(smBlock),arena);
	memset(sBlock,0,sizeof(smBlock));
	sBlock->barrier1=new_barrier(arena);
	sBlock->barrier2=new_barrier(arena);
	sBlock->barrier3=new_barrier(arena);
	sBlock->semCam  =usnewsema(arena,1);
 
	}

/*----------------------------------------------------------------------*/
int semInit(char *arenaPath, int nr)
/*----------------------------------------------------------------------*/
	{
	if (sBlock != NULL) return 0;

    /* create the shared arena used by usmalloc / usfree */

    usconfig( CONF_INITUSERS, 20 );
    usconfig( CONF_LOCKTYPE, US_NODEBUG );
    /* usconfig( CONF_INITSIZE, 1<<28 );*/ 
    switch (nr)
    	{
        case 1:
        	arena = usinit(arenaPath);
            initSMBlock();
            usputinfo( arena, sBlock );
            break;

        default:
            arena = usinit(arenaPath);
            while (!usgetinfo( arena )) {;} /* wait untli arena is ready */
            sBlock = (smBlock *)  usgetinfo( arena);
 			break;
        }
    usadd( arena);
	return 1;
	}


/*----------------------------------------------------------------------*/
int semLock1()
/*----------------------------------------------------------------------*/
	{
	barrier(sBlock->barrier1,3);
	return 1;
	}
	
/*----------------------------------------------------------------------*/
int semLock2()
/*----------------------------------------------------------------------*/
	{
	barrier(sBlock->barrier2,3);
	return 1;
	}

/*----------------------------------------------------------------------*/
int semLock3()
/*----------------------------------------------------------------------*/
	{
	barrier(sBlock->barrier3,3);
	return 1;
	}

/*----------------------------------------------------------------------*/
int semLockCam()
/*----------------------------------------------------------------------*/
	{
	uspsema(sBlock->semCam);
	return 1;
	}
/*----------------------------------------------------------------------*/
int semUnLockCam()
/*----------------------------------------------------------------------*/
	{
	usvsema(sBlock->semCam);
	return 1;
	}	
	
