/* toptest.c++ - Tobias Strasser */

#include <Inventor/Xt/SoXt.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoSelection.h>
#include <Inventor/nodes/SoGroup.h>
#include <Inventor/sensors/SoNodeSensor.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoCube.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoCylinder.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/manips/SoHandleBoxManip.h>
#include <sys/time.h>



#ifdef SENSOR
	#include "tsTopology.h"
	void sensCB(void *, SoSensor *);
	tsTopology top;
#endif

void selCB(void *, SoPath *path);
void deselCB(void *, SoPath *path);

#define SEL_NONE 0
#define SEL_REP  1
#define SEL_DEL  2
#define SEL_MOV  3
#define SEL_MOVING 4

SoSelection *selroot;

SoHandleBoxManip *myHandleBox;

int state=SEL_NONE;
void main(int argc, char *argv[]) 
	{
	// init inventor and xt
    Widget window = SoXt::init(argv[0]);
	if(window == NULL) exit(1);
        
	// build a viewer
	SoXtExaminerViewer *myViewer= new SoXtExaminerViewer(window);
	 
    // read file
	char *fi="toptest.iv";
	if (argc>1) fi=argv[1];
    SoInput input;
    if (!input.openFile(fi))
		{
		fprintf(stderr, "Can't open Inventorfile %s\n", fi);
		return;
		}
	SoSeparator *root=SoDB::readAll(&input);
	if (!root) return;

	// create manips
	myHandleBox=new SoHandleBoxManip;
	myHandleBox->ref();
	
	selroot=new SoSelection;
	selroot->ref();
	selroot->addSelectionCallback(selCB, 0);
	selroot->addDeselectionCallback(deselCB, 0);
	selroot->addChild(root);
	
	
	myViewer->setSceneGraph(selroot);
	myViewer->setTitle("TopTest");
	myViewer->viewAll();
	myViewer->show();  

#ifdef SENSOR
	top.init(root);
	top.dump();
	SoNodeSensor *sens=new SoNodeSensor;
	sens->setFunction(sensCB);
	sens->attach(root);
	sens->setPriority(0);
#endif
	
	SoXt::show(window);
	SoXt::mainLoop();
	}

void clearSelection()
	{
	if (state==SEL_DEL)
		{
		SoBaseColor* bc=(SoBaseColor*) SoNode::getByName("TD_C");
		if (!bc) return;
		bc->rgb.setValue(1.0, 1.0, 1.0);
		}
	else if (state==SEL_REP)
		{
		SoBaseColor* bc=(SoBaseColor*) SoNode::getByName("TR_C");
		if (!bc) return;
		bc->rgb.setValue(1.0, 1.0, 1.0);
		}
	else if (state==SEL_MOV)
		{
		SoBaseColor* bc=(SoBaseColor*) SoNode::getByName("TM_C");
		if (!bc) return;
		bc->rgb.setValue(1.0, 1.0, 1.0);
		}
	}
	
void selCB(void *, SoPath *path)
	{
	SoNode* nd=path->getTail();
	if (nd==SoNode::getByName("TA"))
		{
		SoGroup *grp=(SoGroup*) SoNode::getByName("INSERT_HERE");
		if (!grp)
			{
			fprintf(stderr, "There must exist a Group with name INSERT_HERE\n");
			return;
			}
		grp=(SoGroup*) path->getNodeFromTail(2);
		// set new seed for the randomizer
		struct timeval tp;
		gettimeofday(&tp);
		srand(tp.tv_usec);
		SoSeparator *sep=new SoSeparator;
		sep->ref();
		SoSphere *s=new SoSphere;
		SoTransform *t=new SoTransform;
		t->translation.setValue(SbVec3f( 10.0 * (double) rand() / (double) RAND_MAX, 10.0 * (double) rand() / (double) RAND_MAX,0));
		sep->addChild(t);
		sep->addChild(s);
		
		grp->addChild(sep);
		selroot->deselect(nd);
		}
	else if (nd==SoNode::getByName("TR"))
		{
		SoBaseColor* bc=(SoBaseColor*) SoNode::getByName("TR_C");
		if (!bc) return;
		bc->rgb.setValue(1.0, 1.0, 0.0);
		clearSelection();
		state=SEL_REP;
		}
	else if (nd==SoNode::getByName("TD"))
		{
		SoBaseColor* bc=(SoBaseColor*) SoNode::getByName("TD_C");
		if (!bc) return;
		bc->rgb.setValue(1.0, 1.0, 0.0);
		clearSelection();
		state=SEL_DEL;
		}
	else if (nd==SoNode::getByName("TM"))
		{
		SoBaseColor* bc=(SoBaseColor*) SoNode::getByName("TM_C");
		if (!bc) return;
		bc->rgb.setValue(1.0, 1.0, 0.0);
		clearSelection();
		state=SEL_MOV;
		}
	else
		{
		if (state==SEL_DEL)
			{
			SoGroup *grp=(SoGroup*) path->getNodeFromTail(2);
			grp->removeChild(path->getNodeFromTail(1));
			}	
		else if (state==SEL_REP)
			{
			SoGroup *grp=(SoGroup*) path->getNodeFromTail(1);
			SoNode *rep=(SoNode*) path->getTail();
			SoNode *nw;
			selroot->deselect(rep);
			if (rep->isOfType(SoSphere::getClassTypeId()))
				nw=new SoCube;
			else if (rep->isOfType(SoCube::getClassTypeId()))
				nw=new SoCone;
			else if (rep->isOfType(SoCone::getClassTypeId()))
				nw=new SoCylinder;
			else if (rep->isOfType(SoCylinder::getClassTypeId()))
				nw=new SoSphere;
			else
				{
				fprintf(stderr, "Can't replace thiz\n");
				return;
				}
			grp->replaceChild(rep, nw);
			}	
		else if (state==SEL_MOV)
			{
			SoGroup *grp=(SoGroup*) path->getNodeFromTail(1);
			path->pop();
			path->append(0);
			myHandleBox->replaceNode(path);
			state=SEL_MOVING;
			}
		}
	}
	
void deselCB(void *, SoPath *path)
	{
	if (state==SEL_MOVING)
		{
		SoGroup *grp=(SoGroup*) path->getNodeFromTail(1);
		path->pop();
		path->append(0);
		myHandleBox->replaceManip(path, 0);
		//myHandleBox->unref();
		state=SEL_MOV;
		}
	}
#ifdef SENSOR
void sensCB(void *, SoSensor *s)
	{
	SoNodeSensor *ns=(SoNodeSensor*) s;
	SoNode *nd;
	if (nd=ns->getTriggerNode())
		{
		if (ns->getTriggerField())
			{
			}
		else
			{
			if (nd->isOfType(SoGroup::getClassTypeId()))
				{
				fprintf(stderr, "Group changed\n");
				top.update(new SoPath(nd));
				top.dump();
				}
			else
				{
				}
			}
		}
	}
#endif
