/*
 * Copyright (C) 1996   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.0 $
 |
 |      Networking Functions
 |
 |   Author(s)          : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#include "HvWebLib.h"
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <sys/ipc.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
#include <bstring.h>
#include <malloc.h>

#define BUF_SIZE  32678

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

////////////////////////////////////////////////////////////////////////
//
//  bind socket to name
//  returns -1 on error else new socket id
//  
int bindSocket(char *host, int port, struct sockaddr_in &sin)
//
////////////////////////////////////////////////////////////////////////
{
   struct hostent *he;
   if (!(he = gethostbyname(host))) {
      perror("\tgethostbyname");
      return -1;
   }

   int s;
   if ((s = socket(he->h_addrtype, SOCK_STREAM, 0)) < 0) {
      perror("\tsocket");
      return -1;
   }

   bzero((caddr_t)&sin, sizeof(sin));
   sin.sin_family = he->h_addrtype;
   if (bind(s, &sin, sizeof(sin)) < 0) {
      perror("\tbind");
      return -1;
   }
   bcopy(he->h_addr, &sin.sin_addr, he->h_length);
   sin.sin_port = port;

   return s;
}

////////////////////////////////////////////////////////////////////////
//
//  connect socket to remote server
//  returns -1 on error, 0 on EINPROGRESS else socket id
//  
int connectSocket(int s, struct sockaddr_in &sin)
//
////////////////////////////////////////////////////////////////////////
{
   if (connect(s, &sin, sizeof(sin)) < 0) {
      if ((errno == EINPROGRESS)||(errno == EALREADY)) return 0;
      if (errno == EISCONN) return s;
      perror("\tconnect");
      return -1;
   }

   return s;
}

////////////////////////////////////////////////////////////////////////
//
//  write data to socket
//  returns -1 on error, 0 on success
//  
int sendData(int s, char *data, int len)
//
////////////////////////////////////////////////////////////////////////
{
   if (write(s, data, len) != len) {
      perror("\twrite");
      return -1;
   }

   return 0;
}

////////////////////////////////////////////////////////////////////////
//
//  read data from socket, increases the data buffer if necessary
//	size:    actual size of the data record
// 	maxSize: already allocated space for the data record
//  returns -1 on error, 0 on EOF
//
int receiveData(int s, char* &data, int &size, int &maxSize)
//
////////////////////////////////////////////////////////////////////////
{
   char buf[BUF_SIZE];
   int bytes = -1, newSize, ret;

   while ((ret = read(s, buf, BUF_SIZE)) > 0) {
      bytes = ret;
      newSize = size + bytes;
      if (newSize > maxSize) {
         data = (char *)realloc(data, newSize);
	 maxSize = newSize;
      }
      bcopy(buf, &data[size], bytes);
      size = newSize;
   }
   if (ret == 0) return 0;

   return bytes;
}

////////////////////////////////////////////////////////////////////////
//
//  make socket nonblocking
//
int makeNonblocking(int s)
//
////////////////////////////////////////////////////////////////////////
{
   if (fcntl(s, F_SETFL, FNDELAY) < 0) {
      perror("\tfcntl F_SETFL, FNDELAY");
      return -1;
   }
   return 0;
}

////////////////////////////////////////////////////////////////////////
//
//  split given URL into host, port and file
//  returns -1 on error
//  
int splitURL(const char *url, char* &host, int &port, char* &file)
//
////////////////////////////////////////////////////////////////////////
{
   char* http = "http://";
   int httpLen = strlen(http);
   if (!url) return -1;
   if (strncmp(http, url, httpLen)) return -1;  // no http protocol

   // get the host name
   const char *s;
   for (s = url + strlen(http) + 1; *s && (*s != ':') && (*s != '/'); s++);

   int hostnameLen = s - url;
   hostnameLen -= httpLen;
   host = new char[hostnameLen + 1];  // no error checking

   strncpy(host, url + httpLen, hostnameLen);
   host[hostnameLen] = '\0';

   // get port number
   if (*s == ':') {
      port = atoi(++s);
      while (*s && (*s != '/')) s++;
   }
   else { port = 80; }

   // get the file name
   if (*s == '/') {
      int filenameLen = strlen(s);
      file = new char[filenameLen + 1];
      strncpy(file, s, filenameLen);
      file[filenameLen] = '\0';
   }
   else {
      file = new char[2];
      file[0] = '/'; file[1] = '\0';
   }
return 0;
}

////////////////////////////////////////////////////////////////////////
//
//  test if the buffer is complete
//  first 4 bytes contain length (int)
//  
int isComplete(char *buffer, int bufferSize)
//
////////////////////////////////////////////////////////////////////////
{
   if (bufferSize < 4) return FALSE;  // first 4 bytes contain "int"

   int size = *((int *)buffer);
   if (bufferSize < size) return FALSE;

   return TRUE;
}
