//  -*- C++ -*-

/*
 * HvWebIO.h
 *
 *	This file defines the HvWebUI node class.
 *
 * Copyright 1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
 */

#ident "$Revision: 1.3 $"

#ifndef  __HV_WEB_IO_H__
#define  __HV_WEB_IO_H__

#include <Inventor/SbPList.h>
#include <Inventor/nodes/SoNode.h>
#include <Inventor/nodes/SoSubNode.h>
#include <Inventor/fields/SoMFString.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/fields/SoSFBool.h>

#include <ctype.h>


//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvWebIO
//
//	Base class for I/O field container
//	Everything is stored in String fields which will be analyzed.
//
//////////////////////////////////////////////////////////////////////////////

class HvWebIO : public SoNode {

    SO_NODE_HEADER(HvWebIO);

  public:

    // Fields:
    enum Type {
        INPUT,
        OUTPUT
    };
    SoSFEnum	type;		// input or output

    SoSFBool	hidden;		// should fields show up in UI

    SoMFString	hvInt;		// for future usage
    SoMFString	hvEnum;		// for future usage
    SoMFString	hvFloat;
    SoMFString	hvString;
    SoMFString	hvSlider;
    SoMFString	hvCheck;	// for future usage
    SoMFString	hvOption;	// for future usage
    SoMFString	hvList;
    SoMFString	hvField;

    // Constructor
    HvWebIO();

  SoINTERNAL public:
    static void initClass();

    // find a node in the parent group
    virtual SoNode *findNode(SoNode *, const char *);

    // find a field in a node
    virtual SoField *findField(SoNode *, const char *);

    // Analyses the strings in HvFloat
    virtual SbPList analyseFloats();

    // Analyses the strings in HvString
    virtual SbPList analyseStrings();

    // Analyses the strings in HvSlider
    virtual SbPList analyseSlider();

    // Analyses the strings in HvList
    virtual SbPList analyseList();

    // Analyses the strings in HvField
    virtual SbPList analyseFields();

    void setParentNode(SoNode *pn) { parentNode = pn; };

  protected:
    // Destructor
    virtual ~HvWebIO() { };

  private:
    // parent group node
    SoNode *parentNode;

};



// returns next word and new pos. in string
//
inline const char *findWord(const char *text, char * &word) {
   if (text == NULL) return NULL;

   if (word) delete [] word;
   word = NULL;

   int i, j;
   for (i = 0; text[i]; i++) {
      if (!isalnum(text[i])) continue;
      for (j = i+1; text[j]; j++) {
	 if (isspace(text[j])) break;
      }
      int l = j - i;
      word = new char[l+1];
      strncpy(word, &text[i], l); word[l] = '\0';
      break;
   }
   if (text[i]) return &text[j];
   return NULL;
}


#endif  /* !__HV_WEB_IO_H__ */
