/*
 * HvWebFunction.h
 *
 *	This file defines the HvWebFunction node class.
 *
 * Copyright 1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
 */

#ident "$Revision: 1.2 $"

#ifndef  __HV_WEB_FUNCTION_H__
#define  __HV_WEB_FUNCTION_H__

#include <Xm/Xm.h>
#include <Vk/xpm.h> // stuff to build color icons pixmaps

#include <Inventor/sensors/SoFieldSensor.h>
#include <Inventor/SbPList.h>

#include "HvClientHandler.h"

class SoType;
class SoField;
class SoNode;
class HvManager;
class HvWebField;
class HvWebSelectionField;

#include "HvCommId.h"

//////////////////////////////////////////////////////////////////////////////
//
//  Class: HvWebFunction
//
//
//////////////////////////////////////////////////////////////////////////////


class HvWebFunction {

  public:
    enum Mode {
       STANDBY,
       DIRECT
    };

    // Constructor / Destructor
    HvWebFunction();
    ~HvWebFunction();

    void setWebUI(HvManager *w) { wui = w; };
    void analyseURLBuffer(const char *s);

    void setParentNode(SoNode *pn) { parentNode = pn; };

    void setHostname(const char *host) { daemon.setHostname(host); }
    void setPort(int port) { daemon.setPort(port); }

#ifdef UNDO
    void makeBackup();
    void undo();
    void redo();
#endif /* UNDO */

    Widget buildStartButton(Widget parent);
    Widget buildInitialButton(Widget parent);

    // has to be pblic because HvWebField use it as callback
    static void startCB(Widget, void *info, XmAnyCallbackStruct *);

    void updateFieldReferences(void);

  private:

      // network state
      enum State {
         FIRST_CALL,
         SEND_START,
         SEND_RECEIVE,
         SEND_FIELD,
         SEND_SEND,
         RECEIVING,
         FINISHING,
         LAST_CALL
      };
      int state;

    // UI stuff

    HvManager		*wui;
    Widget		webMenuButton, *widgetList;
    char 		*title;
    int			webFunctionDialogVisible;

    SoNode 	*parentNode;

    // Sensors
    SoFieldSensor 	sensor;

    // networking stuff
    HvClientHandler	daemon;
    SbBool		dataRead;

    // input/output stuff
    int			mode;
    SbBool		writeMode;
    SbPList		inputList, outputList;
    // fields for which to build GUI
    SbPList		visibleInputList, visibleOutputList;

    //pixmaps
    Pixmap clockPixmap[3];

    static void webMenuDialogCB(Widget, HvWebFunction *wfn, void *);
    void openWebFunctionDialog();
    static void webFunctionClosedCB(Widget, void *info, XmAnyCallbackStruct *);
    static void unmanageCB(Widget, void *info, XmAnyCallbackStruct *);
    static void helpCB(Widget, void *info, XmAnyCallbackStruct *);
    void appendLogText(char *text);
    static void handleConnectionCB(HvWebFunction *wfn, SoSensor *);
    void updateOutput();
    void sendFields();
};


#endif  /* !__HV_WEB_FUNCTION_H__ */
