/*
 * Copyright (C) 1996   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.1 $
 |
 |      Some macros
 |
 |   Author(s)          : Horst Vollhardt
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

//////////////////////////////////////////////////////////////////////////
//
// some functions to pack field data into a binary block
// must use #define because of the different data types
//
//////////////////////////////////////////////////////////////////////////
#ifndef S_INT
#define S_INT (sizeof(int))
#endif
//
#define PACK_SFIELD_SCALAR(FieldType,ItemType)				\
   int len = 3*S_INT + sizeof(ItemType);				\
   len += (len&0x3) ? (4-(len&0x3)) : 0; 				\
   cBuff = (char *) realloc(cBuff, s + len);				\
   int *iBuff = (int *)&cBuff[s];					\
   iBuff[0] = len; iBuff[1] = 0; iBuff[2] = 1;				\
   ItemType *itBuff = (ItemType *)&cBuff[s+3*S_INT];			\
   itBuff[0] = ((FieldType *)field)->getValue();			\
   s += len;								\
//
#define PACK_SFIELD_VECTOR(FieldType,ItemSize,ItemType)			\
   int len = 3*S_INT + ItemSize*sizeof(ItemType);			\
   len += (len&0x3) ? (4-(len&0x3)) : 0; 				\
   cBuff = (char *) realloc(cBuff, s + len);				\
   int *iBuff = (int *)&cBuff[s];					\
   iBuff[0] = len; iBuff[1] = 0; iBuff[2] = 1;				\
   ItemType *itBuff = (ItemType *)&cBuff[s+3*S_INT];			\
   for (int j = 0; j < ItemSize; j++, itBuff++)				\
      *itBuff = ((FieldType *)field)->getValue()[j];			\
   s += len;								\
//
#define PACK_SFIELD_STRING()						\
   const int sLen = string.getLength() + 1;				\
   int len = 3*S_INT + sLen;						\
   len += (len&0x3) ? (4-(len&0x3)) : 0; 				\
   cBuff = (char *) realloc(cBuff, s + len);				\
   int *iBuff = (int *)&cBuff[s];					\
   iBuff[0] = len; iBuff[1] = 0; iBuff[2] = 1;				\
   bcopy(string.getString(), &cBuff[s+3*S_INT], sLen);			\
   s += len;								\
//
#define PACK_MFIELD_SCALAR(FieldType,ItemType)				\
   FieldType &f = *(FieldType *)field;					\
   int n = f.getNum();							\
   int len = 3*S_INT + n*sizeof(ItemType);				\
   len += (len&0x3) ? (4-(len&0x3)) : 0; 				\
   cBuff = (char *) realloc(cBuff, s + len);				\
   int *iBuff = (int *)&cBuff[s];					\
   iBuff[0] = len; iBuff[1] = 0; iBuff[2] = n;				\
   ItemType *itBuff = (ItemType *)&cBuff[s+3*S_INT];			\
   for (int i = 0; i < n; i++) itBuff[i] = f[i];			\
   s += len;								\
//
#define PACK_MFIELD_VECTOR(FieldType,ItemSize,ItemType)			\
   FieldType &f = *(FieldType *)field;					\
   int n = f.getNum();							\
   int len = 3*S_INT + n*ItemSize*sizeof(ItemType);			\
   len += (len&0x3) ? (4-(len&0x3)) : 0; 				\
   cBuff = (char *) realloc(cBuff, s + len);				\
   int *iBuff = (int *)&cBuff[s];					\
   iBuff[0] = len; iBuff[1] = 0; iBuff[2] = n;				\
   ItemType *itBuff = (ItemType *)&cBuff[s+3*S_INT];			\
   for (int i = 0; i < n; i++)						\
      for (int j = 0; j < ItemSize; j++, itBuff++)			\
         *itBuff = f[i][j];						\
   s += len;								\
//
#define PACK_MFIELD_STRING(FieldType,ItemType)				\
   FieldType &f = *(FieldType *)field;					\
   int n = f.getNum();							\
   int len = 3*S_INT;							\
   for (int i = 0; i < n; i++) len += f[i].getLength() + 1;		\
   len += (len&0x3) ? (4-(len&0x3)) : 0; 				\
   cBuff = (char *) realloc(cBuff, s + len);				\
   int *iBuff = (int *)&cBuff[s];					\
   iBuff[0] = len; iBuff[1] = 0; iBuff[2] = n;				\
   ItemType *itBuff = (ItemType *)&cBuff[s+3*S_INT];			\
   for (int j = 0; j < n; j++) {					\
      int sLen = f[j].getLength() + 1;					\
      bcopy(f[j].getString(), itBuff, sLen);				\
      itBuff += sLen;							\
   }									\
   s += len;								\
//
#define PACK_MFIELD_SELECTION(FieldType,ItemSize,ItemType)		\
   const ChemPathList &cpList = *parentNode->getList();			\
   int len = 3*S_INT;							\
   if (cpList == NULL) {						\
      len += (len&0x3) ? (4-(len&0x3)) : 0; 				\
      cBuff = (char *)realloc(cBuff, s + len);				\
      int *iBuff = (int *)&cBuff[s];					\
      iBuff[0] = len; iBuff[1] = 0; iBuff[2] = 0;			\
      s += len;								\
      return;								\
   }									\
   int n, ncp = cpList.getLength();					\
   for (int i = n = 0; i < ncp; i++) {					\
      ChemPath *cp = cpList[i];						\
      if (selectionType == HvWebField::ATOM)				\
         n += cp->getAtomIndex().getNum();				\
      else if (selectionType == HvWebField::BOND)			\
         n += cp->getBondIndex().getNum();				\
   }									\
   len += n * ItemSize * sizeof(ItemType);				\
   len += (len&0x3) ? (4-(len&0x3)) : 0; 				\
   cBuff = (char *)realloc(cBuff, s + len);				\
   int *iBuff = (int *)&cBuff[s];					\
   iBuff[0] = len; iBuff[1] = 0; iBuff[2] = n;				\
   ItemType *itBuff = (ItemType *)&cBuff[s+3*S_INT];			\
   for (int j = 0; j < ncp; j++) {					\
      ChemPath *cp = cpList[j];						\
      FieldType f;							\
      if (selectionType == HvWebField::ATOM)      f = cp->getAtomIndex();  \
      else if (selectionType == HvWebField::BOND) f = cp->getBondIndex();  \
      n = f.getNum();							\
      for (int k = 0; k < n; k++)					\
         for (int l = 0; l < ItemSize; l++, itBuff++)			\
               *itBuff = f[k][l];					\
   }									\
   s += len;								\
//
//////////////////////////////////////////////////////////////////////////
//
// some functions to extract field data from a binary block
// must use #define because of the different data types
//
//////////////////////////////////////////////////////////////////////////
//
#define UNPACK_SFIELD_SCALAR(FieldType,ItemType)			\
   FieldType &f = *(FieldType *)field;					\
   f = *(ItemType *)cBuff;						\
//
#define UNPACK_SFIELD_VECTOR(FieldType,ItemType)			\
   FieldType &f = *(FieldType *)field;					\
   f.setValue((const ItemType *)cBuff);					\
//
#define UNPACK_MFIELD_SCALAR(FieldType,ItemType)			\
   FieldType &f = *(FieldType *)field;					\
   f.setNum(nItem);							\
   ItemType *itBuff = (ItemType *)cBuff;				\
   ItemType *item = f.startEditing();					\
   for (int i = 0; i < nItem; i++) item[i] = itBuff[i];			\
   f.finishEditing();							\
//
#define UNPACK_MFIELD_VECTOR(FieldType,ItemSize,ItemType,PrimType)	\
   FieldType &f = *(FieldType *)field;					\
   f.setNum(nItem);							\
   PrimType *itBuff = (PrimType *)cBuff;				\
   ItemType *item = f.startEditing();					\
   for (int i = 0; i < nItem; i++) {					\
      for (int j = 0; j < ItemSize; j++, itBuff++)			\
         item[i][j] = *itBuff;						\
   }									\
   f.finishEditing();							\
//
#define UNPACK_MFIELD_STRING(FieldType,ItemType,PrimType)		\
   FieldType &f = *(FieldType *)field;					\
   f.setNum(nItem);							\
   PrimType *itBuff = (PrimType *)cBuff;					\
   ItemType *item = f.startEditing();					\
   for (int i = 0; i < nItem; i++) {					\
      item[i] = itBuff;							\
      itBuff += item[i].getLength() + 1;				\
   }									\
   f.finishEditing();							\
//
